#|
                            Nqthm-1992 DEFN-SK EXAMPLES

With Matt Kaufmann's permission, we distribute his Skolemizer DEFN-SK with
Nqthm-1992, but we do not load it as part of Nqthm.  Via this file,
`defn-sk.lisp', one can, within Nqthm-1992, check the three examples, all by
Yuan Yu, we distribute with Nqthm-1992 that use defn-sk.  One can
also check an example of William D. Young.

Instructions.  To run these tests, from within Nqthm-1992, one sets two
variables before loading this file.  Here are explicit directions:

1.  Set *NQTHM-SOURCE-DIR* to be a string that points to the directory that
contains the Nqthm sources, where the file defn-sk.lisp may be found.  For
example,

    (DEFPARAMETER *NQTHM-SOURCE-DIR*  "/usr/smith/nqthm-1992/")

2.  Set *NQTHM-YU-DIR* to be a string that points to the directory that
contains Yu's contributions to the Nqthm tests, where the three examples we
distribute with Nqthm-1992 that use defn-sk may be found.  For example

    (DEFPARAMETER *NQTHM-YU-DIR* "/usr/smith/nqthm-1992/examples/yu/")


3.  Set *NQTHM-YOUNG-DIR* to be a string that points to the directory that
contains Young's contributions to the Nqthm tests, where the three examples we
distribute with Nqthm-1992 that use defn-sk may be found.  For example

    (DEFPARAMETER *NQTHM-YOUNG-DIR* "/usr/smith/nqthm-1992/examples/young/")

4.  Finally, load this file, e.g.

    (LOAD "/usr/smith/nqthm-1992/examples/driver-sk.lisp")

That is all there is to do.  Note that the Yu examples `cstring' and `qsort'
depend upon the lib generated by the Yu example mc20-2, which means that one
must do the Yu examples, up through mc20-2, e.g., by running `driver.lisp',
before running this defn-sk driver.

One way to run this file is to put two forms, such as the DEFPARAMETERs above,
for setting the directory variables, in a file, say `dir.lisp', and then to
invoke, at the shell level, the command:

  cat dir.lisp driver-sk.lisp | nice nqthm-1992 >& driver-sk.log  & 


|#

(IN-PACKAGE "USER")

(DEFPARAMETER NQTHM-1992-DEFN-SK-FILES-YU '("cstring" "qsort" "group"))

(DEFPARAMETER NQTHM-1992-DEFN-SK-FILES-YOUNG '("train"))

(PUSH '("DEFN-SK" . "Matt Kaufmann's skolemizer.")
      *MODS-ALIST*)

(FORMAT *STANDARD-OUTPUT* "~%Loading driver-sk.lisp.")

(OR (AND (BOUNDP '*NQTHM-SOURCE-DIR*)
         (STRINGP *NQTHM-SOURCE-DIR*))
    (ERROR "~% Before running this file, please set ~
            *NQTHM-SOURCE-DIR* to a string ~% that names the path to ~
            the Nqthm-1992 sources directory at your~% site.  For ~
            example, on a Unix, one might execute something like~%~%  ~
              (DEFPARAMETER *NQTHM-SOURCE-DIR* ~
            \"/usr/smith/nqthm-1992/\")~%~% It is important that the ~
            string end in the character that separates ~% ~
            subdirectory components, e.g., / on Unix, > on Symbolics, ~
            and : on Macintosh.~%"))


(FORMAT *STANDARD-OUTPUT*
        "~%Assuming that the Nqthm-1992 source directory at this site ~
         is ~%~s.~%"
        *NQTHM-SOURCE-DIR*)

(FORCE-OUTPUT *STANDARD-OUTPUT*)

(OR (AND (BOUNDP '*NQTHM-YU-DIR*)
         (STRINGP *NQTHM-YU-DIR*))
    (ERROR "~% Before running this file, please set *NQTHM-YU-DIR* to ~
            a string ~% that names the path to the `yu' subdirectory ~
            of the Nqthm-1992 ~% examples directory at your site.  ~
            For example, on a Unix, one might ~% execute something ~
            like~%~%    (DEFPARAMETER *NQTHM-YU-DIR* ~
            \"/usr/smith/nqthm-1992/examples/yu/\")~%~% It is ~
            important that the string end in the character that ~
            separates ~% subdirectory components, e.g., / on Unix, > ~
            on Symbolics, and : on Macintosh.~%"))

(FORMAT *STANDARD-OUTPUT*
        "~%Assuming that the `yu' subdirectory of the Nqthm-1992 ~
         examples directory~% at this site is ~s.~%"
        *NQTHM-YU-DIR*)

(OR (AND (BOUNDP '*NQTHM-YOUNG-DIR*)
         (STRINGP *NQTHM-YOUNG-DIR*))
    (ERROR "~% Before running this file, please set *NQTHM-YOUNG-DIR* to ~
            a string ~% that names the path to the `young' subdirectory ~
            of the Nqthm-1992 ~% examples directory at your site.  ~
            For example, on a Unix, one might ~% execute something ~
            like~%~%    (DEFPARAMETER *NQTHM-YOUNG-DIR* ~
            \"/usr/smith/nqthm-1992/examples/young/\")~%~% It is ~
            important that the string end in the character that ~
            separates ~% subdirectory components, e.g., / on Unix, > ~
            on Symbolics, and : on Macintosh.~%"))

(FORMAT *STANDARD-OUTPUT*
        "~%Assuming that the `young' subdirectory of the Nqthm ~
         examples directory~% at this site is ~s.~%"
        *NQTHM-YOUNG-DIR*)

(FORCE-OUTPUT *STANDARD-OUTPUT*)

(LET ((*DEFAULT-NQTHM-PATH* *NQTHM-SOURCE-DIR*))
  (LOAD (EXTEND-FILE-NAME "defn-sk" "lisp")))

(LET ((*DEFAULT-NQTHM-PATH* *NQTHM-YU-DIR*))
  (ITERATE FOR ROOT IN NQTHM-1992-DEFN-SK-FILES-YU
           DO
           (COND ((PROBE-FILE (EXTEND-FILE-NAME ROOT FILE-EXTENSION-PROVED))
                  (FORMAT *STANDARD-OUTPUT*
                          "~%Skipping ~a.~a because the file ~a.~a exists."
                          ROOT FILE-EXTENSION-EVENTS
                          ROOT FILE-EXTENSION-PROVED)
                  "Skipped")
                 (T (FORMAT *STANDARD-OUTPUT*
                            "~%Trying ~a.~a."
                            ROOT FILE-EXTENSION-EVENTS)
                    (COND ((PROVE-FILE-OUT ROOT)
                           (FORMAT *STANDARD-OUTPUT*
                                   "~%Successfully finished ~a.~a."
                                   ROOT FILE-EXTENSION-EVENTS)
                           (FORCE-OUTPUT *STANDARD-OUTPUT*))
                          (T (ERROR "~%Failed on ~a.~a."
                                    ROOT FILE-EXTENSION-EVENTS)))))))

(LET ((*DEFAULT-NQTHM-PATH* *NQTHM-YOUNG-DIR*))
  (ITERATE FOR ROOT IN NQTHM-1992-DEFN-SK-FILES-YOUNG
           DO
           (COND ((PROBE-FILE (EXTEND-FILE-NAME ROOT FILE-EXTENSION-PROVED))
                  (FORMAT *STANDARD-OUTPUT*
                          "~%Skipping ~a.~a because the file ~a.~a exists."
                          ROOT FILE-EXTENSION-EVENTS
                          ROOT FILE-EXTENSION-PROVED)
                  "Skipped")
                 (T (FORMAT *STANDARD-OUTPUT*
                            "~%Trying ~a.~a."
                            ROOT FILE-EXTENSION-EVENTS)
                    (COND ((PROVE-FILE-OUT ROOT)
                           (FORMAT *STANDARD-OUTPUT*
                                   "~%Successfully finished ~a.~a."
                                   ROOT FILE-EXTENSION-EVENTS)
                           (FORCE-OUTPUT *STANDARD-OUTPUT*))
                          (T (ERROR "~%Failed on ~a.~a."
                                    ROOT FILE-EXTENSION-EVENTS)))))))

(FORMAT *STANDARD-OUTPUT*
        "~%~%All Nqthm-1992 DEFN-SK tests completed successfully.~%~%")

(FORCE-OUTPUT *STANDARD-OUTPUT*))

(FORMAT *STANDARD-OUTPUT* "~%Finished loading driver-sk.lisp.")

(FORCE-OUTPUT *STANDARD-OUTPUT*)

; Some Lisps quit when reading end of file, some don't.
#+CMU
(QUIT)
#+Allegro
(EXIT)


