(DEFVAR ISQRT-VCS)
(DEFVAR ISQRT-CONTEXT)
(DEFPARAMETER ISQRT-TOKENS NIL)
(DEFPARAMETER ISQRT-BLOCKS NIL)
(DEFPARAMETER ISQRT-XXX
      '((DEFN SQ (I) (TIMES I I))
	(HINT ISQRT-STUFF
	      (PROVE-LEMMA PLUS-1 (REWRITE)
			   (EQUAL (PLUS 1 X)
				  (ADD1 X)))
	      (PROVE-LEMMA DIFFERENCE-2 (REWRITE)
			   (EQUAL (DIFFERENCE (ADD1 (ADD1 X))
					      2)
				  (FIX X)))
	      (PROVE-LEMMA QUOTIENT-BY-2 (REWRITE)
			   (NOT (LESSP (PLUS (QUOTIENT A 2)
					     (QUOTIENT A 2))
				       (SUB1 A))))
	      (PROVE-LEMMA
		MAIN-TRICK
		(REWRITE)
		(NOT (LESSP  (SQ (ADD1 (QUOTIENT (PLUS J K) 2)))
			    (PLUS (TIMES J K)
				  J)))
		((INDUCT (LESSP J K))))
	      (PROVE-LEMMA LESSP-REMAINDER2 (REWRITE GENERALIZE)
			   (EQUAL (LESSP (REMAINDER X Y)
					 Y)
				  (NOT (ZEROP Y))))
	      (PROVE-LEMMA REMAINDER-QUOTIENT-ELIM (ELIM)
			   (IMPLIES (AND (NOT (ZEROP Y))
					 (NUMBERP X))
				    (EQUAL (PLUS (REMAINDER X Y)
						 (TIMES Y (QUOTIENT X Y)))
					   X)))

	      (PROVE-LEMMA SQ-ADD1-NON-ZERO (REWRITE)
			   (NOT(EQUAL (SQ (ADD1 X)) 0)))
	      (DISABLE SQ)
	      (PROVE-LEMMA
		MAIN
		(REWRITE)
		(IMPLIES (NOT (ZEROP J))
			 (LESSP I   (SQ (ADD1 (QUOTIENT (PLUS J (QUOTIENT I J))
						2))))))

	      (ENABLE SQ)
	      (PROVE-LEMMA LESSP-TIMES-CANCELLATION-RESTATED-FOR-LINEAR
			   (REWRITE)
			   (IMPLIES (NOT (LESSP I J))
				    (NOT (LESSP (TIMES A I)
						(TIMES A J)))) NIL)

;			   (* This could be restated as an equivalence -- if B 
;			      not equal 0 is thrown in too -- but I need it as 
;			      a linear lemma- )

	      
	      (PROVE-LEMMA MULTIPLY-THRU-BY-DIVISOR (REWRITE)
			   (IMPLIES (LESSP A (TIMES B C))
				    (EQUAL (LESSP (QUOTIENT A B)
						  C)
					   T)))
	      
	      (PROVE-LEMMA TIMES-GREATERP-ZERO (REWRITE)
			   (IMPLIES (AND (NOT (ZEROP X))
					 (NOT (ZEROP Y)))
				    (LESSP 0 (TIMES X Y))))
	      (PROVE-LEMMA QUOTIENT-SHRINKS (REWRITE)
			   (NOT (LESSP I (QUOTIENT I J))))
	      (PROVE-LEMMA QUOTIENT-SHRINKS-FAST (REWRITE)
			   (NOT (LESSP I (TIMES 2 (QUOTIENT I 2)))))
	      (PROVE-LEMMA QUOTIENT-BY-1 (REWRITE)
			   (EQUAL (QUOTIENT I 1)(FIX I))))))

(DEFPARAMETER ISQRT-SUBPROGRAM (FAKE 
   '(FUNCTION
    NAME ISQRT
    TYPE INTEGER
    ARGS (I)
    VAR-DCLS ((VAR-DCL I INTEGER NIL))
    INPUT-COND (AND (NUMBERP (I STATE))
		    (LESSP (I STATE)
			   (LEAST-INEXPRESSIBLE-POSITIVE-INTEGER)))
    RESULT (AND (ZGREATEREQP ANS 0)
		(NOT (LESSP (I STATE) (SQ ANS)))
		(LESSP (I STATE) (SQ (PLUS 1 ANS))))
    CLOCKS ((I (START)))
    CODE
    (
    (COMMENT CALCULATE THE SQUARE ROOT OF I USING THE NEWTON |METHOD.|)
    (IF-LOGICAL (ZLESSP I 0) (STOP))
    (IF-LOGICAL (ZGREATERP I 1) (GOTO 100))
    (ASSIGNMENT ISQRT I)
    (RETURN)
    (COMMENT 
             ISQRT TAKES ON INCREASINGLY SMALLER VALUES AND CONVERGES
	     TO THE SQUARE ROOT OF |I.|  THE FIRST APPROXIMATION IS ONE HALF
	     |I,| WHICH IS NOT LESS THAN THE SQUARE ROOT OF I WHEN
	     1 IS LESS THAN |I.|)
    100
    (ASSIGNMENT ISQRT (ZQUOTIENT I 2))
    200
    (CONTINUE)
    (COMMENT ASSERTION LP (AND (LESSP 0 (ISQRT STATE))
			       (NOT (LESSP (I STATE) (TIMES 2 (ISQRT STATE))))
			       (NUMBERP (ISQRT STATE))
			       (LESSP (I STATE)
				      (SQ (ADD1 (ISQRT STATE)))))
	     ((ISQRT STATE)))
    (IF-LOGICAL (ZGREATEREQP (ZQUOTIENT I ISQRT) ISQRT) (RETURN))
    (ASSIGNMENT ISQRT (ZQUOTIENT (ZPLUS ISQRT (ZQUOTIENT I ISQRT))
			     2))
    (COMMENT XXX SQ-REWRITE-OFF-AGAIN NIL (DISABLE SQ))
    (GOTO 200)))))

(DEFUN ADD-ISQRT NIL
  (PROG (TEMP)
    (SETQ TEMP (ADD-TO-CONTEXT ISQRT-TOKENS ISQRT-XXX ISQRT-BLOCKS
			       ISQRT-SUBPROGRAM
				   NIL))
    (SETQ ISQRT-VCS (CAR TEMP))
    (SETQ ISQRT-CONTEXT (CDR TEMP))
    (COND ((CONSP ISQRT-VCS)
	   (LET ((FILE (OPEN "isqrt.vcs" :direction :output)))
		 (PRINC	"(SETQ VCS '(" FILE)
		 (TERPRI FILE)
		 (ITERATE FOR X IN ISQRT-VCS DO
		       (TERPRI FILE)
		       (PPR X FILE))
		 (PRINC "))" FILE)
		 (CLOSE FILE))
	   (PRINT-CONTEXT ISQRT-CONTEXT "isqrt.context" NIL)
	   (RETURN (LIST (QUOTE ISQRT-VCS)
			 (QUOTE ISQRT-CONTEXT))))
	  (T (RETURN FAILURE-MSG)))))
