(DEFVAR MJRTY-VCS)

(DEFVAR MJRTY-CONTEXT)

(DEFPARAMETER MJRTY-XXX '(
 (DEFN CNT (X A I N)
       (IF (OR (ZEROP N)
	       (LESSP N I))
	   0
	   (IF (ZEQP X (ELT1 A N))
	       (ADD1 (CNT X A I (SUB1 N)))
	       (CNT X A I (SUB1 N)))))

 (HINT USEFUL-LEMMAS
       (PROVE-LEMMA PLUS-1
		    (REWRITE)
		    (EQUAL (PLUS 1 X) (ADD1 X)))
       (PROVE-LEMMA DIFFERENCE-0
		    (REWRITE)
		    (IMPLIES (NOT (LESSP X Y))
			     (EQUAL (DIFFERENCE Y X) 0)))
       (PROVE-LEMMA DIFFERENCE-1 (REWRITE)(EQUAL (DIFFERENCE X 1) (SUB1 X)))
       (PROVE-LEMMA LESSP-X-1 (REWRITE)(EQUAL (LESSP X 1) (ZEROP X)))
       (PROVE-LEMMA LESSP-REMAINDER2
		    (REWRITE GENERALIZE)
		    (EQUAL (LESSP (REMAINDER X Y) Y)
			   (NOT (ZEROP Y))))
       (PROVE-LEMMA REMAINDER-QUOTIENT-ELIM
		    (ELIM)
		    (IMPLIES (AND (NOT (ZEROP Y)) (NUMBERP X))
			     (EQUAL (PLUS (REMAINDER X Y)
					  (TIMES Y (QUOTIENT X Y)))
				    X)))
       (PROVE-LEMMA QUOTIENT-BY-2-BOUND (REWRITE)
		    (NOT (LESSP X (QUOTIENT X 2))))
       (PROVE-LEMMA LESSP-QUOTIENT-REWRITE (REWRITE)
		    (EQUAL (LESSP (QUOTIENT N 2) M)
			   (LESSP N (PLUS M M))))
       (PROVE-LEMMA ZNORMALIZE-ZERO (REWRITE)
		    (IMPLIES (NUMBERP X)
			     (EQUAL (EQUAL (ZNORMALIZE X) 0)
				    (EQUAL X 0))))
       (DISABLE ZNORMALIZE)
       (PROVE-LEMMA CNT-BOUND (REWRITE)
		    (NOT (LESSP N (CNT X A 1 N)))))))
(DEFPARAMETER MJRTY-TOKENS NIL)  
(DEFPARAMETER MJRTY-BLOCKS NIL)

(DEFPARAMETER MJRTY-SUBPROGRAM (FAKE 
   '(SUBROUTINE
    NAME MJRTY
    ARGS (A N BOOLE CAND)
    BLOCK-NAMES NIL
    HIT-VARS (BOOLE CAND)
    KNOWN-BLOCK-NAMES NIL
    VAR-DCLS ((VAR-DCL N INTEGER NIL)
	      (VAR-DCL A INTEGER (N))
	      (VAR-DCL BOOLE LOGICAL NIL)
	      (VAR-DCL CAND INTEGER NIL)
	      (VAR-DCL I INTEGER NIL)
	      (VAR-DCL K INTEGER NIL))
    CALLED-FNS NIL
    STATEMENT-FUNCTION-PATTERNS NIL
    INPUT-COND (AND (IMPLIES (AND (LESSP 0 J)
				  (NOT (LESSP (N STATE) J))
				  (NOT (NEGATIVEP (ELT1 A J))))
			     (NUMBERP (ELT1 A J)))
		    (NUMBERP (N STATE))
		    (NOT (EQUAL (N STATE) 0))
		    (LESSP (ADD1 (N STATE))
			   (LEAST-INEXPRESSIBLE-POSITIVE-INTEGER)))
    EFFECTS (AND (OR (EQUAL (BOOLE NEWSTATE) (TRUE))
		     (EQUAL (BOOLE NEWSTATE) (FALSE)))
		 (IF (BOOLE NEWSTATE)
		     (AND (ZNUMBERP (CAND NEWSTATE))
			  (LESSP (QUOTIENT (N STATE) 2)
			    (CNT (CAND NEWSTATE) (A STATE) 1
				      (N STATE))))
		     (NOT (LESSP (QUOTIENT (N STATE) 2)
				 (CNT X (A STATE) 1 (N STATE))))))
    CLOCKS ((ADD1(ADD1 (PLUS (N (START))(N(START))))))
    CODE ((ASSIGNMENT K 0)
	  (COMMENT THE FOLLOWING DO IMPLEMENTS THE PAIRING |PHASE.|  CAND
		   IS THE CURRENTLY LEADING CANDIDATE AND K IS THE NUMBER
		   OF UNPAIRED VOTES FOR |CAND.|)
	  (DO 100 I 1 N 1)
	  (COMMENT DOJUNK PHASE1-HINT
	   (BUMP (CONTINUE)
		 (COMMENT ASSERTION PHASE1-INVRT
		   (AND (NUMBERP (I STATE))
			(NOT (EQUAL (I STATE) 0))
			(NUMBERP (K STATE))
			(NOT (LESSP (I STATE) (K STATE)))
			(NOT (LESSP (N (START)) (I STATE)))
			(IMPLIES (NOT (NEGATIVEP (CAND STATE)))
				 (NUMBERP (CAND STATE)))
			(NOT (LESSP (CNT (CAND STATE) (A STATE)
					 1 (I STATE))
				    (K STATE)))
			(IMPLIES (ZEQP X (CAND STATE))
				 (NOT (LESSP
				       (PLUS (I STATE)(K STATE))
				       (TIMES 2
					 (CNT X (A STATE) 1 (I STATE))))))
			(IMPLIES (ZNEQP X (CAND STATE))
				 (NOT (LESSP
				       (I STATE)
				       (PLUS (K STATE)
					     (TIMES 2
						    (CNT X (A STATE) 1 (I STATE))))))))
		   ((ADD1 (PLUS (N (START))
				(DIFFERENCE (ADD1 (N (START)))
					    (I STATE))))))))
				  
	  (IF-LOGICAL (ZEQP K 0) (GOTO 50))
	  (IF-LOGICAL (ZEQP CAND (A I)) (GOTO 75))
	  (ASSIGNMENT K (ZDIFFERENCE K 1))
	  (GOTO 100)
	  50
	  (ASSIGNMENT CAND (A I))
	  (ASSIGNMENT K 1)
	  (COMMENT XXX PHASE1-INVRT-F-T ((PHASE1-INVRT F T))
		   (PROVE-LEMMA COMPOUND-INVRT (REWRITE)
		      (IMPLIES (EQUAL (K$1) 0)
			      (NOT (LESSP (I$1)
					  (TIMES 2 (CNT X (A$0) 1 (I$1))))))
		      ((USE (PATHS-FROM-PHASE1-INVRT)))))
	  (GOTO 100)
	  75
	  (ASSIGNMENT K (ZPLUS K 1))
	  100
	  (CONTINUE)
	  (IF-LOGICAL (ZEQP K 0) (GOTO 300))
	  (ASSIGNMENT BOOLE (TRUE))
	  (IF-LOGICAL (ZGREATERP K (ZQUOTIENT N 2)) (RETURN))
	  (COMMENT WE NOW ENTER THE COUNTING PHASE.  BOOLE IS SET TO
		   TRUE IN ANTICIPATION OF FINDING CAND IN THE MAJORITY.
		   K IS USED AS THE RUNNING TALLY FOR CAND.  WE EXIT
		   AS SOON AS K EXCEEDS |N/2.|)

	  (ASSIGNMENT K 0)
	  (DO 200 I 1 N 1)
	  (COMMENT DOJUNK PHASE2
	   (BUMP (CONTINUE)
		 (COMMENT ASSERTION PHASE2-INVRT
		  (AND (NUMBERP (I STATE))
		       (NOT (EQUAL (I STATE) 0))
		       (EQUAL (BOOLE STATE) (TRUE))

		       (NOT (LESSP (N (START)) (I STATE)))
		       (IMPLIES (NOT (NEGATIVEP (CAND STATE)))
				(NUMBERP (CAND STATE)))
		       (IMPLIES (ZNEQP X (CAND STATE))
				(NOT (LESSP
				      (N (START))
				      (TIMES 2
				     (CNT X (A STATE) 1 (N (START)))))))
		       (NOT (LESSP (N (START))
				   (TIMES 2
					  (CNT (CAND STATE) (A STATE) 1 (I STATE)))))
		       (EQUAL (K STATE) (CNT (CAND STATE) (A STATE) 1 (I STATE))))
		  ((DIFFERENCE (ADD1 (N (START))) (I STATE))))))
	  (IF-LOGICAL (ZNEQP CAND (A I)) (GOTO 200))
	  (ASSIGNMENT K (ZPLUS K 1))
	  (COMMENT XXX OUTPUT-HINT ((PHASE2-INVRT F F))
		   (PROVE-LEMMA CNT-GROWS (REWRITE)
				(IMPLIES (AND (LESSP (I$1) N)
					      (ZEQP X (ELT1 A (ADD1 (I$1)))))
					 (LESSP (CNT X A 1 (I$1))
						(CNT X A 1 N)))
				((INDUCT (PLUS N I)))))

;   This is really a combination of two prettier facts
;   instantiated-  First, CNT is monotonic.  Second,
;   the CNT up to I+1 can be opened up.

	  (IF-LOGICAL (ZGREATERP K (ZQUOTIENT N 2)) (RETURN))
	  200
	  (CONTINUE)
	  300
	  (ASSIGNMENT BOOLE (FALSE))
	  (COMMENT XXX HINT-FOR-PHASE1-INVRT-T-T ((PHASE1-INVRT T T))
		   (PROVE-LEMMA COMPOUND-INVRT (REWRITE)
		    (IMPLIES (EQUAL (K$1) 0)
			     (NOT (LESSP (I$1)
					 (TIMES 2 (CNT X (A$0) 1 (I$1))))))
		    ((USE (PATHS-FROM-PHASE1-INVRT)))))
 (COMMENT XXX HINT-FOR-PHASE2-INVRT-T ((PHASE2-INVRT T)) 
 (PROVE-LEMMA ZEQP-IS-A-CONGRUENCE-RELATION-WRT-CNT-ARG-1
	   (REWRITE)
	   (IMPLIES (EQUAL (ZNORMALIZE X) (ZNORMALIZE Y))
		    (NOT (LESSP (CNT X A I J) (CNT Y A I J)))))
  (PROVE-LEMMA
   PHASE-2-HINT (REWRITE)
   (IMPLIES (NOT (LESSP (N$0)
			(PLUS (CNT (CAND$1) (A$0) 1 (N$0))
			      (CNT (CAND$1) (A$0) 1 (N$0)))))
	    (NOT (LESSP (N$0)
			(PLUS (CNT X (A$0) 1 (N$0))
			      (CNT X (A$0) 1 (N$0))))))
   ((USE (PATHS-FROM-PHASE2-INVRT)))))
	  (RETURN)))))

(DEFUN ADD-MJRTY NIL
  (PROG (TEMP)
    (SETQ TEMP (ADD-TO-CONTEXT MJRTY-TOKENS MJRTY-XXX MJRTY-BLOCKS
			       MJRTY-SUBPROGRAM
			       NIL))
    (SETQ MJRTY-VCS (CAR TEMP))
    (SETQ MJRTY-CONTEXT (CDR TEMP))
    (COND ((LISTP MJRTY-VCS)
	   (LET ((FILE (OPEN "mjrty.vcs" :direction :output)))
		 (PRINC	"(SETQ VCS '(" FILE)
		 (TERPRI FILE)
		 (ITERATE FOR X IN MJRTY-VCS DO
		       (TERPRI FILE)
		       (PPR X FILE))
		 (PRINC "))" FILE)
		 (CLOSE FILE))
	   (PRINT-CONTEXT MJRTY-CONTEXT "mjrty.context" NIL)
	   (RETURN (LIST 'MJRTY-VCS 'MJRTY-CONTEXT)))
	  (T (RETURN FAILURE-MSG)))))

