#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/procfs.h>
#include <sys/syscall.h>
#include <sys/systm.h>   /* for NSYSCALL */
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/statvfs.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <unistd.h>
#include "CloseFileHook.h"
#include "FDClass.h"
#include "global.h"
#include "sysentry.h"

CloseFileHook::CloseFileHook(FILE *out_, int what):Hook(out_, what)
{
  int ii;
  rtot = (hrtime_t *)malloc(MAXFDCLASS * sizeof(hrtime_t));
  rcount = (int *)malloc(MAXFDCLASS * sizeof(int));
  
  for(ii=0;ii<MAXFDCLASS;ii++){
    rtot[ii] = 0;
    rcount[ii] = 0;
  }
}

hrtime_t
CloseFileHook::Exit(const struct prstatus *p, int procfd)
{

  int readfd;
  char buf[80];
  hrtime_t tot;
  int error;
  FdClass cl;

  tot = Hook::Exit(p, procfd);

  readfd = p->pr_sysarg[0];
  cl = fdClassMap->findClass(readfd);
  fdClassMap->close(readfd); // remove mapping to file
  fprintf(out, "NOTE: %d %s fd %d class %s took %lld lwp %d of %d\n",
	  p->pr_what, 
	  SE_sysCallName[p->pr_what],
	  readfd,
	  fdClassMap->classToName(cl),
	  tot,
	  p->pr_who, 
	  p->pr_nlwp);

  rtot[cl] += tot;
  rcount[cl]++;

  return tot;
}


void 
CloseFileHook::Report()
{
  int ii;
  Hook::Report();
  for(ii=0;ii<MAXFDCLASS;ii++){
    if(!tracedProgIsMultithreaded){
      fprintf(out,"  %s count %d total %lld avg %f\n", 
	      fdClassMap->classToName((FdClass)ii),
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
    }
    else{
      fprintf(out,"  %s count %d (no total/avg for multithreaded procs)\n",
	      fdClassMap->classToName((FdClass)ii),
	      rcount[ii]);
    }
  }
}
