#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/statvfs.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <unistd.h>


#include "FDClass.h"

const char *names[] = {"closedfs",
		"ufs",
		"nfs",
		"procfs",
		"swapfs",
		"fdfs",
		"tmpfs",
		"tcp",
		"unknownfs",
		"MAXCLASSFS--ERROR"};

FDClass::FDClass()
{
  struct rlimit rl;
  int ii;
  int error;

  error = getrlimit(RLIMIT_NOFILE, &rl);
  if(error){
    perror("FDClass getrlimit failed");
    nfds = 1024;
  }
  else{
    nfds = rl.rlim_max;
  }

  table = (FdClass *)malloc(nfds * sizeof(FdClass));
  for(ii = 0; ii < nfds; ii++){
    table[ii] = CLOSED;
  }
}

FDClass::~FDClass()
{
  free(table);
  table = NULL;
  nfds = -1;
}

FdClass
FDClass::findClass(int fd) const
{
  if(fd >= nfds || fd < 0){
    return UNKNOWN;
  }
  return table[fd];
}

FdClass 
FDClass::open(int fd, char *path)
{
  int error;
  FdClass cl;

  struct statvfs stvfs;

  cl = UNKNOWN;

  if(strcmp(path, "/dev/tcp") == 0){
    cl = TCP;
  }

  error = fstatvfs(fd, &stvfs);
  if(error == 0){
    if(strcmp("ufs",stvfs.f_basetype)==0){
      cl = UFS;
    }
    else if(strcmp("nfs",stvfs.f_basetype)==0){
      cl = NFS;
    }
    else if(strcmp("proc",stvfs.f_basetype)==0){
      cl = PROC;
    }
    else if(strcmp("swap",stvfs.f_basetype)==0){
      cl = SWAP;
    }
    else if(strcmp("fd",stvfs.f_basetype)==0){
      cl = FD;
    }
    else  if(strcmp("tmpfs",stvfs.f_basetype)==0){
      cl = TMPFS;
    }
  }

  if(fd < nfds && fd >= 0){
    table[fd] = cl;
  }
  return cl;

}

void
FDClass::close(int fd)
{
  if(fd < nfds && fd >= 0){
    table[fd] = CLOSED;
  }
}

const char *
FDClass::classToName(FdClass c)
{
  return names[c];
}

