#ifndef _FDClass_H_
#define _FDClass_H_

typedef enum FdClass{CLOSED=0, UFS, NFS, PROC, SWAP, FD, TMPFS, TCP, UNKNOWN,
		     MAXFDCLASS} FdClass;

class FDClass{
public:
  FDClass();
  ~FDClass();
  FdClass findClass(int fd) const;
  FdClass open(int fd, char *path);
  void close(int fd);
  const char *classToName(FdClass cl);
private:
  int nfds;
  FdClass *table;
};
extern FdClass FDC_fdToClass(int fd);


#endif _FDClass_H_
