#include <assert.h>
#include <sys/procfs.h>
#include <sys/syscall.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "Hook.h"
#include "sysentry.h"
#include "global.h"

Hook::Hook(FILE *out_, int what)
{
  start = 0;
  total = 0;
  count = 0;
  mySyscall = what;
  out = out_;
}

Hook::~Hook()
{
}

void
Hook::Enter(const struct prstatus *p, int procfd)
{
  /*
   * Sanity check: must be an exit for each entry.
   * Two possible bugs if this triggers. 1: some random screw up.
   * 2: trying to trace multithreaded program (need to fix
   * hook to handle multi-threaded case.)
   */
  assert(start == 0);
  assert(mySyscall == p->pr_what);
  start = gethrtime();
  /*
   * Might be more efficient to write raw data?
   */
  fprintf(out, "%d %s enter %lld lwp %d of %d\n", p->pr_what, 
	  SE_sysCallName[p->pr_what],
	  start, p->pr_who, p->pr_nlwp);
}

hrtime_t
Hook::Exit(const struct prstatus *p, int procfd)
{
  hrtime_t end;
  hrtime_t elapsed;
  /*
   * Sanity check: must be an exit for each entry.
   * Two possible bugs if this triggers. 1: some random screw up.
   * 2: trying to trace multithreaded program (need to fix
   * hook to handle multi-threaded case.)
   */
  //assert(start != 0);

  assert(mySyscall == p->pr_what);
  end = gethrtime();
  /*
   * Might be more efficient to write raw data?
   */
  fprintf(out, "%d %s exit %lld lwp %d of %d\n", p->pr_what, 
	  SE_sysCallName[p->pr_what],
	  end, p->pr_who, p->pr_nlwp);
  count++;
  if(start == 0){
    return 0;
  }
  elapsed = end-start;
  total += elapsed;
  start = 0;
  return elapsed;
}


void 
Hook::Report(void)
{
  float avg;
  avg = ((float)total)/((float)count);
  if(count != 0){
    if(!tracedProgIsMultithreaded){
      fprintf(out, "%d %s count %d total %lld avg %f\n",
	      mySyscall, SE_sysCallName[mySyscall], count, total, avg);
    }
    else{
      fprintf(out, "%d %s count %d (no total/avg for multithreaded procs)\n",
	      mySyscall, SE_sysCallName[mySyscall], count);
    }
  }
}

