#ifndef _HOOK_H_
#define _HOOK_H_
#include <sys/time.h>
#include <stdio.h>
class Hook{
public:
  Hook(FILE *out, int callNum);
  virtual ~Hook(void);
  virtual void Enter(const struct prstatus *prstat, int tracefd);
  virtual hrtime_t Exit(const struct prstatus *prstat, int tracefd);
  virtual void Report(void);
private:
  /*
   * We keep track of when the last system call started and 
   * current one ends, the count of system calls, and total
   * elapsed time for this call. 
   * Note: this is not safe for multithreaded programs -- 
   * we would need an array of start[] in case different
   * threads call the same system call simultaneously.
   * (We would also need a lock).
   */
  hrtime_t start;
  hrtime_t total;
  int mySyscall;
  int count;
protected:
  FILE *out;
};
#endif _HOOK_H_
