#include <assert.h>
#include <sys/procfs.h>
#include <sys/syscall.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "LWPHook.h"
#include "global.h"

LWPHook::LWPHook(FILE *out_, int callNum):Hook(out_, callNum)
{
}

void
LWPHook::Enter(const struct prstatus *p, int procfd)
{

  Hook::Enter(p, procfd);
  /*
   * We need to write down that this program has multiple threads
   * because our statistics code assumes that exit time - enter time
   * is elapsed time; not true if multiple threads. To make that
   * code work with multiple threads, would need an array of enter/exit
   * times.
   */
  tracedProgIsMultithreaded = 1;

}

