#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/procfs.h>
#include <sys/syscall.h>
#include <sys/systm.h>   /* for NSYSCALL */
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/statvfs.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <unistd.h>
#include "fetchstr.h"
#include "global.h"
#include "OpenFileHook.h"
#include "FDClass.h"

OpenFileHook::OpenFileHook(FILE *out_, int what):Hook(out_, what)
{
  int ii;
  rtot = (hrtime_t *)malloc(MAXFDCLASS * sizeof(hrtime_t));
  rcount = (int *)malloc(MAXFDCLASS * sizeof(int));
  
  for(ii=0;ii<MAXFDCLASS;ii++){
    rtot[ii] = 0;
    rcount[ii] = 0;
  }
}


hrtime_t
OpenFileHook::Exit(const struct prstatus *p, int procfd)
{

  int openfd;
  char buf[80];
  struct statvfs stvfs;
  hrtime_t tot;
  int error;
  FdClass cl;
  char *fileName;

  tot = Hook::Exit(p, procfd);

  openfd = p->pr_reg[R_O0]; // return value is in R_O0

  fileName = fetchstr(procfd, (char *)p->pr_sysarg[0]);
  fileName = canonicalize(fileName);
  cl = fdClassMap->open(openfd, fileName);
  fprintf(out, "NOTE: open %s returns fd %d class %s\n", fileName, openfd,
	  fdClassMap->classToName(cl));
  free(fileName);

  rtot[cl] += tot;
  rcount[cl]++;

  return tot; 
}


/*
 * canonicalize -- take a file pathname and canonicalize it
 * to ease path matching and catch attempts to subvert the
 * security policy (e.g. "otherwise/../../valid/path").
 * 
 * returns the new pointer to the pathname.  the original pathname
 * must have been allocated with malloc.  might modify the argument
 * in place, or just return a new pointer to a canonicalized pathname.
 * 
 * returns 0 upon failure.  the caller must deny the request upon failure.
 * 
 * the following transformations are applied:
 *	deny ".."
 *	fold "//" to "/"
 *	fold "/./" to "/"
 * 	eliminate leading "./"s
 * 	turn "" into "."
 * 
 * apologies for duplicating file handling code from the kernel.
 * it's more-or-less necessary in a user-level tool like this.
 */
char	*
OpenFileHook::canonicalize(char *path)
{
	char	*p, *q;

	/* "//"		-->	"/" */
	while ((p = strstr(path, "//"))) {
		/* strcpy(p, p+1); */
		for (q=p; *(q+1); q++)
			*q = *(q+1);
		*q = '\0';
	}

	/* "/./"	-->	"/" */
	while ((p = strstr(path, "/./"))) {
		/* strcpy(p, p+2); */
		for (q=p; *(q+2); q++)
			*q = *(q+2);
		*q = '\0';
	}

	/* ^"./"	-->	"" */
	while ((path[0] == '.' && path[1] == '/')) {
		/* strcpy(path, path+2); */
		for (q=path; *(q+2); q++)
			*q = *(q+2);
		*q = '\0';
	}

	/* ""		-->	"." */
	if (strcmp(path, "") == 0) {
		path = (char *)realloc(path, 2);
		if (path)
			strcpy(path, ".");
	}

	return(path);
}

void 
OpenFileHook::Report()
{
  int ii;
  Hook::Report();
  for(ii=0;ii<MAXFDCLASS;ii++){
    if(!tracedProgIsMultithreaded){
      fprintf(out,"  %s count %d total %lld avg %f\n", 
	      fdClassMap->classToName((FdClass)ii),
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
    }
    else{
      fprintf(out,"  %s count %d  (no total/avg for multithreaded procs)\n",
	      fdClassMap->classToName((FdClass)ii),
	      rcount[ii]);
    }
  }
}
