#include <assert.h>
#include <stdio.h>
#include <sys/procfs.h>
#include <sys/syscall.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "PageFaultHook.h"
#include "sysentry.h"
PageFaultHook::PageFaultHook(FILE *out_, int what):Hook(out_, what)
{
  pcount = 0;
}


void
PageFaultHook::Enter(const struct prstatus *p, int procfd)
{
  /*
   * Don't call Hook::Enter() because we never get exit for
   * page fault, so completely override those methods
   */
  hrtime_t pstart = gethrtime();
  pcount++;
  /*
   * Might be more efficient to write raw data?
   */
  fprintf(out, "-999 PageFault enter %lld\n", pstart);
}

hrtime_t
PageFaultHook::Exit(const struct prstatus *p, int procfd)
{
  /*
   * Right now, we don't have a hook in to tell us when page faults
   * exit. From Manish Gupta's work on the problem:
   *
   * 4. An idea on how to find the time spent in a page fault:
   *
   * The reason to have a roundabout method for doing this is that unlike a
   * system call entry and exit hook, we have only an entry hook. So you
   * cannot find the amount of time spent by simply taking the difference.
   * A trick is to change the instruction which caused the page fault to
   * occur and replace it with an illegal instruction. This will cause an
   * illegal instruction fault to occur, which can be hooked and then the
   * time difference between the occurrence of the page fault and that of
   * an illegal instruction can be found and this is approximately the time
   * required for a page fault recovery. You can then restore the original
   * instruction that was replaced before starting the program again.
   */
  assert(0);
  return -999999;
}


void 
PageFaultHook::Report(void)
{
  fprintf(out, "-999 PageFault count %d\n", pcount);
}

