#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/procfs.h>
#include <sys/syscall.h>
#include <sys/systm.h>   /* for NSYSCALL */
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/statvfs.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <unistd.h>
#include "RWFileHook.h"

RWFileHook::RWFileHook(FILE *out_, int what):Hook(out_, what)
{
  int ii;
  rtot = (hrtime_t *)malloc(AVAILABLEFS * sizeof(hrtime_t));
  rcount = (int *)malloc(AVAILABLEFS * sizeof(int));
  
  for(ii=0;ii<AVAILABLEFS;ii++){
    rtot[ii] = 0;
    rcount[ii] = 0;
  }
}

hrtime_t
RWFileHook::Exit(const struct prstatus *p, int procfd)
{

  int readfd;
  char buf[80];
  struct statvfs stvfs;
  hrtime_t tot;
  int error;

  tot = Hook::Exit(p, procfd);

  readfd= p->pr_sysarg[0];
  error = fstatvfs(readfd,&stvfs);
  if(error == -1){
    /*
     * Probably a failed read call. 
     */
    rtot[ERRORFS] += tot;
    rcount[ERRORFS]++;
  }

  else if(strcmp("ufs",stvfs.f_basetype)==0){
    rtot[UFS] += tot;
    rcount[UFS]++;
  }
  else  if(strcmp("nfs",stvfs.f_basetype)==0){
    rtot[NFS] += tot;
    rcount[NFS]++;
  }
  else  if(strcmp("proc",stvfs.f_basetype)==0){
    rtot[PROC] += tot;
    rcount[PROC]++;
  }
  else  if(strcmp("swap",stvfs.f_basetype)==0){
    rtot[SWAP] += tot;
    rcount[SWAP]++;
  }
  else if(strcmp("fd",stvfs.f_basetype)==0){
    rtot[FD] += tot;
    rcount[FD]++;
  }
  else  if(strcmp("tmpfs",stvfs.f_basetype)==0){
    rtot[TMPFS] += tot;
    rcount[TMPFS]++;
  }
  else{
    rtot[UNKNOWNFS] += tot;
    rcount[UNKNOWNFS]++;
  }

  return tot; 

}


void 
RWFileHook::Report()
{
  int ii;
  Hook::Report();
  for(ii=0;ii<AVAILABLEFS;ii++){
    switch(ii){
    case  UFS :
      fprintf(out,"ufs count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case NFS:
      fprintf(out,"nfs count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case PROC: 
      fprintf(out,"proc count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case SWAP: 
      fprintf(out,"swap count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case FD: 
      fprintf(out,"fd count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case TMPFS: 
      fprintf(out,"tempfs count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case UNKNOWNFS: 
      fprintf(out,"unknown count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    case ERRORFS: 
      fprintf(out,"errorfs count %d total %lld avg %f\n", 
	      rcount[ii],
	      rtot[ii],
	      ((float)rtot[ii])/((float)rcount[ii]));
      break;
    default: 
      fprintf(out,"other\t%d\t%lld\n",rcount[ii],rtot[ii]);
    }
  }
}
