#ifndef _RWFileHook_H_
#define _RWFileHook_H_

#include <stdio.h>
#include <sys/time.h>
#include "Hook.h"

const int UFS = 0;
const int NFS = 1;
const int PROC = 2;
const int SWAP = 3;
const int FD = 4;
const int TMPFS = 5;
const int UNKNOWNFS = 6;
const int ERRORFS = 7;
const int AVAILABLEFS = 8;
const int MAXFSTYPE = 16;

class RWFileHook : public Hook{
public:
  RWFileHook(FILE *outFd, int callNum);
  virtual hrtime_t Exit(const struct prstatus *prstat, int tracefd);
  virtual void Report(void);
protected:
  hrtime_t *rtot;
  int *rcount;
};
#endif _RWFileHook_H_
