#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/syscall.h>
#include <sys/systm.h>   /* for NSYSCALL */
#include <sys/time.h>

#include <sys/types.h>
#include <unistd.h>


#include "log.h"
#include "global.h"
char *sysCallName[NSYSCALL] ={
   "SYS_syscall", 
   "SYS_exit",
   "SYS_fork",
   "SYS_read", 
   "SYS_write",
   "SYS_open", 
   "SYS_close",
   "SYS_wait",
   "SYS_creat",
   "SYS_link", 
   "SYS_unlink", 
   "SYS_exec", 
   "SYS_chdir", 
   "SYS_time",
   "SYS_mknod", 
   "SYS_chmod",
   "SYS_chown",
   "SYS_brk",
   "SYS_stat",
   "SYS_lseek", 
   "SYS_getpid",
   "SYS_mount",
   "SYS_umount",
   "SYS_setuid", 
   "SYS_getuid", 
   "SYS_stime",
   "SYS_ptrace",
   "SYS_alarm", 
   "SYS_fstat", 
   "SYS_pause",
   "SYS_utime",
   "SYS_stty", 
   "SYS_gtty",
   "SYS_access", 
   "SYS_nice", 
   "SYS_statfs",
   "SYS_sync",
   "SYS_kill", 
   "SYS_fstatfs",
   "SYS_pgrpsys", 
   "SYS_xenix", 
   "SYS_dup", 
   "SYS_pipe", 
   "SYS_times",
   "SYS_profil",
   "SYS_plock", 
   "SYS_setgid",
   "SYS_getgid", 
   "SYS_signal", 
   "SYS_msgsys", 
   "SYS_syssun",
   "SYS_acct", 
   "SYS_shmsys",
   "SYS_semsys", 
   "SYS_ioctl", 
   "SYS_uadmin", 
   "56",
   "SYS_utssys", 
   "SYS_fdsync", 
   "SYS_execve", 
   "SYS_umask", 
   "SYS_chroot", 
   "SYS_fcntl", 
   "SYS_ulimit",
   "64", 
   "65",
   "66", 
   "67",
   "68", 
   "69", 
   "70",
   "71",
   "72",
   "73", 
   "74", 
   "75", 
   "76", 
   "77",
   "78",
   "SYS_rmdir", 
   "SYS_mkdir",
   "SYS_getdents", 
   "82",
   "83",
   "SYS_sysfs", 
   "SYS_getmsg", 
   "SYS_putmsg", 
   "SYS_poll",
   "SYS_lstat",
   "SYS_symlink", 
   "SYS_readlink",
   "SYS_setgroups", 
   "SYS_getgroups", 
   "SYS_fchmod", 
   "SYS_fchown", 
   "SYS_sigprocmask",
   "SYS_sigsuspend",
   "SYS_sigaltstack",
   "SYS_sigaction",
   "SYS_sigpending",
   "SYS_context",
   "SYS_evsys",
   "SYS_evtrapret",
   "SYS_statvfs", 
   "SYS_fstatvfs",
   "105", 
   "SYS_nfssys",
   "SYS_waitsys", 
   "SYS_sigsendsys",
   "SYS_hrtsys", 
   "SYS_acancel",
   "SYS_async",
   "SYS_priocntlsys", 
   "SYS_pathconf",
   "SYS_mincore",
   "SYS_mmap",
   "SYS_mprotect", 
   "SYS_munmap",
   "SYS_fpathconf", 
   "SYS_vfork",
   "SYS_fchdir", 
   "SYS_readv",
   "SYS_writev",
   "SYS_xstat",
   "SYS_lxstat", 
   "SYS_fxstat", 
   "SYS_xmknod",
   "SYS_clocal", 
   "SYS_setrlimit", 
   "SYS_getrlimit",
   "SYS_lchown",
   "SYS_memcntl",
   "SYS_getpmsg",
   "SYS_putpmsg",
   "SYS_rename",
   "SYS_uname", 
   "SYS_setegid", 
   "SYS_sysconfig", 
   "SYS_adjtime",
   "SYS_systeminfo", 
   "140",
   "SYS_seteuid",
   "SYS_vtrace",
   "SYS_fork1",
   "SYS_sigtimedwait",
   "SYS_lwp_info",
   "SYS_yield",
   "SYS_lwp_sema_wait",
   "SYS_lwp_sema_post", 
   "149",
   "150", 
   "151",
   "SYS_modctl",
   "SYS_fchroot", 
   "SYS_utimes",
   "SYS_vhangup",
   "SYS_gettimeofday",
   "SYS_getitimer", 
   "SYS_setitimer",
   "SYS_lwp_create", 
   "SYS_lwp_exit", 
   "SYS_lwp_suspend",
   "SYS_lwp_continue",
   "SYS_lwp_kill",
   "SYS_lwp_self", 
   "SYS_lwp_setprivate", 
   "SYS_lwp_getprivate", 
   "SYS_lwp_wait", 
   "SYS_lwp_mutex_unlock", 
   "SYS_lwp_mutex_lock", 
   "SYS_lwp_cond_wait", 
   "SYS_lwp_cond_signal", 
   "SYS_lwp_cond_broadcast",
   "SYS_pread",
   "SYS_pwrite",
   "SYS_llseek", 
   "SYS_inst_sync",
   "177",
   "SYS_kaio",
   "179", 
   "180", 
   "181",
   "182",
   "183", 
   "SYS_tsolsys",
   "SYS_acl",
   "SYS_auditsys",
   "SYS_processor_bind",
   "SYS_processor_info",
   "SYS_p_online",
   "SYS_sigqueue",
   "SYS_clock_gettime",
   "SYS_clock_settime",
   "SYS_clock_getres", 
   "SYS_timer_create",
   "SYS_timer_delete", 
   "SYS_timer_settime",
   "SYS_timer_gettime", 
   "SYS_timer_getoverrun",
   "SYS_nanosleep", 
   "SYS_facl", 
   "SYS_door",
   "SYS_setreuid",
   "SYS_setregid",
   "204",
   "205", 
   "206",
   "207",
   "208",
   "209",
   "SYS_signotifywait", 
   "SYS_lwp_sigredirect", 
   "SYS_lwp_alarm",
   };
      


Log::Log(int pid, char *program_){
  
  readStart=writeStart=0;
  readtime[2]=0;
  pgfaultCount=0;
  setup(pid, 0, program_);  
}

Log::~Log(){

}

void
Log::setup(int pid, int parent, char *prg)
{
  myPid = pid;
  parentPid = parent;
  if(prg == NULL){
    prg = "<Traced program>";
  }
  assert(prg != NULL);
  program = (char *)malloc((strlen(prg) + 1) * sizeof(char));
  strcpy(program, prg);
}

void
Log::Enter(int sysNum)
{
  assert(sysNum < NSYSCALL);
  count[sysNum]++;
  lastEnter = sysNum;

  /* This should be the last thing we do */
  enterStart = gethrtime();
}

void
Log::Exit(int sysNum)
{
  hrtime_t end;

  /* This should be the first thing we do */
  end = gethrtime();


  if(sysNum == lastEnter){
    time[sysNum] += end - enterStart;
  }
  lastEnter = -1;
}

void
Log::Close()
{
  int ii;
  
  fflush(errLog);
    fprintf(errLog, "Pid %d done\n", myPid);
  fprintf(errLog, "ParentPid %d\n", parentPid);
  fprintf(errLog, "Name \t%s\n", program);
  fprintf(errLog, "Syscall count Totaltime(ns)\n");
  for(ii = 0; ii < NSYSCALL; ii++){
    if(count[ii] > 0){
      /* fprintf(errLog, "%s \t%d %lld\n", sysCallName[ii], count[ii], time[ii]/count[ii]);*/
fprintf(errLog, "%s \t%d \t%lld\n", sysCallName[ii], count[ii], time[ii]);
    }
  }
  fprintf(errLog,"\n Open time \n");

  for(ii=0;ii<AVAILABLEFS;ii++){
    switch(ii){
    case  UFS :fprintf(errLog,"ufs\t%d\t%lld\n",opencount[ii],opentime[ii]);
      break;
    case NFS:
      fprintf(errLog,"nfs\t%d\t%lld\n",opencount[ii],opentime[ii]);
      break;
    case PROC: 
      fprintf(errLog,"proc\t%d\t%lld\n",opencount[ii],opentime[ii]);
      break;
    case SWAP: 
      fprintf(errLog,"swap\t%d\t%lld\n",opencount[ii],opentime[ii]);
      break;
    case FD: 
      fprintf(errLog,"fd\t%d\t%lld\n",opencount[ii],opentime[ii]);
      break;
    case TMPFS: 
      fprintf(errLog,"tempfs\t%d\t%lld\n",opencount[ii],opentime[ii]);
      break;
    case UNKNOWNFS: 
      fprintf(errLog,"unknown\t%d\t%lld\n",opencount[ii],opentime[ii]);
      
    }
    
  }

  fprintf(errLog,"\nRead time \n");
  for(ii=0;ii<AVAILABLEFS;ii++){
    switch(ii){
    case  UFS :fprintf(errLog,"ufs\t%d\t%lld\n",readcount[ii],readtime[ii]);
      break;
    case NFS:
      fprintf(errLog,"nfs\t%d\t%lld\n",readcount[ii],readtime[ii]);
      break;
    case PROC: 
      fprintf(errLog,"proc\t%d\t%lld\n",readcount[ii],readtime[ii]);
      break;
    case SWAP: 
      fprintf(errLog,"swap\t%d\t%lld\n",readcount[ii],readtime[ii]);
      break;
    case FD: 
      fprintf(errLog,"fd\t%d\t%lld\n",readcount[ii],readtime[ii]);
      break;
    case TMPFS: 
      fprintf(errLog,"tempfs\t%d\t%lld\n",readcount[ii],readtime[ii]);
      break;
    case UNKNOWNFS: 
      fprintf(errLog,"unknown\t%d\t%lld\n",readcount[ii],readtime[ii]);
      
    }
  
  }


  fprintf(errLog,"\nWrite time \n");
  for(ii=0;ii<AVAILABLEFS;ii++){
    switch(ii){
    case  UFS :
      fprintf(errLog,"ufs\t%d\t%lld\n",writecount[ii],writetime[ii]);
      break;
    case NFS:
      fprintf(errLog,"nfs\t%d\t%lld\n",writecount[ii],writetime[ii]);
      break;
    case PROC: 
      fprintf(errLog,"proc\t%d\t%lld\n",writecount[ii],writetime[ii]);
      break;
    case SWAP: 
      fprintf(errLog,"swap\t%d\t%lld\n",writecount[ii],writetime[ii]);
      break;
    case FD: 
      fprintf(errLog,"fd\t%d\t%lld\n",writecount[ii],writetime[ii]);
      break;
    case TMPFS: 
      fprintf(errLog,"tempfs\t%d\t%lld\n",writecount[ii],writetime[ii]);
      break;
    case UNKNOWNFS: 
      fprintf(errLog,"unknown\t%d\t%lld\n",writecount[ii],writetime[ii]);
      
    }
    
  } 
  fprintf(errLog,"\nClose time \n");

  for(ii=0;ii<AVAILABLEFS;ii++){
    switch(ii){
    case  UFS :fprintf(errLog,"ufs\t%d\t%lld\n",closecount[ii],closetime[ii]);
      break;
    case NFS:
      fprintf(errLog,"nfs\t%d\t%lld\n",closecount[ii],closetime[ii]);
      break;
    case PROC: 
      fprintf(errLog,"proc\t%d\t%lld\n",closecount[ii],closetime[ii]);
      break;
    case SWAP: 
      fprintf(errLog,"swap\t%d\t%lld\n",closecount[ii],closetime[ii]);
      break;
    case FD: 
      fprintf(errLog,"fd\t%d\t%lld\n",closecount[ii],closetime[ii]);
      break;
    case TMPFS: 
      fprintf(errLog,"tempfs\t%d\t%lld\n",closecount[ii],closetime[ii]);
      break;
    case UNKNOWNFS: 
      fprintf(errLog,"unknown\t%d\t%lld\n",closecount[ii],closetime[ii]);
      
    }
  }
  fflush(errLog);
  //Page faults
   fprintf(errLog,"\nTotal Page Faults %d\n", pgfaultCount);
    fclose(errLog);
}
void
Log::Clear(int newPid, int parentPid_, char *newPrg)
{
  int ii;
  for(ii = 0; ii < NSYSCALL; ii++){
    count[ii] = 0;
    time[ii] = 0;

  }
  for(ii=0;ii<MAXFSTYPE;ii++){
    readtime[ii]=0;
    writetime[ii]=0;
    opentime[ii]=0;
    closetime[ii]=0;
    readStart=0;
    writeStart=0;
    openStart=0;
    closeStart=0;
    opencount[ii]=0;
    readcount[ii]=0;
    writecount[ii]=0;
    closecount[ii]=0;
  }
  pgfaultCount=0;
  if(!newPrg){
    //
    // Keep old name.
    //
    assert(program);
    newPrg = (char *)malloc((strlen(program) + 1) * sizeof(char));
    strcpy(newPrg, program);
  }
  assert(newPrg);
  free(program);
  program = NULL;
  lastEnter = -1;
  setup(newPid, parentPid_, newPrg);
}

void
Log::ProgName(char *newProg)
{
  if(program != NULL){
    free(program);
    program = NULL;
  }
  if(newProg != NULL){
    program = (char *)malloc((strlen(newProg) + 1) * sizeof(char));
    strcpy(program, newProg);
  }
}




void Log::errorInCase(int prwhat)
{
  fprintf(errLog, "Error in case statement: %d (make sure not too many of these)\n");
}
