#ifndef _Log_h_
#define _Log_h_
#include <sys/systm.h>   /* for NSYSCALL */


#define MAXFSTYPE 16
#define UFS 0
#define NFS 1
#define PROC 2
#define SWAP 3
#define FD 4
#define TMPFS 5
#define UNKNOWNFS 6
#define AVAILABLEFS 7

class Log{
public:
  Log(int pid, char *progName);
  ~ Log();
  void Enter(int sysNum);
  void Exit(int sysNum);
  void Close();
  void Clear(int newPid, int parentPid, char *progName);
  void ProgName(char *progName);
  void errorInCase(int);

  hrtime_t readtime[MAXFSTYPE];
  hrtime_t writetime[MAXFSTYPE];
  hrtime_t opentime[MAXFSTYPE];
  hrtime_t closetime[MAXFSTYPE];
  hrtime_t readStart;/*when did a read start*/
  hrtime_t writeStart;/*when write started*/
  hrtime_t openStart;/*when an open started*/
  hrtime_t closeStart;/*when an open started*/
  int opencount[MAXFSTYPE];
  int readcount[MAXFSTYPE];
  int writecount[MAXFSTYPE];
  int closecount[MAXFSTYPE];

  //for mmap addresses
  unsigned long *upperAdd;
  unsigned long *lowerAdd;
  int addcount;
  int addsize;
  int pgfaultCount;

private:
  int myPid;
  int parentPid;
  char *program;
 
  int lastEnter; /* last sysnum to enter a syscall */
  hrtime_t enterStart;  /* when did last syscall begin */
  int count[NSYSCALL];
  hrtime_t time[NSYSCALL];
  
  void setup(int newPid, int parentPid, char *progName);
};

#endif


