/*
 * Copyright (c) 1993 The Regents of the University of California.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef __MODULE_H__
#define __MODULE_H__

#include <sys/syscall.h>
#include <sys/procfs.h>
#include <sys/systm.h> /* for NSYSCALL */

#define INIT_FAIL ((void *)-1)

typedef enum {
    NO_COMMENT, DENY, ALLOW, SUPER_ALLOW, SUPER_DENY,
    FUNC, EXIT_FUNC /* for syscall_entry.kind only */
} action;

typedef struct {
    int		which;
    action	kind; /* if kind == FUNC, call hook() below */
    action	(*hook)(const struct prstatus *, int, void *);
} syscall_entry;

/* see example-module.c for an example of how to use this */

#endif
