/*
 * Copyright (c) 1993 The Regents of the University of California.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

/* compile me with gcc foo.c -G -o foo.so */

#include "module.h"
#include "version.h"
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

extern char **environ;
extern char **traced_environ;

void *	init(const char *conf_line)
{
    /* Parse conf_line */
    char *env_line;
    char *end_word;
    char *next_word;
    static char *empty_env[] = { NULL };

    if (!conf_line) return NULL;
    if (!*conf_line)
    {
	/* Kill the environment */
	traced_environ = empty_env;
	return NULL;
    }

    env_line = strdup(conf_line);
    if (!env_line) return(INIT_FAIL);

    while(env_line)
    {
	char **save_environ;

	/* Strip leading whitespace */
	env_line += strspn(env_line, " \t");

	/* Quit if the line's over */
	if (!*env_line) break;

	/* Find the end of the word starting at env_line */
	end_word = strpbrk(env_line, " \t");
	if (end_word)
	{
	    *end_word = '\0';
	    next_word = end_word+1;
	}
	else
	{
	    next_word = NULL;
	}

	if (!strcmp(env_line, "display"))
	{
	    /* Special case; use the current DISPLAY, converted to
		dotted quad. */
	    char *dpy = getenv("DISPLAY");
	    char *dpynewenv;
	    char *colon;

	    if (!dpy) { env_line = next_word; continue;}
	    colon = strchr(dpy, ':');
	    if (!colon) { env_line = next_word; continue;}
	    *colon = '\0';
	    ++colon;

	    dpynewenv = (char *)malloc(25+strlen(colon));
	    strcpy(dpynewenv, "DISPLAY=");
	    if (*dpy == '\0')
	    {
		/* Nothing */
	    }
	    else if (*dpy >= '0' && *dpy <= '9')
	    {
		strncat(dpynewenv, dpy, 15);
	    }
	    else
	    {
		struct hostent *hst = gethostbyname(dpy);
		struct in_addr ina;
		if (!hst || !hst->h_addr_list || !*hst->h_addr_list)
		    { env_line = next_word; continue;}
		ina.s_addr = *(unsigned long *)(*hst->h_addr_list);
		strncat(dpynewenv, inet_ntoa(ina), 15);
	    }
	    strcat(dpynewenv, ":");
	    strcat(dpynewenv, colon);

	    env_line = dpynewenv;
	}

	save_environ = environ;
	environ = traced_environ;
	putenv(env_line);
	traced_environ = environ;
	environ = save_environ;

	env_line = next_word;
    }

    return NULL;
}

const int		nentries = 0;
