/*
 *------------------------------------------------------------------
 *
 * sysentry.cc --
 *
 *          Each sysentry specifies the action that should
 *          be taken on entry/exit of a system call.
 *
 *------------------------------------------------------------------
 */
#include <assert.h>
#include <sys/syscall.h>
#include <sys/procfs.h>
#include <sys/systm.h> /* for NSYSCALL */
#include <stdio.h>

#include "ExecHook.h"
#include "Hook.h"
#include "CloseFileHook.h"
#include "OpenFileHook.h"
#include "PageFaultHook.h"
#include "RWFileHook.h"
#include "LWPHook.h"

#include "sysentry.h"

SyscallEntry sysDispatch[NSYSCALL];

Hook *SE_pageFaultHook = NULL;


char *SE_sysCallName[NSYSCALL] ={
   "SYS_syscall", 
   "SYS_exit",
   "SYS_fork",
   "SYS_read", 
   "SYS_write",
   "SYS_open", 
   "SYS_close",
   "SYS_wait",
   "SYS_creat",
   "SYS_link", 
   "SYS_unlink", 
   "SYS_exec", 
   "SYS_chdir", 
   "SYS_time",
   "SYS_mknod", 
   "SYS_chmod",
   "SYS_chown",
   "SYS_brk",
   "SYS_stat",
   "SYS_lseek", 
   "SYS_getpid",
   "SYS_mount",
   "SYS_umount",
   "SYS_setuid", 
   "SYS_getuid", 
   "SYS_stime",
   "SYS_ptrace",
   "SYS_alarm", 
   "SYS_fstat", 
   "SYS_pause",
   "SYS_utime",
   "SYS_stty", 
   "SYS_gtty",
   "SYS_access", 
   "SYS_nice", 
   "SYS_statfs",
   "SYS_sync",
   "SYS_kill", 
   "SYS_fstatfs",
   "SYS_pgrpsys", 
   "SYS_xenix", 
   "SYS_dup", 
   "SYS_pipe", 
   "SYS_times",
   "SYS_profil",
   "SYS_plock", 
   "SYS_setgid",
   "SYS_getgid", 
   "SYS_signal", 
   "SYS_msgsys", 
   "SYS_syssun",
   "SYS_acct", 
   "SYS_shmsys",
   "SYS_semsys", 
   "SYS_ioctl", 
   "SYS_uadmin", 
   "56",
   "SYS_utssys", 
   "SYS_fdsync", 
   "SYS_execve", 
   "SYS_umask", 
   "SYS_chroot", 
   "SYS_fcntl", 
   "SYS_ulimit",
   "64", 
   "65",
   "66", 
   "67",
   "68", 
   "69", 
   "70",
   "71",
   "72",
   "73", 
   "74", 
   "75", 
   "76", 
   "77",
   "78",
   "SYS_rmdir", 
   "SYS_mkdir",
   "SYS_getdents", 
   "82",
   "83",
   "SYS_sysfs", 
   "SYS_getmsg", 
   "SYS_putmsg", 
   "SYS_poll",
   "SYS_lstat",
   "SYS_symlink", 
   "SYS_readlink",
   "SYS_setgroups", 
   "SYS_getgroups", 
   "SYS_fchmod", 
   "SYS_fchown", 
   "SYS_sigprocmask",
   "SYS_sigsuspend",
   "SYS_sigaltstack",
   "SYS_sigaction",
   "SYS_sigpending",
   "SYS_context",
   "SYS_evsys",
   "SYS_evtrapret",
   "SYS_statvfs", 
   "SYS_fstatvfs",
   "105", 
   "SYS_nfssys",
   "SYS_waitsys", 
   "SYS_sigsendsys",
   "SYS_hrtsys", 
   "SYS_acancel",
   "SYS_async",
   "SYS_priocntlsys", 
   "SYS_pathconf",
   "SYS_mincore",
   "SYS_mmap",
   "SYS_mprotect", 
   "SYS_munmap",
   "SYS_fpathconf", 
   "SYS_vfork",
   "SYS_fchdir", 
   "SYS_readv",
   "SYS_writev",
   "SYS_xstat",
   "SYS_lxstat", 
   "SYS_fxstat", 
   "SYS_xmknod",
   "SYS_clocal", 
   "SYS_setrlimit", 
   "SYS_getrlimit",
   "SYS_lchown",
   "SYS_memcntl",
   "SYS_getpmsg",
   "SYS_putpmsg",
   "SYS_rename",
   "SYS_uname", 
   "SYS_setegid", 
   "SYS_sysconfig", 
   "SYS_adjtime",
   "SYS_systeminfo", 
   "140",
   "SYS_seteuid",
   "SYS_vtrace",
   "SYS_fork1",
   "SYS_sigtimedwait",
   "SYS_lwp_info",
   "SYS_yield",
   "SYS_lwp_sema_wait",
   "SYS_lwp_sema_post", 
   "149",
   "150", 
   "151",
   "SYS_modctl",
   "SYS_fchroot", 
   "SYS_utimes",
   "SYS_vhangup",
   "SYS_gettimeofday",
   "SYS_getitimer", 
   "SYS_setitimer",
   "SYS_lwp_create", 
   "SYS_lwp_exit", 
   "SYS_lwp_suspend",
   "SYS_lwp_continue",
   "SYS_lwp_kill",
   "SYS_lwp_self", 
   "SYS_lwp_setprivate", 
   "SYS_lwp_getprivate", 
   "SYS_lwp_wait", 
   "SYS_lwp_mutex_unlock", 
   "SYS_lwp_mutex_lock", 
   "SYS_lwp_cond_wait", 
   "SYS_lwp_cond_signal", 
   "SYS_lwp_cond_broadcast",
   "SYS_pread",
   "SYS_pwrite",
   "SYS_llseek", 
   "SYS_inst_sync",
   "177",
   "SYS_kaio",
   "179", 
   "180", 
   "181",
   "182",
   "183", 
   "SYS_tsolsys",
   "SYS_acl",
   "SYS_auditsys",
   "SYS_processor_bind",
   "SYS_processor_info",
   "SYS_p_online",
   "SYS_sigqueue",
   "SYS_clock_gettime",
   "SYS_clock_settime",
   "SYS_clock_getres", 
   "SYS_timer_create",
   "SYS_timer_delete", 
   "SYS_timer_settime",
   "SYS_timer_gettime", 
   "SYS_timer_getoverrun",
   "SYS_nanosleep", 
   "SYS_facl", 
   "SYS_door",
   "SYS_setreuid",
   "SYS_setregid",
   "204",
   "205", 
   "206",
   "207",
   "208",
   "209",
   "SYS_signotifywait", 
   "SYS_lwp_sigredirect", 
   "SYS_lwp_alarm",
   };
      

void SE_init(FILE *log)
{
  int ii;
  for(ii = 0; ii < NSYSCALL; ii++){
    sysDispatch[ii].which = ii;
    delete(sysDispatch[ii].hook);
  }

  SE_pageFaultHook = new PageFaultHook(log, -999);

  ii = 0;
  sysDispatch[SYS_syscall].hook = new Hook(log, ii++);
  sysDispatch[SYS_exit].hook = new Hook(log, ii++);
  sysDispatch[SYS_fork].hook = new Hook(log, ii++);
  sysDispatch[SYS_read].hook = new RWFileHook(log, ii++);
  sysDispatch[SYS_write].hook = new RWFileHook(log, ii++);
  sysDispatch[SYS_open].hook = new OpenFileHook(log, ii++);
  sysDispatch[SYS_close].hook = new CloseFileHook(log, ii++);
  sysDispatch[SYS_wait].hook = new Hook(log, ii++);
  sysDispatch[SYS_creat].hook = new Hook(log, ii++);
  sysDispatch[SYS_link].hook = new Hook(log, ii++);
  sysDispatch[SYS_unlink].hook = new Hook(log, ii++);
  sysDispatch[SYS_exec].hook = new ExecHook(log, ii++);
  sysDispatch[SYS_chdir].hook = new Hook(log, ii++);
  sysDispatch[SYS_time].hook = new Hook(log, ii++);
  sysDispatch[SYS_mknod].hook = new Hook(log, ii++);
  sysDispatch[SYS_chmod].hook = new Hook(log, ii++);
  sysDispatch[SYS_chown].hook = new Hook(log, ii++);
  sysDispatch[SYS_brk].hook = new Hook(log, ii++);
  sysDispatch[SYS_stat].hook = new Hook(log, ii++);
  sysDispatch[SYS_lseek].hook = new Hook(log, ii++);
  sysDispatch[SYS_getpid].hook = new Hook(log, ii++);
  sysDispatch[SYS_mount].hook = new Hook(log, ii++);
  sysDispatch[SYS_umount].hook = new Hook(log, ii++);
  sysDispatch[SYS_setuid].hook = new Hook(log, ii++);
  sysDispatch[SYS_getuid].hook = new Hook(log, ii++);
  sysDispatch[SYS_stime].hook = new Hook(log, ii++);
  sysDispatch[SYS_ptrace].hook = new Hook(log, ii++);
  sysDispatch[SYS_alarm].hook = new Hook(log, ii++);
  sysDispatch[SYS_fstat].hook = new Hook(log, ii++);
  sysDispatch[SYS_pause].hook = new Hook(log, ii++);
  sysDispatch[SYS_utime].hook = new Hook(log, ii++);
  sysDispatch[SYS_stty].hook = new Hook(log, ii++);
  sysDispatch[SYS_gtty].hook = new Hook(log, ii++);
  sysDispatch[SYS_access].hook = new Hook(log, ii++);
  sysDispatch[SYS_nice].hook = new Hook(log, ii++);
  sysDispatch[SYS_statfs].hook = new Hook(log, ii++);
  sysDispatch[SYS_sync].hook = new Hook(log, ii++);
  sysDispatch[SYS_kill].hook = new Hook(log, ii++);
  sysDispatch[SYS_fstatfs].hook = new Hook(log, ii++);
  sysDispatch[SYS_pgrpsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_xenix].hook = new Hook(log, ii++);
  sysDispatch[SYS_dup].hook = new Hook(log, ii++);
  sysDispatch[SYS_pipe].hook = new Hook(log, ii++);
  sysDispatch[SYS_times].hook = new Hook(log, ii++);
  sysDispatch[SYS_profil].hook = new Hook(log, ii++);
  sysDispatch[SYS_plock].hook = new Hook(log, ii++);
  sysDispatch[SYS_setgid].hook = new Hook(log, ii++);
  sysDispatch[SYS_getgid].hook = new Hook(log, ii++);
  sysDispatch[SYS_signal].hook = new Hook(log, ii++);
  sysDispatch[SYS_msgsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_syssun].hook = new Hook(log, ii++); /* also: SYS_sysi86] SYS_sysppc */
  sysDispatch[SYS_acct].hook = new Hook(log, ii++);
  sysDispatch[SYS_shmsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_semsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_ioctl].hook = new Hook(log, ii++);
  sysDispatch[SYS_uadmin].hook = new Hook(log, ii++);
  sysDispatch[56].hook = new Hook(log, ii++);        /* 56 reserved for exch() */
  sysDispatch[SYS_utssys].hook = new Hook(log, ii++);
  sysDispatch[SYS_fdsync].hook = new Hook(log, ii++);
  sysDispatch[SYS_execve].hook = new ExecHook(log, ii++);
  sysDispatch[SYS_umask].hook = new Hook(log, ii++);
  sysDispatch[SYS_chroot].hook = new Hook(log, ii++);
  sysDispatch[SYS_fcntl].hook = new Hook(log, ii++);
  sysDispatch[SYS_ulimit].hook = new Hook(log, ii++);
  sysDispatch[64].hook = new Hook(log, ii++); /* 64-69 reserved for UNIX PC */
  sysDispatch[65].hook = new Hook(log, ii++);
  sysDispatch[66].hook = new Hook(log, ii++);
  sysDispatch[67].hook = new Hook(log, ii++);
  sysDispatch[68].hook = new Hook(log, ii++);
  sysDispatch[69].hook = new Hook(log, ii++);
  sysDispatch[70].hook = new Hook(log, ii++); /* 70 not used, was advfs */
  sysDispatch[71].hook = new Hook(log, ii++); /* 71 not used, was unadvfs */
  sysDispatch[72].hook = new Hook(log, ii++); /* 72 not used, was rmount */
  sysDispatch[73].hook = new Hook(log, ii++); /* 73 not used, was rumount */
  sysDispatch[74].hook = new Hook(log, ii++); /* 74 not used, was rfstart */
  sysDispatch[75].hook = new Hook(log, ii++); /* 75 not used, was sigret(SunOS) */
  sysDispatch[76].hook = new Hook(log, ii++); /* 76 not used, was rdebug */
  sysDispatch[77].hook = new Hook(log, ii++); /* 77 not used, was rfstop */
  sysDispatch[78].hook = new Hook(log, ii++); /* 78 not used, was rfsys */
  sysDispatch[SYS_rmdir].hook = new Hook(log, ii++);
  sysDispatch[SYS_mkdir].hook = new Hook(log, ii++);
  sysDispatch[SYS_getdents].hook = new Hook(log, ii++);
  sysDispatch[82].hook = new Hook(log, ii++); /* 82 not used, was libattach */
  sysDispatch[83].hook = new Hook(log, ii++); /* 83 not used, was libdetach */
  sysDispatch[SYS_sysfs].hook = new Hook(log, ii++);
  sysDispatch[SYS_getmsg].hook = new Hook(log, ii++);
  sysDispatch[SYS_putmsg].hook = new Hook(log, ii++);
  sysDispatch[SYS_poll].hook = new Hook(log, ii++);
  sysDispatch[SYS_lstat].hook = new Hook(log, ii++);
  sysDispatch[SYS_symlink].hook = new Hook(log, ii++);
  sysDispatch[SYS_readlink].hook = new Hook(log, ii++);
  sysDispatch[SYS_setgroups].hook = new Hook(log, ii++);
  sysDispatch[SYS_getgroups].hook = new Hook(log, ii++);
  sysDispatch[SYS_fchmod].hook = new Hook(log, ii++);
  sysDispatch[SYS_fchown].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigprocmask].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigsuspend].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigaltstack].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigaction].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigpending].hook = new Hook(log, ii++);
  sysDispatch[SYS_context].hook = new Hook(log, ii++);
  sysDispatch[SYS_evsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_evtrapret].hook = new Hook(log, ii++);
  sysDispatch[SYS_statvfs].hook = new Hook(log, ii++);
  sysDispatch[SYS_fstatvfs].hook = new Hook(log, ii++);
  sysDispatch[105].hook = new Hook(log, ii++); /* 105 reserved */
  sysDispatch[SYS_nfssys].hook = new Hook(log, ii++);
  sysDispatch[SYS_waitsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigsendsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_hrtsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_acancel].hook = new Hook(log, ii++);
  sysDispatch[SYS_async].hook = new Hook(log, ii++);
  sysDispatch[SYS_priocntlsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_pathconf].hook = new Hook(log, ii++);
  sysDispatch[SYS_mincore].hook = new Hook(log, ii++);

#if 0
  sysDispatch[SYS_mmap].hook = new MMapHook(log, ii++);
#endif
  sysDispatch[SYS_mmap].hook = new Hook(log, ii++);

  sysDispatch[SYS_mprotect].hook = new Hook(log, ii++);
#if 0
  sysDispatch[SYS_munmap].hook = new MMapHook(log, ii++);
#endif
  sysDispatch[SYS_munmap].hook = new Hook(log, ii++);

  sysDispatch[SYS_fpathconf].hook = new Hook(log, ii++);
  sysDispatch[SYS_vfork].hook = new Hook(log, ii++);
  sysDispatch[SYS_fchdir].hook = new Hook(log, ii++);
  sysDispatch[SYS_readv].hook = new Hook(log, ii++);
  sysDispatch[SYS_writev].hook = new Hook(log, ii++);
  sysDispatch[SYS_xstat].hook = new Hook(log, ii++);
  sysDispatch[SYS_lxstat].hook = new Hook(log, ii++);
  sysDispatch[SYS_fxstat].hook = new Hook(log, ii++);
  sysDispatch[SYS_xmknod].hook = new Hook(log, ii++);
  sysDispatch[SYS_clocal].hook = new Hook(log, ii++);
  sysDispatch[SYS_setrlimit].hook = new Hook(log, ii++);
  sysDispatch[SYS_getrlimit].hook = new Hook(log, ii++);
  sysDispatch[SYS_lchown].hook = new Hook(log, ii++);
  sysDispatch[SYS_memcntl].hook = new Hook(log, ii++);
  sysDispatch[SYS_getpmsg].hook = new Hook(log, ii++);
  sysDispatch[SYS_putpmsg].hook = new Hook(log, ii++);
  sysDispatch[SYS_rename].hook = new Hook(log, ii++);
  sysDispatch[SYS_uname].hook = new Hook(log, ii++);
  sysDispatch[SYS_setegid].hook = new Hook(log, ii++);
  sysDispatch[SYS_sysconfig].hook = new Hook(log, ii++);
  sysDispatch[SYS_adjtime].hook = new Hook(log, ii++);
  sysDispatch[SYS_systeminfo].hook = new Hook(log, ii++);
  sysDispatch[140].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[SYS_seteuid].hook = new Hook(log, ii++);
  sysDispatch[SYS_vtrace].hook = new Hook(log, ii++);
  sysDispatch[SYS_fork1].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigtimedwait].hook = new Hook(log, ii++);
  sysDispatch[SYS_lwp_info].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_yield].hook = new Hook(log, ii++);
  sysDispatch[SYS_lwp_sema_wait].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_sema_post].hook = new LWPHook(log, ii++);
  sysDispatch[149].hook = new Hook(log, ii++);  /* what is this supposed to be? */
  sysDispatch[150].hook = new Hook(log, ii++);  /* what is this supposed to be? */
  sysDispatch[151].hook = new Hook(log, ii++);  /* what is this supposed to be? */
  sysDispatch[SYS_modctl].hook = new Hook(log, ii++);
  sysDispatch[SYS_fchroot].hook = new Hook(log, ii++);
  sysDispatch[SYS_utimes].hook = new Hook(log, ii++);
  sysDispatch[SYS_vhangup].hook = new Hook(log, ii++);
  sysDispatch[SYS_gettimeofday].hook = new Hook(log, ii++);
  sysDispatch[SYS_getitimer].hook = new Hook(log, ii++);
  sysDispatch[SYS_setitimer].hook = new Hook(log, ii++);
  sysDispatch[SYS_lwp_create].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_exit].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_suspend].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_continue].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_kill].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_self].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_setprivate].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_getprivate].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_wait].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_mutex_unlock].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_mutex_lock].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_cond_wait].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_cond_signal].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_cond_broadcast].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_pread].hook = new RWFileHook(log, ii++);
  sysDispatch[SYS_pwrite].hook = new RWFileHook(log, ii++);
  sysDispatch[SYS_llseek].hook = new Hook(log, ii++);
  sysDispatch[SYS_inst_sync].hook = new Hook(log, ii++);
  sysDispatch[177].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[SYS_kaio].hook = new Hook(log, ii++);
  sysDispatch[179].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[180].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[181].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[182].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[183].hook = new Hook(log, ii++);   /* what is this supposed to be? */
  sysDispatch[SYS_tsolsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_acl].hook = new Hook(log, ii++);
  sysDispatch[SYS_auditsys].hook = new Hook(log, ii++);
  sysDispatch[SYS_processor_bind].hook = new Hook(log, ii++);
  sysDispatch[SYS_processor_info].hook = new Hook(log, ii++);
  sysDispatch[SYS_p_online].hook = new Hook(log, ii++);
  sysDispatch[SYS_sigqueue].hook = new Hook(log, ii++);
  sysDispatch[SYS_clock_gettime].hook = new Hook(log, ii++);
  sysDispatch[SYS_clock_settime].hook = new Hook(log, ii++);
  sysDispatch[SYS_clock_getres].hook = new Hook(log, ii++);
  sysDispatch[SYS_timer_create].hook = new Hook(log, ii++);
  sysDispatch[SYS_timer_delete].hook = new Hook(log, ii++);
  sysDispatch[SYS_timer_settime].hook = new Hook(log, ii++);
  sysDispatch[SYS_timer_gettime].hook = new Hook(log, ii++);
  sysDispatch[SYS_timer_getoverrun].hook = new Hook(log, ii++);
  sysDispatch[SYS_nanosleep].hook = new Hook(log, ii++);
  sysDispatch[SYS_facl].hook = new Hook(log, ii++);
  sysDispatch[SYS_door].hook = new Hook(log, ii++);
  sysDispatch[SYS_setreuid].hook = new Hook(log, ii++);
  sysDispatch[SYS_setregid].hook = new Hook(log, ii++);
 /* sysDispatch[SYS_install_utrap].hook = new Hook(log, ii++);*/
  sysDispatch[204].hook = new Hook(log, ii++); /* What is this supposed to be? */
  sysDispatch[205].hook = new Hook(log, ii++); /* What is this supposed to be? */
  sysDispatch[206].hook = new Hook(log, ii++); /* What is this supposed to be? */
  sysDispatch[207].hook = new Hook(log, ii++); /* What is this supposed to be? */
  sysDispatch[208].hook = new Hook(log, ii++); /* What is this supposed to be? */
  sysDispatch[209].hook = new Hook(log, ii++); /* What is this supposed to be? */
  sysDispatch[SYS_signotifywait].hook = new Hook(log, ii++);
  sysDispatch[SYS_lwp_sigredirect].hook = new LWPHook(log, ii++);
  sysDispatch[SYS_lwp_alarm].hook = new LWPHook(log, ii++);
}


void
SE_report()
{
  int ii;
  for(ii = 0; ii < NSYSCALL; ii++){
    assert(sysDispatch[ii].which == ii); // sanity check
    sysDispatch[ii].hook->Report();
  }
}


