/*
 *------------------------------------------------------------------
 *
 * sysentry.h --
 *
 *          Each sysentry specifies the action that should
 *          be taken on entry/exit of a system call.
 *
 *------------------------------------------------------------------
 */

#ifndef _SYSENTRY_H_
#define _SYSENTRY_H_

#include <sys/syscall.h>
#include <sys/procfs.h>
#include <sys/systm.h> /* for NSYSCALL */
#include <stdio.h>
#include "Hook.h"

void SE_init(FILE *log);
void SE_report();

extern Hook *SE_pageFaultHook;

typedef struct {
  int	which;   /* System call index */
  Hook  *hook;  /* object to invoke when syscall called */
} SyscallEntry;

extern SyscallEntry sysDispatch[NSYSCALL]; 
                                           /* Array of SyscallEntries that
					    * form the dispatch table for
					    * handling syscall entry and 
					    * exit. */

extern char *SE_sysCallName[NSYSCALL];

void SE_SelfTest();

#endif _SYSENTRY_H_
