//                              -*- Mode: Verilog -*-
// Filename        : datapath.v
// Description     : ALU
// Author          : Stephen W. Keckler
// Created On      : Wed Sep 24 10:01:44 2003
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!

`include "lc35.h"

module alu (instr, op1, op2, out);
   input [3:0] 	instr;
   input [15:0] op1, op2;
   output [15:0] out;

   wire [15:0] shift_data;
   reg [15:0] out;
   
   barrel_shifter shifter(instr, op1, op2[15], op2[3:0], shift_data);
   
   always @(instr or op1 or op2 or shift_data)
     begin
	case(instr)
	  `ADD, `LEA, `LD, `LDR, `ST, `STR, `BR, `JSR: out = op1 + op2;
	  `SUB: out = op1 + ~op2 + 1'b1;
	  `AND: out = op1 & op2;
	  `OR: out = op1 | op2;
	  `ASH: out = shift_data;
	  `LSH: out = shift_data;
	  `NOT: out = ~op1;
	  `LEA: out = op1 + op2;
	  `JMP: out = op1;
	  `TRAP: out = {8'b0, op2[7:0]};
	  default: out = op1;
	endcase // case(ctl)
     end // always @ (ctl, op1, op2)

endmodule	  


