//                              -*- Mode: Verilog -*-
// Filename        : lc35_top.s
// Description     : lc35 stimulus test file
// Author          : Stephen W. Keckler
// Created On      : Sun Oct  5 14:59:39 2003
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!

`include "lc35.h"

module timeunit;
   initial $timeformat(-9,1," ns",9);
endmodule

// testbench module

module TEST ( ) ;
   reg clk, reset;
   integer i, j, cycle, max_cycles;
   reg [200:1] pgm_file;

   lc35_top lc35(clk, reset);

   initial
     begin

	// load trap table and O/S code
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/getc.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'h0400);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/promptgetc.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'h04A0);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/putc.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'h0430);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/puts.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'h0450);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/putspacked.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'h04e0);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/startup.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'hfc00);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/undeftrap.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'hfd00);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/halt.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'hfd70);
	$readmemh("/u/www/users/skeckler/cs352h/lc35/os/ivtable.vhex", 
		  TEST.lc35.lc35_dp.id_memory.mem_array, 16'h0000);

	// get program hex file name: +hexfile+
	$cmd_arg(pgm_file);
	$display("Running program: = %s", pgm_file);
	$readmemh(pgm_file, TEST.lc35.lc35_dp.id_memory.mem_array, 16'h3000);

	// fetch command line argument to set max number of cycles +maxc
	max_cycles = $max_cycles(10000);  
	 
	// dump all signals to file for post-simulation viewing
	$dumpfile("lc35.dump");
	$dumpvars(0, TEST);

	// Can use this code to inspect memory
	/*
	for(i=16'h3000; i<16'h3010; i=i+1)
	  begin
	     $display("addr: %4h  data:%4h", i, TEST.lc35.lc35_dp.id_memory.mem_array[i]);
	  end
	 */

	// initialize machine state
	clk = 0;   
	cycle = 0;
	reset = 0;
	TEST.lc35.lc35_dp.id_memory.mcr = 16'h8000;  // machine control register
	

	// resest sequence
	@(posedge clk);
	@(posedge clk); #5;
	reset = 1'b1;
	@(posedge clk);
	@(posedge clk); #5;
	reset = 1'b0;

	for(i=0; (i<max_cycles && TEST.lc35.lc35_dp.id_memory.mcr[15] == 1'b1); i=i+1)
	  begin
	     @(posedge clk);
	  end

	print_regfile;
	$display("Completed %d cycles", cycle);
	
	$finish;
     end // initial begin

   always clk = #20 ~clk; // generate clock with 20 time units per phase

   always @(posedge clk) cycle = cycle + 1; // cycle counter


   // routine to display contents of registers
   
   task print_regfile;
      begin
	 $display("  PC  :  %4h", TEST.lc35.lc35_dp.pc_out);
	 $display("  nzp :  %3b", TEST.lc35.nzp);
	 $display("  reg 0: %4h", TEST.lc35.lc35_dp.regfile1.reg0.y);
	 $display("  reg 1: %4h", TEST.lc35.lc35_dp.regfile1.reg1.y);
	 $display("  reg 2: %4h", TEST.lc35.lc35_dp.regfile1.reg2.y);
	 $display("  reg 3: %4h", TEST.lc35.lc35_dp.regfile1.reg3.y);
	 $display("  reg 4: %4h", TEST.lc35.lc35_dp.regfile1.reg4.y);
	 $display("  reg 5: %4h", TEST.lc35.lc35_dp.regfile1.reg5.y);
	 $display("  reg 6: %4h", TEST.lc35.lc35_dp.regfile1.reg6.y);
	 $display("  reg 7: %4h", TEST.lc35.lc35_dp.regfile1.reg7.y);
      end
   endtask // print_regfile   

endmodule

