//                              -*- Mode: Verilog -*-
// Filename        : regfile.v
// Description     : LC3.5 register file
// Author          : Stephen W. Keckler
// Created On      : Fri Oct  3 18:15:34 2003
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!


`include "lc35.h"

/* -------------------------------------------------------------
 reg_file
   16x8 register file
   Register file acts as edge-triggered flip-flop
   with bypassing from write to read in same cycle
 --------------------------------------------------------------- */

module regfile (clk, selA, selB, selW, write, dataW, dataA, dataB);
   input clk;
   input [2:0] selA, selB, selW;
   input       write;
   input [15:0] dataW;
   output [15:0] dataA, dataB;

   wire [7:0] 	 wlA, wlB, wlW;
   wire [15:0] 	 val0, val1, val2, val3, val4, val5, val6, val7;
   reg [15:0] 	 regfile_dataA, regfile_dataB;
   
   // decoder   
   dec3_8 decW(selW, wlW);

   // register file array

   reg_row reg0(clk, write, wlW[0], dataW, val0);
   reg_row reg1(clk, write, wlW[1], dataW, val1);
   reg_row reg2(clk, write, wlW[2], dataW, val2);
   reg_row reg3(clk, write, wlW[3], dataW, val3);
   reg_row reg4(clk, write, wlW[4], dataW, val4);
   reg_row reg5(clk, write, wlW[5], dataW, val5);
   reg_row reg6(clk, write, wlW[6], dataW, val6);
   reg_row reg7(clk, write, wlW[7], dataW, val7);

   // output multiplexors for operand A and B

   always @(selA or val0 or val1 or val2 or val3 or val4 or 
	    val5 or val6 or val7)
     begin
	case (selA)
	  3'b000: regfile_dataA = val0;
	  3'b001: regfile_dataA = val1;
	  3'b010: regfile_dataA = val2;
	  3'b011: regfile_dataA = val3;
	  3'b100: regfile_dataA = val4;
	  3'b101: regfile_dataA = val5;
	  3'b110: regfile_dataA = val6;
	  3'b111: regfile_dataA = val7;
	endcase
     end

   always @(selB or val0 or val1 or val2 or val3 or val4 or 
	    val5 or val6 or val7)
     begin
	case (selB)
	  3'b000: regfile_dataB = val0;
	  3'b001: regfile_dataB = val1;
	  3'b010: regfile_dataB = val2;
	  3'b011: regfile_dataB = val3;
	  3'b100: regfile_dataB = val4;
	  3'b101: regfile_dataB = val5;
	  3'b110: regfile_dataB = val6;
	  3'b111: regfile_dataB = val7;
	endcase
     end
   
   // bypass paths
   assign dataA = ((selA == selW) & write) ? dataW : regfile_dataA;
   assign dataB = ((selB == selW) & write) ? dataW : regfile_dataB;
   
endmodule // reg_file

