;; returns the name of the documentation file that corresponds to comp
;; e.g. spec-filename('|age|) -> "Age-Value.spec.kml"

(defun spec-filename (comp &optional (type "kml"))
  (make-pathname :name (concatenate 'string (spec-file comp) ".spec")
                 :type type))

;; returns the name of the file for the spec of comp should point to
;; the returned value has to be concatenated with ".spec.kml"
(defun spec-file (comp)
  (cond 
        ;; property instance
        ((km `((|the| |instance-of| |of| ,comp) |includes| |Property|))
	 (concatenate 'string (string-capitalize (string comp)) "-Value"))
	
	;; constant class
	((km `((|the| |superclasses| |of| ,comp) |includes| |Constant|))
	 (let ((scalar-const-class-of (km `(|the| |scalar-constant-class-of| |of| ,comp)))
	       (categorical-const-class-of (km `(|the| |categorical-constant-class-of| |of| ,comp))))
	   (cond (scalar-const-class-of
		  (string-capitalize (string (first (km `(|the| |range| |of| ,scalar-const-class-of))))))
		 (categorical-const-class-of 
		  (string-capitalize (string (first (km `(|the| |range| |of| ,categorical-const-class-of)))))))))

	;; constant instance
	((first (km `(,comp |isa| |Constant|)))
	 (spec-filename (km `(|the| |instance-of| |of| ,comp))))

	;; scale class
	((km `((|the| |superclasses| |of| ,comp) |includes| |Scale|))
	 (string-capitalize (string (first (km `(|the| |range| |of| (|the| |scale-class-of| |of| ,comp)))))))

	;; scale instance
	((first (km `(,comp |isa| |Scale|)))
	 (string-capitalize (string (first (km `(|the| |instance-of| |of| ,comp))))))
	
	;;
	(t (string comp))))
