;;
;; Top-level function called by the Unit-Conversion concept in 
;; the CLIB to convert the values of a list of value term to the 
;; target UoM.
;;
(defun convert-card-vals (vals target)
  (let ((target-UoM (intern (string-upcase (string (first target)))))
	card-vals result temp instance-value final-result)
    ;; Extract all the cardinal values and verify consistency.
    (dolist (val vals) 
      (let ((cvals (extract-card-vals (km0 `(|the| |value| |of| ,val)))))
	(cond 
	  ((null cvals) 
	   (setf card-vals nil)
	   (return))
	  ((consistent-card-vals cvals)
	   (setf card-vals (cons (first cvals) card-vals)))
	  (t
	   (setf card-vals nil)
           (return)))))
    ;; Converting the UoM to the target. Check to make sure all the 
    ;; values are convertible.
    (dolist (val card-vals)
      (let ((UoM (intern (string-upcase (string (third val))))))
	(setf temp (my-glconvertunit UoM target-UoM))
	(cond 
	  (temp
	   (setf result (cons (list :|pair| (* (second val) temp) (first target)) result)))
	  (t 
	   (setf result nil)
	   (return)))))
    ;; Return the result if there is no violation. Otherwise,
    ;; return nil.
    (setf instance-value (first (km0 `(|the| |instance-of| |of| ,(first vals)))))  
    (dolist (r result final-result)
      (let ((new-instance 
	     (first (km0 `(|a| ,instance-value |with|
			       (|value| (,r)))))))
	(setf final-result (cons new-instance final-result))))))

;;
;; Given a list of values, return all the cardinal elements from 
;; the list.
;;
(defun extract-card-vals (vals)
  (let (result)
    (dolist (x vals result)
      (if (numberp (second x))
	  (setf result (cons x result))))))

;;
;; Given a list of cardinal values, this function checks to
;; see if all the values are consistent.
;;
(defun consistent-card-vals (cvals)
  (let ((consistent t) 
	(key-val  (second (first cvals)))
	(key-UoM (intern (string-upcase (string (third (first cvals)))))))
    (dolist (cval (rest cvals))
      (let ((con-UoM (intern (string-upcase (string (third cval)))))
	    con-val)
	(setf con-val (my-glconvertunit con-UoM key-UoM))
	(if (not (and con-val (= (* con-val (second cval)) key-val)))
	    (progn
	      (setf consistent nil)
	      (return)))))
     consistent))

(defun my-glconvertunit (UoM1 UoM2)
  (if (equal UoM1 UoM2) 1 (glconvertunit UoM1 UoM2)))
	
