

(defun minchksca (Self TheValue)
  (let* ( (scales   (km0 '(|the| |all-instances| |of| |Scale|)))
          (val      (second (car TheValue)))  ;;gets the constant of value's pair
          (valclass (third (car TheValue)))   ;;gets the class of value's pair
          (minval      (car (km0 `(|the1| |of| (|theoneof| (|the| |min-value| |of| ,Self)               
                                       |where| ((|the2| |of| |It|) = ,valclass))))))
(result
(car
    (remove nil
	    ;;goes thru all the scales and finds the first one that contains both constants
            (mapcar #'(lambda (sca)
                        (let ((seq (km0 `(|the| |elements| |of| (|the| |element| |of| ,sca)))))
                          (if (and (member val    seq)
                                   (member minval seq)) ;from the min-value slot
                              seq
                              nil)))
                    scales);;end mapcar
    );;end remove
);;end car
);;end result
);;end of let's ()
;debuging print messages
;(FORMAT t "val = ~s minval = ~s result = ~s~%" val minval result)
;(PRINT TheValue)
;if a minval was found test whether it is earlier in the scale sequence else just return true
(if minval 
    (>= (POSITION val result) (POSITION minval result))
    t
)
  );;end let
);;end defun


(defun maxchksca (Self TheValue)
  (let* ( (scales   (km0 '(|the| |all-instances| |of| |Scale|)))
          (val      (second (car TheValue)))
          (valclass (third (car TheValue)))
          (maxval      (car (km0 `(|the1| |of| (|theoneof| (|the| |max-value| |of| ,Self)
                                       |where| ((|the2| |of| |It|) = ,valclass))))))
(result
(car
    (remove nil
            (mapcar #'(lambda (sca)
                        (let ((seq (km0 `(|the| |elements| |of| (|the| |element| |of| ,sca)))))
                          (if (and (member val    seq)
                                   (member maxval seq)) ;from the max-value slot
                              seq
                              nil)))
                    scales);;end mapcar
    );;end remove
);;end car
);;end result
);;end of let's ()
;(FORMAT t "val = ~s maxval = ~s result = ~s~%" val maxval result)
;(PRINT TheValue)
(if maxval
    (<= (POSITION val result) (POSITION maxval result))
    t
)
  );;end let
);;end defun

(defun minchkcard (Self TheValue)
  (let* ( (valnum   (second (car TheValue)))
	  (valUoMKM (third (car TheValue))) ;;km needs it in this format
	  (valUoM   (intern (string-upcase (string
				  (third  (car TheValue))
	  ))))

	  (minnum (car (km0 `(|the1| |of| (|theoneof| (|the| |min-value| |of| ,Self)
                                       |where| ((|the1| |of| |It|) |isa| |Number|))))))
	  ;;this does not consider the chance that there is two cardinal representations and
	  ;;this somehow grabs a different one than minnum took its value from
	  (minUoM (intern (string-upcase (string
		       (car (km0 `(|the2| |of| (|theoneof| (|the| |min-value| |of| ,Self)
                                       |where| ((|the1| |of| |It|) |isa| |Number|)))))))))
	)

;;(format t "~%minnum = ~s minUoM = ~s~%" minnum minUoM)
;;(format t "valnum = ~s valUoM = ~s~%" valnum valUoM)

(if minnum
    (if (not valUoM) ;;if the second part of the pair is not NIL
	(>= valnum minnum) ;;the second part is nil, so just evaluate numbers
        (if (not (km0 `(,valUoMKM |isa| |Unit-of-Measurement|)))  ;;the second part is not a UoM so evaluate like a scalar
	    (if (equal valUoM minUoM) ;;are the reference classes the same
		(>= valnum minnum)
	        t
	    )   
	    (if (km0 `(,valUoMKM |isa| |UoM-Temperature|))
		(>= (tempconvert (list '* valnum valUoM) minUoM) minnum)
	        (>= (* valnum (glconvertunit valUoM minUoM)) minnum)
	    )
	)
    )
  t
)
))

(defun maxchkcard (Self TheValue)
  (let* ( (valnum   (second (car TheValue)))
          (valUoMKM (third (car TheValue))) ;;km needs it in this format
          (valUoM   (intern (string-upcase (string
                                  (third  (car TheValue))
          ))))

          (maxnum (car (km0 `(|the1| |of| (|theoneof| (|the| |max-value| |of| ,Self)
                                       |where| ((|the1| |of| |It|) |isa| |Number|))))))
          (maxUoM (intern (string-upcase (string
                       (car (km0 `(|the2| |of| (|theoneof| (|the| |max-value| |of| ,Self)
                                       |where| ((|the1| |of| |It|) |isa| |Number|)))))))))
        )

;(format t "~%maxnum = ~s maxUoM = ~s~%" maxnum maxUoM)
;(format t "valnum = ~s valUoM = ~s~%" valnum valUoM)
(if maxnum
    (if (not valUoM)
	(<= valnum maxnum)
        (if (not (km0 `(valUoMKM |isa| |Unit-of-Measurement|)))
	    (if (equal valUoM maxUoM)
		(<= valnum maxnum)
	        t
	    )
	    (if (km0 `(,valUoMKM |isa| |UoM-Temperature|))
		(<= (tempconvert (list '* valnum valUoM) maxUoM) maxnum)
	        (<= (* valnum (glconvertunit valUoM maxUoM)) maxnum)
	    )
	)
    )
  t
)
))

;;  this is the function that will be called from the constraint
;;  It calls the appopriate function depending on whether the value is a 
;; Cardinal or Scalar
;;  Self = the property-value being checked
;;  TheValue = the particular value that the constraint is checking in the value slot
;; of Property-Value

(defun valuecheck (Self TheValue)
  (if (not TheValue)
      t
      (if (km0 `((|the1| |of| ,TheValue) |isa| |Constant|))
	  (and 
	   (minchksca Self TheValue)
	       (maxchksca Self TheValue)
	  )
	  (and 
	   (minchkcard Self TheValue)
	       (maxchkcard Self TheValue)
	  )
      )
))







