bruce-and-my-km-extensions.lisp                                                                     000775  003117  001440  00000033030 05641657620 020065  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ; -*- Mode: Lisp; Syntax: Common-Lisp; Package: KM; Base: 10 -*-

(in-package 'km)



;;;;				 KM Extensions
;;;;				 -------------



;;; GET+  -- the universal get function with lots of options
;;; ----
;;;
;;; purpose: to get the filler (i.e. set of slot values) for a slot
;;;
;;; arguments
;;;  required
;;;    unit:  unit to be accessed
;;;    slot:  slot to be accessed on unit
;;;  optional
;;;    levels-of-kb: the levels of the knowledge base to be accessed
;;;                when embedded units are returned (i.e. bare-value
;;;                is nil).
;;;                A list of one or more specifications, each of which
;;;                is of the form:
;;;                     1) a positive integer
;;;                     2) a range of levels specified by the list:
;;;                        (m n), where m and n are positive integers
;;;                        and n>m.
;;;                The specifications are interpreted conjunctively.
;;;                For example, ((1 10) (30 85) 4) retrieves information
;;;                on levels 1-10, 30-85, AND level 4 of the knowledge base.
;;;                To determine the information stored on each level of the
;;;                knowledge base, see the LEVEL-OF-KB facet on each slot,
;;;                or the summary of this information in the file:
;;;                         levels-in-kb in the BKB directory
;;;                (default: (1 100), i.e. domain knowledge only)
;;;    bare-value: t if the bare value is to be returned;
;;;                nil if the value annotations (if any) are to be returned
;;;                (default: nil)
;;;    use-inheritance-always: t if inheritance should be used to augment
;;;                any local values on unit/slot
;;;                (default: nil)
;;;    use-inheritance-if-novalue: t if inheritance should be used when
;;;                there is no local value on unit/slot
;;;                (default: nil)
;;;    listify: if listify=t then values returned are listified
;;;                (default: t)
;;;    nullify: if nullify=t then nil is returned when unit/slot has no
;;;                no value;
;;;                otherwise, :novalue is returned when unit/slot has no 
;;;                value (default: nil)

(defun get+ (unit slot
		  &key 
		  (levels-of-kb '(1 100))
		  (bare-value nil)
		  (use-inheritance-always nil)
		  (use-inheritance-if-novalue nil)
		  (listify t)
		  (nullify nil))
  (let ((vals nil))
    (when use-inheritance-always
      (if bare-value
	  (setf vals (get-global-without-annotation unit slot))
	  (setf vals (get-global-with-annotation 
		      unit slot :levels-of-kb levels-of-kb))))
    (when (not use-inheritance-always)
      (if bare-value
	  (setf vals (get-local-without-annotation unit slot))
	  (setf vals (get-local-with-annotation unit slot 
						:levels-of-kb levels-of-kb)))
      (when (and (equal vals ':no-value)
		 use-inheritance-if-novalue)
	(if bare-value
	    (setf vals (get-global-without-annotation))
	    (setf vals (get-global-with-annotation 
			unit slot :levels-of-kb levels-of-kb)))))
    (when (and listify (atom vals))
      (setf vals (list vals)))
    (when (and nullify (not (tvalue? vals)))
      (setf vals nil))
    vals))


;;; GET-UNIT+ 
;;; ----------
;;;
;;; purpose: to get the contents of a unit (top-level or embedded)
;;;
;;; arguments
;;;  required
;;;    unit:  unit to be accessed 
;;;  optional
;;;    levels-of-kb: the levels of the knowledge base to be accessed
;;;                A list of one or more specifications, each of which
;;;                is of the form:
;;;                     1) a positive integer
;;;                     2) a range of levels specified by the list:
;;;                        (m n), where m and n are positive integers
;;;                        and n>m.
;;;                The specifications are interpreted conjunctively.
;;;                For example, ((1 10) (30 85) 4) retrieves information
;;;                on levels 1-10, 30-85, AND level 4 of the knowledge base.
;;;                To determine the information stored on each level of the
;;;                knowledge base, see the LEVEL-OF-KB facet on each slot,
;;;                or the summary of this information in the file:
;;;                         levels-in-kb in the BKB directory
;;;                (default: (1 100), i.e. domain knowledge only)
;;;    bare-unit:  t if the unit is to be returned "bare", i.e. without
;;;                any substructures on slots and values within the unit.
;;;                nil if the substructures are to be returned.
;;;                (default: nil)
;;;    get-slots-using-inheritance: t if inheritance should be used to
;;;                get all the legal slots (and their fillers) for unit.
;;;                (note: this option does not use inheritance to get
;;;                all the values for slots on the unit.  For this, use
;;;                get+ with the use-inheritance features).
;;;                nil if only unit's explicit slots should be returned
;;;                (default: nil)


;(defun get-unit (unit 
;		 &key 
;		 (levels-of-kb '(1 100))
;		 (bare-unit nil)
;		 (get-slots-using-inheritance nil))
;
;)





;;; Specialized Selector Functions
;;; ------------------------------

;;; finds values of get-global call
(defun get-global-vals (addr)
  (first (get-global addr)))


;;; retrieves an unannotated value from an annotated value
(defun bareify (annot-value)
  (first annot-value))


;;; returns the source unit of the address, where source means
;;; the origin, and source may be either an top-level or embedded unit
(defun start-of-path (addr)
  (if (listp addr)
      (first addr)
      addr))




;;; Get-Global-with-Annotation Functions
;;; ------------------------------------

;;; get-global-with-annotation returns those values that are
;;; locally placed on the unit at the slot (unit and slot are the
;;; passed parameters), plus those that can be inherited 
;;; to the address.  The only tricky part of the function is pruning 
;;; values that are replaced by more specific ones.
;;; (note: unit may be an implicit unit.)
;;;
;;; Since unit might not have any explicit generalizations, 
;;; the function might "guess" what generalizations it might have.
;;; This occurs only when unit is an embedded unit which has not yet
;;; been created.  For example, the caller might ask for the filler of:
;;;   - unit = (flower parts)
;;;   - slot =  ordinality
;;; even though the unit does not exist.  By "guessing", get-global
;;; starts the "ancestry-thread" for the unit at the slot "parts"
;;;
;;; Important Note: we use ancestry* to perform a breadth-first search
;;; --------------  upward through the KB; this is accomplished, but
;;;                 it is not true that the order of the values
;;;                 returned by ancestry* have the property that they
;;;                 are in increasing order of generality; in fact,
;;;                 one value may be more specific than its predecessor
;;;                 in the list of values returned; this has far-reaching
;;;                 and (yet unforseen) consequences

(defun get-global-with-annotation (unit slot 
					&key 
					(levels-of-kb '(1 100)))

  (let* ((global-vals (get-local-with-annotation unit slot
						 :levels-of-kb levels-of-kb))
	 (replacements (slot-values-replaced unit slot global-vals))
	 (ancestors (ancestry-with-guessing+ unit)))
    (dolist (ancestor ancestors)
      (let ((vals-on-ancestor (get-local-with-annotation 
			       ancestor slot
			       :levels-of-kb levels-of-kb)))
	(dolist (val-on-ancestor vals-on-ancestor)
	  (let ((extended-addr-with-value
		 (extend-address-indefinitely ancestor
					      slot
					      (first val-on-ancestor))))
					; recall that val-on-ancestor is of 
					;the form: (value annotation)

	    ;;if extended-addr-with-value has been replaced by a more
	    ;;specific value, then remove it from the list of replacements
	    ;;(an efficiency hack; controls the length of the list).
	    ;;Else, add an explanation to the annotation on val-on-ancestor
	    ;;and add val-on-ancestor to global-vals

;	    (format *terminal-io* "extended-addr-with-value: ~a~%"
;		    extended-addr-with-value)
;	    (format *terminal-io* "replacements:~a~%" replacements)
	    (if (member extended-addr-with-value replacements 
			:test #'equal)
		(setf replacements
		      (delete extended-addr-with-value replacements
			      :test #'equal))
		(setf global-vals 
		      (push 

		       (cons
			(first val-on-ancestor)
			(list (cons (list 'inherited-from 
					  (extend-address-indefinitely
					   ancestor slot
					   (first val-on-ancestor)))
				    (second val-on-ancestor))))

		       global-vals)))))

	;;destructive operation rationale: arguments built up from copies
	(setf replacements 
	      (nconc 
	       (slot-values-replaced ancestor slot vals-on-ancestor) 
	       replacements))))

    ;;reverse the order of global-vals so that the they are increasing
    ;;generality (local values on (unit slot) are first).
    ;;destructive operation rationale: arguments built up from copies

    (nreverse global-vals)))
  

;;; return the ancestry of a unit, "guessing" if necessary.
;;; first determines if the unit has explicit generalizations
;;; in the KB, thereby giving it ancestry;
;;; if so, they are returned;
;;; otherwise "guesses" a generalization for the first
;;; link (as defined below), starting the "ancestry-thread",
;;; and then performs the traditional ancestry* operation
(defun ancestry-with-guessing (unit)
  (let ((ancestors (ancestry* unit)))
    (if (length-of-1 ancestors)
	(ancestry* (first (guess-generalization unit)))
	ancestors)))
   
 

;; return the list of addresses that are replaced by the values
;; at (unit slot)
(defun slot-values-replaced (unit slot values)
  (mapcan #'(lambda (val)
	     (let ((replaces-for-val (get-replaces+ unit slot val)))
	       (if replaces-for-val
		   (copy-list replaces-for-val))))
	  values))

;;; returns slot values at address ``(unit slot)'', excluding any
;;; annotation on those values.

(defun get-local-without-annotation (unit slot)
   (let* ((slot-filler (get-slot-object (extend-address unit slot)))
	 (values+annots (cdr slot-filler)))
     (first values+annots)))


;;; returns slot values at address ``(unit slot)'', including the
;;; annotation on each value. 
;;;
;;; returns a list of the form:
;;;  ((v1 annot1) (v2 annot2) ... )
;;;  where annot-n is a list of slots and values
;;; example:
;;;    (get-local-with-annotation 'embryo-sac-formation 'developee)
;;;    returns the single value (embryo-sac) with its annotation:
;;;        ((EMBRYO-SAC
;;;         ((I-GENLS (EMBRYO-SAC))
;;;          (BEFORE-STATE (MEGASPORE-MOTHER-CELL))
;;;          (AFTER-STATE (EMBRYO-SAC)))))

(defun get-local-with-annotation (unit slot &key (levels-of-kb '(1 100)))
   (let* ((slot-filler (get-slot-object (extend-address unit slot)))
	 (values+annots (cdr slot-filler))
	 (values (listifyn (first values+annots))) ;use listify in case the
	 (annots (rest values+annots))             ;slot value is :novalue
	 (return-list nil))
    (dolist (value values)
      (setf return-list
	    (push
	     (cons value 
		   (get-local-with-annotation-aux value annots levels-of-kb))
	     return-list)))
    return-list))


;;; return the annotation (from the list annots) that corresponds to value
(defun get-local-with-annotation-aux (value annots levels-of-kb)
  (dolist (annot annots)
    (when (equal value (first annot))
      (return-from get-local-with-annotation-aux 
	(list (cddr annot)))))
  nil)

(defun filter-by-level (unit levels-of-kb)
  t)

(defun my-getobj (unit levels-of-kb)
  (filter-by-level (getobj unit) levels-of-kb))

;;; Much like get-global-with-annotation, but leaves off the annotation.
;;; returns the values stored locally on (unit slot) plus those
;;; values inherited to (unit slot).  
(defun get-global-without-annotation (unit slot)
  (let ((vals-with-annotation (get-global-with-annotation unit slot)))
    (mapcar #'(lambda (val)
		(first val))
	    vals-with-annotation)))


;;; Put-Local-with-annotation
;;; -------------------------
(defun put-local-with-annotation (unit slot vals)
  (dolist (val vals)
    (add-val-with-annotation unit slot val)))



;;; Kludged Add-val-with-annotation
;;; -------------------------------

;;; adding the annotation is a KLUDGE (it only works for 2 levels)
;;; see note on FIX-IT list
;;; ALSO, it installs the value locally, without installing inverses
;;; contains a kludge in the atom test below; we've got to get the
;;; new low-level access fn's corrected!
(defun add-val-with-annotation (unit slot value)
  (let ((bare-value (first value))
	(annotation (second value)))
    (add-val-local (extend-address unit slot) bare-value)
    (when annotation
      (dolist (annot annotation)
	(let ((annot-slot (first annot))
	      (annot-fillers (second annot)))
	  (if (atom annot-fillers)
	    (add-val-local (extend-address-indefinitely unit slot bare-value
						  annot-slot)
		   annot-fillers)
	    (dolist (val annot-fillers)
	      (add-val-local (extend-address-indefinitely unit slot bare-value
							  annot-slot)
			     val))))))))


;;; Add-Val (Our own version)
;;; -------------------------

;;; this version does not do any get-globals for rules
;;; or constraints; it does, however, compute and
;;; install inverses in accord with the global inverse
;;; variable setting 

(defun my-add-val (addr val)
  (when (tvalue? val)
    (let ((oldval (get-local-internal addr)))
      (unless (member val oldval :test #'equal)
	(put-local-internal addr (cons-end val oldval)))))
  (let ((inverse-pairs (compute-inverse addr val)))
    (dolist (inv-pair inverse-pairs)
      (put-local (first inv-pair) (second inv-pair)))))


               knowledge base, see the LEVEL-OF-KB facet on each slot,
;;;                or the summary of this information in the file:
;;;                         levels-in-kb in the BKB directory
;;;                (default: (1 100), i.e. domain knowledge only)
;;;    bare-unit:  t if the unit is to be returned "bare", i.e. without
;;;                any substructures on slots and values within the unit.
;;;                nil if the substructures are to be returned.
;;;         bruce-and-my-replaces-annot.lisp                                                                    000775  003117  001440  00000016702 05641657621 020204  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ; -*- Mode:Lisp; Syntax:Common-Lisp; Package:KM; Base:10 -*-
(in-package 'km)


;; put replaces annotation on the value located on unit/slot
;; install the inverse annotation (replaced-by) when
;; the optional parameter, inverse-maint is T (default is nil)
(defun put-replaces+ (unit slot value replaces-list &key inverse-maint)
  (put-replaces (extend-address-indefinitely unit slot value)
		replaces-list
		:inverse-maint inverse-maint))

(defun put-replaces (address replaces-list &key inverse-maint)
  (let* ((current-replaced-by (get-replaced-by address))
	 (new-replacements (if replaces-list
			       (list 'replaces replaces-list)
			       nil))
	 (new-replaced-by (if current-replaced-by
			      (list 'replaced-by current-replaced-by)
			      nil))
	 (replacements-record 
	  (if (or new-replaced-by new-replacements)
	      (delete-if #'null (list ':a-novalue 
				      new-replaced-by new-replacements))
	      :novalue))) ;putting :novalue at an address deletes 
                                    ;the replacements record

;   (format *terminal-io* "current-replaced-by: ~a~%" current-replaced-by)
;   (format *terminal-io* "new-replacements: ~a~%" new-replacements)
;   (format *terminal-io* "new-replaced-by: ~a~%" new-replaced-by)
;   (format *terminal-io* "replacements-record: ~a~%" replacements-record)

    ;since this call to put-replaces eliminates the old replaces annotation,
    ;we must eliminate the inverses of this annotation too
    (when inverse-maint
      (dolist (old-replaces-addr (get-replaces address))
	(remove-replaced-by old-replaces-addr address :inverse-maint nil)))

    ;install the inverses for this call to put-replaces
    (when inverse-maint
      (dolist (new-replaces-addr replaces-list)
	(add-replaced-by new-replaces-addr address :inverse-maint nil)))

    ;finally, put the new replaces information in the KB
    (put-local address replacements-record)))




;; put replaced-by annotation on the value located on unit/slot
;; install the inverse annotation (replaces) when
;; the optional parameter, inverse-maint is T (default is nil)
(defun put-replaced-by+ (unit slot value replaced-by-list 
			      &key inverse-maint)
  (put-replaced-by (extend-address-indefinitely unit slot value)
		   replaced-by-list 
		   :inverse-maint inverse-maint))

(defun put-replaced-by (address replaced-by-list &key inverse-maint)
  (let* ((current-replacements (get-replaces address))
	 (new-replaced-by (if replaced-by-list
			      (list 'replaced-by replaced-by-list)
			      nil))
	 (new-replacements (if current-replacements
			       (list 'replaces current-replacements)
			       nil))
	 (replacements-record 
	  (if (or new-replaced-by new-replacements)
	      (delete-if #'null (list ':a-novalue 
				      new-replaced-by new-replacements))
	      :novalue))) ;putting :novalue at an address deletes
                                    ;the replacements record

    ;since this call to put-replaced-by eliminates the old replaced-by 
    ;annotation, we must eliminate the inverses of this annotation too
    (when inverse-maint
      (dolist (old-replaced-by-addr (get-replaced-by address))
	(remove-replaces old-replaced-by-addr address :inverse-maint nil)))

    ;install the inverses for this call to put-replaced-by
    (when inverse-maint
      (dolist (new-replaced-by-addr replaced-by-list)
	(add-replaces new-replaced-by-addr address :inverse-maint nil)))

    ;finally, put the new replaces information in the KB
    (put-local address replacements-record)))


;; remove the replaced-by annotation located on the 
(defun remove-replaced-by+ (unit slot value 
			   address-to-delete
			   &key inverse-maint)
  (remove-replaced-by (extend-address-indefinitely unit slot value)
		      address-to-delete
		      :inverse-maint inverse-maint))

(defun remove-replaced-by (address-of-replaced-by-info 
			   address-to-delete
			   &key inverse-maint)
  (let ((new-val (remove
		  address-to-delete
		  (get-replaced-by address-of-replaced-by-info)
		  :test #'equal)))
    (if new-val
	(put-replaced-by address-of-replaced-by-info
			 new-val
			 :inverse-maint inverse-maint)
	(remove-all-replaced-by address-of-replaced-by-info
				:inverse-maint inverse-maint))))

(defun remove-replaces+ (unit slot value 
			      address-to-delete
			      &key inverse-maint)
  (remove-replaces (extend-address-indefinitely unit slot value)
		   address-to-delete
		   :inverse-maint inverse-maint))

(defun remove-replaces (address-of-replaces-info 
			address-to-delete
			&key inverse-maint)
  (let ((new-val (remove
		  address-to-delete
		  (get-replaces address-of-replaces-info)
		  :test #'equal)))
    (if new-val
	(put-replaces address-of-replaces-info
		      new-val
		      :inverse-maint inverse-maint)
	(remove-all-replaces address-of-replaces-info
			     :inverse-maint inverse-maint))))


(defun remove-all-replaces+ (unit slot value &key inverse-maint)
  (put-replaces+ unit slot value nil :inverse-maint inverse-maint))

(defun remove-all-replaced-by+ (unit slot value &key inverse-maint)
  (put-replaced-by+ unit slot value nil :inverse-maint inverse-maint))

(defun remove-all-replaces (address &key inverse-maint)
  (put-replaces address nil :inverse-maint inverse-maint))

(defun remove-all-replaced-by (address &key inverse-maint)
  (put-replaced-by address nil :inverse-maint inverse-maint))


(defun get-replaces+ (unit slot value)
  (get-replaces (extend-address-indefinitely unit slot value)))

(defun get-replaces (address)
  (let* ((replacement-record 
	  (get-local address :nullify nil))
	 (replacements (if (atom replacement-record)
			   nil
			   (assoc 'replaces (cdr replacement-record)
				  :test #'equal))))
    (if replacements
	(second replacements)
	nil)))

(defun get-replaced-by+ (unit slot value)
  (get-replaced-by (extend-address-indefinitely unit slot value)))

(defun get-replaced-by (address)
  (let* ((replacement-record 
	  (get-local address :nullify nil))
	 (replaced-by (if (atom replacement-record)
			  nil
			  (assoc 'replaced-by (cdr replacement-record)
				 :test #'equal))))
    (if replaced-by
	(second replaced-by)
	nil)))


(defun add-replaces+ (unit slot value new-replacement &key inverse-maint)
  (add-replaces (extend-address-indefinitely unit slot value)
		new-replacement
		:inverse-maint inverse-maint))

(defun add-replaces (address new-replacement &key inverse-maint)
  (let ((current-replacements (get-replaces address)))
    (unless (member new-replacement current-replacements :test #'equal)
      (put-replaces address
		    (append 
		     (list new-replacement) 
		     current-replacements)
		    :inverse-maint nil)
      (when inverse-maint
	(add-replaced-by new-replacement address)))))

(defun add-replaced-by+ (unit slot value new-replaced-by &key inverse-maint)
  (add-replaced-by (extend-address-indefinitely unit slot value)
		   new-replaced-by 
		   :inverse-maint inverse-maint))

(defun add-replaced-by (address new-replaced-by &key inverse-maint)
  (let ((current-replaced-bys (get-replaced-by address)))
    (unless (member new-replaced-by current-replaced-bys :test #'equal)
      (put-replaced-by address
		       (append 
			(list new-replaced-by) 
			current-replaced-bys)
		       :inverse-maint nil)
      (when inverse-maint
	(add-replaces new-replaced-by address)))))



;; get the replaces or replaced-by annotation for the value
;; located a particular addr.
;; slot is either 'replaces or 'replaced-by

(defun get-replaces-annotation (addr value slot)
  (if (equal slot 'replaces)
      (get-replaces addr value)
      (get-replaced-by addr value)))


by replaced-by-list)
			      nil))
	 (new-replacements (if cubruce-and-my-retrieve.lisp                                                                          000775  003117  001440  00000106240 05641657621 017113  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ; -*- Mode: Lisp; Syntax: Common-Lisp; Package: KM; Base: 10 -*-


(in-package 'km)

#||  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

The following are examples of view retriever invocations:

  (retrieve-view '(embryo-sac-formation dimension (black-box)))
  (retrieve-view '(photosynthesis dimension (black-box)))
  (retrieve-view '(photosynthesis dimension (event-structural)))
  (retrieve-view '(photosynthesis dimension (black-box event-structural)))
  (retrieve-view '(photosynthesis as-kind-of conversion))
  (retrieve-view '(photosynthesis as-kind-of production))
  (retrieve-view '(photosynthesis as-kind-of production))
  (retrieve-view '(flower dimension (spatial-structural))) --> vp1
  (retrieve-view '(angiosperm-sexual-reproduction dimension 
                  (event-structural)))                     --> vp2
  (retrieve-view '(composite vp1 vp2 (actor-in)))
      where: vp1 and vp2 are bound above
  (retrieve-view '(embryo-sac-formation dimension 
                 (event-structural)))               --> vp1
  (retrieve-view '(embryo-sac dimension (spatial-structural))) --> vp2
  (retrieve-view '(composite vp2 vp1 (actor-in)))
      where: vp1 and vp2 are bound above
  (retrieve-view '(composite (flower dimension (spatial-structural))
                             (angiosperm-sexual-reproduction 
                              dimension (event-structural))
                             (actor-in)))

||#


;;;;			      The View Retriever
;;;;			      ------------------


;;;; Organization of File
;;;; --------------------
;;;; 1. The Driver
;;;; 2. Basic Dimension Constructor
;;;; 3. As-Kind-Of Constructor
;;;; 4. Composite View Constructor
;;;; 5. View Retriever Error Signaler
;;;; 6. Test Call Functions


;;;; To Fix
;;;; ------
;;;; Caching of viewpoints: storing & checking at retrieve time
;;;; (need to check if above works)
;;;;
;;;; filtering out general values (this isn't replacements; its
;;;; layers)
;;;;
;;;; make sure that put-local puts the annotation that have been
;;;; carefully get-global'ed (need to find KM function that will
;;;; serve as the basis for this)
;;;;
;;;; test get-global-with-annotation more thoroughly; in particular,
;;;; try it with embedded units and with replacement chains of length
;;;; greater than 1
;;;;
;;;; get-local needs to handle deeply embedded annotations
;;;;
;;;; we really need to ask Erik to rewrite all-explicit-slots with 
;;;; an optional argument &include-notation? that defaults to nil
;;;; (more generally, we need to provide a layering mechanism for
;;;; the KB)
;;;;
;;;; fix MAJOR kludge in add-val-with-annotation so it really adds
;;;; annotations to KB; make certain that it works when given implicit
;;;; units; also, make sure that deeply-nested annotations are also
;;;; added properly; (note that get-local-with-annotation doesn't currently
;;;; properly reformat deeply nested annotations, but it needs to be
;;;; fixed to do so)
;;;;
;;;; add efficiency hack to get-global: when the slot's ordinality is
;;;; atom, halt when encounter first value in upward search
;;;;
;;;; in construct-basic-dimension-vp-2 there is a call in the let binding-list
;;;; to get-explicit-slots (previously, it was get-legal-slots); what we
;;;; really want is something "between" these two: it should get all explicitly
;;;; filled slots on ancestry* of the unit, but does not get values on slots
;;;; that are genl-slots of the slots that appear on the unit
;;;;
;;;; the view retriever needs to set the *interactive?* global variable to nil
;;;; so that we achieve a menu-less call to add-val and put-local
;;;;
;;;; get cardinality and ordinality straightened out; currently
;;;; they are confused;
;;;; moreover, we need to distinguish two properties: ordered? and ordinality?
;;;;
;;;; fix get-contentful-slots so it doesn't compute progeny* of several
;;;; units EVERYTIME it's called
;;;;
;;;; consider using only local puts in viewpoint code so that inverses from 
;;;; domain KB units to viewpoints are not installed.  Remember that in the
;;;; code for building a composite view, add-val is called (instead of put-
;;;; local) because it has the side-effect of installing the intermediaries
;;;; used in paths).  
;;;;
;;;; Viewpoint code (and all other applications) should never use put-local.
;;;; Such code only gets what it deserves.... a dirty KB
;;;;
;;;; Constraints:
;;;;      - create slot: put-constraints
;;;;      - add following values to (New-slot-top put-constraints):
;;;;             (domain-constraint range-constraint ordinality-constraint)
;;;;
;;;; Fix up generalizations-ok sweep to also include a call like:
;;;;     (set-difference *kb-objects* (progeny* 'entity))
;;;; Otherwise, the sweep is incomplete.
;;;;
;;;; Fix up my-add-val (see file my-add-val-error)
;;;; This fn is called by the composite view function (and no others)


;;;; Sweeps
;;;; ------
;;;;
;;;; install inverses and replaces
;;;;
;;;; write function to be run periodically that searches
;;;; universally for generalizations of embedded units
;;;;
;;;; after run replaces sweep in KB, change construct-basic-dimension-vp-2
;;;; so that it does a get-global-with-annotation rather than the (kludged)
;;;; get-local-with-annotation
;;;;
;;;; sweep for all x such that there is a path through only genls back to x
;;;; (or a path through only specs back to x) (x includes embedded units also)



;;;;--------------------------------------------------------------------------
;;;;
;;;;	         	  VIEW RETRIEVER
;;;;			  --------------
;;;; 
;;;; given a specification for a viewpoint, return the name of the viewpoint
;;;; unit created (or retrieved) that satisfies the specification, or an 
;;;; error code (see below).
;;;;
;;;; The syntax for the specification depends on the type of viewpoint:
;;;; I.  Basic Dimension Viewpoint: 
;;;;              (<concept> dimension <dimension-types>)
;;;;  - concept may be either a top-level unit or an embedded unit
;;;;  - dimension-types may be one or more of spatial-structural, 
;;;;    temporal-structural etc.; see the unit basic-dimension-value 
;;;;    in the KB and examine its specializations to determine all 
;;;;    dimension-types
;;;;
;;;; II. As-Kind-Of Viewpoint:
;;;;             (<concept> as-kind-of <reference concept>)
;;;; Note that the specification might contain an auxillary basic-dimension
;;;; viewpoint specification in place of a <reference concept>,
;;;; i.e. a recursive call to the view retriever, such as: 
;;;;          (X as-kind-of (Y basic-dimension (spatial-structural)))
;;;;
;;;; III. Composite Viewpoint:
;;;;
;;;; IV. As-Having Viewpoint:
;;;;          not currently implemented.
;;;;
;;;; ERRORS: This function returns the following error codes under the
;;;; conditions specified below:
;;;;
;;;;   '(error invalid-view-spec)       
;;;;        The syntax of the viewpoint specification is wrong.
;;;;   '(error unknown-type-of-vp)
;;;;        The specification asked for an unknown type of viewpoint.
;;;;   '(error unknown-concept)
;;;;        The concept for which the viewpoint is requested is not in the KB.
;;;;   '(error unknown-type-of-basic-dimension)
;;;;        The basic-dimension requested is unknown.
;;;;   '(error ref-concept-not-genl-of-coi)
;;;;        In the specification for an as-kind-of viewpoint, 
;;;;        the reference concept is not an all-generalization of the
;;;;        concept of interest, and it must be.
;;;;   '(error ill-formed-AS-KIND-OF-viewpoint)
;;;;        The syntax of the specification for an as-kind-of viewpoint
;;;;        is wrong.


(defun retrieve-view (vspec)
  (reset);; make sure KM stack is clear
  (with-no-inverses
      (cond ((or (atom vspec)           
		 (< (length vspec) 2))  
	     (signal-vr-error 'invalid-view-spec))
	    ((eq (second vspec) 'dimension)
	     (construct-basic-dimension-vp vspec))
	    ((eq (second vspec) 'as-kind-of)
	     (construct-as-kind-of-vp vspec))
	   ;((eq (second vspec) 'as-having)
	   ; (construct-as-having-vp vspec))
	    ((eq (car vspec) 'composite)
	     (decompose-composite-vp-spec
	      (second vspec)
	      (third vspec)
	      (fourth vspec)))
	    (t (signal-vr-error 'unknown-type-of-vp)))))


;;;; decompose the specification for a composite viewpoint.  
;;;; Unlike other types of viewpoint specifications, these
;;;; can involve recursive calls to the view retriever, e.g.
;;;; the following structural-functional composite view of flower:
;;;;  (retrieve-view '(composite 
;;;;     (retrieve-view '(flower dimension (spatial-structural)))
;;;;     (retrieve-view '(angiosperm-sexual-reproduction dimension 
;;;;                      (event-structural)))
;;;;                     (actor-in)))
;;;;
(defun decompose-composite-vp-spec (concept-or-spec-1 
				    concept-or-spec-2 
				    correspondence-slots)
  (let ((concept1 (if (object? concept-or-spec-1)
		      concept-or-spec-1 
		      (retrieve-view concept-or-spec-1)))
	(concept2 (if (object? concept-or-spec-2)
		      concept-or-spec-2
		      (retrieve-view concept-or-spec-2))))
    (construct-composite-vp concept1 concept2 correspondence-slots)))



;;;;--------------------------------------------------------------------------
;;;;
;;;;
;;;;			  Basic Dimension Constructor
;;;;			  ---------------------------


;;;; construct-basic-dimension returns a viewpoint of a concept
;;;; created along a basic dimension
;;;;
;;;; viewpoint specification form:
;;;;      (<concept> dimension <dimension-type>)
;;;;
;;;;  - concept may be either a top-level unit or an embedded unit
;;;;  - dimension-type may be one of spatial-structural, temporal-structural
;;;;    etc.; see the unit basic-dimension-value in the KB and examine its
;;;;    specializations for all dimension-types
;;;;  - viewpoints created for some types of basic dimensions have 
;;;;    interconnecting relations.  For example, 
;;;;    basic dimensions have interconnecting relations. For example,
;;;;    the spatial-structural type includes relations such as parts,
;;;;    surrounds, encloses, etc; the black-box type has no relations.
;;;;    For find (or change) the interconnecting relations for a 
;;;;    particular type of basic-dimension, look in the KB at 
;;;;    (<type-of-basic-dimension> interconnection-dimension) or
;;;;    call the function: 
;;;;        (get-interconnect-slots '(<type-of-basic-dimension>)).
;;;;
;;;;  - an error is returned if the concept of interest is not in the KB.


(defun construct-basic-dimension-vp (vspec)
  (let* ((concept (first vspec))
	 (dimensions (third vspec))
	 (concept-in-kb? (object? concept)))
    (cond ((not (listp dimensions))
	   (signal-vr-error 'dimension-list-not-a-list))
	  ((error-in-vr? concept-in-kb?)
	   (signal-vr-error 'object-in-view-specification-not-in-kb))
	  (t (construct-basic-dimension-vp-2 concept dimensions)))))


;;; return a viewpoint constructed along basic-dimensions,
;;; a passed parameter. 
;;; First, get those legal slots of concept that pertain to basic-dimensions
;;; if there are any pertinent slots, create a viewpoint using them,
;;; otherwise return with an error.  A viewpoint is created by:
;;;      1.  initializing it with its type(s)
;;;      2.  installing inherited values on all pertinent slots
;;;      3.  installing facets on pertinent slots, if there are any.
;;;      4.  installing interconnections.  Note that this is a no-op
;;;          for viewpoints created along basic dimensions that do not
;;;          have any interconnections.

(defun construct-basic-dimension-vp-2 (concept basic-dimensions)
  (let* ((slots-on-concept (get-explicit-slots concept));need another fn here
	                                                ;see FIX IT list
	 (pertinent-slots (slots-in-basic-dimensions slots-on-concept
						     basic-dimensions)))
    (cond ((not (subsetp basic-dimensions
			 ;; JL changed following line 8-29-93 so will get
			 ;; active-functional-dimension
			 (progeny* 'basic-dimension-value)
			 :test #'equal))
	   (signal-vr-error 'unknown-type-of-basic-dimension))
	  ((null slots-on-concept)
	   (signal-vr-error 'no-slots-on-given-concept))
	  ((null pertinent-slots)
	   (signal-vr-error 'no-slots-in-basic-dimension-on-concept))
	  (t (let ((viewpoint (init-basic-dim-vp concept basic-dimensions)))
	       (dolist (slot pertinent-slots)
		 ;;see FIX IT line above
		 (let ((vals (get-local (list concept slot)))
		       ;(vals (get-local-with-annotation concept slot))
		       ) 
		   (when vals                                           
		     (dolist (val vals)
		       (add-val-local (list viewpoint slot) val)
		       (copy-values-only (list concept slot val)
					 (list viewpoint slot val)))
		     ;(put-local-with-annotation viewpoint slot vals)
		     ;   to return to old version, sub (put-local-with ...)
		     ;   for (copy-values-only ...)
		     )))
					;fix:(put-facets viewpoint
	                                ;                slot
	                                ;           (get-facets concept slot))
	       (add-interconnects viewpoint basic-dimensions pertinent-slots)
	       viewpoint)))))



;;; return the subset of candidate-slots that belong to basic-dimensions.
;;; This is done by checking the (possibly inherited) value for
;;; each slot's "slot-dimension" facet.
(defun slots-in-basic-dimensions (candidate-slots basic-dimensions)
  (let ((result nil))
    (dolist (slot candidate-slots)
      (if (intersection (get-global-without-annotation slot 'slot-dimension)
			basic-dimensions)
	  (push slot result)))
    result))


;;; create and return a new viewpoint, one taken of concept along
;;; basic-dimensions.
(defun init-basic-dim-vp (concept basic-dimensions)
  (let ((new-vp (make-new-view concept)))
    (put-local (extend-address new-vp 'basic-dimensions) basic-dimensions)
    new-vp))


;--------------------------------------------------------------------------
;;; original version

(defun make-new-view (concept)
  (let ((view (gentemp "VIEWPOINT-")))
    (put-local (list view 'instance-of) '(viewpoint))
    (add-val-local '(viewpoint instances) view)
    (put-local (list view 'viewpoint-of)
	       (list concept))
    (put-local (list view 'generalizations)  
	       (list concept))
    (put-local (list view 'author) '("view retriever"))
    view))

;;;
;;;
;;;			    View Shell Constructor Version
;;;                         ------------------------------


;;; Because the old view shell constructor was so slow, with almost
;;; half of the time consumed by the construction of the unit itself,
;;; we will now keep a collection of view-shells around and build
;;; a new batch of them on-the-fly when the collection runs dry
;;;
;;; Algorithm
;;; ---------
;;; shell <-- get-next-viewpoint-shell
;;; if (null shell) then
;;;    shell-list <-- make 50 viewpoint shells
;;;    shell <-- get-next-viewpoint-shell
;;;    remove shell from shell-list
;;; else remove shell from shell-list
;;; 
;;; Representation
;;; --------------
;;; Unit: VP-Shell (on the instances)
;;; Slot on Knight-Global-State: Create-VP-Shells-Dynamically-Batch
;;;         - defaults to TRUE
;;;
;;; Speed-Up
;;; --------
;;; timing statistics indicate that this new version takes 25%
;;; less time than the old version
;
;
;;; return an "empty" viewpoint of concept, one with a unique name,
;;; which is interned by gentemp into the current package.
;(defun make-new-view (concept)
;  (let ((view (get-vp-shell)))
;    (put-local (list view 'viewpoint-of)
;	       ;; changed by J.L. so works for embeded units 9-5-93
;	       (if (listp concept)
;		   (list concept)
;		   concept))
;    (put-local (list view 'generalizations)  
;	       (if (listp concept)
;		   (list concept)
;		   concept))
;    (put-local (list view 'author) '("view retriever"))
;    view))
;
;
;;; obtains new shell and creates 50 news ones if necessary
;(defun get-vp-shell ()
;
;  ;; create new shells if necessary
;  (when (null (get-local '(vp-shell instances)))
;    (cond ((create-vp-shells-batch?)
;
;	   ;; create a batch of shells
;	   (format t "Creating 50 new viewpoint shells.~%~%")
;	   (make-multiple-vp-shells 10))
;
;	  (t
;	   ;; create only one new shell (because batch not wanted)
;	   (make-vp-shell))))
;
;  ;; grab a shell
;  (grab-first-vp-shell))
;
;
;;; switches a shell from being a shell to being a viewpoint,
;;; and returns the shell
;;;
;;; assumes a shell exists
;(defun grab-first-vp-shell ()
;  (let ((new-shell (first (get-local '(vp-shell instances)))))
;    ;(format t "New-shell: ~a~%" new-shell)
;    (remove-val '(vp-shell instances)
;		new-shell)
;    new-shell))
;
;
;;; creates n new viewpoint shells
;(defun make-multiple-vp-shells (n)
;  (dotimes (i n)
;    (make-vp-shell)))
;
;
;;; creates a new viewpoint shell
;(defun make-vp-shell ()
;  (let ((shell (gentemp "VIEWPOINT-")))
;    (put-local (list shell 'instance-of) '(vp-shell viewpoint))
;    (add-val-local '(vp-shell instances) shell)
;    (add-val-local '(viewpoint instances)
;		   shell)
;    shell))
;
;
;(defun create-vp-shells-batch? ()
;  (equal (get-only-val '(knight-global-state create-vp-shells-batch?))
;	 'true))
;
;
;--------------------------------------------------------------------------


;;; for testing the make-new-view-function
;;;(defun test-maker ()
;;;  (time
;;;   (dotimes (i 10)
;;;     (test-make-new-view 'embryo-sac))))


;;; add interconnection slots to a viewpoint constructed along
;;; a basic dimension.
;;;
;;; parameters:
;;;    view: the viewpoint to which interconnections 
;;;          will be added (must be a basic-dimension viewpoint)
;;;    dimensions: a list of the types of basic dimensions for which
;;;                view was constructed
;;;    pertinent-slots: a list of slots on view that are candidates
;;;                     for interconnections
;;;
;;; Algorithm is as follows: Collect the set of values appearing
;;; locally on all pertinent-slots of view.  Examine the units
;;; representing each of these values.  If a unit contains relevant
;;; interconnection information, copy that information to the 
;;; viewpoint.  Interconnection information is considered "relevant"
;;; when it refers to another value appearing locally on the view.
;;; 
;;; Canonical Example:
;;;       
;;;                 KB before interconnections are added
;;; 
;;; viewpoint007                             Calyx
;;; ------------                             -----
;;; instance-of: viewpoint                   surrounded-by: corolla, stem
;;; viewpoint-of: flower                     attached-to: perianth
;;; basic-dimension: spatial-structural
;;; parts: calyx, corolla, perianth
;;; 
;;;                 KB after interconnections are added
;;; 
;;; viewpoint007
;;; ------------
;;;    ...
;;; parts: calyx, corolla, perianth
;;;   annotation on calyx:           <-- added because (calyx surrounded-by)
;;;      surrounded-by: corolla          contains corolla, and corolla is
;;;                                      a value (along with calyx) on the vp.
;;;                                      Note that stem is NOT included.
;;;      attached-to: perianth       <-- added for similar reasons.
;;; 

(defun add-interconnects (view dimensions pertinent-slots)
  (let ((values-on-view (get-values-on-selected-slots 
			 view pertinent-slots))
	(all-interconnect-slots (get-interconnect-slots dimensions)))
    (dolist (pertinent-slot pertinent-slots)
      (dolist (val (get-local (extend-address view pertinent-slot)))
	(dolist (interconnect-slot (intersection
				    (get-contentful-slots val)
				    all-interconnect-slots
				    :test #'equal))
	  ;; copy an interconnection:
	  ;;   - FROM the unit referred to in the viewpoint,
	  ;;     e.g. "calyx" in the example above, and an
	  ;;     interconnection slot, e.g. surrounded-by or attached-to
	  ;;     in the example above.
	  ;;   - TO the viewpoint unit as annotation, e.g. on the address
	  ;;     (viewpoint007 parts calyx) in the example above.
	  ;;   - UNLESS that interconnection refers to a concept that
	  ;;     that is not used in the viewpoint -- that is, it is not
	  ;;     "interconnecting."  In the example above, "stem" is omitted.
	  (copy-selected-values
	   val				; origin unit
	   interconnect-slot		; origin slot
	   (extend-address-indefinitely ; destination unit
	    view                        
	    pertinent-slot
	    val)
	   interconnect-slot		; destination slot
	   #'(lambda (value)		; value-pruning predicate
	       (not (member (first value) values-on-view
			    :test #'equal)))))))))


;;; copies those values on (origin-unit origin-slot) to
;;; (destination-unit destination-slot) that do not satisfy
;;; value-pruning-predicate
;;;
;;; note that the value-pruning-predicate is applied to the
;;; tuple (value annotation) - just as it is returned by
;;; get-local-with-annotation - and not merely the bare value
(defun copy-selected-values (origin-unit
			     origin-slot
			     destination-unit
			     destination-slot
			     value-pruning-predicate)
  (dolist (val (get-local-with-annotation origin-unit origin-slot))
    (unless (funcall value-pruning-predicate val)
      (add-val-with-annotation destination-unit destination-slot val))))


;;; follows the interconnection-dimension slot from each basic-dimension
;;; to one of: connections-spatial, connections-temporal,
;;; connections-subevents, or connections-specialization.  From there,
;;; it returns the fillers of dimension-of-slots of the
;;; interconnection-dimension and their progeny.


(defun get-interconnect-slots (basic-dimensions)
  (mapcan #'(lambda (dimension)
	      (let* ((inter-connect-dim
		      (get-only-val (list dimension
					  'interconnection-dimension)))
		     (inter-conn-slots			     
		      (get-local (list inter-connect-dim
				       'dimension-of-slots))))
		(copy-list 
		 (mapcan #'progeny*	      ;WARNING: destructive operation
			 inter-conn-slots)))) ;depends on progeny* making a
	  basic-dimensions))	              ;copy of the objects it returns

;; the old way - less efficient
;(defun get-interconnect-slots (basic-dimensions)
;  (reduce #'append
;	  (mapcar #'(lambda (dimension)
;		      (let* ((inter-connect-dim
;			      (get-only-val (list dimension
;						 'interconnection-dimension)))
;			     (inter-conn-slots			     
;			      (get-local (list inter-connect-dim
;					       'dimension-of-slots))))
;			(reduce #'append
;				(mapcar #'progeny*
;					inter-conn-slots))))
;		  basic-dimensions)))
;



;;;;--------------------------------------------------------------------------
;;;;
;;;;			    As-Kind-Of Constructor
;;;;			    ----------------------


;;;; construct an AS-KIND-OF viewpoint
;;;; 
;;;; decompose the viewpoint specification
;;;;
;;;; Note that it might contain an auxillary viewpoint specification in 
;;;; place of a reference concept, i.e. a recursive call to the
;;;; view retriever, such as: "X as-kind-of 'Y basic-dimension Structural'".
;;;; This recursive call is not handled here, instead its specification
;;;; is simply extracted and handled by a recursive call to retrieve-view.

(defun construct-as-kind-of-vp (vspec)
  (let* ((concept-of-interest (first vspec))
	 (reference-concept-or-spec (third vspec))
	 (concept-in-kb? (object? concept-of-interest)))
    (if (error-in-vr? concept-in-kb?)
	concept-in-kb?
	(if (not (member (get-ref-for-path reference-concept-or-spec)
			 (ancestry* concept-of-interest)
			 :test #'equal))

	    ;; reference-concept-or-spec may be a nested view specification
	    (let ((secondary-view (retrieve-view reference-concept-or-spec)))
	      (if (error-in-vr? secondary-view)

		  ;; either the reference-concept is an ill-formed
		  ;; view specification or a non-existant concept
		  (signal-vr-error (second secondary-view))
		  (construct-as-kind-of-vp-2 concept-of-interest
					     secondary-view)))

	    ;; reference-concept-or-spec is a reference-concept
	    (construct-as-kind-of-vp-2 concept-of-interest 
				       reference-concept-or-spec)))))


;;; coi = concept of interest
;;; reference = reference concept.  Note that reference might be
;;;             a viewpoint in the event that the VR was called with
;;;             a recursive as-kind-of specification.
;;; assumption: reference may be a viewpoint constructed along a basic
;;; dimension or an as-kind-of viewpoint, but not a composite viewpoint.
;;;
;;; old algorithm: used only slots whose domain was the reference
;;; problem: produced *very* few values on viewpoint
;;; modification: allow all slots that appear on reference, whether
;;;               they originate there or not
;;; result: filters out slots that are inherited from another ancestor
;;;         in the taxonomy other than via reference
;;;
;;; another modification: using ref-for-path in the case of nested
;;;                       view retrieval calls results in a too
;;;                       inclusive set of slots; it includes slots
;;;                       that the first (innermost) view tried to
;;;                       filter out; instead, maybe just use reference
(defun construct-as-kind-of-vp-2 (coi reference)
  ;; in the event that reference is a viewpoint, ref-for-path is the concept
  ;; of which that viewpoint is taken; otherwise, ref-for-path is reference.
  ;; This function finds the path (through taxonomic slots) that connects 
  ;; coi to ref-for-path.  Then it copies slots/values from coi to a new
  ;; as-kind-of viewpoint whenever the slot is in the domain-of ref-for-path
  ;; OR the value replaces a filler on ref-for-path.
  (let* ((ref-for-path (get-ref-for-path reference)) 
	 (connecting-path (find-ref-conc-connecting-path coi ref-for-path)))
    (if connecting-path
	(let (;(domain-of-slots (get-local (list ref-for-path 'domain-of)))
	      (filled-ref-slots (get-explicit-slots  reference))
				                     ;ref-for-path
	      (filled-coi-slots (get-explicit-slots coi)) 
	      (new-viewpoint (init-ako-vp coi reference)))
	  ;(format t "~%filled-ref-slots: ~a~%~%"
	  ;	  filled-ref-slots)
	  ;(format t "~%filled-coi-slots: ~a~%~%"
	  ;	  filled-coi-slots)
	  (dolist (coi-slot filled-coi-slots)
	    (dolist (coi-value (get-local-with-annotation coi coi-slot))
	      (if (or (ultimately-replaces                           
		       coi                                           
		       coi-slot                                      
       		       (bareify coi-value)                           
		       reference    ; note: this is reference, not
		                    ; ref-for-path,
                                    ; because, if reference is a viewpoint, it
		                    ; resulted from useful filtering
		                    ; of the facts
		                    ; on ref-for-path
		       connecting-path)
		      (specializes-one-of? coi-slot filled-ref-slots))
					     ;domain-of-slots
	       (add-val-with-annotation new-viewpoint             
					coi-slot
					coi-value))))
	  new-viewpoint)
	(signal-vr-error 'ref-concept-not-genl-of-coi))))


;;; if ref is not a viewpoint, return ref
;;; if ref is a viewpoint, trace viewpoint-of links to non-viewpoint
(defun get-ref-for-path (ref)
  (if (member 'viewpoint (get-local (extend-address ref 'instance-of)))
      (get-ref-for-path (get-only-val (extend-address ref 'viewpoint-of)))
      ref))



;;; FIX: Consider adding the inverse for the put-local below when
;;       reference is a viewpoint (but not otherwise)
;;; create and return the "skeleton" of a new as-kind-of viewpoint
(defun init-ako-vp (coi reference)
   (let ((new-vp (make-new-view coi)))
     (put-local (extend-address new-vp 'as-kind-of) (listify reference))
     ;; copy the basic dimensions if the reference concept is
     ;; a viewpoint to the new viewpoint
     (copy-all-values (extend-address reference 'basic-dimensions)
		      (list new-vp 'basic-dimensions))
     new-vp))


;;; Parameters:
;;;    required:
;;;       origin-unit: a unit in the KB from which the search will
;;;                    begin
;;;       slot: a slot located on origin-unit
;;;       value: a value on (origin-unit slot)
;;;       target-unit: a unit that is the target of the search,
;;;                    i.e., where the string of replaces terminates
;;;                    when this function succeeds
;;;    optional:
;;;       connecting-path: a path connecting origin-unit to 
;;;                        target-unit through taxonomic slots.
;;;
;;; return T iff (origin-unit slot value) is connected through a 
;;; series of replaces slots to a filler on target-unit.
;;; If a connecting-path is given, then the series of replaces slots
;;; may not deviate from units on that path.
(defun ultimately-replaces (origin-unit slot value 
					target-unit 
					&optional connecting-path)
  (let* ((success-function (make-success-function-ako-vr target-unit))
	 (pruning-function (if connecting-path
			       (make-pruning-function-for-ako-vr 
				connecting-path)))
	 (kb-search-results
	  (kb-search (list (extend-address-indefinitely origin-unit 
							slot value))
		     (list 'replaces)
		     :terminate-with-success-criteria success-function
		     :pruning-function pruning-function
		     :control-strategy 'breadth-first
		     :collect-path? nil
		     :loop-elimination? t)))
    (equal (first kb-search-results) 'success)))


;;; this function when called generates a function that
;;; takes 1 parameter, which is the unit being considered
;;; by the search function, i.e., current
;;;
;;; the reference concept is built into this generated function
(defun make-success-function-ako-vr (reference)
  #'(lambda (unit)
      (equal (start-of-path unit)
	     reference)))


;;; this function when called generates a function that
;;; takes 1 parameter, which is the unit being considered
;;; by the search function, i.e., current
;;;
;;; the path is built into this generated function
(defun make-pruning-function-for-ako-vr (path)
  #'(lambda (unit)
      (not (member (start-of-path unit) path
		   :test #'equal))))


;;; search for a path from the concept of interest (coi) to the
;;; reference concept through the slot generalizations and its
;;; progeny.
;;; returns list with elements (coi u1 u2 ... u3 ref-conc)
;;; if no path exists returns nil
(defun find-ref-conc-connecting-path (coi reference)
  (let ((kb-search-result (kb-search 
			   (list coi)
			   '(generalizations)
			   :search-progeny? t
			   :goal-units (list reference)
			   :collect-path? t
			   :control-strategy 'breadth-first
			   :loop-elimination? t)))
    (if (equal (car kb-search-result) 'success)
	(third kb-search-result))))


;;;;-------------------------------------------------------------------------- 
;;;;
;;;;			  Composite View Constructor
;;;;			  --------------------------

;;; given:
;;;    concept1: a concept in the KB
;;;    concept2: a concept in the KB
;;;    correspondence-slots: slots to connect concept1 to concept2
;;;
;;; method:
;;;    for each "contentful" slot s on concept1
;;;       for each value v on s
;;;          find connection from v to a value on a "contentful" slot 
;;;               on concept2
;;;          record this connection in the new viewpoint
;;;
;;; returns:
;;;         New-Correspondence-VP
;;;         ---------------------
;;;         viewpoint-of: concept1
;;;                       --------
;;;                       (optional: viewpoint-of: <concept1 viewpoint-of>)
;;;         correspondence-type: correspondence-slots
;;;         correspondence-with: concept2 
;;;                              --------
;;;                              (optional: viewpoint-of: 
;;;                                              <concept2 viewpoint-of>)
;;;         slot-i

;	     (slots-to-search (remove-duplicates 
;			       (reduce #'append
;				       (mapcar #'(lambda (slot)
;						   (progeny* slot))
;					       correspondence-slots))
;			       :test #'equal)))

(defun construct-composite-vp (concept1 concept2 correspondence-slots)
  (if (not (legal-correspondence-slots correspondence-slots))
      (signal-vr-error 'bad-correspondence-slot-to-composite-viewpoint-request)

      (let* ((new-view (init-composite-vp 
			concept1 concept2 correspondence-slots))
	     (slots-on-concept1 (get-contentful-slots concept1))
	     (slots-on-concept2 (get-contentful-slots concept2))
	     (vals-on-concept2 (get-values-on-selected-slots
				concept2 slots-on-concept2))
	     ; WARNING: the following destructive operation depends on
	     ;          the fact that progeny* makes a copy of the
	     ;          objects it returns
	     (slots-to-search (remove-duplicates 
			       (mapcan #'progeny* correspondence-slots)
			       :test #'equal)))


	(dolist (slot-on-concept1 slots-on-concept1)
	  (let ((vals-on-concept1 (get-local+ concept1 slot-on-concept1)))
	    (dolist (val-on-concept1 vals-on-concept1)
	      (dolist (val-on-concept2 vals-on-concept2)

		(let ((search-result
		       (kb-search (list val-on-concept1)
				  slots-to-search
				  :search-progeny? nil
				  :goal-units (list val-on-concept2)
				  :collect-path? t)))

		  (when (equal (first search-result) 'success)
		    (let* ((search-path (third search-result))
			   (slot-that-begins-path (second search-path))
			   (rest-of-path (cddr search-path)))
		      (add-val-local
		       (extend-address-indefinitely new-view
						    slot-on-concept1
						    val-on-concept1
						    slot-that-begins-path)
		       (if (equal (length rest-of-path) 1)
			   (first rest-of-path)
			   rest-of-path)))))))))
	new-view)))


;;; returns t iff correspondence-slots is non-null, it is a list, and
;;; each member is a slot
(defun legal-correspondence-slots (correspondence-slots)
  (and correspondence-slots
       (listp correspondence-slots)
       (every #'slot? correspondence-slots)))


;;; create the "shell" for a composite viewpoint.  It's form is:
;;;
;;;      new-correspondence-vp
;;;      ---------------------
;;;        viewpoint-of: concept1
;;;                      --------
;;;                      (optional: viewpoint-of: <concept1 viewpoint-of>)
;;;        correspondence-type: correspondence-slots
;;;        correspondence-with: concept2 
;;;                             ----------
;;;                             (optional: viewpoint-of: <concept2 viewpoint-of>)
;;;
;;; the optional information above is added when concept1 and/or concept2
;;; are viewpoints
;;;
(defun init-composite-vp (concept1 concept2 correspondence-slots)
  (let ((new-vp (make-new-view concept1)))
    (put-local (extend-address new-vp 'viewpoint-of) concept1)
    (put-local (extend-address new-vp 'correspondence-type) correspondence-slots)
    (put-local (extend-address new-vp 'correspondence-with) concept2)
    (when (viewpoint? concept1)
      (put-local (extend-address-indefinitely new-vp 'viewpoint-of
					      concept1 'viewpoint-of)
		 (get-local+ concept1 'viewpoint-of)))
    (when (viewpoint? concept2)
      (put-local (extend-address-indefinitely new-vp 'correspondence-with
					      concept2 'viewpoint-of)
		 (get-local+ concept2 'viewpoint-of)))
    new-vp))


;;; returns t iff unit is a viewpoint
(defun viewpoint? (unit)
  (a-kind-of? unit 'viewpoint))


;;;;---------------------------------------------------------------------------- 
;;;;
;;;;			  Signal View-Retriever Error
;;;;			  ---------------------------


;;; signal a view-retriever error if concept is not in the KB.
(defun check-concept (concept)
  (when (not (object? concept))
    (signal-vr-error 'unknown-concept)))


;;; return an error from the view retriever
(defun signal-vr-error (errortype)
  (list 'error errortype))  	


(defun error-in-vr? (possibly-an-error-code)
  (and (listp possibly-an-error-code)
       (equal (car possibly-an-error-code) 'error)))



;;;;---------------------------------------------------------------------------- 
;;;;
;;;;			      Test Call Functions
;;;;			      -------------------

(defun is-calyx (value)
  (equal (first value) 'calyx))
in-of)))
	      (filled-ref-slots (get-explicit-slots  reference))
				                     ;ref-for-path
	      (filled-coi-slots (get-explicit-slots coi)) 
	      (new-viewpoint (init-ako-vp coi reference)))
	  ;(format t "~%filled-ref-slots: ~a~%~%"
	  ;	  filled-ref-slots)
	  ;(format t "~%filled-coi-slots: ~a~%~%"
	  ;	  filled-coi-slots)
	  (dobruce-and-my-search.lisp                                                                            000775  003117  001440  00000036545 05641657621 016545  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ; -*- Mode: Lisp; Syntax: Common-Lisp; Package: KM; Base: 10 -*-
(in-package 'km)


;;;				   KB Search
;;;				   ---------

;;; generalized KB search
;;; searches through KB using criteria provided by user
;;;
;;; given: - initial-unit-list: list of units that serve as initial
;;;                             source(s) in the search
;;;
;;;        - slots            : list of slots through which search
;;;                             may pass 
;;;
;;;        - search-progeny?  : if given as t, then searches both
;;;                             slots and their progeny
;;;                             (default: nil)
;;;
;;;        - goal-units       : list of units that serve as final
;;;                             success states in the search
;;;
;;;        - terminate-with-success-criteria
;;;                           : predicate on units that returns t
;;;                             if the unit to which it is applied
;;;                             is to be considered a goal
;;;
;;;        - terminate-with-failure-criteria
;;;                           : predicate on units that returns t
;;;                             if the unit to which it is applied
;;;                             is to be considered a failure
;;;
;;;        - pruning-function : predicate on units that returns t
;;;                             if the unit and all of its successors
;;;                             should be excluded from the search
;;;
;;;        - control-strategy : depth-first or breadth-first
;;;                             (default: depth-first)
;;;
;;;        - collect-path?    : if given as t, then collects and
;;;                             returns successful search path
;;;                             (default: nil)
;;;
;;;        - loop-elimination?: if given as t, then checks for 
;;;                             and eliminates loops during search
;;;                             (default: t)
;;;
;;; use of arguments:
;;;      - user must provide initial-unit-list and slots
;;;      - user must provide at least one of
;;;        terminate-with-success-criteria
;;;        or goal-units; he may provide both
;;;      - all other arguments are optional
;;;
;;; returns one of:
;;;      - (fail no-goal-found)
;;;      - (fail terminate-with-failure <failure-unit>)
;;;      - (success <goal-unit> <path>)
;;;
;;; if <failure-unit> is non-null, its value is the unit
;;; at which the terminate-with-failure-criteria returned t
;;;
;;; if <goal-unit> is non-null, its value is either the unit
;;; at which the terminate-with-success-criteria returned t
;;; or is a member of goal-units
;;;
;;; Notes on removing duplicates from open-list during search:
;;;    1) in the case when a path will not be returned from the search,
;;;       duplicates are removed.  Reason: the code doesn't, and can't,
;;;       exploit information about the path to each node on the
;;;       open-list; therefore, different paths to the same node
;;;       are equivalent.
;;;    2) in the case when a path will be returned from the search:
;;;       a) the current implementation of this search program does
;;;          not permit the user to apply predicates on paths (e.g. to 
;;;          measure the length of a path, or to order nodes on open, 
;;;          best-first search, based on characteristics of their paths).
;;;          These are options that might be added later.
;;;       b) so, duplicates are removed from the open-list in this
;;;          implementation.  However, we've tried to document the
;;;          parts of the code that might be modified later.
;;;       c) interestingly, the method for removing duplicates does not
;;;          depend on control strategy.  For both breadth-first and
;;;          depth-first search, duplicates are removed from the 
;;;          end of the open-list.  For depth-first search, this insures
;;;          that newly placed nodes on open overshadow older copies;
;;;          for breadth-first search, this insures that older copies
;;;          overshadow newly placed ones.

;;; Organization of File
;;; --------------------
;;; 1. General KB-Search function
;;; 2. Path-Finding Search functions
;;; 3. Non-Path-Finding Search functions
;;; 4. Auxiliary functions used by both (2) and (3)
;;; 5. Test function calls


;;; this top-level function simply collects all the slots that will
;;; searched (by collecting the progeny of slots, a passed parameter,
;;; when search-progeny?=T) and calling one of two search programs,
;;; based on whether paths are being collected.
(defun kb-search (initial-unit-list slots
				    &key search-progeny?
				    goal-units
				    terminate-with-success-criteria
				    terminate-with-failure-criteria
				    pruning-function
				    (control-strategy 'depth-first)
				    collect-path?
				    (loop-elimination? t))
  (if (not (or goal-units terminate-with-success-criteria))
      '(fail no-goal-requested)
      (let ((slots-to-search (if search-progeny?
				 (remove-duplicates 
				  (reduce #'append
					  (mapcar #'(lambda (slot)
						      (progeny* slot))
						  slots))
				  :test #'equal)
				 slots)))
	(if collect-path?
	    (kb-search-for-path initial-unit-list
				slots-to-search
				goal-units
				terminate-with-success-criteria
				terminate-with-failure-criteria
				pruning-function
				control-strategy
				loop-elimination?)
	    (kb-search-for-goal initial-unit-list
				slots-to-search
				goal-units
				terminate-with-success-criteria
				terminate-with-failure-criteria
				pruning-function
				control-strategy
				loop-elimination?)))))


;;;-------------------------------------------------------------------
;;; Path-finding functions (return a solution path)
;;;
;;; a solution path is of the form:
;;;      (<initial-unit> s1 u1 s2 u2 ... sn <goal-unit>)
;;; where <initial-unit> occurs in the initial-unit-list
;;; and s1, s2,..., sn are slots that occur in slots-to-search
;;;
;;; the variable Open is a list of pairs of the form
;;;      (<path from initial-unit to unit-i> <unit-i>)
;;; where initial-unit is in the initial-unit-list and
;;; unit-i is reachable through slots-to-search


(defun kb-search-for-path (initial-unit-list
			   slots-to-search
		           goal-units
			   terminate-with-success-criteria
			   terminate-with-failure-criteria
			   pruning-function
			   control-strategy
			   loop-elimination?)
  (do ((open (initialize-open initial-unit-list))
       (closed nil)
       (terminated? nil))
      (terminated?
       terminated?)
    (if (null open)
	(setf terminated? '(fail no-goal-found))
	(let ((current-unit (second (first open)))
	      (current-path (first (first open))))
	  (setf terminated?
		(check-termination-with-path
		 current-unit
		 current-path
		 goal-units
		 terminate-with-success-criteria
		 terminate-with-failure-criteria))
;	  (format t "Current-unit: ~a~%" current-unit)
;	  (format t "Open:")
;	  (pprint open)
;	  (format t "~%")
	  ;(format t "Terminated?: ~a~%~%" terminated?)
	  ;(print-abbrev-open open)
	  (when (not terminated?)
	    (when loop-elimination?
	      (setf closed (cons current-unit closed)))
	      ;(format t "Closed:")
	      ;(pprint closed)
	      ;(format t "~%")
	    (setf open
		  (update-open-with-path (rest open)
					 current-unit
					 current-path
					 closed
					 loop-elimination?
					 slots-to-search
					 control-strategy
					 pruning-function)))))))


;;; initializes the variable Open to be a list of pairs of the
;;; form ((initial-unit) initial-unit)
(defun initialize-open (initial-unit-list)
  (mapcar #'(lambda (unit)            
	      (list (list unit) unit))
	  initial-unit-list))


;(defun print-abbrev-open (open)
;  (format t "Open:")
;  (let ((open-abbrev 
;	 (mapcar #'(lambda (element)
;		     (second element))
;		 open)))
;    (pprint open-abbrev))
;  (format t "~%"))




;;; returns the open list updated by the successors of the current unit,
;;; with duplicates removed
(defun update-open-with-path (open current-unit current-path
				   closed loop-elimination? slots
				   control-strategy pruning-function)
  (let ((additions-to-open
	 (generate-path-successors-of-unit
	  current-unit
	  current-path
	  slots
	  loop-elimination?
	  closed
	  pruning-function)))
    (remove-duplicates
     (case control-strategy
       (depth-first
	(append additions-to-open
		open))
       (breadth-first
	(append open
		additions-to-open)))
     :key #'(lambda (element-on-open)
	      (second element-on-open))
     :test #'equal
     :from-end t)))


;;; finds all successors of current that are connected via slots
;;; if no loop-elimination, returns all successors; otherwise
;;; returns successors that are not on closed and that are not pruned
;;; each successor is a pair of the form (<path> <successor-unit>)
;;; the last step in the process is to append the partial-paths to
;;;    each successor
(defun generate-path-successors-of-unit (current-unit current-path
					 slots loop-elimination?
					 closed pruning-function)
  (let* ((successors
	  (generate-unpruned-unit-successors-with-slots current-unit
							slots))
	 (non-dupe-successors
	  (if loop-elimination?
	      (set-difference successors closed
			      :test #'(lambda (successor-item closed-item)
					(equal (second successor-item)
					       closed-item)))
	      successors))
	 (non-pruned-successors
	  (if pruning-function
	      (apply-pruning-function-with-slots pruning-function
						 non-dupe-successors)
	      non-dupe-successors)))
    (add-path non-pruned-successors current-path)))


;;; CONSIDER THIS EFFICIENCY HACK:
;;;    REDUCE THE LIST OF SLOTS BY INTERSECTING IT WITH THE EXPLICIT
;;;    SLOTS ON CURRENT-UNIT, THEN GET-LOCAL'ing ONLY THOSE

;;; finds all successors of current that are connected via slots
;;; current is a unit
;;; returns list of the form:
;;;        ( ... (slot successor) ...)
(defun generate-unpruned-unit-successors-with-slots (current-unit slots)
  (reduce #'append
	  (mapcar #'(lambda (slot)
		      (mapcar #'(lambda (value)
				       (list slot value))
			      (get-local (extend-address current-unit
							 slot))))
		  slots)))


;;; returns subset of candidates that do not satisfy the pruning function
;;; candidates is a list of pairs of the form (slot unit)
(defun apply-pruning-function-with-slots (pruning-function candidates)
  (reduce #'append
	  (mapcar #'(lambda (candidate)
		      (if (funcall pruning-function (second candidate))
			  nil
			  (list candidate)))
		  candidates)))


;;; extends the path of each successor by adding current-path
;;; to the front
;;;
;;; example:
;;;     successors: ((x y) (z w))
;;;     current-path: (a b c)
;;;     result: (((a b c x y) y) ((a b c z w) w))
(defun add-path (successors current-path)
  (mapcar #'(lambda (successor)
	      (list (append current-path successor)
		    (second successor)))
	  successors))


(defun check-termination-with-path (current-unit current-path
				    goal-units
				    terminate-with-success-criteria
				    terminate-with-failure-criteria)
  (cond ((member current-unit goal-units :test #'equal)
	 (list 'success current-unit current-path))
	((and terminate-with-success-criteria
	      (funcall terminate-with-success-criteria current-unit))
	 (list 'success current-unit current-path))
	((and terminate-with-failure-criteria
	      (funcall terminate-with-failure-criteria current-unit))
	 (list 'fail current-unit))
	(t nil)))


;;;-------------------------------------------------------------------
;;; Goal-searching functions (does not return a solution path)

(defun kb-search-for-goal (initial-unit-list
			   slots
		           goal-units
			   terminate-with-success-criteria
			   terminate-with-failure-criteria
			   pruning-function
			   control-strategy
			   loop-elimination?)
  (do ((open initial-unit-list)
       (closed nil)
       (terminated? nil))
      (terminated?
       terminated?)
    (if (null open)
	(setf terminated? '(fail no-goal-found))
	(let ((current (first open)))
	  (setf terminated? (check-termination current
					       goal-units
					       terminate-with-success-criteria
					       terminate-with-failure-criteria))
	  ;(format t "Current: ~a~%" current)
;	  (format t "Open:")
;	  (pprint open)
;	  (format t "~%")
	  ;(format t "Terminated?: ~a~%~%" terminated?)
	  (when (not terminated?)
	    (when loop-elimination?
	      (setf closed (cons current closed)))
	                                ;(format t "Closed:")
					;(pprint closed)
					;(format t "~%")
	    (setf open (update-open (rest open) current closed
				    loop-elimination?
				    slots
				    control-strategy
				    pruning-function)))))))


;;; returns the open list updated by the successors of the current unit,
;;; with duplicates removed
(defun update-open (open current closed loop-elimination?
                    slots control-strategy pruning-function)
  (let ((additions-to-open
	 (generate-successors-of-unit current slots
				      loop-elimination?
				      closed
				      pruning-function)))
    (remove-duplicates
     (case control-strategy
       (depth-first
	(append additions-to-open
		open))
       (breadth-first
	(append open
		additions-to-open)))
     :test #'equal
     :from-end t)))



;;; finds all successors of current that are connected via slots
;;; if no loop-elimination, returns all successors; otherwise
;;; returns successors that are not on closed and that are not pruned
(defun generate-successors-of-unit (current slots loop-elimination?
					    closed pruning-function)
  (let* ((successors (generate-unpruned-unit-successors current
							slots))
	 (non-dupe-successors (if loop-elimination?
				  (set-difference successors closed
						  :test #'equal)
				  successors)))
    (if pruning-function
	(apply-pruning-function pruning-function non-dupe-successors)
	non-dupe-successors)))
    


;;; finds all successors of current that are connected via slots
(defun generate-unpruned-unit-successors (current slots)
  (reduce #'append
	  (mapcar #'(lambda (slot)
		      (get-local (extend-address current slot)))
		  slots)))


;;; returns subset of candidates that do not satisfy the pruning function
(defun apply-pruning-function (pruning-function candidates)
  (reduce #'append
	  (mapcar #'(lambda (candidate)
		      (if (funcall pruning-function candidate)
			  nil
			  (list candidate)))
		  candidates)))


(defun check-termination (current goal-units
				  terminate-with-success-criteria
				  terminate-with-failure-criteria)
  (cond ((member current goal-units :test #'equal)
	 (list 'success current nil))
	((and terminate-with-success-criteria
	      (funcall terminate-with-success-criteria current))
	 (list 'success current nil))
	((and terminate-with-failure-criteria
	      (funcall terminate-with-failure-criteria current))
	 (list 'fail current))
	(t nil)))


;;;-----------------------------------------------------------------------
;;; sample test functions

;;; prunes all flowers and their offspring
;;; returns t iff unit satisfies test
(defun flower-picker (unit)
  (if (member unit (progeny* 'flower)
	      :test #'equal)
      t))


;;; termination test functions

(defun is-sepal? (unit)
  (equal unit 'sepal))

(defun is-embryo-sac-formation? (unit)
  (equal unit 'embryo-sac-formation))

(defun is-corolla? (unit)
  (equal unit 'corolla))

(defun is-perianth? (unit)
  (equal unit 'perianth))

;;; sample kb-search test call

(defun test-kb-search ()
    (kb-search '(flower) '(actor-in occurs-after temporal-ordering) 
	       :goal-units '(embryo-sac-formation)
	       :search-progeny? t
	       :loop-elimination? t 
               :collect-path? t
	       :control-strategy 'breadth-first))
criteria
				terminate-with-failure-criteria
				pruning-function
				control-strategy
				loop-elimination?)))))


;;;------------------------------------content-determination.lisp                                                                          000775  006350  001440  00000167057 05653754532 017703  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		 The Auxiliary Content Determination Functions
;;;;		 ---------------------------------------------


;;;; These are the functions used by the EDPs for content determination.
;;;;
;;;;
;;;; What's Returned
;;;; ---------------
;;;; Either a unit or a list is returned; if the content is to be
;;;; used by another function, only a list will be returned; on
;;;; the other hand, if the content is to be part of an explantion
;;;; plan, then a viewpoint unit will be returned (just like the
;;;; the View Retriever does)
;;;;
;;;;
;;;; Error Handling
;;;; --------------
;;;; They include methods for reporting errors encountered during
;;;; execution.  In general, during content determination, if an
;;;; error is found, the function returns a pair of the form:
;;;;          (error <error-type>)
;;;; Typically, the Applier will omit the intended content.
;;;;
;;;;
;;;; User Modeling Issues
;;;; --------------------
;;;; Some functions exploit the user model.  When the user modeling
;;;; facility is off, these functions behave differently.  They
;;;; take the approach of doing whatever is the ``right thing''
;;;; without regard to what might have been in the user model, e.g.,
;;;; when finding a reference concept, the function merely finds
;;;; an immediate genl of the given concept, rather than the most
;;;; specific concept that was familiar to the user.  (See the header
;;;; of the User Model functions file for additional information.)

;;;;-------------------------------------------------------------------
;;;;		     Top-Level Content Determination Calls
;;;;-------------------------------------------------------------------
;;;;
;;;; Function                           Arguments
;;;; --------                           ---------
;;;;
;;;; connect-to-core                    (origin)
;;;;
;;;; connect-to-core-rev                (origin)
;;;;
;;;; find-partonomic-connection         (object)
;;;;
;;;; make-as-kind-of-perceptual-view    (concept ref-conc)
;;;;
;;;; make-auxiliary-process-view        (process view-type)
;;;;
;;;; make-bare-ako-view                 (concept ref-conc)
;;;;
;;;; make-black-box-view                (process reference-process)
;;;;
;;;; make-functional-view               (actor-slot black-box-view)
;;;;
;;;; make-subevent-list                 (process)
;;;;
;;;; make-sub-structural-view           (object part-slot)
;;;;
;;;; make-temporal-step-of-view         (process)
;;;;
;;;;-------------------------------------------------------------------


(in-package 'km)


;-----------------------------------------------------------------------
;			   Concept-Has-Value-On-Slot
;-----------------------------------------------------------------------

;;; arguments: - Concept
;;;            - Slot
;;;            - Value
;;;
;;; returns non-null if Value appears locally on Concept.Slot

(defun concept-has-value-on-slot (concept slot value)
  (member value (get-local (list concept slot))
	  :test #'equal))

			   
;-----------------------------------------------------------------------
;				Collect-Actors
;-----------------------------------------------------------------------

;;; arguments: Content Node with Black-box-view
;;;
;;; searches through the Black box view to find the actor slots
;;; 
;;; seaches through the values on these slots to return the actors
;;; 
;;; returns a list of actors
;;;
;;; errors:
;;;             - condition: no content node exists
;;;             - returns: (error no-content-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;                          with black-box view
;;;             - returns: (error error-in-node-with-black-box-view)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint-in-content-node)
;;;
;;;		- condition: viewpoint exists, but no actors
;;;		- returns: (error no-actor-slots-on-viewpoint)

(defun collect-actors (content-node)
  (cond ((null content-node)
	 '(error no-content-node))
	((content-node-has-error? content-node)
	 '(error error-in-node-with-black-box-view))
	(t (let ((viewpoint
		  (get-only-val (list content-node 'kb-subgraph))))
	     (if (null viewpoint)
		 '(error no-viewpoint-in-content-node)
		 (let ((actor-slots (collect-actor-slots viewpoint)))
		   (if (null actor-slots)
		       '(error no-actor-slots-on-viewpoint)
		       (collect-all-values-on-slots viewpoint
						    actor-slots))))))))


(defun collect-actor-slots (viewpoint)
  (let ((slots-with-values (all-explicit-slots viewpoint)))
    (remove-if-not #'is-actor-slot-p
		   slots-with-values)))


(defun is-actor-slot-p (slot)
  (member 'actors (ancestry* slot)))


;;; returns list of all values that appear on some slot in
;;; slot-list on frame
;;;
;;; Important note: mapcan is *not* used below and should
;;;                 not be used anywhere in the code because
;;;                 it nconc's some structures in the KB,
;;;                 sometimes creating circular structures
;;;                 that cause KM to go into infinite recursion

(defun collect-all-values-on-slots (frame slot-list)
  (remove-duplicates
   (reduce #'append
	   (mapcar #'(lambda (slot) (get-local (extend-address frame slot)))
		   slot-list))))


;-----------------------------------------------------------------------
;			 Collect-Actors-From-Viewpoint
;-----------------------------------------------------------------------

;;; arguments: an Output-Actor Viewpoint of a Process
;;;
;;; searches through the Black box view to find the actor slots
;;; 
;;; seaches through the values on these slots to return the actors
;;; 
;;; returns a list of actors
;;;
;;; like function collect-actors, but a viewpoint is given directly
;;;
;;; errors:
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint-in-content-node)
;;;
;;;		- condition: viewpoint exists, but no actors
;;;		- returns: (error no-actor-slots-on-viewpoint)

(defun collect-actors-from-viewpoint (viewpoint)
  (if (not (viewpoint? viewpoint))
      '(error no-viewpoint-in-content-node)
      (let ((actor-slots (collect-actor-slots viewpoint)))
	(if (null actor-slots)
	    '(error no-actor-slots-on-viewpoint)
	    (collect-all-values-on-slots viewpoint
					 actor-slots)))))


;-----------------------------------------------------------------------
;			 Collect-Functional-Processes
;-----------------------------------------------------------------------

;;; arguments: Active-Functional-View
;;;
;;; goes through Active-Functional-View to find processes which are
;;; values of actor-in slots
;;;
;;; returns (a list of a) list of processes
;;;
;;; errors:
;;;		- condition: no active-functional-view exist
;;;		- returns: (error no-view)
;;;
;;;		- condition: viewpoint exists, but no processes
;;;		- returns: (error no-processes)

(defun collect-functional-processes (active-functional-view)
  (if (null active-functional-view)
      '(error no-view)
      (let* ((slot-list (all-explicit-slots active-functional-view))
	     (actor-in-slots (reduce
			      #'append
			      (mapcar #'(lambda (slot)
					  (if (member 'actor-in
						      (ancestry* slot))
					      (list slot)))
				      slot-list))))
	(get-processes-on-slots active-functional-view
				actor-in-slots))))


;-----------------------------------------------------------------------
;		  Collect-Funct-Processes-From-Content-Nodes
;-----------------------------------------------------------------------

;;; arguments: Object-Signif-Topic-Node
;;;
;;; goes through children of Object-Significance-Topic-Node to examine
;;; the kb-subgraph associated with each one, and then collects the
;;; the process that is the function of each one
;;;
;;; returns list of processes
;;;
;;; errors:
;;;		- condition: no Object-Significance-Topic-Node exists
;;;		- returns: (error no-object-signif-topic-node)

(defun collect-funct-processes-from-content-nodes (object-signif-topic-node)
  (if object-signif-topic-node
      (let ((content-nodes (get-local (list object-signif-topic-node
					    'child-nodes-ordered))))
	(remove-duplicates
	 (reduce #'append
		 (mapcar #'(lambda (content-node)
			     (let ((viewpoint
				    (get-only-val (list content-node
							'kb-subgraph))))
			       (if viewpoint
				   (get-local (list viewpoint
						    'viewpoint-of)))))
			      content-nodes))))))

	 
;-----------------------------------------------------------------------
;			 Collect-Modulatory-Processes
;-----------------------------------------------------------------------

;;; arguments: Content-Node with a Causal-Agent-Viewpoint,
;;;            a Causal-Facilitating-Viewpoint, or
;;;            a Causal-Inhibiting-Viewpoint
;;;
;;; can test with:
;;;                Enables: <No non-embedded processes>
;;;                Facilitates: <None>
;;;                Inhibits: <None>
;;;                Causes: Guard-Cell-Collapse, Plant-Water-Loss
;;;                Caused-by: Plant-water-stress, Stoma-closing-sequence
;;;
;;; returns list of processes
;;;
;;; errors:
;;;		- condition: no content node exists
;;;		- returns: (error no-content-node)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint)
;;;
;;;		- condition: viewpoint exists, but error
;;;		- returns: (error problem-viewpoint)
;;;
;;;		- condition: viewpoint exists, but no processes
;;;		- returns: (error no-processes)

(defun collect-modulatory-processes (content-node)
  (if (null content-node)
      '(error no-content-node)
      (let ((the-viewpoint (get-only-val (list content-node
					       'kb-subgraph))))
	(cond ((null the-viewpoint)
	       '(error no-viewpoint))
	      ((content-node-has-error? content-node)
	       '(error problem-viewpoint))
	      (t (let* ((all-slots (all-explicit-slots the-viewpoint))
			(interesting-slots
			 (set-difference all-slots
					 '(last-edit-time
					   last-editor
					   specification-type 
					   generalizations
					   viewpoint-of
					   instance-of
					   author
					   creation-time)
					 :test #'equal))
			(processes (get-processes-on-slots the-viewpoint
							   interesting-slots)))
		   (if (null processes)
		       '(error no-processes)
		       processes)))))))


;;; returns all values on unit that appear on some slot in slot-list
;;; and are specs of process
(defun get-processes-on-slots (unit slot-list)
  (remove-duplicates
   (reduce #'append
	   (mapcar #'(lambda (slot)
		       (let ((values (get-local (extend-address unit slot))))
			 (reduce #'append
				 (mapcar #'(lambda (value)
					     (if (process-p value)
						 (list value)))
					 values))))
		   slot-list))
   :test 'equal))


;-----------------------------------------------------------------------
;				Connect-To-Core
;-----------------------------------------------------------------------

;;; arguments: Origin
;;;
;;; called from Process-Significance
;;;
;;; finds connection from Origin to either (1) a process that 
;;; is marked ``core'' in the knowledge base, or (2) a process 
;;; that is known to the user and is on the search path to a
;;; core process, or (3) the unit ``Process'' is reached, which
;;; is an error
;;;
;;; first climbs up superevents and then climbs up generalizations
;;;
;;; assumes if user knows a process, he knows the relation of that
;;; process to a core process (if at the begining of a session
;;; the user is told about all core processes, or if it is
;;; known that he knows about all core processes, then this
;;; assumption is true by induction)
;;;
;;; if a process has more than one superevent or more than one
;;; generalization, the first one is chosen (arbitrarily)
;;;
;;; errors:
;;;             - condition: given parameter is not a process
;;;             - returns: (error origin-not-a-process)
;;;
;;;		- condition: cannot find a genl
;;;		- returns: (error no-known-or-core-genl-available)
;;;
;;; returns a list: the first item in the list is the
;;; unit at which the search terminated, the next 
;;; item in the list is the slot that connects the 
;;; units in the search path, the next item is the 
;;; penultimate unit in the search, etc., until the 
;;; final item in the list which is the origin
;;;
;;; all of this is found in a viewpoint with the following template:
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           specification-type: Core-Connection
;;;                           viewpoint-of: <Given-Process>
;;;                           connection-to-core: (<Core-Process> <link-1>
;;;                                               <Linking-Process-1> <link-2>
;;;                                               <Linking-Process-2> <link-3>
;;;                                               ... <link-3>
;;;                                                   <Given-Process>)
;;;                           first-item-is-core?: <True or False>


(defun connect-to-core (origin)
  (let ((connect-to-core-result 
	 (if (not (process-p origin))
	     '(error origin-not-a-process)

	     ;; first climb superevents
	     (let* ((superevent-search-result (climb-superevents origin))
		    (top-superevent (first superevent-search-result)))
	       (if (or (is-known-p top-superevent)
		       (is-core-p top-superevent))
		   superevent-search-result

		   ;; then climb genl-events
		   (let ((genl-event-search-result
			  (climb-genl-events top-superevent)))
		     (if genl-event-search-result
			 (append (all-but-last genl-event-search-result)
				 superevent-search-result)
			 '(error no-known-or-core-genl-available)))))))

	(new-view-unit (make-new-view origin)))

    (put-local (list new-view-unit 'specification-type)
	       '(core-connection))
    (cond ((contains-error connect-to-core-result)
	   (signal-kb-access-error new-view-unit
				   (second connect-to-core-result)))
	  (t (put-local (list new-view-unit 'connection-to-core)
			(list connect-to-core-result))
	     (put-local (list new-view-unit 'first-item-is-core?)
			(if (is-core-p (first connect-to-core-result))
			    '(true)
			    '(false)))))
    new-view-unit))


(defun climb-superevents (origin)
  (substitute 'subevents
	      'superevents
	      (reverse (third
			(kb-search (list origin)
				   (list 'superevents)
				   :terminate-with-success-criteria
				   #'(lambda (process)
				       (null (get-local
					      (extend-address process
							      'superevents))))
				   :collect-path? t
				   :loop-elimination? t)))))

	
(defun climb-genl-events (process)
  (let ((search-result
	 (kb-search (list process)
		    (list 'generalizations 'stage-of 'i-genls)
		    :terminate-with-success-criteria
		    #'(lambda (current-process)
			(or (is-known-p current-process)
			    (is-core-p current-process)))
		    :collect-path? t
		    :loop-elimination? t)))
    (if (not (equal (first search-result) 'fail))
	(mapcar #'(lambda (path-element)
		    (case path-element
		      ((generalizations i-genls) 'specializations)
		      (stage-of                  'stages)
		      (t                         path-element)))
		(reverse (third search-result))))))


;-----------------------------------------------------------------------
;			      Connect-To-Core-Rev
;-----------------------------------------------------------------------

;;; arguments: Origin
;;;
;;; called from Process-Significance
;;;
;;; If user modeling ON:
;;; --------------------
;;; finds connection from Origin to either (1) a process that 
;;; is marked ``core'' in the knowledge base, or (2) a process 
;;; that is known to the user and is on the search path to a
;;; core process, or (3) the unit ``Process'' is reached, which
;;; is an error
;;;
;;; If user modeling OFF:
;;; ---------------------
;;; climbs up a superevent if it exists
;;;
;;; returns an error if Origin is elementary (so no need to
;;;                                           make a viewpoint)
;;;
;;; exactly like Connect-to-Core (except for elementary check), but
;;; path is presented in order from Origin to terminal process
;;;
;;; errors:
;;;             - condition: given parameter is not a process
;;;             - returns: (error origin-not-a-process)
;;;
;;;             - condition: given parameter is elementary
;;;             - returns: (error origin-is-elementary)
;;;
;;;		- condition: cannot find a genl
;;;		- returns: (error no-known-or-core-genl-available)
;;;
;;;             - condition: no superevent available
;;;             - returns: (error no-superevent-available)
;;;
;;; all of this is found in a viewpoint with the following template:
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           specification-type: Core-Connection-Rev
;;;                           viewpoint-of: <Given-Process>
;;;                           connection-to-core: (Given-Process> <link-1>
;;;                                               <Linking-Process-1> <link-2>
;;;                                               <Linking-Process-2> <link-3>
;;;                                               ... <link-3> <Core-Process>)

(defun connect-to-core-rev (origin)
  (let ((connect-to-core-result 
	 (if (not (process-p origin))
	     '(error origin-not-a-process)

	     ;; check for elementary
	     (if (is-elementary-p origin)
		 '(error origin-is-elementary)

		 (if (not (user-modeling-on?))

		     ;; general case of user modeling off
                     ;; ---------------------------------
		     (let ((super-event
				(get-only-val (list origin 'superevents))))
		       (if super-event
			   (list origin 'superevents super-event)
			   '(error no-superevent-available)))
		     
		     ;; general case of user modeling on
		     ;; --------------------------------

		     ;; first climb superevents
		     (let* ((superevent-search-result (climb-superevents-rev
						       origin))
			    (top-superevent (first
					     (last
					      superevent-search-result))))
		       (if (or (is-known-p top-superevent)
			       (is-core-p top-superevent))
			   superevent-search-result

			   ;; then climb genl-events
			   (let ((genl-event-search-result
				  (climb-genl-events-rev top-superevent)))
			     (if genl-event-search-result
				 (append superevent-search-result
					 (rest genl-event-search-result))
				 '(error no-known-or-core-genl-available)))))))))

	(new-view-unit (make-new-view origin)))

    (put-local (list new-view-unit 'specification-type)
	       '(core-connection-rev))
    (cond ((contains-error connect-to-core-result)
	   (signal-kb-access-error new-view-unit
				   (second connect-to-core-result)))
	  (t (put-local (list new-view-unit 'connection-to-core)
			(list connect-to-core-result))))
    new-view-unit))


(defun climb-superevents-rev (origin)
  (third
   (kb-search (list origin)
	      (list 'superevents)
	      :terminate-with-success-criteria
	      #'(lambda (process)
		  (null (get-local
			 (extend-address process
					 'superevents))))
	      :collect-path? t
	      :loop-elimination? t)))


(defun climb-genl-events-rev (process)
  (let ((search-result
	 (kb-search (list process)
		    (list 'generalizations 'stage-of 'i-genls)
		    :terminate-with-success-criteria
		    #'(lambda (current-process)
			(or (is-known-p current-process)
			    (is-core-p current-process)))
		    :collect-path? t
		    :loop-elimination? t)))
    (if (not (equal (first search-result) 'fail))
	(third search-result))))


;-----------------------------------------------------------------------
;			   Find-Destination-Process
;-----------------------------------------------------------------------

;;; arguments: Core-Content-Node
;;;
;;; called from Process-Significance
;;;
;;; looks in content node resulting from Connect-to-core call
;;;
;;; returns first element of the list, which is the destination
;;; of the search that was conducted in Connect-to-core
;;;
;;; errors:
;;;		- condition: no content node exists
;;;		- returns: (error no-content-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;                          with connect-to-core path
;;;             - returns: (error error-in-node-with-connect-to-core)
;;;
;;;             - condition: an error was returned by Connect-to-core
;;;             - returns: (error connect-to-core-failed)

(defun find-destination-process (core-content-node)
  (cond ((null core-content-node)
	 '(error no-content-node))
	((content-node-has-error? core-content-node)
	 '(error error-in-node-with-connect-to-core))
	(t (let* ((connection-view (get-only-val (list core-content-node
						       'kb-subgraph)))
		  (connection-path (get-only-val (list connection-view
						       'connection-to-core))))
	     (if (or (null connection-path)
		     (equal (get-only-val (list core-content-node
						'error-occurred))
			    'true))
		 '(error connect-to-core-failed)
		 (first connection-path))))))


;-----------------------------------------------------------------------
;				 Find-Inverse
;-----------------------------------------------------------------------

;;; arguments: Slot
;;;
;;; looks up inverse
;;;
;;; note: differs from KM's get-inverse in that actual slot
;;;       is returned
;;;
;;; returns inverse of given slot
;;;
;;; errors:
;;;		- condition: no inverse can be found
;;;		- returns: (error no-inverse-available)
;;;

(defun find-inverse (slot)
  (let ((listed-inverse (get-inverse slot)))
    (if (consp listed-inverse)
	(first listed-inverse)
	'(error no-inverse-available))))


;-----------------------------------------------------------------------
;		   Find-Object-Functions-from-Content-Nodes
;-----------------------------------------------------------------------

;;; arguments: Content-Node-List: a list of content nodes
;;;                               of type ``Object-Functions''
;;;
;;; called from Sub-Struct-Function
;;;
;;; for each content node in list, first finds the viewpoint of
;;; of that content node (with the kb-subgraph slot), and then
;;; finds the process that the view is taken of
;;;
;;; returns a list of processes (functions) which are the functions
;;; discussed in these content nodes
;;;
;;; errors: none

(defun find-object-functions-from-content-nodes (obj-funct-content-nodes)
  (remove-duplicates
   (mapcar #'(lambda (content-node)
	       (let ((viewpoint (get-only-val (list content-node
						    'kb-subgraph))))
		 (if viewpoint
		     (get-only-val (list viewpoint 'viewpoint-of)))))
	   obj-funct-content-nodes)
   :test #'equal))


;-----------------------------------------------------------------------
;			  Find-Partonomic-Connection
;-----------------------------------------------------------------------

;;; arguments: Object
;;;
;;; searches up the partonomy from Object to find concept with
;;; which user is familiar
;;;
;;; considers slots other than ``part-of'' that are similar,
;;; e.g., contained-in
;;;
;;; If user modeling is ON:
;;; -----------------------
;;; search continues until encounter either (1) a known concept 
;;; (uses function is-known-p) or (2) an elementary concept 
;;; (is-known-p uses function is-elementary-p), or (3) no
;;; familiar concept is encountered and cannot climb higher
;;; in partonomy (in which case the highest super-part is returned)
;;;
;;; if user-modeling is not on, returns (1) error if Object has
;;; no super-parts, or (2) highest super-part encountered
;;;
;;; performs a breadth-first search up the partonomy (needs to
;;; be breadth-first to ensure that most specific concept in
;;; partonomy is found)
;;;
;;;     template:          Specification
;;;                        -------------
;;;                        specification-type: Super-Structural-Connection
;;;                        viewpoint-of: <Given-Object>
;;;                        highest-superpart: <Super-Part>
;;;                        super-parts-chain: (<Given-Object> <part-link-1>
;;;                                            <Intermediate-Object-1>
;;;                                            <part-link-2> 
;;;                                            <Intermediate-Object-2> ...
;;;                                            <part-link-n> <Super-Part>)
;;;
;;; If user modeling is OFF:
;;; ------------------------
;;; gets ALL of an object's superparts (if it exists)
;;; 
;;;
;;;                          Specification-i
;;;                          ---------------
;;;                          specification-type: Super-Structural-Flat
;;;                          viewpoint-of: <Given-Object>
;;;                          [attribute-1: (<Value-1 ... <Value-p>)]
;;;                          [attribute-2: (<Value-1 ... <Value-q>)]
;;;                                .
;;;                                .
;;;                                .
;;;                          [attribute-n: (<Value-1 ... <Value-r>)]
;;;
;;;
;;; errors:
;;;             - condition: parameter has no superparts
;;;             - returns: (error has-no-superparts)

(defun find-partonomic-connection (object)
  (if (not (user-modeling-on?))
      (find-partonomic-connection-flat object)
      (find-partonomic-connection-chain object)))


(defun find-partonomic-connection-flat (object)
  (let ((new-view (retrieve-view (list object
				       'dimension
				       '(spatial-superstructural)))))
    (when (viewpoint? new-view)
      (put-local (list new-view 'specification-type)
		 '(super-structural-flat))
      (remove-all-values (list new-view 'basic-dimensions)))
    new-view))


(defun find-partonomic-connection-chain (object)
  (let ((connection-result
	 (if (or (not (object-p object))
		 (has-no-superparts object))
	     '(error has-no-superparts)
	     (find-partonomic-connection-aux object)))
	(new-view-unit (make-new-view object)))

    (put-local (list new-view-unit 'specification-type)
	       '(super-structural-connection))
    (cond ((contains-error connection-result)
	   (signal-kb-access-error new-view-unit
				   (second connection-result)))
	  (t (put-local (list new-view-unit 'super-parts-chain)
			(list connection-result))
	     (put-local (list new-view-unit 'highest-superpart)
			(list (first (last connection-result))))))

    new-view-unit))


(defun find-partonomic-connection-aux (object)
  (let ((initial-unit-list (list object))
	(part-slots (get-local '(part-slot-list
				 part-slots-used-by-knight))))
    (if (not (user-modeling-on?))

	;; case 1: user modeling is off
	;; ----------------------------
	(let ((super-part-slot-value-pair
	       (get-immediate-super-part-slot-value-pair object)))
	  (if super-part-slot-value-pair
	      (cons object super-part-slot-value-pair)
	      '(error has-no-superparts)))

	;; case 2: user modeling is on
	;; ---------------------------
	(let ((search-result 
	       (kb-search initial-unit-list
			  part-slots
			  :terminate-with-success-criteria
			  #'(lambda (object)
			      (or (is-known-p object)
				  (has-no-superparts object)))
			  :control-strategy 'breadth-first
			  :collect-path? t
			  :loop-elimination? t)))
	  (if (equal (first search-result) 'fail)

	      ;; error
	      '(error has-no-superparts)

	      ;; terminated with success, so return path
	      (third search-result))))))


;;; if object has a superpart, return a pair:
;;;              (superpart-slot superpart)
;;; otherwise nil
;;;
;;; if there multiple ones, arbitrarily chooses a single slot and value 
(defun get-immediate-super-part-slot-value-pair (object)
  (let ((part-slots (get-local '(part-slot-list
				 part-slots-used-by-knight)))
	(slot-value-pair nil))
    ;; note: part slots are reversed to correspond to default search order
    (dolist (part-slot (reverse part-slots))
      (let ((superpart (get-only-val (list object part-slot))))
	(when superpart
	  (setf slot-value-pair (list part-slot superpart)))))
    slot-value-pair))


;;; returns t iff object has no super-parts
(defun has-no-superparts (object)
  (null (get-immediate-super-parts object)))


;;; finds immediate super-parts of an object
(defun get-immediate-super-parts (object)
  (let ((part-slots (get-local '(part-slot-list
				 part-slots-used-by-knight))))
    (reduce #'append   
	    (mapcar #'(lambda (slot)
			(get-local (extend-address object slot)))
		    part-slots))))


;-----------------------------------------------------------------------
;				 Find-Ref-Conc
;-----------------------------------------------------------------------

;;; arguments: Origin
;;;
;;; searches up the taxonomy from Origin to find concept with
;;; which user is familiar
;;; 
;;; considers slots ``generalizations'', ``stage-of'', and ``i-genls''
;;;
;;; search continues until encounter either (1) a known concept 
;;; (uses function Is-known-p) or (2) an elementary concept 
;;; is-known-p uses function is-elementary-p), or (3) no
;;; familiar concept is encountered (this is an error)
;;;
;;; performs a breadth-first search up the taxonomy (needs to
;;; be breadth-first to ensure that most specific concept in
;;; partonomy is found) via the KM function ``ancestry*''
;;;
;;; slight complication: because of the structure of the taxonomy
;;;                      it may be the case that the breadth-first
;;;                      search will return an elementary concept
;;;                      that is encountered sooner but is in fact
;;;                      very general, e.g., ``object'' or ``process''
;;;
;;; solution: if finds an elementary concept first, and this concept is
;;;           either ``process'' or ``object,'' attempts to find a
;;;           more specific elementary concept; if fails to find a more
;;;           specific elementary concept, then returns either ``process''
;;;           or ``object''
;;;
;;; if user-modeling is not on, returns (1) error if Origin has
;;; no genl's, or (2) first genl encountered
;;;
;;; returns that concept at which the search halted
;;; 
;;; Note: only will undertake search if origin is a top-level unit
;;; 
;;; errors:
;;;             - condition: origin is not a top-level unit
;;;             - returns: (error origin-not-top-level-unit)
;;;
;;;		- condition: user modeling is off and origin has
;;;                          no genls
;;;		- returns: (error no-user-modeling-and-no-genl)
;;;
;;;		- condition: no familiar concept is encountered and
;;;                          cannot climb higher in taxonomy
;;;		- returns: (error no-familiar-generalizations)

(defun find-ref-conc (origin)
  (if (or (not (atom origin))
	  (not (member 'entity (ancestry* origin) :test #'equal)))
      '(error origin-not-top-level-unit)
      (let ((initial-unit-list (list origin))
	    (genl-slots (list 'generalizations 'stage-of 'i-genls)))
	(if (user-modeling-on?)

	    ;; find reference concept with user modeling on
	    (let ((search-result 
		   (kb-search initial-unit-list
			      genl-slots
			      :terminate-with-success-criteria #'is-known-p
			      :control-strategy 'breadth-first
			      :loop-elimination? t)))
	      (if (equal (first search-result) 'fail)

		  ;; no familiar concept found
		  '(error no-familiar-generalizations)

		  ;; terminated with success, so determine if result
		  ;; was elementary or not; if so, and if the elementary
		  ;; concept was either ``object'' or ``process'' then
		  ;; attempts to find a more specific elementary concept
		  (let ((termination-concept (second search-result)))
		    (if (and (is-elementary-p termination-concept)
			     (or (equal termination-concept 'object)
				 (equal termination-concept 'process)))
			(find-more-specific-elementary-concept
			 origin
			 termination-concept)
			termination-concept))))

	    ;; user-modeling is off, so check to see if object has
	    ;; generalizations, if yes, return one; if not, return error
	    (let ((immediate-generalizations
		   (reduce #'append   
			   (mapcar #'(lambda (slot)
				       (get-local (extend-address origin slot)))
				   genl-slots))))
	      (if (null immediate-generalizations)
		  '(error no-user-modeling-and-no-genl)

		  ;;otherwise arbitrarily choose one
		  (first immediate-generalizations)))))))


;;; given:
;;;   - origin: concept at which the first search begun
;;;   - termination-concept: concept at which the first search ended
;;;
;;; assumptions: 
;;;   - termination-concept is elementary
;;;
;;; returns: if can find an elementary concept that is in the ancestry of
;;;          origin and is not ``object'' or ``process'' then returns
;;;          that concept; otherwise returns termination concept

(defun find-more-specific-elementary-concept (origin termination-concept)
  (let ((search-result 
	 (kb-search (list origin)
		    (list 'generalizations 'stage-of 'i-genls)
		    :terminate-with-success-criteria
		    #'(lambda (concept)
			(and (is-elementary-p concept)
			     (not (equal concept 'process))
			     (not (equal concept 'object))))
		    :control-strategy 'breadth-first
		    :loop-elimination? t)))
    (if (equal (first search-result) 'fail)
	termination-concept
	(second search-result))))


;-----------------------------------------------------------------------
;			      Find-Subevent-Order
;-----------------------------------------------------------------------

;;; arguments: Event
;;;
;;; simply returns list of subevents
;;;
;;; *** later: should examine the list in slot: ordered-subevents
;;;
;;; errors:
;;;		- condition: event is not a process
;;;             - returns: (error non-process-argument)

(defun find-subevent-order (event)
  (if (process-p event)
      (get-local (list event 'subevents))
      '(error non-process-argument)))

;-----------------------------------------------------------------------
;				Find-Subevents
;-----------------------------------------------------------------------

;;; arguments: - Event-List: a list of events
;;;
;;; simply returns list of all subevents of events in Event-List
;;; (with dupes removed)
;;;

(defun find-subevents (event-list)
  (if (listp event-list)
      (remove-duplicates
       (reduce #'append
	       (mapcar #'(lambda (event)
			   (if (process-p event)
			       (get-local (list event 'subevents))))
		       event-list))
       :test #'equal)))


;-----------------------------------------------------------------------
;			    Find-Undiscussed-Actors
;-----------------------------------------------------------------------

;;; arguments: Actor-List
;;;
;;; for each actor in Actor-list, places actor in result
;;; list if actor hasn't been discussed
;;;
;;; uses ``is-known-p'' function
;;;
;;; returns subset of Actor-list where the actors haven't yet been discussed
;;;
;;; if user modeling not on, returns entire actor-list
;;;
;;; errors:
;;;		- condition: list of actors is empty
;;;             - returns: (error no-actors)

(defun find-undiscussed-actors (actor-list)
  (cond	((null actor-list)
	 '(error no-actors))
	((not (user-modeling-on?))
	 actor-list)
	(t (remove-if #'(lambda (x) (is-known-p x))
		      actor-list))))


;-----------------------------------------------------------------------
;			     Get-Function-Process
;-----------------------------------------------------------------------

;;; arguments: Object-significance-content-node
;;;
;;; retrieves process which was used in functional description
;;; in this content node
;;; 
;;; currently finds first process on the agent-in slot
;;; of the viewpoint
;;;
;;; later may want to modify to return multiple processes 
;;; (for objects with multiple functions)
;;;
;;; returns the process
;;;
;;; errors:
;;;		- condition: node is empty
;;;		- returns: (error no-significance-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;             - returns: (error error-in-object-significance-node)
;;;
;;;             - condition: no viewpoint exists in content node
;;;             - returns: (error no-viewpoint-in-significance-node)

(defun get-function-process (content-node)
  (cond ((null content-node)
	 '(error no-significance-node))
	((content-node-has-error? content-node)
	 '(error error-in-object-significance-node))
	(t (let ((viewpoint
		  (get-only-val (list content-node 'kb-subgraph))))
	     (if (null viewpoint)
		 '(error no-viewpoint-in-significance-node)
		 (get-function-process-aux viewpoint))))))


(defun get-function-process-aux (viewpoint)
  (let* ((actual-slots (all-explicit-slots viewpoint))
	 (chosen-slot (choose-function-process-slot actual-slots)))
    (get-only-val (extend-address viewpoint chosen-slot))))


;;; the function to change to more intelligently choose 
;;; a function slot; currently just picks the first
(defun choose-function-process-slot (slot-list)
  (first slot-list))

	
;-----------------------------------------------------------------------
;			   Get-Functional-Processes
;-----------------------------------------------------------------------

;;; arguments: Content Node with Struct-Funct-Viewpoint
;;;
;;; traverses structural-functional viewpoint to obtain list
;;; of processes that are mentioned in the viewpoint
;;;
;;; returns list of processes
;;;
;;; errors:
;;;		- condition: node is empty
;;;		- returns: (error no-black-box-functional-iteration-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;             - returns: (error error-in-black-box-functional-iteration-node)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-struct-funct-viewpoint)
;;;
;;;		- condition: struct-funct viewpoint has no top-level view
;;;		- returns: (error struct-funct-viewpoint-malformed)

(defun get-functional-processes (content-node)
  (cond ((null content-node)
	 '(error no-black-box-functional-iteration-node))
	((content-node-has-error? content-node)
	 '(error error-in-black-box-functional-iteration-node))
	(t (let ((struct-funct-viewpoint 
		  (get-only-val (list content-node 'kb-subgraph))))
	     (if (null struct-funct-viewpoint)
		 '(error no-struct-funct-viewpoint)
		 (let ((viewpoint-of-top-event
			(get-viewpoint-of-top-event struct-funct-viewpoint)))
		   (if (null viewpoint-of-top-event)
		       '(error struct-funct-viewpoint-malformed)
		       (get-local (list viewpoint-of-top-event
					      'subevents)))))))))


(defun get-viewpoint-of-top-event (struct-funct-viewpoint)
  (let ((top-event
	 (get-only-val (list struct-funct-viewpoint 'correspondence-with))))
    (get-only-val (list struct-funct-viewpoint
			'correspondence-with
			top-event
			'viewpoint-of))))


;-----------------------------------------------------------------------
;			       Get-Location-Slot
;-----------------------------------------------------------------------

;;; arguments: Locational-Viewpoint
;;;
;;; searches through the viewpoint to find the location slot
;;;
;;; assumes:
;;;          - there is only one location slot (if there is more
;;;            than one, it is ignored)
;;;          - the location slot has only one value
;;;       
;;; returns the location slot
;;;
;;; errors:
;;;             - condition: viewpoint is nil
;;;               returns:   nil
;;;
;;;             - condition: finds no location slot
;;;               returns:   nil

(defun get-location-slot (locational-viewpoint)
  (let* ((slots-with-values (all-explicit-slots locational-viewpoint))
	 (all-location-slots (remove-if-not #'is-location-slot-p
					    slots-with-values)))
    (if all-location-slots
	(first all-location-slots))))


(defun is-location-slot-p (slot)
  (member 'location (ancestry* slot)))


;-----------------------------------------------------------------------
;			       Get-Output-From-Slot
;-----------------------------------------------------------------------

;;; arguments: an Output-Actor-From-Viewpoint
;;;
;;; searches through the viewpoint to find the output-actor-from slots
;;;
;;; arbitrarily chooses one slot and returns it
;;;
;;; errors:
;;;             - condition: viewpoint is nil
;;;               returns:   nil
;;;
;;;             - condition: finds no output-actor-from-slots
;;;               returns:   nil

(defun get-output-from-slot (output-actor-from-viewpoint)
  (let* ((slots-with-values (all-explicit-slots output-actor-from-viewpoint))
	 (all-output-from-slots (remove-if-not #'is-output-from-slot-p
					       slots-with-values)))
    (if all-output-from-slots
	(first all-output-from-slots))))


(defun is-output-from-slot-p (slot)
  (let ((slot-ancestors (ancestry* slot)))
    (or (member 'output-from slot-ancestors)
	(member 'developee-in slot-ancestors))))

	   
;-----------------------------------------------------------------------
;			  Get-Part-Slots-With-Values
;-----------------------------------------------------------------------

;;; arguments: Object
;;;
;;; Art also asked for the following algorithm (6-28-94)
;;;
;;; procedure: get all slots
;;;            if any slots then
;;;                 if have non-composed-of slots AND composed-of slot
;;;                 keep only non-composed-of slots
;;;             elseif have only non-composed-of slots
;;;                 keep them
;;;             elseif have composed-of slots
;;;                 keep them
;;;             else NONE
;;;
;;; returns list of part-slots that have at least one value on Object

(defun get-part-slots-with-values (object)
  (if (object-p object)
      (let* ((all-slots (all-explicit-slots object))
	     (part-slots (get-local
			  (list 'part-slot-list
				'all-part-slots-substructures-used-by-knight)))
	     (part-slots-on-object
	      (remove-if-not
	       #'(lambda (slot)
		   (member slot part-slots :test #'equal))
	       all-slots)))
	(if (member 'composed-of part-slots-on-object)
	    (if (> (length part-slots-on-object) 1)
		(remove 'composed-of part-slots-on-object
			:test #'equal)
		part-slots-on-object)
	    part-slots-on-object))))
	

;-----------------------------------------------------------------------
;			      Get-Slot-For-Focus
;-----------------------------------------------------------------------

;;; arguments: Black-Box-Viewpoint
;;;            Object
;;;
;;; assumes either (a) Object is a value of some slot on Black-Box-Viewpoint
;;;         or     (b) Object is a value on annotation of one the slots
;;;
;;;         note: case (b) needed to find
;;;                            Leaf-Initiation
;;;                            ---------------
;;;                            generated: Leaf-Primordium
;;;                                          origin: Shoot-Apical-Meristem
;;;
;;; returns: slot on Black-Box-Viewpoint that has Object as one
;;;          of its values
;;;
;;;        note: in our example above, the function will return ``origin''
;;;
;;; note: extra code for looking at annotations had to be written quickly,
;;;       so it's very inelegant (sorry!)
;;;
(defun get-slot-for-focus (black-box-viewpoint object)
  (let* ((filled-slots (get-explicit-slots black-box-viewpoint))
	 (object-found 
	  (get-slot-for-focus-aux black-box-viewpoint
				  filled-slots
				  object)))
    (if object-found
	object-found
	(get-slot-for-focus-aux-2 black-box-viewpoint
				   filled-slots
				   object))))


(defun get-slot-for-focus-aux (black-box-viewpoint black-box-slots object)
  (if black-box-slots
      (let ((curr-slot (first black-box-slots)))
	(if (member object (get-local (list black-box-viewpoint curr-slot)))
	    curr-slot
	    (get-slot-for-focus-aux black-box-viewpoint
				    (rest black-box-slots)
				    object)))))


;;; searches top-most annotations for the object
(defun get-slot-for-focus-aux-2 (black-box-viewpoint black-box-slots object)
  (if black-box-slots
      (let* ((candidate-slot (first black-box-slots))
	     (slot (get-slot-for-focus-from-annotations black-box-viewpoint
							candidate-slot
							object)))
	(if slot
	    slot
	    (get-slot-for-focus-aux-2 black-box-viewpoint
				      (rest black-box-slots)
				      object)))))


;;; searches top-most annotations on values of
;;;         (viewpoint candidate-slot)
;;; for the object
(defun get-slot-for-focus-from-annotations (black-box-viewpoint
					    candidate-slot
					    object)
  (let ((candidate-values (get-local (list black-box-viewpoint
					   candidate-slot))))
    (get-slot-for-focus-for-annotations-aux black-box-viewpoint
					    candidate-slot
					    candidate-values
					    object)))


;;; searches each value on 
;;;   (viewpoint cand-slot)
;;; for an annotation whose value is object
(defun get-slot-for-focus-for-annotations-aux (black-box-viewpoint
					       candidate-slot
					       candidate-values
					       object)
  (if candidate-values
      (let* ((annotation-slots
	      (get-explicit-slots (list black-box-viewpoint
					candidate-slot
					(first candidate-values))))
	     (slot
	      (get-slot-for-focus-for-annotations-aux-2 black-box-viewpoint
							candidate-slot
							(first
							 candidate-values)
							annotation-slots
							object)))
	(if slot
	    slot
	    (get-slot-for-focus-for-annotations-aux black-box-viewpoint
						    candidate-slot
						    (rest candidate-values)
						    object)))))


;;; searches each annotation on 
;;;   (viewpoint cand-slot cand-value)
;;; for a value that is object
(defun get-slot-for-focus-for-annotations-aux-2 (black-box-viewpoint
						 candidate-slot
						 candidate-value
						 annotation-slots
						 object)
  (if annotation-slots
      (if (member object (get-local (list black-box-viewpoint
					  candidate-slot
					  candidate-value
					  (first annotation-slots))))
	  (first annotation-slots)
	  (get-slot-for-focus-for-annotations-aux-2 black-box-viewpoint
						     candidate-slot
						     candidate-value
						     (rest
						      annotation-slots)
						     object))))


;-----------------------------------------------------------------------
;			    Has-Common-Super-Event?
;-----------------------------------------------------------------------
;;; arguments: Proc1 Proc2
;;;
;;; returns t iff Proc1 and Proc2 have the same superevent
;;; otherwise nil
;;;
;;; used in output actor fates to ensure that a particular fate (function)
;;; of an actor is worth reporting
;;;    art's heuristic: if a candidate fate and the primary concept process
;;;                     are subevents of the same process, then it is
;;;                     worthwhile to report the fate; otherwise, it
;;;                     should be cut

(defun has-common-super-event? (proc-1 proc-2)
  (if (and (process-p proc-1)
	   (process-p proc-2))
      (let ((super-for-proc-1 (get-only-val (extend-address proc-1
							    'superevents)))
	    (super-for-proc-2 (get-only-val (extend-address proc-2
							    'superevents))))
	(and super-for-proc-1
	     super-for-proc-2
	     (equal super-for-proc-1 super-for-proc-2)))))


;-----------------------------------------------------------------------
;			    Is-Conversion-Process?
;-----------------------------------------------------------------------
;;; arguments: - Concept
;;;
;;; returns t iff concept is a conversion process
;;; otherwise nil

(defun is-conversion-process? (concept)
  (if (and concept
	   (member 'conversion (ancestry* concept)))
      t))


;-----------------------------------------------------------------------
;			Make-As-Kind-Of-Perceptual-View
;-----------------------------------------------------------------------

;;; arguments: a concept and a reference concept
;;;
;;; creates an as-kind-of viewpoint
;;;
;;; returns a viewpoint of the form
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           generalizations: <COI>
;;;                           instance-of: Viewpoint
;;;                           as-kind-of: <Ref-Conc>
;;;                           specification-type: as-kind-of
;;;                           viewpoint-of: <COI>
;;;                          [attribute list]              
;;; errors: as-kind-of errors

(defun make-as-kind-of-perceptual-view (concept ref-conc)
  (let ((new-ako-vp (retrieve-view (list concept 'as-kind-of
				     (list ref-conc
					   'dimension
					   (list 'perceptual))))))
    (when (viewpoint? new-ako-vp)
      (put-local (list new-ako-vp 'as-kind-of) (list ref-conc))
      (put-local (list new-ako-vp 'specification-type) '(as-kind-of))
      (remove-all-values (list new-ako-vp 'basic-dimensions))
      (if (has-perceptual-slots? new-ako-vp)
	  new-ako-vp
	  '(error no-perceptual-slots)))))


;;; returns non-null iff viewpoint has perceptual slots
(defun has-perceptual-slots? (viewpoint)
  (let* ((interesting-slots (get-domain-slots viewpoint))
	 (perceptual-slots (set-difference
			    interesting-slots
			    '(SPECIFICATION-TYPE
			      AS-KIND-OF
			      GENERALIZATIONS
			      VIEWPOINT-OF
			      INSTANCE-OF))))
    perceptual-slots))


;-----------------------------------------------------------------------
;			  Make-Auxiliary-Process-View
;-----------------------------------------------------------------------

;;; arguments: Process, View-Type
;;;
;;; used for the following view types:
;;;                                     - Connections-Temporal
;;;                                     - Modulatory-Facilitators
;;;                                     - Modulatory-Inhibitors
;;;                                     - Causal-Agent
;;;                                     - Temporal-Attributes
;;;                                     - Locational
;;;                                       
;;; returns a viewpoint unit of the form
;;;
;;;                          Specification-i
;;;                          ---------------
;;;                          specification-type: auxiliary-process-description
;;;                          viewpoint-of: <Process-1>
;;;                          [attribute-1: (<Value-1 ... <Value-p>)]
;;;                          [attribute-2: (<Value-1 ... <Value-q>)]
;;;                                .
;;;                                .
;;;                                .
;;;                          [attribute-n: (<Value-1 ... <Value-r>)]
;;;
;;; errors: none

(defun make-auxiliary-process-view (process view-type)
  (let ((new-view (retrieve-view (list process
				       'dimension
				       (list view-type)))))
    (when (viewpoint? new-view)
      (put-local (list new-view 'specification-type)
		 '(auxiliary-process-description))
      (remove-all-values (list new-view 'basic-dimensions)))
    new-view))


;-----------------------------------------------------------------------
;			      Make-Bare-AKO-View
;-----------------------------------------------------------------------

;;; arguments: a concept and a reference concept
;;;
;;; creates an as-kind-of viewpoint and strips out all of the slots on it
;;; except for: as-kind-of, generalizations, viewpoint-of, instance-of
;;;
;;; returns a stripped out viewpoint of the form
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           generalizations: <COI>
;;;                           instance-of: Viewpoint
;;;                           as-kind-of: <Ref-Conc>
;;;                           as-kind-of-relation: <stage-of OR generalization>
;;;                           specification-type: as-kind-of
;;;                           viewpoint-of: <COI>
;;; errors: none

(defun make-bare-ako-view (concept ref-conc)
  (let ((new-ako-vp (make-new-view concept)))
    (put-local (list new-ako-vp 'as-kind-of) (list ref-conc))
    (put-local (list new-ako-vp 'specification-type) '(as-kind-of))
    (put-local (list new-ako-vp 'as-kind-of-relation)
	       (list (find-as-kind-of-relation concept ref-conc)))
    new-ako-vp))


;;; fills in the as-kind-of-relation for as-kind-of-view
;;;
;;; if there is a stage-of link in the chain, returns ``stage-of''
;;; otherwise, returns ``generalizations''
;;;
;;; assumes a path exists between them

(defun find-as-kind-of-relation (concept ref-conc)
    (let* ((search-result 
	   (kb-search (list concept)
		      (list 'generalizations 'stage-of 'i-genls)
		      :terminate-with-success-criteria
		      #'(lambda (concept)
			  (equal concept ref-conc))
		      :control-strategy 'breadth-first
		      :collect-path? t
		      :loop-elimination? t))
	   (path (third search-result)))
      ;(format t "~%Path: ~a~%"
      ;        path)
      (if (member 'stage-of path)
	  'stage-of
	  'generalizations)))


;-----------------------------------------------------------------------
;			      Make-Black-Box-View
;-----------------------------------------------------------------------

;;; arguments: a concept and a reference concept
;;;
;;; creates a black-box view
;;;
;;; the reference concept will be used by the PDT mechanism
;;;
;;; hard-during? is an optional argument
;;; if its has a value (typically t) then the realizer will include the
;;; during clause, even if it violates redundancy checks
;;;
;;; if an error is found by the view retriever, it is reported
;;; 
;;; errors:
;;;             - condition process is nil
;;;             - returns (error null-process)
;;;
;;;             - condition: process is elementary
;;;             - returns: (error elementary-process)

(defun make-black-box-view (process reference-process &key hard-during?)
  (if (null process)
      '(error null-process)
      (if (is-elementary-p process)
	  '(error elementary-process)
	  (let ((new-vp (retrieve-view (list process
					     'dimension
					     (list 'black-box)))))
	    (when (viewpoint? new-vp)
	      (put-local (list new-vp 'specification-type)
			 '(black-box-process-description))
	      (put-local (list new-vp 'reference-concept)
			 (list reference-process))
	      (put-local (list new-vp 'include-during-clause?)
			 '(true))
	      (when hard-during? 
		(put-local (list new-vp 'include-during-clause-hard?)
			   '(true)))
	      (remove-all-values (list new-vp 'basic-dimensions)))
	    new-vp))))


;-----------------------------------------------------------------------
;			     Make-Functional-View
;-----------------------------------------------------------------------

;;; arguments: Black-Box-View: the black-box view that has been taken
;;;                            of the process
;;;            Actor-Slot:  the actor slot on the given process (which
;;;                         is the function of the object) that has
;;;                         the object as its value
;;;
;;; method: uses Black-Box view as basis for functional view, and so
;;;         the correct emphasis will be placed on the Object, exploits
;;;         FUF's focus mechanism
;;;
;;; returns: a viewpoint unit that is identical to Black-Box-View
;;;          except the focused-concept slot has been assigned the value
;;;          Actor-Slot
;;;
;;; errors:
;;;             - condition: no actor slot was given
;;;             - returns: (error no-actor-slot)
;;;
;;;             - condition: no black-box view was given
;;;             - returns: (error no-black-box-view)
;;;
;;;		- condition: black-box view has an error
;;;		- returns: (error erroneous-black-box-view)

(defun make-functional-view (actor-slot black-box-view)
  (cond ((null actor-slot)
	 '(error no-actor-slot))
	((null black-box-view)
	 '(error no-black-box-view))
	((contains-error black-box-view)
	 '(error erroneous-black-box-view))
	(t (put-local (list black-box-view 'focused-concept)
		      (list actor-slot))
	   (put-local (list black-box-view
			    'include-during-clause?)
		      '(true))
	   black-box-view)))

;-----------------------------------------------------------------------
;			      Make-Subevent-List
;-----------------------------------------------------------------------

;;; arguments: Process
;;;
;;; makes ordered subevent list
;;;
;;; errors:
;;;		- condition: Process is not an actual process
;;;		- returns: (error non-process-has-no-subevents)
;;;
;;; returns a viewpoint unit of the form
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           specification-type: Subevent-List
;;;                           viewpoint-of: <Parent-Process>
;;;                           ordered-subevents: (<Process-1> <Process-2>
;;;                                               ... <Process-n>)

(defun make-subevent-list (process)
  (let* ((new-view-unit (make-new-view process))
	 (subevents (get-local (extend-address process 'ordered-subevents))))
    (put-local (list new-view-unit 'specification-type)
	       '(subevent-list))
    (cond ((not (process-p process))
	   (signal-kb-access-error new-view-unit
				   'non-process-has-no-subevents))
	  ((null subevents)
	   (signal-kb-access-error new-view-unit
				   'process-has-no-subevents))
	  (t (put-local (list new-view-unit 'ordered-subevents)
			subevents)))
  new-view-unit))


;-----------------------------------------------------------------------
;			    Make-Sub-Structural-View
;-----------------------------------------------------------------------

;;; arguments: - Object
;;;            - Part-Slot
;;;
;;; returns a viewpoint of the form
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           specification-type: Sub-Structural-Description
;;;                           viewpoint-of: <Object>
;;;                           part-slot-for-view: <Part-Slot>
;;;                           part-values: <Values>
;;;
(defun make-sub-structural-view (object part-slot)
  (let ((new-view-unit (make-new-view object))
	(vals
	 ;(get-local-with-annotation object part-slot)
	 (get-local (extend-address object part-slot)))
	)

    (put-local (list new-view-unit 'specification-type)
	       '(sub-structural-description))
    (put-local (list new-view-unit 'part-slot-for-view)
	       (list part-slot))
    (when vals
      (put-local (list new-view-unit 'part-values) vals)
      (dolist (val vals)
	(copy-values-only (list object part-slot val)
			  (list new-view-unit 'part-values val)))
      )
    ;(put-local-with-annotation new-view-unit 'part-values vals)
    new-view-unit))


;-----------------------------------------------------------------------
;		 Is-Function-Of-Interest-Wrt-Object-Functions?
;-----------------------------------------------------------------------

;;; arguments: Function: the function of a sub-structure being considered
;;;            Object-Functions  : the main object
;;;
;;; returns t iff Function is a subevent of Object-Functions
;;;         otherwise nil
;;; errors: none

(defun is-function-of-interest-wrt-object-functions? (function
						      object-functions)
  (if (and function
	   object-functions
	   (listp object-functions))
      (let ((all-subevents (reduce #'append
				   (mapcar #'(lambda (process)
					       (get-local (list process
								'subevents)))
					   object-functions))))
	(if (member function all-subevents :test #'equal)
	    t))))


;-----------------------------------------------------------------------
;			  Make-Temporal-Step-Of-View
;-----------------------------------------------------------------------

;;; arguments: Process: the process being described
;;;
;;; returns a viewpoint of the following form:
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           specification-type: Core-Connection-Rev
;;;                           viewpoint-of: <Given-Process>
;;;                           connection-to-core: (Given-Process> superevents
;;;                                                <Known-Superevent>)
;;;
;;; assumes: a process has at most one superevent
;;;
;;; errors: 
;;;		- condition: Process is not an actual process
;;;		- returns: (error origin-not-a-process)
;;;
;;;		- condition: Process has no superevents
;;;		- returns: (error process-has-no-subevents)
;;;
;;;             - condition: Superevent is not known
;;;             - returns: (error superevent-not-known)

(defun make-temporal-step-of-view (origin)
  (let ((step-of-result 
	 (if (not (process-p origin))
	     '(error origin-not-a-process)
	     (let ((superevent (get-only-val (list origin 'superevents))))
	       (if (null superevent)
		   '(error process-has-no-superevents)
		   superevent))))
	(new-view-unit (make-new-view origin)))

    (cond ((contains-error step-of-result)
	   (signal-kb-access-error new-view-unit
				   (second step-of-result)))
	  ((and (user-modeling-on?)
		(not (is-known-p step-of-result)))
	   (signal-kb-access-error new-view-unit
				   '(error superevent-not-known)))
	  (t
	   (put-local (list new-view-unit 'specification-type)
		      '(core-connection-rev))
	   (put-local (list new-view-unit 'connection-to-core)
		      (list (list origin
				  'superevents
				  step-of-result)))))
    new-view-unit))
   

----------------------------------

;;; arguments: a concept and a reference concept
;;;
;;; creates an as-kind-of viewpoint and strips out all of the slots on it
;;; except for: as-kind-of, generalizations, viewpoint-of, instance-of
;;;
;;; returns a stripped out viewpoint of the form
;;;
;;;                           Specification-i
;;;                           ---------------
;;;                           generalizations: <COI>
;;;                          error-predicates.lisp                                                                               000775  003117  001440  00000007512 05641657622 016262  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
				       
;;;;			     The Error Predicates
;;;;			     --------------------


;;;; This file contains predicates for determining if an error
;;;; has occurred.
;;;;
;;;; Function Directory:
;;;;
;;;;    (Function)                         (Arguments)    (Comments)
;;;;
;;;;     Error Predicates
;;;;     -----------------
;;;;     contains-error                     expression     for templates
;;;;     content-node-has-error?            content-node
;;;;     viewpoint-contains-error?          viewpoint
;;;;     empty-view-p                       viewpoint
;;;;
;;;;     Error Signaling Functions
;;;;     -------------------------
;;;;     signal-empty-viewpoint-warning     content-node
;;;;     signal-kb-access-error             content-node,


(in-package 'km)


;-----------------------------------------------------------------------
;			       Error Predicates
;-----------------------------------------------------------------------

;;; determines if the keyword ``error'' occurs anyplace
;;; in the nested expression

(defun contains-error (expression)
  (cond ((null expression)
	 nil)
	((and (atom expression)
	      (equal expression 'error))
	 t)
	((atom expression) nil)
	(t (or (contains-error (first expression))
	       (contains-error (cdr expression))))))


;;; determines if an error is shown by a content-node

(defun content-node-has-error? (content-node)
  (equal (get-only-val (list content-node 'error-occurred?))
	 'true))


;;; determines if a viewpoint has an error
;;;
;;; returns t iff viewpoint is not a true viewpoint or
;;;               when viewpoint has an error

(defun viewpoint-contains-error? (viewpoint)
  (or (not (viewpoint? viewpoint))
      (equal (get-only-val (list viewpoint 'error-occurred?))
	     'true)))


;;; determines if a view returned by the view retriever is empty

(defun empty-view-p (view)
  (let* ((slots-with-values (all-explicit-slots view))
	 (uninteresting-slots (get-local '(non-domain-slot-list
					   non-domain-slots)))
	 (view-slots '(viewpoint-of instance-of basic-dimensions
		       kb-subgraph-of generalizations
		       specification-type focused-concept
		       reference-concept object-focus
		       part-slot-for-view
		       first-item-is-core?
		       highest-superpart))
	 (all-uninteresting-slots (append view-slots uninteresting-slots))
	 (interesting-slots (set-difference slots-with-values
					    all-uninteresting-slots)))
    ;(format t "Interesting-slots: ~a~%" interesting-slots)
    (null interesting-slots)))


;-----------------------------------------------------------------------
;			   Error Signaling Functions
;-----------------------------------------------------------------------

;;; signals an empty viewpoint error

(defun signal-empty-viewpoint-warning (content-node)
  (when (trace-kb-access?)
    (format t "KB Access Warning: Empty viewpoint at ~a.~%~%"
	    content-node))
  (put-local (list content-node 'error-occurred?)
	     '(true))
  (put-local (list content-node 'error-type)	     
	     '(empty-viewpoint)))

    
;;; records KB Access error in content-node of Explanation Plan
;;; when trace is turned on, prints error message

(defun signal-kb-access-error (content-node error-type)
  (when (trace-kb-access?)	       
    (format t "An error has occurred at ~a.~%"
	    content-node)
    (format t "Error type: ~a~%~%"
	    error-type))
  (put-local (list content-node 'error-occurred?)
	     '(true))
  (put-local (list content-node 'error-type)	     
	     (list error-type)))


;;; signals that an iteration list is empty

(defun signal-empty-iteration-list-error (topic-node instantiated-template)
  (format t "An error has occurred at ~a.~%"
	  topic-node)
  (format t "Error type: Null iteration list.~%")
  (format t "Instantiated iteration template:")
    (pprint instantiated-template t)
    (format t "~%~%"))

error origin-not-a-process)
	     (let ((superevent (get-only-val (list origin 'superevents))))
	       (if (null superevent)
		   '(error process-has-no-superevents)
		   supereventevaluation.lisp                                                                                     000775  003117  001440  00000043273 05641657622 015163  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
				       
;;;;			   The Evaluation Functions
;;;;			   ------------------------
				       

;;;; This file contains functions for running evaluations.


;-----------------------------------------------------------------------
;			 Evaluation Function Directory
;-----------------------------------------------------------------------
;;;;
;;;;     (choose-random-concepts number-to-choose
;;;;                             concept-type
;;;;		                 &optional (include-embedded-units? nil)
;;;;      		                   (include-elementary? nil))
;;;;
;;;;     (collect-vps-to-test exposition-node)
;;;;
;;;;     (make-nlg-test-specs-report)


(in-package 'km)


;-----------------------------------------------------------------------
;			   Concept Choice Functions
;-----------------------------------------------------------------------
;;;
;;; These functions randomly select a specified number of object
;;; and/or processes from the knowledge base.
;;;
;;; The user may specify whether embedded units and elementary concepts
;;; should be included.


;;; defines which object concepts in the KB whose progeny should
;;; be considered for choice
;;;
;;; Old list: (plant plant-part)
;;;
;;; Art's List:  (not consistent and not correct)
;;;                          hypocotyl
;;;          	             biota
;;;		             plant-association
;;;                          population
;;;                          accessory-cells
;;;                          epidermal-cells
;;;                          virus
;;;                          cell-walls
;;;                          protoplasm
;;;                          cytoplasm
;;;                          meristem
;;;		             organ
;;;       		     organism
;;;		             cell
;;;		             tissue
;;;                          botanical-system
;;;                          seed
;;;		             organelle
;;;                          protoplasm
;;;			     virus))
;;;
;;; Trouble: (BOTANICAL-ORGAN PLANT-CELL-LEVEL-STRUCTURE PLANT-PART
;;; STOMA-CONTAINING-STRUCTURE)
;;;
;;; must avoid these
;;; generalizations of Plant: (MULTI-CELLULAR-ORGANISM PHOTOSYNTHETIC-ORGAN
;;;                            PLANT-ORGAN-LEVEL-STRUCTURE)
;;; these run only into trouble

(defparameter *object-tops* '(
                          subcellular-region
                          plant-tissue
                          haploid-cell
			  diploid-cell
                          botanical-system
                          diploid-phase-plant
                          haploid-phase-plant
                          mature-plant
                          zygote
                          embryo
                          seedling
                          immature-plant
                          seed
			  plant-supercellular-region
                          seed-part
                          plant-tissue-part
			  stomatal-structure
			  stomatal-structures
                          epidermis
			  hypocotyl
			  vascular-system-part
			  shoot-system-part
			  vascular-tissue
			  phloem-network
			  plant-organ-part
			  intercellular-spaces
			  fiber-strand
			  dermal-system-part
			  branches
			  shoots
			  crown
			  thorn
			  prickle
			  nectary
			  perforation-plate
			  thecum
			  flower
			  root
			  leaf
			  stem
			  plant-subcellular-part
			      ))

;;; defines objects which if a candidate genl's up to it, the
;;; candidate should be thrown away -- even if the candidate
;;; goes up to other ``good'' stuff, e.g., moth_pollinated_flower
(defparameter *bad-object-tops* '(flower))


;;; defines which process concepts in the KB whose progeny should
;;; be considered for choice
(defparameter *process-tops* '(acquisition biosynthesis chemical-reaction
			       degeneration destruction development
			       energy-transduction formation generation 
			       growth maturation removal reproduction
			       reproductive-fertilization storage
			       transportation))



;;; defines processes which if a candidate genl's up to it, the
;;; candidate should be thrown away -- even if the candidate
;;; goes up to other ``good'' stuff, e.g., cell-cycle should
;;; be tossed because genl's up to complex-event
(defparameter *bad-process-tops* '(complex-event))


;-----------------------------------------------------------------------
;			   Concept Choice Functions
;-----------------------------------------------------------------------
;;; randomly chooses a collection of concepts from the KB
;;;
;;; given:
;;;       - number-to-choose        : number of concepts to choose
;;;       - concept-type            : one of: object, process
;;;       - include-embedded-units? : flag for whether embedded units
;;;                                   should be included; default is nil
;;;       - include-elementary?     : flag for whether elementary units
;;;                                   should be included; default is nil
(defun choose-random-concepts (number-to-choose
			       concept-type
			       &optional
			       (include-embedded-units? nil)
			       (include-elementary? nil))
  (when (legal-evaluation-arguments number-to-choose concept-type)
    (let ((concept-list nil)
	  (concept-list-length 0))
      (do* ((new-concept (choose-concept concept-type
					 include-embedded-units?
					 include-elementary?)
			 (choose-concept concept-type
					 include-embedded-units?
					 include-elementary?)))
	   ((equal concept-list-length number-to-choose)
	    concept-list)
	(when (and new-concept
		   (not (member new-concept concept-list))
		   ;; this line special for generating more new concepts
		   (not (member new-concept *existing-process-list*)))
	  (push new-concept concept-list)
	  (setf concept-list-length (1+ concept-list-length))
	  (format t "Adding ~a to concept-list.~%" new-concept)))
      concept-list)))


(defun legal-evaluation-arguments (number-to-choose concept-type)
  (cond ((and (member concept-type '(object process))
	      (numberp number-to-choose)
	      (< number-to-choose 500))
	 t)
	(t (format t "Illegal arguments for evaluation.~%")
	   (values))))


;;; a candidate passes the test if
;;;     (1) it genl's up to something in TOPS
;;;     (2) either
;;;                (a) it does not genl up to something in BAD
;;;                (b) or if it does, it is actually in BAD
;;; note: BAD is itself not bad; only it progeny are bad,
;;;       e.g., flower, which is OK, but Moth_Pollinated_Flower isn't ok
(defun choose-concept (concept-type include-embedded-units? include-elementary?)
  (let* ((candidate-concept (random-mem *kb-objects*))
	 (candidate-passes-type-test?
	  (case concept-type
	    ((object) (and
		       (intersection (ancestry* candidate-concept)
				     *object-tops*)
		       (or (null (intersection (ancestry* candidate-concept)
					       *bad-object-tops*))
			   (member candidate-concept
				   *bad-object-tops*))))
	    ((process) (and
			(intersection (ancestry* candidate-concept)
				      *process-tops*)
			(or (null (intersection (ancestry* candidate-concept)
						*bad-process-tops*))
			    (member candidate-concept
				    *bad-process-tops*)))))))
    (cond ;;checks to ensure of correct type
          ((not candidate-passes-type-test?)
	   nil)
	  ;; checks for embedded (path) concepts
	  ((and (not include-embedded-units?)
		(listp candidate-concept))
	   nil)
	  ;; checks for elementary concepts
	  ((and (not include-elementary?)
		(elementary-at-all? candidate-concept))
	   nil)
	  ;; checks for empty concept
	  ((empty-concept candidate-concept)
	   nil)
	  ;; checks for viewpoints
	  ((is-a-viewpoint-p candidate-concept)
	   nil)
	  ;; checks for processes that are too high
	  ((and (equal concept-type 'process)
		(member candidate-concept *process-tops*))
	   nil)
	  (t candidate-concept))))

    
;;; randomly chooses a member of a list
;;;
;;; function definition appears in Norvig's book, p. 322

(defun random-mem (given-list)
  (nth (random (length (the list given-list)))
       given-list))


;;; returns t iff concept is elementary 
;;;           or if the concept has an elementary all-spec
;;;
;;; the second condition includes concepts that are higher
;;; up in the KB but might not have been marked explicitly as elementary
;;;
;;; rationale: if a concept has a spec that is elementary, then it is
;;;            sufficiently high up in the KB to be considered elementary

(defun elementary-at-all? (concept)
  (or (is-elementary-p concept)
      (has-elementary-specs concept)))


;;; returns t iff the concept has an elementary concept in its progeny
;;;
;;; KB problem with leaf (can't take its progeny*) ---> 
;;;                                   that why the leaf hack is there
(defun has-elementary-specs (concept)
  (let* ((progeny (if (equal concept 'leaf)
		      '(leaf)
		      (progeny* concept)))
	 (elementary-specs (find-if #'(lambda (x)
					(and x
					     (is-elementary-p x)))
				       progeny)))
    (if elementary-specs
	t)))


;;; returns non-nil if candidate concept is completely lacking 
;;;         interesting facts
(defun empty-concept (concept)
  (let* ((slots-with-values (all-explicit-slots concept))
	 (uninteresting-slots (get-local '(non-domain-slot-list
					   non-domain-slots)))
	 (other-uninteresting-slots '(generalizations))
	 (all-uninteresting-slots (append uninteresting-slots
					  other-uninteresting-slots))
	 (interesting-slots (set-difference slots-with-values
					    all-uninteresting-slots)))
    ;(format t "Interesting-slots: ~a~%" interesting-slots)
    (null interesting-slots)))


;;; returns non-nil if candidate concept is a viewpoint
;;;
;;; note: since some viewpoints are (for some reason) not
;;; instances of viewpoint, we need to use this grosser
;;; test
(defun is-a-viewpoint-p (concept)
  (get-local (list concept 'viewpoint-of)))


;-----------------------------------------------------------------------
;			      Collect-Vps-To-Test
;-----------------------------------------------------------------------

;;; given: an exposition node
;;;
;;; adds all of the filtered linearized viewpoints to nlg-test-specs


(defun collect-vps-to-test (exposition-node)
  (let ((linearized-leaves (get-local (list exposition-node
					    'linearized-leaves))))
    (dolist (paragraph linearized-leaves)
      (when (listp paragraph)
	(dolist (viewpoint paragraph)
	  (when (viewpoint? viewpoint)
	    (add-val-local '(nlg-test-specs instances)
			   viewpoint)))))))


;-----------------------------------------------------------------------
;			  Make-NLG-Test-Specs-Report
;-----------------------------------------------------------------------

;;; prints report on specifications (viewpoints) in NLG-Test-Specs
(defun make-nlg-test-specs-report ()
  (collect-domain-relations-to-represent)
  (collect-spec-types-and-examples)
  (values))


;;; prints out domain relations to be represented in lexicon
(defun collect-domain-relations-to-represent ()
  (let* ((relations-list (collect-domain-relations-to-represent-aux))
	 (actor-relations (remove-if-not #'actor-slot-p
					 relations-list))
	 (non-actor-relations (set-difference relations-list
					      actor-relations)))
    (format t "~%~%Relation Lists for NLG-Test-Specs~%")
    (format t "---------------------------------~%~%")
    (format t "Relations for PDTs: ")
    (pprint actor-relations t)
    (format t "~%~%Relations for FD-Skeletons and Make-Np: ")
    (pprint non-actor-relations t)
    (values)))


;;; goes through nlg-test-specs to collect list of domain relations
(defun collect-domain-relations-to-represent-aux ()
  (let ((specs-to-test (get-local '(nlg-test-specs instances)))
	(relations-list nil))
    (dolist (spec specs-to-test)
      (setf relations-list (append (collect-all-domain-relations spec)
				   relations-list)))
    (remove-duplicates relations-list)))


;;; goes through a unit (including embedded units) to find all
;;; domain relations
(defun collect-all-domain-relations (unit)
  (let* ((all-slots (all-explicit-slots unit))
	 (vp-slots (get-local '(viewpoint-slots specializations)))
	 (non-domain-slots (get-local '(non-domain-slot-list
					non-domain-slots)))
	 (other-slots-to-avoid '(generalizations instance-of i-genls))
	 (good-slots (set-difference all-slots
				     (append vp-slots
					     non-domain-slots
					     other-slots-to-avoid)))
	 (relations-list (if (viewpoint? unit)
			     (collect-relations-on-vp-slots unit))))
    (dolist (curr-slot good-slots)
      (setf relations-list (cons curr-slot relations-list))
      (dolist (curr-value (get-local (extend-address unit curr-slot)))
	(let ((nested-address
	       (extend-address-indefinitely unit
					    curr-slot
					    curr-value)))
	  (when (get-substructure nested-address)
	    ;; address has annotations, so collected the nested relations
	    (setf relations-list
		  (append (collect-all-domain-relations nested-address)
			  relations-list))))))
    (remove-duplicates relations-list)))


;;; collects relations from viewpoint slots on a viewpoint
;;;
;;; assumes given unit is a viewpoint
(defun collect-relations-on-vp-slots (unit)
  (let ((spec-type (get-only-val (list unit 'specification-type))))
    (case spec-type
      ((core-connection core-connection-rev super-structural-connection)
       (collect-relations-on-chain unit spec-type))
      (t
       (get-local (list unit 'part-slot-for-view))))))


;;; collects relations that occur on a chain
(defun collect-relations-on-chain (viewpoint spec-type)
  (let* ((slot-of-interest
	  (case spec-type
	    ((core-connection core-connection-rev) 'connection-to-core)
	    ((super-structural-connection)         'super-parts-chain)))
	 (chain (get-only-val (list viewpoint slot-of-interest))))
    (remove-duplicates
     (remove 'generalizations
	     (remove-if-not #'slot-p chain)))))


;;; prints out specification types and examples of each that
;;; reside on nlg-test-specs
(defun collect-spec-types-and-examples ()
  (let* ((spec-types (collect-all-spec-types))
	 (spec-type-spec-list-pairs
	  (collect-spec-type-example-list spec-types)))
    (format t "~%~%Specification Types and Examples on NLG-Test-Specs~%")
    (format t "--------------------------------------------------~%~%")
    (dolist (spec-type-spec-list-pair spec-type-spec-list-pairs)
      (let ((spec-type (first spec-type-spec-list-pair))
	    (spec-list (second spec-type-spec-list-pair)))
	(format t "~a: " spec-type)
	(pprint spec-list t)
	(format t "~%~%")))
    (values)))


;;; collects all specification types that are represented by some
;;; specification on nlg-test-specs
(defun collect-all-spec-types ()
  (let ((viewpoints (get-local '(viewpoint instances)))
	(result-list nil))
    (dolist (vp viewpoints)
      (let ((spec-type (get-only-val (list vp 'specification-type))))
	(when (not (member spec-type result-list))
	  (setf result-list (cons spec-type result-list)))))
    result-list))
    

;;; constructs a list of pairs of the following format from the
;;; specifiations found on nlg-test-specs:
;;;
;;;  (<spec-type> <specification-list>)
;;;
;;; where <specification-list> is a list of all specifications
;;; of type <spec-type> that occur on nlg-test-specs
;;;
(defun collect-spec-type-example-list (spec-types)
  (let ((viewpoints (get-local '(viewpoint instances)))
	(result-list nil))
    (dolist (spec-type spec-types)
      (let* ((specialized-specification-list
	      (remove-if-not
	       #'(lambda (spec)
		   (let ((specification-type
			  (get-only-val (list spec 'specification-type))))
		     (equal specification-type spec-type)))
	       viewpoints))
	     (result-pair (list spec-type specialized-specification-list)))
	(setf result-list (cons result-pair result-list))))
    result-list))



;-----------------------------------------------------------------------
;				  Counts VPs
;-----------------------------------------------------------------------

(defun count-good-vps ()
  (let ((count 0))
    (dolist (vp (get-local '(viewpoint instances)))
      (when (not (viewpoint-contains-error? vp))
	(setf count (1+ count))))
    count))

;-----------------------------------------------------------------------
;			       Test for Loop-It
;-----------------------------------------------------------------------

;;; when Charles' loopit function is run, this code should be inside it
;;; reason: filters out lots of erroneous viewpoints which won't
;;;         be passed to the realizer anyway
;;;
;;; returns: if legit viewpoint        -->   viewpoint
;;;          if problematic viewpoint  -->   nil

(defun viewpoint-looks-good-for-loopit
    (viewpoint)
  (let ((content-spec-node (get-only-val (list viewpoint 'kb-subgraph-of))))
    (if (and content-spec-node
	     (null (content-node-has-error? content-spec-node))
	     (null (viewpoint-contains-error? viewpoint)))
	viewpoint)))


;-----------------------------------------------------------------------
;			   Concept n Random Concepts
;-----------------------------------------------------------------------
;;; randomly chooses n concepts from a given list
;;;
;;; given:
;;;       - number-to-choose        : number of concepts to choose
;;;       - given-concept-list      : list of concepts
;;;
(defun choose-n-random-concepts (number-to-choose
                                 given-concept-list)
  (if (> number-to-choose
	 (length given-concept-list))
      (progn (format t "~%The specified number of concepts is ~
                          to large for the given list.~%")
	     (values))
      (let ((result-concept-list nil)
	    (result-concept-list-length 0))
	(do* ((new-concept (random-mem given-concept-list)
			   (random-mem given-concept-list)))
	     ((equal result-concept-list-length number-to-choose)
	      result-concept-list)
	  (when (not (member new-concept result-concept-list))
	    (push new-concept result-concept-list)
	    (setf result-concept-list-length (1+ result-concept-list-length))
	    (format t "Adding ~a to result list.~%" new-concept)))
	result-concept-list)))
concept))))

    
;;; randomly chooses a member of a list
;;;
;;; function definition appears in Norvig's book, p. 322

(defun random-mem (given-list)
  (nth (random (length (the list given-list)))
       given-list))


;;; returns t iff concept is elementary 
;;;           or if the concept has an elementary all-spec
;;;
;explain.lisp                                                                                        000775  006350  001440  00000050000 05755673276 015014  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         knight                                                                                              000644  006350  001440  00000024000 05755673216 013660  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         find-pdt.lisp                                                                                       000775  003117  001440  00000003252 05641657622 014512  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
				       
;;;;				   Finds PDT
;;;;				   ---------
				       

;;;; Given: a viewpoint
;;;;
;;;; Returns: 
;;;;
;;;;    if viewpoint is a blackbox view then 
;;;;                returns the PDT-type (from reference concept)
;;;;    else
;;;;                the viewpoint's specification type
;;;;
;;;; Code required: Need to load the file "bruce-and-my-search"
;;;;                from the directory:
;;;;
;;;;                /v/sally/v6/lester/Planner/EDP/Implementation
;;;;
;;;; The process-description-template information is stored on
;;;; the lex-process-description-template slot of li-primary's.


(in-package 'km)


(defun find-pdt (viewpoint)
  (if viewpoint
      (let ((spec-type (get-only-val (list viewpoint
					   'specification-type))))
	(if (equal spec-type 'black-box-process-description)
	    (let ((ref-conc (get-only-val (list viewpoint
						'reference-concept))))
	      (if ref-conc
		  (find-pdt-aux ref-conc)))
	    spec-type))))

      
(defun find-pdt-aux (reference-concept)
  (let* ((initial-unit-list (list reference-concept))
	 (genl-slots (list 'generalizations 'stage-of 'i-genls))
	 (search-result 
	  (kb-search initial-unit-list
		     genl-slots
		     :terminate-with-success-criteria #'has-pdt?
		     :control-strategy 'breadth-first
		     :loop-elimination? t)))
    (if (equal (first search-result) 'fail)
	'none
	(let ((final-unit (second search-result)))
	  (get-only-val (list final-unit 'lexical-info 'li-primary
			      'lex-process-description-template))))))


(defun has-pdt? (concept)
  (get-local (list concept
		   'lexical-info
		   'li-primary
		   'lex-process-description-template)))

)


(defun find-pdt (viewpoint)
  (if viewpoint
      (let ((spec-type (get-only-val (list viewpoint
					   'specification-type))))
	(if (equal spec-type 'black-box-process-description)
	    (let ((ref-conc (get-only-val (list viewpoint
						'reference-concept))))
	      (if ref-conc
		  (find-pdt-aux ref-conc)))
	    spec-type))))

     focus-function-eval.lisp                                                                            000775  003117  001440  00000001740 05641657623 016675  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		    The Focus Function Evaluation Function
;;;;		    --------------------------------------


(in-package 'km)


(defun evaluate-focus-function (topic-or-elab-node centrality verbosity)
  "Evaluates focus function for topic or elaboration"
  (let* ((focus-condition (get-only-val (list topic-or-elab-node
					      'focus-condition-evaluation)))
	 (condition-value (eval focus-condition))
	 ;; converts evaluation result to ``real boolean'', i.e.,
	 ;; to TRUE or FALSE
	 (real-boolean-condition-value (if (equal condition-value t)
					   'true
					   'false)))
    (put-local (list topic-or-elab-node 'focus-condition-evaluation)
	       (list real-boolean-condition-value))
    (if condition-value
	(case verbosity
	  ((low) (if (equal centrality 'high)
		     'true
		     'false))
	  ((medium) (if (or (equal centrality 'medium)
			    (equal centrality 'high))
			'true
			'false))
	  ((high) 'true))
	'false)))
		  
		  
	       
onc)))
	    spec-type))))

     global-variable-manip.lisp                                                                          000775  003117  001440  00000005503 05641657623 017134  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		  The Global Variable Manipulation Functions
;;;;		  ------------------------------------------


;;;; These are the functions that manipulate global variables:
;;;;
;;;; Representation: 
;;;;                  knight-global-state
;;;;                  -------------------
;;;;                  global-variable-bindings: ((x . v1) (y . v2))
;;;;
;;;; Use: when have value that want to use many times but that doesn't
;;;;      appear as a local-variable in the tree
;;;;
;;;; Example: the subevents of the functions of the object in object-edp
;;;;
;;;;	- need to know them to see if functions of substructures are
;;;;          in this list of subevents
;;;;
;;;;	- the functions are computed in object-functions iteration, but are
;;;;          only used for the iterate-over-list, which doesn't happen
;;;;          to be stored in the explanation plan; so need to compute
;;;;          the subevents and refer to them several times
;;;;
;;;; Restriction: nil cannot be the value of a global variable


;;;;--------------------------------------------------------------------
;;;;			      Function Directory
;;;;--------------------------------------------------------------------
;;;;
;;;;     Initialize
;;;;     ----------
;;;;     (initialize-global-variable-bindings)
;;;;
;;;;     Access
;;;;     ------
;;;;     (retrieve-global-var-value var)
;;;;     
;;;;     Update
;;;;     ------
;;;;     (assert-global-var-value var new-value)
;;;;	
;;;;--------------------------------------------------------------------


(in-package 'km)


;;; initializes list of global-variable-bindings
(defun initialize-global-variable-bindings ()
  (put-local '(knight-global-state global-variable-bindings)
	     nil))


;;; retrieves value of global variable if variable exists
;;; if it doesn't exist, returns nil

(defun retrieve-global-var-value (var)
  (let* ((binding-list (get-local '(knight-global-state
				   global-variable-bindings)))
	 (binding (assoc var binding-list)))
    (if binding
	(cdr binding))))


;;; asserts value of global variable
;;; if variable already exists, replaces old value
;;; if variable doesn't exist yet, creates it and asserts the given value

(defun assert-global-var-value (var new-value)
  (let* ((binding-list (get-local '(knight-global-state
				    global-variable-bindings)))
	 (binding (assoc var binding-list)))
    (if binding

	;replace value of existing variable
	(let ((fixed-binding-list 
	       (remove binding binding-list
		       :test #'equal)))
	  (put-local '(knight-global-state
		       global-variable-bindings)
		     (acons var new-value fixed-binding-list)))

	;create new variable with given value
	(let ((new-binding-list
	       (acons var new-value binding-list)))
	  (put-local '(knight-global-state
		       global-variable-bindings)
		     new-binding-list)))))
                                                                                                                                                                                             initialization.lisp                                                                                 000775  003117  001440  00000014144 05641657623 016037  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;			    Global Knight Variables
;;;;			    -----------------------


;;;; Initializes the global variables of the Knight system
;;;;
;;;; All of their values are stored in the KB on the frame:
;;;;
;;;;         Knight-Global-State


(in-package 'km)


;-----------------------------------------------------------------------
;			    Initialization Function
;-----------------------------------------------------------------------

(defun initialize-knight ()
  (put-local '(knight-global-state
  	       current-explanation-plan-header)
  	     'explanation-plan-header)
  (put-local '(explanation-plan-header
  	       number-of-content-nodes)
  	     0)
  (put-local '(knight-global-state
  	       current-exposition-node)
  	     'current-exposition-node)
  (put-local '(knight-global-state
  	       current-topic-node)
  	     'current-topic-node)
  (put-local '(knight-global-state
  	       current-t-content-node)       ;Current content node that is
  	     'current-t-content-node)        ;child of current topic node 
  (put-local '(knight-global-state
	       current-e-content-node)       ;Current content node that is
  	     'current-e-content-node)        ;child of current elaboration
                                             ;node 
  (put-local '(knight-global-state
  	       current-elaboration-node)
  	     'current-elaboration-node)  
  (put-local '(knight-global-state
  	       instantiation-error?)
  	     'false)

  (put-local '(knight-global-state
	       current-user)
	     nil)

  (put-local '(knight-global-state
  	       filter-path-values?)
  	     'true)

  (put-local '(knight-global-state
  	       filter-path-viewpoints?)
  	     'true)

  (put-local '(knight-global-state
  	       create-vp-shells-batch?)
	     'true)

  (set-verbosity 'high)

  (set-make-report? 'true)

  ;; set tracers appropriately
  (put-local '(knight-global-state
	       trace-edp-selection?)
	     'true)
  (put-local '(knight-global-state           ;Turns off detailed trace of 
	       trace-instantiation-details?) ;computation during instantiation
	     'false)                         
  (put-local '(knight-global-state           ;Turns off trace of computation 
	       trace-instantiation?)         ;during instantiation
	     'false) 
  (put-local '(knight-global-state
	       trace-iteration?)
	     'false)
  (put-local '(knight-global-state
	       trace-kb-access?)
	     'true)
  (put-local '(knight-global-state
	       trace-node-creation?)
	     'true)
  (put-local '(knight-global-state
	       trace-organization?)
	     'false)
  (put-local '(knight-global-state
	       trace-viewpoint-filtering?)
	     'true)

  ;; initializes tracer list
  (put-local '(knight-global-state
	       tracer-list)
	     '(trace-instantiation?
	       trace-instantiation-details?
	       trace-kb-access?
	       trace-node-creation?
	       trace-iteration?
	       trace-organization?
	       trace-edp-selection?
	       trace-viewpoint-filtering?))

  ;; nullifies list of global variable bindings
  (initialize-global-variable-bindings)

  ;; switches user model off
  (switch-off-um)

  ;; initializes non-domain-slot-record on Knight-global-state
  ;;
  ;; non-domain-slot-record points to Non-domain-slot-list
  ;;
  ;; Non-domain-slot-list has a slot non-domain-slots
  ;;
  ;; the value of non-domain-slots is a list of slots that is 
  ;; used by the user model to compute what percentage of slots
  ;; on a given unit that is known to the user
  ;;
  ;; non-domain-slots are those that
  ;;     (1) are bookkeeping slots
  ;;     (2) are domain-discourse slots
  ;;     (3) are constraint-slots, e.g., range-of
  ;;     (4) are notation-slots, e.g., english
  ;;     (5) are lexical-slots, e.g., lexical-info
  (put-local '(knight-global-state
	       non-domain-slot-record)
	     'non-domain-slot-list)
  (let ((bookkeeping-slots (remove-if #'listp
				      (progeny* 'bookkeeping-slots)))
	(domain-discourse-slots (remove-if #'listp
					   (progeny* 'domain-discourse-slots)))
	(constraint-slots (remove-if #'listp
				     (progeny* 'constraint-slots)))
	(notation-slots (remove-if #'listp
				   (progeny* 'notation-slots)))
	(lexical-slots (remove-if #'listp
				   (progeny* 'lexical-slot)))
	(other-slots '(i-specs checked)))
    (put-local '(non-domain-slot-list
		 non-domain-slots)
	       (append bookkeeping-slots
		       domain-discourse-slots
		       constraint-slots
		       notation-slots
		       lexical-slots
		       other-slots)))

  ;; initalizes part-slots-record on Knight-global-state
  ;;
  ;; part-slots-record points to part-slot-list
  ;;
  ;; part-slot-list has a slot part-slots-used-by-knight
  ;;
  ;; the value of part-slots-used-by-knight is used by the
  ;; find-partonomic-connection function in the library of
  ;; auxiliary content determination functions
  ;;
  ;; the slots in this list are considered when the system
  ;; ascends the partonomy searching for a familiar object
  ;;
  ;; the slots in this list are ordered by specificity so
  ;; most specific slots are listed (and hence tried) before
  ;; more general ones  
  ;;
  ;; when editing this list, the best place to look is in
  ;; the slot hierarchy in the unit ``partition-of''

  (put-local '(knight-global-state part-slots-record)
	     'part-slot-list)

  (let* ((knight-part-of-slots
	  (list 'basic-unit-of 'subregion-of 'layer-of
		'part-of 'composes 'protective-component-for
		'contained-in))

	 (knight-part-slots
	  (list 'basic-unit 'subregions 'layers 'parts 'composed-of
		'protective-components 'contains))

	 (all-part-of-slots
	  (compute-all-progeny knight-part-of-slots))

	 (all-part-slots
	  (compute-all-progeny knight-part-slots)))

    (put-local '(part-slot-list part-slots-substructures-used-by-knight)
	       knight-part-slots)
    (put-local '(part-slot-list all-part-slots-substructures-used-by-knight)
	       all-part-slots)
    (put-local '(part-slot-list part-slots-used-by-knight)
	       knight-part-of-slots)
    (put-local '(part-slot-list all-part-slots-used-by-knight)
	       all-part-of-slots)

    ;; hacks for suppressing the over-zealous warning messages

  (values)))  ;; so no value is returned

      trace-viewpoint-filtering?)
	     'true)

  ;; initializes tracer list
  (put-local '(knight-global-state
	       tracer-list)
	     '(trace-instantiation?
	       trace-instantiation-details?
	       trace-kb-access?
	       trace-node-creation?
	       trace-iteration?
	       trace-organization?
	       trace-edp-selection?
	       trace-viewpoint-filtering?))

  ;; nullifies list of global variable instantiate-templates.lisp                                                                          000775  006350  001440  00000052355 05723177221 017672  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		     The Template Instantiation Functions
;;;;		     ------------------------------------


;;;; This file contains the template instantiation functions.
;;;; It has 7 sections of functions:
;;;;
;;;;                 - Content Specification Instantiation Function
;;;;                 - Iterate-Over Instantiation Function
;;;;                 - Iteration Condition Instantiation Function
;;;;                 - Focus Condition Instantiation Function
;;;;                 - Generic Template Instantiation Function
;;;;                 - Trace Switches and Accessors
;;;;		     - Instantiation Error Functions


(in-package 'km)


;-----------------------------------------------------------------------
;		      The Content Specification Function
;-----------------------------------------------------------------------


;;; on every EDP node with a template slot will be a slot 
;;;   ``local-variables'' which will be a list of variables that are 
;;;   mentioned in the template slot, along with their associated means 
;;;   of computation via a to-compute
;;;
;;;		- in a template, variables to be instantiated will
;;;               have as the first character of their names a ``?''
;;;
;;;		- for example, a content specification will look like:
;;;
;;;                  content-specifications: (C1 ... Ci ... Cn)
;;;
;;;                         Ci:
;;;                           local-variables: (?v1 ... ?vj ... ?vm)
;;;
;;;                                 ?vj:
;;;                                    to-compute: <function-call>
;;;
;;;                           content-specification-template: (
;;;                                                 <template-expression>)
;;;
;;;		- special variables, i.e., variables which are not
;;;               local, are 
;;;
;;;			- ?primary-concept         : the primary concept
;;;                                                  of in an EDP call
;;;
;;;			- ?current-exposition-node : the exposition node in  
;;;                                                  the explanation plan
;;;                                                  that this EDP is
;;;                                                  being used to construct
;;;
;;;			- ?current-topic-node      : the topic node in the 
;;;                                                  explanation plan
;;;                                                  that this topic in this
;;;                                                  EDP is being used to 
;;;                                                  construct
;;;
;;;			- ?current-T-content-node  : the content node in the 
;;;                                                  explanation plan
;;;                                                  that the current topic
;;;                                                  has generated
;;;
;;;			- ?current-E-content-node  : the content node in the 
;;;                                                  explanation plan
;;;                                                  that the current 
;;;                                                  elaboration has generated
;;;
;;;                     - ?current-elaboration-node: the elaboration node
;;;                                                  that is currently (or
;;;                                                  was last) under
;;;                                                  construction

(defun instantiate-specification-template (content-specification
					   content-node
					   &key loop-var-bindings)
  (let ((template (get-only-val (list content-specification
				      'content-specification-template))))
    (instantiate-template template
			  content-specification
			  content-node
			  loop-var-bindings)))


;-----------------------------------------------------------------------
;		    The Iterate-Over Instantiation Function
;-----------------------------------------------------------------------


;;; instantiates the iterate-over template to produce an expression
;;;   which, when evaluated, will produce a list of elements to
;;;   iterate over
;;;
;;; the Loop-Var-Bindings are a list of dotted pairs of Variable-
;;;   Value bindings, which may be nil; if they are not nil, they
;;;   were passed to this function from an outer loop
;;;
;;; at the time that this function is called, a Content Node has not
;;;   yet been created in the Explanation Plan Tree, so the generic
;;;   instantiation functions called by this node cannot store away
;;;   local variable values if they are computed
;;;
;;; the nil in the instantiate-template function call below indicates
;;;   that there is  no Plan-Tree-Node; more specifically, there
;;;   is no Content Node on which computed values of local variables
;;;   may be found or stored

(defun instantiate-iterate-over-template (content-specification
					  loop-var-bindings)
  (let ((iterate-over-template (get-only-val (list content-specification
						   'iterate-over-template))))
    (instantiate-template iterate-over-template
			  content-specification
			  nil
			  loop-var-bindings)))


;-----------------------------------------------------------------------
;		The Iteration Condition Instantiation Function
;-----------------------------------------------------------------------


;;; instantiates the iteration condition of a conditional-iterative
;;;   content specification
;;;
;;; Loop-Var-Bindings are bindings of loop variables in outer loops;
;;;   this list may be nil
;;;
;;; at the time that this function is called, a Content Node has not
;;;   yet been created in the Explanation Plan Tree, so the generic
;;;   instantiation functions called by this node cannot store away
;;;   local variable values if they are computed
;;;
;;; the first nil in the function call below indicates that there is 
;;;   no loop variable binding list
;;;
;;; the second nil in the function call below indicates that there is 
;;;   no Plan-Tree-Node; more specifically, there is no Content Node
;;;   on which computed values of local variables may be found or stored

(defun instantiate-iteration-condition (iteration-condition
					loop-var-bindings
					content-specification)
  (instantiate-template iteration-condition
			content-specification
			nil
			loop-var-bindings))


;-----------------------------------------------------------------------
;		  The Focus Condition Instantiation Function
;-----------------------------------------------------------------------


;;; instantiates Focus-Condition
(defun instantiate-focus-condition (focus-condition
				    edp-unit
				    plan-tree-node)
  (instantiate-template focus-condition
			edp-unit
			plan-tree-node))


;-----------------------------------------------------------------------
;		  The Generic Template Instantiation Function
;-----------------------------------------------------------------------


;;; Given: a template to instantiate
;;;        an edp-unit
;;;        a list of loop variable bindings (may be nil)
;;;        a plan tree node (may be nil)
;;;
;;; if Plan-Tree-Node is nil, then the results of computing
;;;   local variables will not be searched for (nor will
;;;   the resulting bindings be cached on it)
;;;
;;; Searching variables of other nodes:
;;;   the system will sometimes attempt to instantiate a variable
;;;   with a binding that has been made to it at a higher level
;;;   in the Explanation Plan Tree; it will do this *only* in the 
;;;   following situation:
;;;
;;;        (1) it has ruled out all special variables, and
;;;        (2) the variable wasn't found among the loop variables, and
;;;        (3) the Plan-Tree-Node is not nil
;;;
;;;   if it fails to find the variable, it will continue searching 
;;;   upward in the tree until it either finds the variable or it 
;;;   runs out of nodes to examine in the tree (indicated by 
;;;   encountering a nil value for child-of-node, meaning the top of 
;;;   the Explanation Plan Tree has been reached)
;;;
;;;   note that the system currently does not invoke to-computes
;;;   of variables that occur at higher nodes; it simply examines
;;;   the nodes in the explanation plan to determine if a value
;;;   for the variable of interest has been previously computed
;;;
;;;   the system substitutes t for true and nil for false to
;;;   aid the evaluation of the statement later
;;;
;;; the real work is done by the function instantiate-template-aux;
;;;    the top-level function instantiate-template is used to return 
;;;    nil (as opposed to a partially instantiated template) in the
;;;    case of an instantiation error

(defun instantiate-template (template edp-unit 
		             &optional plan-tree-node loop-var-bindings)
  "Generic template instantiation function"

  (when (trace-instantiation?)
    (format t "Attempting to instantiate template")
    (pprint template t)
    (format t "~%in edp-unit ~a.~%~%"
	    edp-unit)
    (when (not (null plan-tree-node))
      (format t "The instantiator was given plan tree node ~a.~%~%"
	      plan-tree-node))
    (when (not (null loop-var-bindings))
      (format t "It was given loop variable bindings:~% ~a.~%~%"
	      loop-var-bindings)))
  (let ((result (instantiate-template-aux template
					  edp-unit 
					  plan-tree-node
					  loop-var-bindings)))
    (when (trace-instantiation?)
      (format t "The resulting instantiated template is")
      (pprint result t)
      (format t "~%~%"))
    (cond ((null (instantiation-error?)) result)
	  (t (switch-off-instantiation-error)))))


(defun instantiate-template-aux (template edp-unit 
 			         &optional plan-tree-node loop-var-bindings)
  (cond ((atom template)
	 (cond ((and (symbolp template)
		     (char= (schar (symbol-name template) 0)
			    #\?))
		(instantiate-template-var template
					  edp-unit  
					  plan-tree-node
					  loop-var-bindings))
	       ((and (symbolp template)
		     (equal template 'true))
		t)
	       ((and (symbolp template)
		     (equal template 'false))
		nil)
	       (t template)))
	((null template) nil)
	(t (cons (instantiate-template-aux (first template)
					   edp-unit
					   plan-tree-node
					   loop-var-bindings)
		 (instantiate-template-aux (rest template)
					   edp-unit
					   plan-tree-node
					   loop-var-bindings)))))
	     

;;; Template Variable Instantiation Method:
;;;
;;;			1. Determine if it is a special variable 
;;;
;;;			2. if it is a special variable, instantiate it
;;;                        with the appropriate value
;;;
;;;			3. if it is not a special variable, then
;;;                        determine if it is a loop variable as
;;;                        follows:
;;;
;;;                             a. assoc of it on Loop-Var-Bindings
;;;
;;;                             b. return cdr of assoc
;;;
;;;                     4. if it was not a loop variable either, then
;;;                        check if it it is a local variable:
;;;
;;;                             a. first check if its value has
;;;                                already been computed by
;;;				   examining list of
;;;                                local-variable-bindings on
;;;                                Plan-Tree-Node (if node was given)
;;;
;;;                             b. if not, check if there is a
;;;                                to-compute for it on the EDP unit
;;;
;;;                             c. if there is a to-compute, apply it
;;;
;;;                     5. if it is not a local variable on the EDP,
;;;                        search upward in the Explanation Plan
;;;                        Tree until either find the variable
;;;                        or run out of nodes to examine in the
;;;                        tree (indicated by encountering a nil 
;;;                        value for child-of-node, meaning the top
;;;                        of the Explanation Plan Tree has been
;;;                        reached)           
;;;
;;;                        (assumes function ``search-upward-for-non-local''
;;;                         returns nil if it is unable to find a value)
;;;
;;; error results: returns nil if fails to instantiate variable

(defun instantiate-template-var (template-var edp-unit
				 &optional plan-tree-node loop-var-bindings)
  "Instantiates a template variable"

  (when (trace-instantiation-details?)
    (format t "Attempting to instantiate ~a ~%in EDP node ~a.~%~%"
	    template-var
	    edp-unit))

  ;; first check if variable is special
  (let ((special-var-binding (check-special-vars template-var)))
    (if (not (null special-var-binding)) special-var-binding

	;; then check if variable is a loop variable
	(let ((possible-loop-binding
	       (assoc template-var loop-var-bindings)))
	  ;(format t "Just checked possible loop bindings.~%~%")
	  (if (not (null possible-loop-binding))
	      (progn (when (trace-instantiation-details?)
		       (format t "The variable ~a is a loop variable with~%~
                                  with value ~a.~%~%"
			       template-var
			       (cdr possible-loop-binding)))
		     (cdr possible-loop-binding))

	      ;; then check if binding exists on plan-tree-node
	      (if (not (null plan-tree-node))
		  (let ((local-binding
			 (assoc template-var
				(get-local
				 (list plan-tree-node
				       'local-variable-bindings)))))
		    ;(format t "Just checked local variable bindings~%~%")
		    (if (not (null local-binding))
			(progn (when (trace-instantiation-details?)
				 (format t "The variable ~a is an existing ~
                                            local variable~%on ~a ~
                                            with value ~a.~%~%"
					 template-var
                                         plan-tree-node
					 (cdr local-binding)))
			       (cdr local-binding))

			;; then check if there is a to-compute for it
			(let ((to-compute-template
			       (get-to-compute-for-local-var template-var
							     edp-unit)))
			  (if (not (null to-compute-template))
			      (evaluate-computable-local-var
			                               to-compute-template
			                               template-var
						       edp-unit
						       plan-tree-node
						       loop-var-bindings)

			      ;; otherwise search upward in Plan
			      (let ((value-of-var 
				     (search-upward-for-non-local
				      template-var plan-tree-node)))
				(if (not (null value-of-var))
				    value-of-var
				    (signal-instantiation-error
				           template-var
				           edp-unit
				           plan-tree-node)))))))

		  ;; if no plan tree node, check for to-computes
		  (let ((to-compute-template
			 (get-to-compute-for-local-var template-var
						       edp-unit)))

		    (when (and (trace-instantiation-details?)
			       (not (null to-compute-template)))
		      (format t "The to-compute template for ~
                                 template variable ~a is:~%"
			      template-var)
		      (pprint to-compute-template t)
		      (format t "~%~%"))

		    (if (not (null to-compute-template))
			(evaluate-computable-local-var
			 to-compute-template
			 template-var
			 edp-unit
			 plan-tree-node
			 loop-var-bindings)
			
			;; otherwise search upward in Plan
			(let ((value-of-var 
			       (search-upward-for-non-local
				template-var plan-tree-node)))
			  (if (not (null value-of-var))
			      value-of-var
			      (signal-instantiation-error
			       template-var
			       edp-unit
			       plan-tree-node)))))))))))


	
;;; checks if template variable is a special variable
;;; if so, the value of the special variable is returned
;;; otherwise returns nil

(defun check-special-vars (template-var)
  "Looks through special variables for value of template variable"
  (let ((result 
	 (case template-var
	   (?primary-concept
	    (get-only-val (list (current-exposition-node)
				'primary-concept)))
	   (?current-exposition-node (current-exposition-node))
	   (?current-topic-node (current-topic-node))
	   (?current-t-content-node (current-t-content-node))
	   (?current-e-content-node (current-e-content-node))
	   (?current-elaboration-node (current-elaboration-node)))))
    (when (trace-instantiation-details?)
      (if (null result)
	  (format t "The variable ~a is not a special variable.~%~%"
		  template-var)
	  (format t "The variable ~a is a special variable ~%~
                     with value ~a.~%~%"
		  template-var
		  result)))
    result))


;;; searches for to-compute expression for template-var on edp-unit
;;; returns expression if exists
;;; otherwise returns nil
;;;
;;; assumes that if a variable appears on the local variable list of
;;;    an edp-unit, then there is a to-compute expression associated 
;;;    with it

(defun get-to-compute-for-local-var (template-var edp-unit)
  "Searches for to-compute template for local variable"
  (let* ((local-vars (get-local (list edp-unit 'local-variables)))
	 (result (if (member template-var local-vars)
		     (get-only-val (list edp-unit
					 'local-variables
					 template-var
					 'to-compute)))))
    (when (and (trace-instantiation-details?)
	       (null result))
      (format t "The variable ~a has no to-compute expression~%~
                 on ~a.~%~%"
	      template-var
	      edp-unit)
      (format t "The to-compute expression for ~a~%on ~a is:"
	      template-var
	      edp-unit)
      (pprint result t)
      (format t "~%~%"))
    result))


;;; evaluates a local variable template-var with to-compute-template
;;;      in edp-unit for building plan-tree-node
;;;
;;; method:
;;;
;;;     (1) instantiates to-compute template
;;;
;;;     (2) evaluates it
;;;
;;;     (3) if Plan-Tree-Node is not nil, then the value is stored
;;;
;;;     (4) returns value or, if failed to instantiate variable, returns nil
;;;
;;; instantiating to-compute-template may involve evaluating
;;;    the to-computes of local variables; these to-computes must 
;;;    be interpreted by KNIGHT, not by KM, which doesn't know how 
;;;    to correctly instantiate special variables mentioned in the 
;;;    to-compute, such as ``?current-topic-node''; this may involve
;;;    calling this function recursively; the recursion bottoms out 
;;;    when either
;;;         (1) a function only mentions special variables, or
;;;         (2) a function has values for all local variables
;;;                already computed

(defun evaluate-computable-local-var (to-compute-template
				      template-var
				      edp-unit
				      plan-tree-node
				      loop-var-bindings)
  "Evaluates local variable with to-compute"
  (let ((to-compute-instantiation
	 (instantiate-template-aux to-compute-template 
				   edp-unit
				   plan-tree-node
				   loop-var-bindings)))
    (when (trace-instantiation-details?)
      (format t "The instantiation of the to-compute expression for ~a~%~
                 on ~a is:"
	      template-var
	      edp-unit)
      (pprint to-compute-instantiation t)
      (format t "~%~%"))
    (if (not (null to-compute-instantiation))
	(let ((value-of-var (eval to-compute-instantiation)))

	  (when (trace-instantiation-details?)
	    (format t "The value of the instantiated expression for ~a~%~
                       on ~a is: ~a.~%~%"
		    template-var
		    edp-unit
		    value-of-var))
	  ;; install computed value in plan-tree-node		      
	  (if (not (null plan-tree-node))
	      (add-val (list plan-tree-node 'local-variable-bindings)
		       (list template-var value-of-var)))
	  value-of-var)

	;; found to-compute, but couldn't instantiate it
	(signal-instantiation-error template-var
				    edp-unit
				    plan-tree-node
				    'to-compute-problem))))


;;; searches upwards for value of V in Explanation Plan Tree 
;;;
;;; search begins at Plan-Tree-Node
;;;
;;; calls self recursively on parent of Plan-Tree-Node if
;;;   cannot find it in current Plan-Tree-Node
;;;
;;; if fails returns nil

(defun search-upward-for-non-local (v plan-tree-node)
  "Searches upward in Explanation Plan Tree for value of local variable"
  (if (not (null plan-tree-node))
      (let ((possible-binding (assoc v (get-local
					(list plan-tree-node
					      'local-variable-bindings)))))
	(when (trace-instantiation-details?)
	  (format t "Considering bindings on node ~a~%~%" plan-tree-node)
	  (format t "Bindings are ~a~%~%" (get-local
					   (list plan-tree-node
						 'local-variable-bindings))))
	(if (not (null possible-binding))
	    (cdr possible-binding)
	    (search-upward-for-non-local v (get-only-val
					    (list plan-tree-node
						  'child-of-node)))))))


;-----------------------------------------------------------------------
;		  The Instantiation Error Functions
;-----------------------------------------------------------------------

;;; instantiation-error? is a slot on the KB frame Knight-Global-State


(defun switch-on-instantiation-error ()
  (put-local '(knight-global-state instantiation-error?)
	     'true))


(defun switch-off-instantiation-error ()
  (put-local '(knight-global-state instantiation-error?)
	     'false))


(defun instantiation-error? ()
  (equal (get-only-val '(knight-global-state instantiation-error?))
	 'true))


;;; prints instantiation error message
(defun signal-instantiation-error (template-var edp-unit plan-tree-node
				   &optional to-compute?)
  (switch-on-instantiation-error)
  (when (trace-instantiation?)
    (format t "~%Could not instantiate variable ~a~%~
                 in EDP node ~a~%~
                 when constructing Explanation Plan node ~a.~%~%"
	  template-var
	  edp-unit
	  plan-tree-node)
    (if (equal to-compute? 'to-compute-problem)
	(format t "Reason: Could not properly instantiate ~
                 ~a's to-compute.~%~%" template-var)))
  nil)




e on the EDP,
;;;                        search upward in the Explanation Plan
;;;                        Tree until either find the variable
;;;                        or run out of nodes to examine in the
;;;                        tree (indicated by encountering a nil 
;;kb-access.lisp                                                                                      000775  003117  001440  00000003631 05641657623 014642  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		     The Knowledge Base Access Functions
;;;;		     -----------------------------------


;;; instantiates specification template and evaluates it
;;;
;;; if successful, adds KB Subgraph to content-node
;;;
;;; if fails, i.e., if knowledge is not present in KB or
;;; specification template is invalid, signals an error


(in-package 'km)


(defun access-kb (content-node)
  "Accesses knowledge base to retrieve domain knowledge"
  (let* ((instantiated-specification-template
	  (get-only-val (list content-node
			      'instantiated-specification-template)))
	 (template-has-error?
	  (contains-error instantiated-specification-template)))

    (when (and (trace-kb-access?)	       
	       (not template-has-error?))
      (format t "Accessing KB with call:")
      (pprint instantiated-specification-template)
      (format t "~%~%"))

    (let ((result (if (not (equal template-has-error?
				  'true))
		      (eval instantiated-specification-template))))

      (cond ((or (null instantiated-specification-template)
		 (equal template-has-error? 'true))
	     (signal-kb-access-error content-node
				     'specification-template-uninstantiable))

	    ((and (equal (first instantiated-specification-template)
			 'retrieve-view)
		  (null result))
	     (signal-kb-access-error content-node
				     'view-retriever-error))

	    ((and (equal (first instantiated-specification-template)
			 'retrieve-view)
		  (empty-view-p result))
	     (signal-empty-viewpoint-warning content-node))

	    ((and (listp result)
		  (equal (first result) 'error))
	     (signal-kb-access-error content-node
				     (second result)))

	    ((null result)
	     (signal-kb-access-error content-node
				     'null-kb-access-result))

	    (t (put-local (list content-node 'kb-subgraph)
			  (listify result))
	       (put-local (list result 'kb-subgraph-of)
			  (list content-node)))))))
               on ~a is:"
	      template-var
	      edp-unit)
      (pprint to-compute-instantiation tkb-errors.lisp                                                                                      000775  003117  001440  00000007140 05641657624 014715  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		     The Knowledge Base Error Functions
;;;;		     ----------------------------------


;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;; 


(in-package 'km)






;;; determines if the keyword ``error'' occurs anyplace
;;; in the nested expression

(defun contains-error (expression)
  (cond ((null expression)
	 nil)
	((and (atom expression)
	      (equal expression 'error))
	 t)
	((atom expression) nil)
	(t (or (contains-error (first expression))
	       (contains-error (cdr expression))))))


;;; signals an empty viewpoint error

(defun signal-empty-viewpoint-warning (content-node)
  (when (trace-kb-access?)
    (format t "KB Access Warning: Empty viewpoint at ~a.~%~%"
	    content-node))
  (put-local (list content-node 'error-occurred?)
	     'true)
  (put-local (list content-node 'error-type)	     
	     'empty-viewpoint))

    
;;; determines if an error is shown by a content-node

(defun content-node-has-error? (content-node)
  (equal (get-only-val (list content-node 'error-occurred?))
	 'true))


;;; determines if a viewpoint has an error
;;;
;;; returns t iff viewpoint is not a true viewpoint or
;;;               when viewpoint has an error

(defun viewpoint-contains-error? (viewpoint)
  (or (not (viewpoint? viewpoint))
      (equal (get-only-val (list viewpoint 'error-occurred?))
	     'true)))


;;; reports content-nodes of current explanation plan with errors
;;;
;;; a content node has an error if 
;;;         (1) an error has occurred at the content node
;;;         (2) an error has occurred in the viewpoint associated
;;;             with the content node
;;;
;;; note: this is *not* an efficient implementation;
;;;       it traverses all content nodes and reports only
;;;       those that are in the current explanation plan
;;;       rather than traversing the explanation plan itself;
;;;       the implemented algorithm was just a little easier
;;;       to code

(defun report-kb-access-irregularities ()
  (pprint (find-erroneous-content-nodes) t))


(defun find-erroneous-content-nodes ()
  (let* ((all-content-nodes
	  (get-local '(content-node specializations)))
	 (current-content-nodes
	  (remove-if-not #'content-node-of-current-explanation-plan-p
			 all-content-nodes)))
    (remove-if-not #'problem-content-node-p
		   current-content-nodes)))


(defun content-node-of-current-explanation-plan-p (content-node)
  (let* ((current-exposition-node
	  (get-only-val '(knight-global-state
			  current-exposition-node)))
	 (search-result
	  (kb-search (list content-node)
		     (list 'child-of-node)
		    :terminate-with-success-criteria
		    #'(lambda (curr-plan-node)
			(equal curr-plan-node
			       current-exposition-node))
		    :collect-path? nil
		    :loop-elimination? t)))
    (not (equal (first search-result)
		'fail))))

			       
(defun problem-content-node-p (content-node)
  (or (content-node-has-error? content-node)
      (viewpoint-contains-error? (get-only-val (list content-node
						     'kb-subgraph)))))




;-----------------------------------------------------------------------
;			   Signals a KB Access Error
;-----------------------------------------------------------------------

;;; records KB Access error in content-node of Explanation Plan
;;; when trace is turned on, prints error message

(defun signal-kb-access-error (content-node error-type)
  (when (trace-kb-access?)	       
    (format t "An error has occurred at ~a.~%"
	    content-node)
    (format t "Error type: ~a~%~%"
	    error-type))
  (put-local (list content-node 'error-occurred?)
	     'true)
  (put-local (list content-node 'error-type)	     
	     error-type))

content node
;;;
;;; note: this is *not* an efficient implementation;
;;;       it traverses all content nodes and reports only
;;;       those that are in the current explanation plan
;;;       rather than traversing the explanation plan itself;
;;;       the implemented algorithm was just a little easier
;;;       to code

(defun report-kb-access-irregularities ()
  (pprint (find-erroneous-content-nodes) t))


kb-filter.lisp                                                                                      000775  003117  001440  00000036067 05641657624 014700  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
				       
;;;;		    The Knowledge Base Filtering Functions
;;;;		    --------------------------------------



;;;; given: a content-node and its associated viewpoint
;;;;
;;;; filters content node in three ways, then checks if the viewpoint
;;;; has become emptied
;;;;
;;;; (1) filters (signals errors on) viewpoints whose concept of
;;;;     interest is a path
;;;;
;;;; if an error was not signalled on the viewpoint, then
;;;;
;;;;     (2) filters triples with concepts which are marked as unspeakable
;;;;
;;;;     (3) if user modeling is on, filters known concepts from the
;;;;         viewpoint and adds triples that will be communicated to
;;;;         the user model
;;;;
;;;;     finally,
;;;;
;;;;     (4) checks if the filtering process has removed the final
;;;;         bits of information from the viewpoint, leaving only
;;;;         a ``shell;'' if so, signals an error in the content node
;;;;
;;;; returns: the main result is the side-effects of filtering the
;;;;          given viewpoint


(in-package 'km)


;-----------------------------------------------------------------------
;			 Top-Level Filtering Function
;-----------------------------------------------------------------------

(defun filter-content (content-node)
  (when (not (content-node-has-error? content-node))

    (let ((viewpoint (get-only-val (list content-node 'kb-subgraph))))

      (when (not (viewpoint-contains-error? viewpoint))

	(cond

	  ;; check if filtering paths from viewpoints
	  ((and (filter-path-viewpoints?)
		(concept-of-interest-is-path? viewpoint))

	   ;; filter one if encountered
	   (signal-kb-access-error content-node
				   'concept-of-interest-is-path)
	   )

	  (t ;; otherwise do all the other filtering


	   ; function below calls code the Charles' code takes care of
	   ;(filter-overly-general-concepts viewpoint)

	   (when (user-modeling-on?)
	     (filter-known-concepts-and-update-user-model viewpoint))

	   (when (filter-path-values?)
	     (filter-path-values viewpoint))

	   (when (empty-view-p viewpoint)
	     (signal-kb-access-error
	      content-node
	      'kb-filtering-removed-essential-information)))
	  ))
      )))


(defun filter-path-viewpoints? ()
  (equal (get-only-val '(knight-global-state filter-path-viewpoints?))
	 'true))

(defun concept-of-interest-is-path? (viewpoint)
  (let ((coi (get-only-val (list viewpoint 'viewpoint-of))))
    (and coi (listp coi))))


;-----------------------------------------------------------------------
;		       Overly General Concept Filtering
;-----------------------------------------------------------------------
;;;
;;; filters concepts that are too general and should not be included
;;; in a natural language translation of the viewpoint
;;;
;;; the with-no-prompts call is used to prevent KM from calling
;;; KnEd and issuing a window prompt when remove-val is called
;;; on a value that has annotations
;;;
;;; some slots should not be filtered on particular kinds of viewpoints
;;; these are all included in the ``slots-special-not-to-filter''
;;; variable, e.g., 
;;;
;;;     if have as-kind-of viewpoint
;;;        if concept of interest is an object
;;;           do not filter values of as-kind-of slot
;;;               --> put as-kind-of in slots-special-not-to-filter
;;;        if concept of interest is a process
;;;           do filter values of as-kind-of slot


(defun filter-overly-general-concepts (viewpoint)
  (with-no-prompts
      (let* ((spec-type
	      (get-only-val (list viewpoint 'specification-type)))

	     (slots-always-not-to-filter
	      '(generalizations kb-subgraph-of viewpoint-of))

	     (slots-special-not-to-filter
	      (case spec-type
		(black-box-process-description '(reference-concept))
		(t                             nil                 )
		))

	     (all-slots-not-to-filter (append slots-always-not-to-filter
					      slots-special-not-to-filter))
	     )
	(case spec-type
	  ((core-connection core-connection-rev super-structural-connection)
	   (filter-overly-general-concepts-chain viewpoint spec-type))
	  (t (filter-overly-general-concepts-aux viewpoint
						 all-slots-not-to-filter))))))


(defun filter-overly-general-concepts-chain (viewpoint spec-type)
  (let* ((slot-of-interest
	  (case spec-type
	    ((core-connection core-connection-rev) 'connection-to-core)
	    ((super-structural-connection)         'super-parts-chain)))
	 (chain (get-only-val (list viewpoint slot-of-interest)))
	 (overly-general-concept-found? nil))
    (dolist (concept chain)
      (when (is-unspeakable-p concept)
	(setf overly-general-concept-found? t)))
    (when overly-general-concept-found?
      (when (trace-viewpoint-filtering?)
	(format t "Viewpoint filtering:~%Filtered ~a~%~
                   of ~a.~%"
		slot-of-interest
		viewpoint)
	(format t "Reason: Unspeakable concept occurred on chain.~%~%"))

      (put-local (list viewpoint slot-of-interest)
		 (list (remove-chain-bits chain
					  #'is-unspeakable-p))))))


(defun filter-overly-general-concepts-aux (unit all-slots-not-to-filter)
  (let ((slots-to-filter (set-difference (get-explicit-slots unit)
					 all-slots-not-to-filter)))
    
      (dolist (curr-slot slots-to-filter)
	(dolist (curr-value (get-local (extend-address unit
						       curr-slot)))
	  (cond ((is-unspeakable-p curr-value)
		 (when (trace-viewpoint-filtering?)
		   (format t "Viewpoint filtering:~%Filtered ~a~%~
                              on ~a of ~a.~%"
			   curr-value
			   curr-slot
			   unit)
		   (format t "Reason: Unspeakable concept.~%~%"))
		 (remove-val (extend-address unit curr-slot)
			     curr-value))
		(t (let ((nested-address
			  (extend-address-indefinitely unit
						       curr-slot
						       curr-value)))
		     (when (get-substructure nested-address)
		       ;; address has annotations, so filter them too
		       (filter-overly-general-concepts-aux
			nested-address
			all-slots-not-to-filter)))))))))


;-----------------------------------------------------------------------
;			     User Model Filtering
;-----------------------------------------------------------------------
;;;
;;; There are two primary functions which need to be accomplished:
;;;
;;;        - Filtering: Given a viewpoint, remove those triples
;;;                     (and their annotations) that have
;;;                     already been discussed
;;;
;;;        - Updating:  Given a viewpoint, update the UM to indicate
;;;                     that the triples in it have been discussed
;;; given: a viewpoint
;;;
;;; if the viewpoint is a standard viewpoint, then the viewpoint
;;; is filtered for triples that contain known concepts, and the
;;; user model is updated with concepts that will be discussed
;;;
;;; if viewpoint is one whose main content is a specially constructed
;;; list structure, e.g. connect-to-core, then the user model
;;; is updated with each of the triples that compose the chain

(defun filter-known-concepts-and-update-user-model (viewpoint)
  (with-no-prompts
      (let ((spec-type (get-only-val (list viewpoint 'specification-type))))
	(case spec-type
	  ((core-connection core-connection-rev super-structural-connection)
	   (update-um-with-list-structure viewpoint spec-type))
	  ((sub-structural-description)
	   (update-um-with-sub-structural-view viewpoint))
	  (t
	   (filter-known-concepts-and-update-um-standard viewpoint))))))


(defun update-um-with-list-structure (viewpoint spec-type)
  (let* ((slot-of-interest
	  (case spec-type
	    ((core-connection core-connection-rev) 'connection-to-core)
	    ((super-structural-connection)         'super-parts-chain)))
	 (chain (get-only-val (list viewpoint slot-of-interest)))
	 (triples-list (break-chain-into-triples chain)))
    (dolist (triple triples-list)
      (add-um-triple (list (first triple)
			   (second triple)
			   (third triple))))))


;;; breaks a chain into its composite triples
;;;
;;; example: (a b c d e) --> ((a b c) (c d e))
	     
(defun break-chain-into-triples (chain)
  (if (and chain
	   (not (equal (length chain) 1)))
      (cons (list (first chain)
		  (second chain)
		  (third chain))
	    (break-chain-into-triples (rest (rest chain))))))


(defun update-um-with-sub-structural-view (viewpoint)
  (let* ((concept-of-interest (get-only-val (list viewpoint 'viewpoint-of)))
	 (part-slot (get-only-val (list viewpoint 'part-slot-for-view)))
	 (parts (get-local (list viewpoint 'part-values))))
    (dolist (part parts)
      (add-um-triple (list concept-of-interest
			   part-slot
			   part)))))

      
(defun filter-known-concepts-and-update-um-standard (viewpoint)
  (let ((concept-of-interest (get-only-val (list viewpoint 'viewpoint-of))))

    (dolist (curr-slot (set-difference
			(get-explicit-slots viewpoint)
			(append (get-local '(viewpoint-slots specializations))
				'(generalizations kb-subgraph-of
				  instance-of focused-concept))))
      (dolist (curr-value (get-local (extend-address viewpoint
						     curr-slot)))
	(cond ((is-known-p (list concept-of-interest
				 curr-slot
				 curr-value))

	       ;; triple is known so remove it
	       (when (trace-viewpoint-filtering?)
		 (format t "Viewpoint filtering:~%Filtered ~a~%on ~a.~%"
			 (list (get-only-val (list viewpoint 'viewpoint-of))
			       curr-slot
			       curr-value)
			 viewpoint)
		 (format t "Reason: Known triple.~%~%"))
	       (remove-val (extend-address viewpoint curr-slot)
			   curr-value))
		
	      ;; triple is now known so do not remove it
              ;; but include it in viewpoint and then
	      ;; add it to the user model
	      (t (add-um-triple (list concept-of-interest
				      curr-slot
				      curr-value))))))))


;-----------------------------------------------------------------------
;		       Filters Embedded Units
;-----------------------------------------------------------------------

;;; For some cases in testing, especially until we get the NLG system
;;; to work for paths, we need a mechanism for filtering embedded units.
;;;
;;; The predicate and filter in this section performs these functions.

;;; predicate for testing whether embedded unit filtering is on

(defun filter-path-values? ()
  (equal (get-only-val '(knight-global-state filter-path-values?))
	 'true))


;;;filters embedded units that occur as values of slots on viewpoints
;;;
;;; the with-no-prompts call is used to prevent KM from calling
;;; KnEd and issuing a window prompt when remove-val is called
;;; on a value that has annotations
;;;
;;; below we are careful not to filter values of viewpoint slots
;;; which are special cases; these slots have values that are not
;;; paths in the traditional sense; instead they are values which
;;; are ordered lists, such as the results of a connect-to-core
;;; specification; these types of units need special treatment

(defun filter-path-values (viewpoint)
  (with-no-prompts
      (let* ((spec-type (get-only-val (list viewpoint 'specification-type))))
	(case spec-type
	  
	  ((core-connection
	    core-connection-rev
	    super-structural-connection) (filter-path-values-special
					  spec-type
					  viewpoint))

	  (t                             (filter-path-values-standard
					  viewpoint))))))


;;; recursively works through substructures of unit to filter paths
(defun filter-path-values-standard (unit)
  (let* ((slots-to-filter (set-difference (get-explicit-slots unit)
					  '(generalizations
					    i-genls
					    i-specs
					    kb-subgraph-of
					    viewpoint-of))))
      (dolist (curr-slot slots-to-filter)
	(dolist (curr-value (get-local (extend-address unit
						       curr-slot)))
	  (cond ((listp curr-value)
		 (when (trace-viewpoint-filtering?)
		   (format t "Viewpoint filtering:~%Filtered ~a~%~
                              on ~a of ~a.~%"
			   curr-value
			   curr-slot
			   unit)
		   (format t "Reason: Path value.~%~%"))
		 (remove-val (extend-address unit curr-slot)
			     curr-value))
		(t (let ((nested-address
			  (extend-address-indefinitely unit
						       curr-slot
						       curr-value)))
		     (when (get-substructure nested-address)
		       ;; address has annotations, so filter them too
		       (filter-path-values-standard
			nested-address)))))))))


;;; works through list value of special viewpoints such as
;;; substructures of unit to filter paths
;;;
;;; after finding the chain, filters out all slots from the chain
;;; and then checks the units that remain
;;;
;;; if one or more of the units in the chain are paths, the
;;; entire chain is deleted from the slot on the viewpoint, thereby
;;; effectively leaving the viewpoint empty
(defun filter-path-values-special (spec-type viewpoint)
  (let* ((slot-of-interest
	  (case spec-type
	    ((core-connection core-connection-rev) 'connection-to-core)
	    ((super-structural-connection)         'super-parts-chain)))
	 (chain (get-only-val (list viewpoint slot-of-interest)))
	 (units-in-chain (remove-if #'slot-p chain))
	 (path-unit-found-in-chain? nil))

    ;(format t "Units-in-chain: ~a~%" units-in-chain)

    (dolist (unit units-in-chain)
      (when (listp unit)
	(setf path-unit-found-in-chain? t)))

    (when path-unit-found-in-chain?

      (when (trace-viewpoint-filtering?)
	(format t "Viewpoint filtering:~%Filtered ~a~%~
                   of ~a.~%"
		slot-of-interest
		viewpoint)
	(format t "Reason: Path value occurred on chain.~%~%"))

      (put-local (list viewpoint slot-of-interest)
		 (list (remove-chain-bits chain
					  #'listp))))))


;-----------------------------------------------------------------------
;		       Removing Bits from Chains Utility
;-----------------------------------------------------------------------
;;; given: a chain (a b c d e) of length at least 3
;;;        a predicate
;;;  
;;;
;;; if don't find member of chain that satisfies predicate then
;;; return chain
;;;
;;; for each member that satisfies the predicate then
;;;    if offending member is in the first position then
;;;       return nil else:
;;;              alter chain to remove offender and its predecessor (a slot)
;;;              if length of resulting chain is less than 3 then
;;;                 return nil else
;;;                 return chain
;;;
;;; example: (remove-chain-bits '(a b c d e f g)
;;;                             #'(lambda (x) (equal x 'd)))
;;;          --> (a b e f g)
;;;
;;; note: VERY unelegant, but had to write it quickly
;;;
;;; use: call remove-chain-bits with chain #'unspeakable 

(defun remove-chain-bits (chain predicate)
  (let ((altered-chain (remove-chain-bits-aux chain predicate)))
    (cond ((null altered-chain)
	   nil)
	  ((equal chain altered-chain)
	   chain)
	  (t (remove-chain-bits altered-chain predicate)))))


(defun remove-chain-bits-aux (chain predicate)
  (let ((chain-length (length chain)))
    (let ((bad-bit-position (position-if #'(lambda (x)
					     (funcall predicate x))
					 chain)))
      (if (numberp bad-bit-position)
	  (if (and (not (zerop bad-bit-position))
		   (not (equal bad-bit-position 1)))
	      (let* ((slot-before-bad-bit-position (1- bad-bit-position))
		     (altered-chain
		      (append
		       (subseq chain
			       0
			       slot-before-bad-bit-position)
		       (subseq chain
			       (1+ bad-bit-position)
			       chain-length))))
		(if (>= (length altered-chain) 3)
		    altered-chain)))
	  chain))))


(not (null value-of-var))
				    value-of-var
				    (signal-instantiation-error
				           template-var
				           edp-unit
				           plan-tree-node)))))))

		  ;; if no plan tree node, check for to-computes
		  (let ((to-compute-template
			 (get-to-compute-for-local-var template-var
						       edp-unit)))

		    (when (and (trace-instantiation-details?)
			       (not (null to-compute-template)))
		                                  knight-and-nlg.lisp                                                                                 000775  003117  001440  00000005556 05641657624 015622  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
;;;;			     The Knight/NLG System
;;;;			     ---------------------

;;;; Starting Kned/KM & Knight & NLG
;;;; -------------------------------
;;;;
;;;;    (1) Start Up Ilisp & Clim  :    M-x lucid-clim
;;;;
;;;;    (2) Load Kned              :    (start), select ``1'' for user 
;;;;                                
;;;;    (3) Load Knight and NLG    :    (load-knight-and-nlg)
;;;;
;;;;    (4) Go to KM package       :    (in-package 'km)
;;;;
;;;;    (5) Start Up KnEd & Load KB:    (kned::begin-kned)
;;;;
;;;;    (6) Initialize Knight           (initialize-knight)

;-----------------------------------------------------------------------
;			Defines Knight and Auxiliary Code
;-----------------------------------------------------------------------

(in-package 'km)

(proclaim '(optimize (compilation-speed 0)))


(defvar *knight-file-list*
  '(

    ;; KM Extension Files
    ;; ------------------
    "bruce-and-my-replaces-annot.lisp"
    "bruce-and-my-km-extensions.lisp"
    "my-km-extensions"
    ;; File below commented out because of all of the overwriting
    ;; definitions.  If this works, then just get rid of next
    ;; line.  These functions appear to all be in
    ;; /v/sage/v0/brewery/km/general-utilities.lisp
    ;;"prompts"

    ;; Search File
    ;; -----------
    "bruce-and-my-search"

    ;; View Retriever File
    ;; -------------------
    "bruce-and-my-retrieve"

    ;; Knight
    ;; ------
    "user-model"
    "tracers"
    "global-variable-manip"
    "plan-node-functions"
    "error-predicates"
    "evaluation"
    "reports"
    "initialization"
    "instantiate-templates"
    "focus-function-eval"
    "kb-filter"
    "kb-access"
    "linearize"
    "realize"
    "organization"
    "content-determination"
    "applier-top-level"
    "explain"
    ))
    

(defun load-knight-files ()
  (dolist (curr-file *knight-file-list*)
    (load curr-file
	  :if-source-only :load-source
	  :if-source-newer :compile)))

;-----------------------------------------------------------------------
;			Defines NLG and Auxiliary Code
;-----------------------------------------------------------------------

(defun start2a ()
    (load "i.l2"))   ;;Loads FUF with its own readtable

;;; the KB must be loaded after this is executed
(defun start2b ()
    (in-package 'km)
    (km::surge)      ;;Loads SURGE
    ;;(load "/v/sage/v0/brewery/kastl/James/load-file.lisp")
    (in-package 'km))  

(defun start2 ()
  (start2a)
  (start2b))

;-----------------------------------------------------------------------
;		    Loads KNIGHT and NLG and Auxiliary Code
;-----------------------------------------------------------------------

(in-package 'user)

(defun load-knight-and-nlg-files ()
  (cd "/v/sally/v6/lester/Planner/EDP/Implementation")
  (km::load-knight-files)
  (cd "~theorist/Fugtest")
  (km::start2))

(load-knight-and-nlg-files)
riever File
    ;; -------------------
    "bruce-and-my-retrieve"

    ;; Knight
    ;; ------
    "user-model"
    "tracers"
    "global-variablknight.lisp                                                                                         000775  006350  001440  00000007366 05653754113 014644  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-

;;;;			       The Knight System
;;;;			       -----------------

;;;; Starting Kned/KM & Knight
;;;; -------------------------
;;;;
;;;;    (1) Start Up Ilisp & Clim  :    M-x lucid-clim
;;;;
;;;;    (2) Load Kned              :    (start), select ``1'' for user 
;;;;                                
;;;;    (3) Load system            :    (load-knight)
;;;;
;;;;    (4) Go to KM package       :    (in-package 'km)
;;;;
;;;;    (5) Start Up KnEd & Load KB:    (kned::begin-kned)
;;;;
;;;;    (6) Initialize Knight           (initialize-knight)

;;;; Editing Knight
;;;; --------------
;;;;
;;;;   (1) Change to Knight implementation directory :  cdknight
;;;;
;;;;   (2) Invoke emacs                              :  em
;;;;
;;;;   (3) Load Knight files into emacs              :  M-x load-knight-system
;;;;

;;;; Changing Knight System File-List
;;;; --------------------------------
;;;;
;;;; To update which knight files are loaded into emacs:
;;;;
;;;;    Change *knight-files-to-be-loaded* in .emacs

;;;; Viewing EDPs and Explanation Plans with Tree Frames
;;;; ---------------------------------------------------
;;;;
;;;; EDPs can be viewed in a tree frame with selected slots:
;;;;       topic-list
;;;;       content-specifications
;;;;       elaborations
;;;;
;;;; Explanation Plans can be viewed in a tree frame with selected slots:
;;;;       kb-subgraph
;;;;       current-explanation-plan-header
;;;;       explanation-subject
;;;;       topic-nodes
;;;;       content-nodes
;;;;       elaboration-nodes

;-----------------------------------------------------------------------
;		    Conceptual Organization of Knight Code
;-----------------------------------------------------------------------

;;;; Main Files
;;;; ----------
;;;; explain.lisp
;;;;    applier-top-level.lisp
;;;;        instantiate-templates.lisp
;;;;        focus-function-eval.lisp
;;;;        kb-access.lisp
;;;;        kb-filter.lisp
;;;;        organization.lisp
;;;;    linearize.lisp
;;;;    realize.lisp
;;;;
;;;; Content Determination File
;;;; --------------------------
;;;; content-determination.lisp
;;;;
;;;; Support Files
;;;; -------------
;;;; initialization.lisp
;;;; tracers.lisp
;;;; user-model.lisp
;;;; plan-node-functions.lisp
;;;; global-variable-manip.lisp
;;;; error-predicates.lisp
;;;; reports.lisp
;;;; evaluation.lisp

;-----------------------------------------------------------------------
;			Loads Knight and Auxiliary Code
;-----------------------------------------------------------------------

(in-package 'km)

(cd "/v/sage/v0/brewery/knight")


(proclaim '(optimize (compilation-speed 0)))


(defvar *knight-file-list*
  '(

    ;; KM Extension Files
    ;; ------------------
    "bruce-and-my-replaces-annot.lisp"
    "bruce-and-my-km-extensions.lisp"
    "my-km-extensions"
    ;; File below commented out because of all of the overwriting
    ;; definitions.  If this works, then just get rid of next
    ;; line.  These functions appear to all be in
    ;; /v/sage/v0/brewery/km/general-utilities.lisp
    ;;"prompts"

    ;; Search File
    ;; -----------
    "bruce-and-my-search"

    ;; View Retriever File
    ;; -------------------
    "bruce-and-my-retrieve"

    ;; Knight
    ;; ------
    "user-model"
    "tracers"
    "global-variable-manip"
    "plan-node-functions"
    "error-predicates"
    "evaluation"
    "reports"
    "initialization"
    "instantiate-templates"
    "focus-function-eval"
    "kb-filter"
    "kb-access"
    "linearize"
    "realize"
    "organization"
    "content-determination"
    "applier-top-level"
    "explain"
    ))
    

(defun load-knight-files ()
  (dolist (curr-file *knight-file-list*)
    (load curr-file)))
;;	  :if-source-only :load-source
;;	  :if-source-newer :compile)))


(load-knight-files)
b-subgraph-of
					    viewpoint-of))))
      (dolist (curr-slot slots-to-filter)
	(dolist (curr-value (get-local (extend-address unit
						       curr-slot)))
	  (cond ((listp curr-value)
		 (when (trace-viewpoint-filtering?)
		   (format t "Viewpoint filtering:~%linearize.lisp                                                                                      000775  003117  001440  00000065365 05641657625 015007  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;			   The Linearizing Functions
;;;;			   -------------------------

;;; This file contains functions that linearize leaves of
;;; of an explanation plan.  It is divided into 5 sections:
;;; 
;;;       - Top-level Linearization Functions
;;;       - Explanation Plan Traversal
;;;       - Paragraph Grouping
;;;       - Paragraph Flattening
;;;       - EDP Organization Checking


;-----------------------------------------------------------------------
;		       Top-Level Linearization Functions
;-----------------------------------------------------------------------


;;; Traversal
;;; ---------
;;; traverses an explanation plan to produce a list of viewpoints
;;; that reside at the leaves of the explanation plan
;;;
;;; Filtering
;;; ---------
;;; filters those viewpoints that are erroneous or incomplete
;;;
;;; if a content node contains an error, neither its associated
;;; viewpoint or its elaboration nodes will be considered for
;;; inclusion
;;;
;;; Paragraphing
;;; ------------
;;; rather than returning a flat list, the list defines the paragraph
;;; structure of the explanation
;;;
;;; for example,
;;;               ((A B) (C) (D E F))
;;; means that viewpoints A and B will be expressed in a single
;;; paragraph, C will be expressed in a paragraph by itself, and
;;; D, E, and F will grouped together into a single paragraph
;;;
;;; method: (1) performs depth-first traversal of explanation plan; at
;;;             each node examines the paragraph-structure slot on the
;;;             EDP-unit that is the ``type'' of that node
;;;
;;;         (2) performs second pass to return embedded list with only
;;;             a single level of embedding (takes care of case where
;;;             a parent EDP unit begins a new paragraph, then a
;;;             descendant of that unit in the EDP begins yet another
;;;             new paragraph; this results in multiple levels of
;;;             embeddings, which has to be reduced to one level of
;;;             embedding)
;;;
;;;          (Optional step) may later add post-processing routines
;;;             that split up large paragraphs into smaller ones; of
;;;             course, this will need to be done very carefully so
;;;             that the first sentence of each new paragraph can serve
;;;             as a topic sentence
;;;
;;; representation of paragraph structure on EDP units:
;;;
;;;      - uses slots ``paragraph-structure'' and
;;;                   ``paragraphize-children?''
;;;    
;;;      - if both slots are empty, then no new paragraph should be begun,
;;;        all of the subtopics should be included in the same paragraph
;;;        as their supertopic
;;;
;;;      - embedded list on ``paragraph-structure'': new paragraph(s) begun
;;;                       example: ((A) (B C)) indicates that a new
;;;                                paragraph should be begun for A,
;;;                                and B and C should be included together
;;;                                in yet another new paragraph
;;;
;;;      - advice:
;;;               - to cause children of node that are produced by
;;;                 iteration to each be in their own paragraph,
;;;                 give the parent node the value ``True'' for
;;;                 the slot ``paragraphize-children?''
;;;
;;;               - to put into separate paragraphs a content
;;;                 specification's viewpoint and its elaborations,
;;;                 add a paragraph-structure value that names the
;;;                 elaborations
;;;
;;;      - rules: (1) the root of every EDP must have a value for either the
;;;                   paragraph-structure slot or the paragraphize-children?
;;;                   slot
;;;
;;;               (2) any unit in the EDP that has subtopics may
;;;                   have a value for the paragraph-structure slot
;;;
;;;               (3) any other unit in the EDP (except for
;;;                   content-specifications) that has subtopics
;;;                   may have a value for the paragraphize-children? slot
;;;    
;;;               (4) any unit that has a value for the paragraph-structure
;;;                   slot must satisfy the following criteria:
;;;                       the order of the units in ``flattened''
;;;                       paragraph-structure list must be the same
;;;                       as the order of the units in the organization
;;;                       specification in that unit, the units mentioned
;;;                       must be exactly the same in 3 lists:
;;;                            - the ``topic-list'' slot,
;;;                            - the ``organization'' slot
;;;                            - the paragraph-structure slot
;;;
;;;               (5) any unit that has non-null values for both its
;;;                   paragraph-structure and paragraphize-children?
;;;                   slots will be assigned the structure specified by
;;;                   the paragraph-structure slot
;;;
;;;       - rule checking: to see if an EDP satisfies all of these
;;;                        run the function ``check-organization''
;;;    
;;; Result
;;; ------
;;; asserts list of viewpoints as value of filtered, paragraphed
;;; ``linearized-leaves'' to slot of given exposition node


(in-package 'km)


(defun linearize-exposition-node (exposition-node)
  (let* ((ordered-explanation-plan-leaves
	  (find-leaves-of-exposition-node exposition-node))
	 (properly-paragraphed-leaves
	  (parag-flatten ordered-explanation-plan-leaves)))
    (put-local (list exposition-node 'linearized-leaves)
	       properly-paragraphed-leaves)))


;-----------------------------------------------------------------------
;			``Explanation Plan Traversal''
;-----------------------------------------------------------------------
;;; algorithm:
;;;              - visit node N in the explanation plan tree
;;;              - at N, get:
;;;                           Child-List          : a list of N's children
;;;              - if Child-List is empty then
;;;                   - return (N)
;;;                else
;;;                   - get: 
;;;                           EDP-Unit            : the corresponding EDP unit
;;;                           Paragraph-Structure : parag-struct of EDP-Unit
;;;                   - if Paragraph-Structure is empty
;;;                        and paragraphize-children? is empty then
;;;                        - return <ordered recursive results of applying
;;;                                  function to each element of Child-List>
;;;                     else if paragraph-structure is non-null then
;;;                        - return <ordered recursive results of applying
;;;                                  function to each element of Child-List,
;;;                                  where results are grouped by 
;;;                                  Paragraph-Structure>
;;;                     else (paragraphize-children? is non-null)
;;;                        - return <ordered recursive results of applying
;;;                                  function to each element of Child-List,
;;;                                  where each Child is assigned its own
;;;                                  paragraph
;;;
;;; assumes: exposition-node has either a paragraph-structure value
;;;                              or     a paragraphize-children? value
;;;          exposition-node has topic-nodes          
;;;
(defun find-leaves-of-exposition-node (exposition-node)
  (let* ((topic-nodes (get-local (list exposition-node
				       'child-nodes-ordered)))
	 (edp-unit (get-only-val (list exposition-node
				       'node-type)))
	 (paragraph-structure (get-local (list edp-unit
					       'paragraph-structure))))

    (if paragraph-structure
	(let ((grouped-topic-nodes (group-nodes topic-nodes
						paragraph-structure)))
	  ;(format t "~%Grouped topic nodes: ~a~%"
	  ;	  grouped-topic-nodes)
	  (remove nil
		  (mapcar #'find-leaves-of-topic-node-group
			  grouped-topic-nodes)))
	;;assumes should paragraphize children, i.e., each child should
	;;be in its own paragraph 	  
	(mapcar #'find-leaves-of-topic-node
		topic-nodes))))


(defun find-leaves-of-topic-node-group (topic-node-group)
  (reduce #'append
	  (mapcar #'find-leaves-of-topic-node
		  topic-node-group)))


(defun find-leaves-of-topic-node (topic-node)
  (let ((content-nodes (get-local (list topic-node
					'child-nodes-ordered))))

    (if (null content-nodes)
	(list topic-node)
	(let* ((edp-unit (get-only-val (list topic-node
					     'node-type)))
	       (paragraph-structure (get-local (list edp-unit
						     'paragraph-structure)))
	       (paragraphize-children (get-only-val
				       (list edp-unit
					     'paragraphize-children?))))
	  (cond ((and (null paragraph-structure)
		      (null paragraphize-children))
		 (find-leaves-of-content-node-group content-nodes))
		(paragraph-structure
		 (let ((grouped-content-nodes
			(group-nodes content-nodes paragraph-structure)))
		   (mapcar #'find-leaves-of-content-node-group
			   grouped-content-nodes)))
		(t
		 ;;paragraphize-children is TRUE
		 (remove-if #'null
			    (mapcar #'find-leaves-of-content-node
				       content-nodes))))))))


(defun find-leaves-of-content-node-group (content-node-group)
  (reduce #'append
	  (mapcar #'find-leaves-of-content-node
		  content-node-group)))


;;; filters those content nodes which have an error recorded in them
;;;                             or which have an erroneous viewpoint
;;;
;;; if an error has occurred at a content node (or its associated
;;; viewpoint), no elaboration nodes below are included
(defun find-leaves-of-content-node (content-node)
  (if (and (not (content-node-has-error? content-node))
	   (not (viewpoint-contains-error? (get-only-val
					    (list content-node
						  'kb-subgraph)))))
      (let ((elaboration-nodes (get-local (list content-node
						'child-nodes-ordered))))
	(append

	 ;;viewpoints at this level
	 (get-local (list content-node 'kb-subgraph))

	 ;;results of recursing into elaboration nodes
	 (if elaboration-nodes
	     (let* ((edp-unit (get-only-val (list content-node
						  'node-type)))
		    (paragraph-structure (get-local
					  (list edp-unit
						'paragraph-structure))))
	       (if (null paragraph-structure)
		   (find-leaves-of-elaboration-node-group elaboration-nodes)
		   (let ((grouped-elaboration-nodes
			  (group-nodes elaboration-nodes
				       paragraph-structure)))
		     (mapcar #'find-leaves-of-elaboration-node-group
			     grouped-elaboration-nodes)))))))))


(defun find-leaves-of-elaboration-node-group (elaboration-node-group)
  (reduce #'append
	  (mapcar #'find-leaves-of-elaboration-node
		  elaboration-node-group)))


(defun find-leaves-of-elaboration-node (elaboration-node)
  (let ((content-nodes (get-local (list elaboration-node
					'child-nodes-ordered))))
    (if (null content-nodes)
	(list elaboration-node)
	(let* ((edp-unit (get-only-val (list elaboration-node
					     'node-type)))
	       (paragraph-structure (get-local (list edp-unit
						     'paragraph-structure)))
	       (paragraphize-children (get-only-val
				       (list edp-unit
					     'paragraphize-children?))))
	  (cond ((and (null paragraph-structure)
		      (null paragraphize-children))
		 (find-leaves-of-content-node-group content-nodes))
		(paragraph-structure
		 (let ((grouped-content-nodes
			(group-nodes content-nodes paragraph-structure)))
		   (mapcar #'find-leaves-of-content-node-group
			   grouped-content-nodes)))
		(t
		 ;;paragraphize-children it TRUE
		 (mapcar #'find-leaves-of-content-node
			 content-nodes)))))))


;-----------------------------------------------------------------------
;			   ``Paragraph Grouping''
;-----------------------------------------------------------------------


;;; groups nodes into paragraph structure
;;;
;;; example:
;;;          plan-nodes: (a c d)
;;;          paragraph-structure: ( (A B C) (D E) )
;;;          result: ( (a c) (d) )
;;;
(defun group-nodes (plan-nodes paragraph-structure)
  (if (null paragraph-structure)
      nil
      (let* ((first-parag-list (first paragraph-structure))
	     (matching-nodes (retrieve-matching-nodes plan-nodes
						      first-parag-list))
	     (remaining-nodes (retrieve-remaining-nodes plan-nodes
							matching-nodes)))
	(cons matching-nodes
	      (group-nodes remaining-nodes (rest paragraph-structure))))))


;;; finds nodes that correspond to units in paragraph-structure
;;; and preserves order of topic-nodes list 
;;;
;;; example:
;;;          plan-nodes: (a c d)
;;;          paragraph-structure: (A B C)
;;;          result: (a c)
;;;
;;; must consider: nodes that don't match directly but match 
;;;                modulo iteration
;;;
(defun retrieve-matching-nodes (plan-nodes parag-list)
  (let ((first-node (first plan-nodes)))
    (if (plan-node-matches-some-unit? first-node parag-list)
	(cons first-node
	      (retrieve-matching-nodes (rest plan-nodes)
				       parag-list)))))


;;; returns the (first) edp-unit that matches plan-node
;;; if none, returns nil
;;;
(defun plan-node-matches-some-unit? (plan-node paragraph-structure)
  (or (plan-node-matches-some-unit-directly? plan-node
					     paragraph-structure)
      (plan-node-matches-some-unit-with-iteration? plan-node
						   paragraph-structure)))


;;; returns non-nil if finds an edp-unit that matches plan-node directly
;;; if none, returns nil
;;;
(defun plan-node-matches-some-unit-directly? (plan-node
					      paragraph-structure)
  (let ((node-type (get-only-val (list plan-node
				       'node-type))))
    (member node-type paragraph-structure)))


;;; returns the (first) edp-unit that matches plan-node modulo iteration
;;; if none, returns nil
;;;
;;;
(defun plan-node-matches-some-unit-with-iteration? (plan-node
						    paragraph-structure)
  (if (produced-by-iteration? plan-node)
      (let* ((node-type (get-only-val (list plan-node
					    'node-type)))
	     (iterative-node-types (collect-all-content-specs-of node-type)))
	(intersection iterative-node-types paragraph-structure))))


;;; returns t iff plan node was produced by iteration
(defun produced-by-iteration? (plan-node)
  (equal (get-only-val (list plan-node 'produced-by-iteration?))
	 'true))


;;; climbs up EDP units until finds a non-iterative unit
;;;
;;; returns list of all EDP units encountered
;;;
(defun collect-all-content-specs-of (node-type)
  (if node-type
      (let ((parent (get-only-val (list node-type
					'content-specification-of))))
	(cons node-type (collect-all-content-specs-of parent)))))


;;; finds nodes that haven't yet been matched and returns them in order
;;;
;;; example:
;;;          topic-nodes: (a c d)
;;;          matching-nodes: (a c)
;;;          result: (d)
;;;
;;; assumes: topic-nodes and matching-nodes match at beginning
;;; 
;;; method: works by peeling off matching-nodes from topic-nodes
;;;
(defun retrieve-remaining-nodes (topic-nodes matching-nodes)
  (cond ((null topic-nodes)
	 nil)
	((null matching-nodes)
	 topic-nodes)
	(t (retrieve-remaining-nodes (rest topic-nodes)
				     (rest matching-nodes)))))


;-----------------------------------------------------------------------
;			   ``Paragraph Flattening''
;-----------------------------------------------------------------------
;;; converts a possibly deeply-embedded list to a single level
;;; of embedding
;;;
;;; assumes: parag-list is in fact a list
;;;
;;; example: 
;;;  (((A)) (B K  (C D  (E)  F)  G H) ((((I)))) ((J)))) -->
;;;  ( (A)  (B K) (C D) (E) (F) (G H)    (I)     (J)  )
;;;
;;; rationale: even though B, K, G, and H are at the same levels
;;;            in the text tree, because paragraphs were created
;;;            between K and G, G must begin a new paragraph
;;;
;;; also removes non-viewpoint elements

(defun parag-flatten (parag-list)
  (cond ((null parag-list) nil)
	((flat-list-p parag-list)
	 (let ((list-with-only-views (remove-if-not #'viewpoint-p parag-list)))
	   (if list-with-only-views
	       (list list-with-only-views))))
	(t
	 ;;parag-list has at least one embedding
	 (let ((up-to-embedding (get-up-to-embedded-list parag-list))
	       (first-embedding (get-first-embedded-list parag-list)) 
	       (after-embedding (get-after-embedded-list parag-list)))
	   (append (if up-to-embedding
		       (list up-to-embedding))
		   (parag-flatten first-embedding)
		   (parag-flatten after-embedding))))))


;;; returns t iff the-list has no embedded sub-lists
;;; assumes the-list is a list
(defun flat-list-p (view-list)
  (notany #'listp
	  view-list))


;;; given: a non-null list that includes at least one embedded list
;;;
;;; returns: list of atomic elements up to but not including
;;;          the first embedded-list
;;;
;;; example: (a b c (d e (f g)) h i) --> (a b c)
;;;
;;; also removes non-viewpoint elements
;;;
(defun get-up-to-embedded-list (list-with-embedding)
  (if list-with-embedding   ; J.L. added this check 6-24-94
      (let ((first-elem (first list-with-embedding)))
	(if (atom first-elem)
	    (if (viewpoint-p first-elem)
		(cons first-elem
		      (get-up-to-embedded-list (rest list-with-embedding)))
		(get-up-to-embedded-list (rest list-with-embedding)))))))


;;; given: a non-null list that includes at least one embedded list
;;;
;;; returns: first embedded-list
;;;
;;; example: (a b c (d e (f g)) h i) --> (d e (f g))
;;;
(defun get-first-embedded-list (list-with-embedding)
  (let ((first-element (first list-with-embedding)))
    (if (listp first-element)
	first-element
	(get-first-embedded-list (rest list-with-embedding)))))


;;; given: a non-null list that includes at least one embedded list
;;;
;;; returns: list of elements beginning with embedded list
;;;
;;; example: (a b c (d e (f g)) h i) --> (h i)
;;;
(defun get-after-embedded-list (list-with-embedding)
  (let ((first-element (first list-with-embedding)))
    (if (listp first-element)
	(rest list-with-embedding)
	(get-after-embedded-list (rest list-with-embedding)))))


;-----------------------------------------------------------------------
;			EDP Organization Checking
;-----------------------------------------------------------------------

;;;      - rules: (1) the root of every EDP must have a value for either the
;;;                   paragraph-structure slot or the paragraphize-children?
;;;                   slot
;;;
;;;               (2) any unit in the EDP that has subtopics may
;;;                   have a value for the paragraph-structure slot
;;;
;;;               (3) any other unit in the EDP (except for
;;;                   content-specifications) that has subtopics
;;;                   may have a value for the paragraphize-children? slot
;;;    
;;;               (4) any unit that has a value for the paragraph-structure
;;;                   slot must satisfy the following criteria:
;;;                       the order of the units in ``flattened''
;;;                       paragraph-structure list must be the same
;;;                       as the order of the units in the organization
;;;                       specification in that unit, the units mentioned
;;;                       must be exactly the same in 3 lists:
;;;                            - the ``topic-list'' slot,
;;;                            - the ``organization'' slot
;;;                            - the paragraph-structure slot
;;;
;;;     - advice: if encounter error, then after fix it, need to rerun to
;;;               check for other errors


(defun check-organization (edp)
  (let ((top-unit-problem? (check-top-unit edp)))
    (if top-unit-problem?
	top-unit-problem?
	(check-topic-units (get-local (list edp 'topic-list))))))


;-----------------
;;; traverses EDPs
;-----------------


;;; returns (problem <edp-unit> <type>) if there is a problem
;;; if no problem, then returns nil
;;;
(defun check-top-unit (edp-unit)
  (let ((organization-problem?
	 (check-org-spec edp-unit
			 'topic-list
			 'inter-topic-organization-specification))
	(paragraphize-children? 
	 (get-local (list edp-unit 'paragraphize-children?)))
	(paragraph-structure 
	 (get-local (list edp-unit 'paragraph-structure))))
    (cond (organization-problem?
	   (signal-org-error edp-unit 'illegal-organization-spec))
	  ((and (null paragraphize-children?)
		(null paragraph-structure))
	   (signal-org-error edp-unit 'no-paragraph-info))
	  (paragraph-structure
	   (let ((parag-results
		  (check-paragraph-structure
		   edp-unit
		   'inter-topic-organization-specification)))
	     (if parag-results
		 (signal-org-error edp-unit 'illegal-parag-info))))
	  (t nil))))


(defun check-topic-units (topic-units)
  (if topic-units
      (let* ((first-unit (first topic-units))
	     (topic-unit-problem? (check-topic first-unit)))
	(if topic-unit-problem?
	    topic-unit-problem?
	    (check-topic-units (rest topic-units))))))


;;; checks topic-unit locally
;;; if there is a problem reports it
;;; otherwise, checks children of topic-unit
;;; returns (problem <problem-unit> <problem-type>) if there is a problem
;;;
(defun check-topic (topic-unit)
  (let* ((organization-problem?
	  (check-org-spec topic-unit
			  'content-specifications
			  'intra-topic-organization-specification))
	 (paragraph-structure 
	  (get-local (list topic-unit 'paragraph-structure)))
	 (parag-problem?
	  (if paragraph-structure
	      (check-paragraph-structure
	       topic-unit
	       'intra-topic-organization-specification))))
    (cond (organization-problem?
	   (signal-org-error topic-unit 'illegal-organization-spec))
	  ((and paragraph-structure
		parag-problem?)
	   (signal-org-error topic-unit 'illegal-parag-info))	   
	  (t (check-content-specification-units
	      (get-local (list topic-unit 'content-specifications)))))))


(defun check-content-specification-units (content-specifications)
  (if content-specifications
      (let* ((first-unit (first content-specifications))
	     (content-specification-problem? (check-content-spec first-unit)))
	(if content-specification-problem?
	    content-specification-problem?
	    (check-content-specification-units
	     (rest content-specifications))))))


;;; note: a content-specification may have 2 kinds of children:
;;;                 - content-specifications (for iteration)
;;;                 - elaborations
;;;       but it may have only one of these two types because
;;;       if it's iterative, it will only have content-specifications,
;;;       and if it's not iterative, it will either have elaborations
;;;       or no value on either slot; if it's iterative, no need to
;;;       check organization-specification
;;;
(defun check-content-spec (content-specification)
  (let* ((has-nested-specifications?
	  (has-content-specifications-p content-specification))
	 (elaborations
	  (retrieve-elaborations content-specification))
	 (organization-problem?
	  (if elaborations
	      (check-org-spec content-specification
			      'elaborations
			      'inter-elaboration-organization-specification)))
	 (paragraph-structure 
	  (if elaborations
	      (get-local (list content-specification 'paragraph-structure))))
	 (parag-problem?
	  (if paragraph-structure
	      (check-paragraph-structure
	       content-specification
	       'inter-elaboration-organization-specification))))
    (cond (organization-problem?
	   (signal-org-error content-specification
			     'illegal-organization-spec))
	  ((and paragraph-structure
		parag-problem?)
	   (signal-org-error content-specification
			     'illegal-parag-info))
	  (has-nested-specifications?
	   (check-content-spec has-nested-specifications?))
	  (elaborations
	   (check-elaboration-units elaborations))
	  (t nil))))


;;; returns nested spec iff content-specification has nested
;;; otherwise nil
;;; assumes at most one nested spec 
(defun has-content-specifications-p (content-specification)
  (get-only-val (list content-specification 'content-specifications)))


;;; returns elaborations iff content-specification has elaborations
;;; otherwise nil
(defun retrieve-elaborations (content-specification)
  (get-local (list content-specification 'elaborations)))


(defun check-elaboration-units (elaboration-units)
  (if elaboration-units
      (let* ((first-unit (first elaboration-units))
	     (elab-unit-problem? (check-elaboration first-unit)))
	(if elab-unit-problem?
	    elab-unit-problem?
	    (check-elaboration-units (rest elaboration-units))))))


;;; checks elaboration unit locally
;;; if there is a problem reports it
;;; otherwise, checks children of elaboration
;;; returns (problem <problem-unit> <problem-type>) if there is a problem
;;;
(defun check-elaboration (elaboration-unit)
  (let* ((organization-problem?
	  (check-org-spec elaboration-unit
			  'content-specifications
			  'intra-elaboration-organization-specification))
	 (paragraph-structure 
	  (get-local (list elaboration-unit 'paragraph-structure)))
	 (parag-problem?
	  (if paragraph-structure
	      (check-paragraph-structure
	       elaboration-unit
	       'intra-elaboration-organization-specification))))
    (cond (organization-problem?
	   (signal-org-error elaboration-unit 'illegal-organization-spec))
	  ((and paragraph-structure
		parag-problem?)
	   (signal-org-error elaboration-unit 'illegal-parag-info))	   
	  (t (check-content-specification-units
	      (get-local (list elaboration-unit 'content-specifications)))))))


;---------------------------------------------------
;;; checks organization and paragraph specifications
;---------------------------------------------------

;;; returns t if there is a problem
;;; otherwise returns nil
;;;
;;; an EDP unit must satisfy the following criteria:
;;; the units in two lists must be the same
;;;                            - the ``organization'' slot
;;;                            - the paragraph-structure slot
;;;
(defun check-org-spec (edp-unit child-slot organization-slot)
  (let* ((child-list
	  (get-local (list edp-unit child-slot)))
	 (organization-list 
	  (get-local (list edp-unit organization-slot))))
    (not (sets-are-equal child-list organization-list))))


;;; returns t if there is a problem
;;; otherwise returns nil
;;;
;;; any unit that has a value for the paragraph-structure slot must
;;; satisfy the following criteria:
;;;                       the order of the units in ``flattened''
;;;                       paragraph-structure list must be the same
;;;                       as the order of the units in the organization
;;;                       specification in that unit, the units mentioned
;;;                       must be exactly the same in 2 lists:
;;;                            - the ``organization'' slot
;;;                            - the paragraph-structure slot
;;;
(defun check-paragraph-structure (edp-unit organization-slot)
  (let* ((organization-list 
	  (get-local (list edp-unit organization-slot)))
	 (paragraph-structure 
	  (get-local (list edp-unit 'paragraph-structure)))
	 (flattened-paragraph-structure
	  (flatten paragraph-structure)))
    (not (equal organization-list
		flattened-paragraph-structure))))


(defun sets-are-equal (set1 set2)
  (and (subsetp set1 set2 :test #'equal)
       (subsetp set2 set1 :test #'equal)))


(defun signal-org-error (edp-unit error-type)
  (list 'problem edp-unit error-type))

ewpoint-p first-elem)
		(cons first-elem
		      (get-up-to-embedded-list (rest list-with-embedding)))
		(get-up-to-embedded-list (rest list-with-embedding)))))))


;;; given: a non-null list that includes at least one embedded list
;;;
;;; returns: first embedded-liload-vr.lisp                                                                                        000775  006350  001440  00000000403 05641657625 014714  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         (in-package 'km)

(load "/v/sage/v1/lester/Planner/EDP/Implementation/bruce-km-extensions.lisp")

(cd "/v/sage/v0/brewery/kastl/James")

(load "replaces-annot")
;(load "constraints")
(load "sweep")
(load "search")
(load "retrieve")
(load "replaces-annot")



ation-units))
	     (elab-unit-problem? (check-elaboration first-unit)))
	(if elab-unit-problem?
	    elab-unit-problem?
	    (check-elaboration-units (rest elaboration-units))))))


;;; checks elaboration unit locally
;;; if there is a problem reports load.lisp                                                                                           000775  003117  001440  00000002275 05641657625 013733  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:CL-User; Base:10 -*-


;;; Load the Knight system.
;;; Compiles, loads binaries, or loads source, as selected.

(in-package :cl-user)

(defun  MAKE-KNIGHT ()

  "Make system KNIGHT."
  (let ((action (get-action)))
    (when action
      (compile?-load action *knight-directory*
	;; KM Extension Files
	;; ------------------
	"bruce-and-my-replaces-annot"
	"bruce-and-my-km-extensions"
	"my-km-extensions"
	;; File below commented out because of all of the overwriting
	;; definitions.  If this works, then just get rid of next
	;; line.  These functions appear to all be in
	;; /v/sage/v0/brewery/km/general-utilities.lisp
	;;"prompts"
	
	;; Search File
	;; -----------
	"bruce-and-my-search"
	
	;; View Retriever File
	;; -------------------
	"bruce-and-my-retrieve"
	
	;; Knight
	;; ------
	"user-model"
	"tracers"
	"global-variable-manip"
	"plan-node-functions"
	"error-predicates"
	"evaluation"
	"reports"
	"initialization"
	"instantiate-templates"
	"focus-function-eval"
	"kb-filter"
	"kb-access"
	"linearize"
	"realize"
	"organization"
	"content-determination"
	"applier-top-level"
	"explain"
	))))

(MAKE-KNIGHT)

(unless (member :knight *features*)
  (push :knight *features*))
arag-problem?)
	   (signal-org-error elaboration-unit 'illegal-parag-info))	   
	  (t (check-content-specification-units
	      (get-local (list elaboration-unit 'content-specifications)))))))


;---------------------------------------------------
;;; checks organization and paragraph specifications
;---------------------my-km-extensions.lisp                                                                               000775  003117  001440  00000004047 05641657625 016242  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;			       Extensions To KM
;;;			       ----------------


(in-package 'km)

	    
(defun process-p (concept)
  (member 'process (ancestry* concept)))


(defun object-p (concept)
  (member 'object (ancestry* concept)))


(defun slot-p (concept)
  (member 'slot (ancestry* concept)))


;;; returns t iff slot is an actor slot
(defun actor-slot-p (slot)
  (when (member 'actors (ancestry* slot))
    t))


(defun viewpoint-p (concept)
  (member 'viewpoint (ancestry* concept)))


;;;function for (non-recursively) removing all children of given unit 
(defun remove-all-children (parent)
  "Removes all specializations and instances from given unit"
  (dolist (frame (get-local (list parent 'specializations)))
    (remove-frame frame))
  (dolist (frame (get-local (list parent 'instances)))
    (remove-frame frame)))


;;;function for computing all progeny of all slots in a unit 
(defun compute-all-progeny (slot-list)
  (reduce #'append
	  (mapcar #'(lambda (slot)
		      (progeny* slot))
		  slot-list)))



#||  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; retrieves only value in a get-local
(defun get-only-val (addr)
  (first (get-local addr)))


;;; Address Extension Functions
;;; ---------------------------
;;;
;;; These functions do not check whether the extended address is
;;; well-formed (i.e. that the extensions are legal for the address and
;;; that the extended-address exists in the kb).

;;; extend an address with a slot
(defun extend-address (address extension)
  (child address extension))


;;; extend an address with an arbitrary number of slots and values  
(defun extend-address-indefinitely (address val &rest vals)
  (append (listify address) (list val) vals))


;;; Filtered Get-Explicit-Slots
;;; ---------------------------

;;; returns all local slots on concept - except for notation
;;; slots such as bookkeeping slots and the english slot
(defun get-explicit-slots (concept)
  (set-difference (all-explicit-slots-on-embedded-unit concept)
		  (progeny* 'notation-slots)))


||#ist organization-list))))


;;; returns t if there is a problem
;;; otherwise returns nil
;;;
;;; any unit that has a value for the paragraph-structure slot must
;;; satisfy the following criteria:
;;;                       the order of the units in ``flattened''
;;;                       paragraph-structure list must be the same
;;;                       as the order of the units in the organization
;;;                       specification in that unit, the units mentiold-aux-content-determ.lisp                                                                         000775  006350  001440  00000141740 05641657625 017661  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		 The Auxiliary Content Determination Functions
;;;;		 ---------------------------------------------


;;;; These are the functions used by the EDPs for content determination.
;;;;
;;;;
;;;; What's Returned
;;;; ---------------
;;;; Often a list is returned; for compatibility with KM, this is
;;;; first turned into a list of a list before it is returned; hence,
;;;; the entire desired list will be put as a single value on the
;;;; kb-subgraph slot of a content node
;;;;
;;;;
;;;; Error Handling
;;;; --------------
;;;; They include methods for reporting errors encountered during
;;;; execution.  In general, during content determination, if an
;;;; error is found, the function returns a pair of the form:
;;;;          (error <error-type>)
;;;;
;;;; The error handler of the EDP Applier will record the error type
;;;; in the Explanation Plan and act appropriately.  Typically, the
;;;; Applier will omit the intended content.
;;;;
;;;;
;;;; User Modeling Issues
;;;; --------------------
;;;; Some functions exploit the user model.  When the user modeling
;;;; facility is off, these functions behave differently.  They
;;;; take the approach of doing whatever is the ``right thing''
;;;; without regard to what might have been in the user model, e.g.,
;;;; when finding a reference concept, the function merely finds
;;;; an immediate genl of the given concept, rather than the most
;;;; specific concept that was familiar to the user.  (See the header
;;;; of the User Model functions file for additional information.)
;;;;
;;;;
;;;; Consider Doing Later: Dealing with Implicit Units in Code
;;;; ---------------------------------------------------------
;;;; Consider revising all content determination functions to deal with
;;;; values that are addresses, e.g., when climbing up in Connect-to-Core
;;;; the code treats all values though they are units (like asking
;;;; is-known-p, is-core-p, but actually values might be addresses;
;;;; one superevent of Stem-Cortex-Generation is
;;;;             (Development subevents Generation)


(in-package 'km)


;-----------------------------------------------------------------------
;			Collect-Causal-Agent-Processes
;-----------------------------------------------------------------------

;;; arguments: Content-Node with Causal-Agent-Viewpoint
;;;
;;; goes through causal agent viewpoint to find processes
;;; which the current process affects
;;;
;;; basic-dimension: Causal-Agent
;;;
;;; can test with:
;;;                Enables: <No non-embedded processes>
;;;                Facilitates: <None>
;;;                Inhibits: <None>
;;;                Causes: Guard-Cell-Collapse, Plant-Water-Loss
;;;
;;; returns (a list of a) list of processes
;;;
;;; errors:
;;;		- condition: no content node exists
;;;		- returns: (error no-content-node)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint)
;;;
;;;		- condition: viewpoint exists, but error
;;;		- returns: (error problem-viewpoint)
;;;
;;;		- condition: viewpoint exists, but no processes
;;;		- returns: (error no-processes)

(defun collect-causal-agent-processes (content-node)
  (if (null content-node)
      '((error no-content-node))
      (let ((the-viewpoint (get-only-val (list content-node
					       'kb-subgraph))))
	(cond ((null the-viewpoint)
	       '((error no-viewpoint)))
	      ((content-node-has-error? content-node)
	       '((error problem-viewpoint)))
	      (t (let* ((slot-list (get-local '(causal-agent
						dimension-of-slots)))
			(processes (get-processes-on-slots the-viewpoint
							   slot-list)))
		   (if (null processes)
		       '((error no-processes))
		       (list processes))))))))


;;; returns all values on unit that appear on some slot in slot-list
;;; and are specs of process
(defun get-processes-on-slots (unit slot-list)
  (remove-duplicates
   (reduce #'append
	   (mapcar #'(lambda (slot)
		       (let ((values (get-local (list unit slot))))
			 (reduce #'append
				 (mapcar #'(lambda (value)
					     (if (member 'process
							 (ancestry* value))
						 (list value)))
					 values))))
		   slot-list))
   :test 'equal))


;-----------------------------------------------------------------------
;		     Collect-Causal-Facilitating-Processes
;-----------------------------------------------------------------------

;;; arguments: Content-Node with Causal-Facilitating-Viewpoint
;;;
;;; goes through causal facilitating viewpoint to find processes
;;; which facilitate or cause the current process
;;;
;;; basic-dimension: Modulatory-Facilitators
;;;
;;; can test with:
;;;                Caused-by: Plant-water-stress, Plant-water-loss,
;;;                           Stoma-closing-sequence, Guard-Cell-Collapse
;;;                Facilitated-by: <None>
;;;
;;; returns (a list of a) list of processes
;;;
;;; errors:
;;;		- condition: no content node exists
;;;		- returns: (error no-content-node)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint)
;;;
;;;		- condition: viewpoint exists, but error
;;;		- returns: (error problem-viewpoint)
;;;
;;;		- condition: viewpoint exists, but no processes
;;;		- returns: (error no-processes)

(defun collect-causal-facilitating-processes (content-node)
  (if (null content-node)
      '((error no-content-node))
      (let ((the-viewpoint (get-only-val (list content-node
					       'kb-subgraph))))
	(cond ((null the-viewpoint)
	       '((error no-viewpoint)))
	      ((content-node-has-error? content-node)
	       '((error problem-viewpoint)))
	      (t (let* ((slot-list (get-local '(modulatory-facilitators
						dimension-of-slots)))
			(processes (get-processes-on-slots the-viewpoint
							   slot-list)))
		   (if (null processes)
		       '((error no-processes))
		       (list processes))))))))


;-----------------------------------------------------------------------
;			 Collect-Inhibiting-Processes
;-----------------------------------------------------------------------

;;; arguments: Content-Node with Causal-Inhibiting-Viewpoint
;;;
;;; goes through causal inhbiting viewpoint to find processes
;;; which inhibits the current process
;;;
;;; basic-dimension: Modulatory-Inhibitors
;;;
;;; can test with:
;;;                Inhibited-By: <none>
;;;
;;; returns (a list of a) list of processes
;;;
;;; errors:
;;;		- condition: no content node exists
;;;		- returns: (error no-content-node)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint)
;;;
;;;		- condition: viewpoint exists, but error
;;;		- returns: (error problem-viewpoint)
;;;
;;;		- condition: viewpoint exists, but no processes
;;;		- returns: (error no-processes)

(defun collect-inhibiting-processes (content-node)
  (if (null content-node)
      '((error no-content-node))
      (let ((the-viewpoint (get-only-val (list content-node
					       'kb-subgraph))))
	(cond ((null the-viewpoint)
	       '((error no-viewpoint)))
	      ((content-node-has-error? content-node)
	       '((error problem-viewpoint)))
	      (t (let* ((slot-list (get-local '(modulatory-inhibitors
						dimension-of-slots)))
			(processes (get-processes-on-slots the-viewpoint
							   slot-list)))
		   (if (null processes)
		       '((error no-processes))
		       (list processes))))))))


;-----------------------------------------------------------------------
;				Collect-Actors
;-----------------------------------------------------------------------

;;; arguments: Content Node with Black-box-view
;;;
;;; searches through the Black box view to find the actor slots
;;; 
;;; seaches through the values on these slots to return the actors
;;; 
;;; returns a list of actors
;;;
;;; errors:
;;;             - condition: no content node exists
;;;             - returns: (error no-content-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;                          with black-box view
;;;             - returns: (error error-in-node-with-black-box-view)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-viewpoint-in-content-node)
;;;
;;;		- condition: viewpoint exists, but no actors
;;;		- returns: (error no-actor-slots-on-viewpoint)

(defun collect-actors (content-node)
  (cond ((null content-node)
	 '((error no-content-node)))
	((content-node-has-error? content-node)
	 '((error error-in-node-with-black-box-view)))
	(t (let ((viewpoint
		  (get-only-val (list content-node 'kb-subgraph))))
	     (if (null viewpoint)
		 '((error no-viewpoint-in-content-node))
		 (let ((actor-slots (collect-actor-slots viewpoint)))
		   (if (null actor-slots)
		       '((error no-actor-slots-on-viewpoint))
		       (collect-all-values-on-slots viewpoint
						    actor-slots))))))))


(defun collect-actor-slots (viewpoint)
  (let ((slots-with-values (all-explicit-slots viewpoint)))
    (remove-if-not #'is-actor-slot-p
		   slots-with-values)))


(defun is-actor-slot-p (slot)
  (member 'actors (ancestry* slot)))


;;; returns list of all values that appear on some slot in
;;; slot-list on frame
;;;
;;; Important note: mapcan is *not* used below and should
;;;                 not be used anywhere in the code because
;;;                 it nconc's some structures in the KB,
;;;                 sometimes creating circular structures
;;;                 that cause KM to go into infinite recursion

(defun collect-all-values-on-slots (frame slot-list)
  (remove-duplicates
   (reduce #'append
	   (mapcar #'(lambda (slot) (get-local (list frame slot)))
		   slot-list))))


;-----------------------------------------------------------------------
;				Connect-To-Core
;-----------------------------------------------------------------------

;;; arguments: Origin
;;;
;;; called from Process-Significance
;;;
;;; finds connection from Origin to either (1) a process that 
;;; is marked ``core'' in the knowledge base, or (2) a process 
;;; that is known to the user and is on the search path to a
;;; core process, or (3) the unit ``Process'' is reached, which
;;; is an error
;;;
;;; assumes that if unit has a value on core? then the unit is
;;; a core process
;;;
;;; first climbs up superevents and then climbs up generalizations
;;;
;;; assumes if user knows a process, he knows the relation of that
;;; process to a core process (if at the begining of a session
;;; the user is told about all core processes, or if it is
;;; known that he knows about all core processes, then this
;;; assumption is true by induction)
;;;
;;; if a process has more than one superevent or more than one
;;; generalization, the first one is chosen (arbitrarily)
;;;
;;; errors:
;;;		- note: all errors involve failing to find either
;;;                     a core process or a familiar process;
;;;                     there are 2 basic cases: during the
;;;                     superevent ascent and during the genl
;;;                     ascent
;;;
;;;		- condition: climb up superevents yields deadend,
;;;                          i.e., superevents lead up to unit 
;;;                          ``Process''
;;;		- returns: (error super-event-search-dead-ended)
;;;
;;;		- condition: cannot find a genl
;;;		- returns: (error no-known-or-core-genl-available)
;;;
;;;	- Note: the system will later need to decide whether to
;;;       talk about the ``destination'' process, i.e, the unit
;;;       at which the search terminated; 
;;;
;;;		- one way of making this decision would be for
;;;               the kb-access function to return a pair, where
;;;               the first item in the pair is either the atom
;;;               ``core'' to indicate that the search terminated 
;;;               at a core process, or ``known'' to indicate that the 
;;;               search terminated at a process that is familiar to the
;;;               user; the second item in the pair would have been
;;;               the list
;;;
;;;			- problem: this information about whether the
;;;                       process is known or core is needed to make
;;;                       the decision about whether to have an
;;;                       elaboration or not about the ``destination'';
;;;                       however, things will be much cleaner if the
;;;                       focus conditions of the elaboration look this
;;;                       up themselves in the KB
;;;
;;;		        - principle: don't return anything in KB-access
;;;                                  except the content itself
;;;
;;; Some cases:
;;;      (1)  known-or-core process is origin
;;;      (2)  known-or-core process is superevent
;;;      (2') superevent climb dead-ends
;;;      (3)  known-or-core process is genl
;;;      (4)  known-or-core process is an all genl of an all-superevent
;;;      (4') genl climb dead-ends
;;;
;;; returns (a list of) a list: the first item in the list is the
;;; unit at which the search terminated, the next 
;;; item in the list is the slot that connects the 
;;; units in the search path, the next item is the 
;;; penultimate unit in the search, etc., until the 
;;; final item in the list which is the origin


(defun connect-to-core (origin)
  (let* ((super-event-result (climb-super-events origin))
	 (destination-type (first super-event-result))
	 (sub-event-path (second super-event-result)))
    ;(format t "Sub-event-path: ~a~%" sub-event-path)
    (case destination-type
      (error '((error super-event-search-dead-ended)))
      (known-or-core (list sub-event-path))
      (not-known-or-core
       (let* ((genls-result (climb-genls (first sub-event-path)))
	      (final-destination-type (first genls-result))
	      (genls-path (second genls-result)))
	 ;(format t "Genls-path: ~a~%" genls-path)
	 (case final-destination-type
	   (error '((error no-known-or-core-genl-available)))
	   (path-found (list (append genls-path
				     (cdr sub-event-path))))))))))


;;; climbs super-events until encounters either (1) a process that
;;; is marked ``core'' in the knowledge base or (2) a process 
;;; that is known to the user
;;;
;;; if user modeling is off, only considers core processes
;;;
;;; returns a list of the form
;;; where <destination-type> is either 'known-or-core or 'not-known-or-core    
;;; or 'error, and <path> is a list of the form
;;;    (destination 'sub-event p(n-1) 'sub-event ... 'sub-event origin)
;;; or nil if <destination-type> is 'error

(defun climb-super-events (origin)
  (let* ((result (climb-super-events-aux origin))
	 (last-of-result (first (last result))))
    (cond ((equal last-of-result 'error)
	   (list 'error nil))
	  ((or (and (user-modeling-on?) (is-known-p last-of-result))
	       (is-core-p last-of-result))
	   (list 'known-or-core (reverse result)))
	  (t (list 'not-known-or-core (reverse result))))))


;;; climbs up super-events
;;;
;;; assumes an event has at most 1 (direct) super-event (in fact,
;;; this is not always true, and code may someday need to be revised
;;; to reflect this
;;;
;;; returns a list of the form
;;;    (origin 'sub-event p1 'sub-event ... 'sub-event destination)
;;; where destination is either the destination process or 'error

(defun climb-super-events-aux (origin)
  ;(format t "Considering in climb-super-events-aux ~a~%" origin)
  (cond ((or (and (user-modeling-on?) (is-known-p origin))
	     (is-core-p origin))
	 (list origin))
	((equal origin 'process)
	 (list 'error))
	(t (let ((superevent (first (get-local (list origin 'superevents)))))
	     (if (null superevent)
		 (list origin)
		 (cons origin
		       (cons 'subevent
			     (climb-super-events-aux superevent))))))))


;;; climbs genl's until encounters either (1) a process that
;;; is marked ``core'' in the knowledge base or (2) a process 
;;; that is known to the user, or (3) no known or core process
;;; is encountered
;;;
;;; if user modeling is off, only considers core processes
;;;
;;; returns a pair of the form: (<destination-type> <path>)
;;; where <destination-type> is either 'error or 'path-found,
;;; and <path> is a list of the form
;;; (pn 'spec p(n-1) 'spec ... 'spec origin)
;;; or nil if <destination-type> is error

(defun climb-genls (origin)
  (let ((result (climb-genls-aux origin nil)))
    (if (null result)
	(list 'error nil)
	(list 'path-found (reverse result)))))


;;; performs a depth-first up the taxonomy
;;; 
;;; deals with multiple genl's
;;;
;;; returns list of form:
;;;      (origin 'specialization p1 'specialization p2 'specialization ...
;;;              'specialization destination)
;;; or nil

(defun climb-genls-aux (origin genls-already-considered)
  ;(format t "Considering in climb-genls-aux ~a~%" origin)
  (cond ((or (and (user-modeling-on?) (is-known-p origin))
	     (is-core-p origin))
	 (list origin))
	((equal origin 'content-frame)
	 nil)
	(t (let* ((new-genls (get-local (list origin 'generalizations)))
		  (actual-genls (set-difference new-genls
						genls-already-considered)))
	     (if (not (null actual-genls))
		 (do* ((remaining-genls actual-genls
					(cdr remaining-genls))
		       (first-remaining-genl (first remaining-genls)
					     (first remaining-genls))
		       (path (climb-genls-aux
			      first-remaining-genl
			      (cons origin
				    genls-already-considered))
			     (climb-genls-aux
			      first-remaining-genl
			      (cons origin
				    genls-already-considered))))
		      ((or (not (null path))
			   (null remaining-genls))
		       (if (not (null path))
			   (cons origin
				 (cons 'specialization
				       path))))))))))


;-----------------------------------------------------------------------
;			   Find-Destination-Process
;-----------------------------------------------------------------------

;;; arguments: Core-Content-Node
;;;
;;; called from Process-Significance
;;;
;;; looks in content node resulting from Connect-to-core call
;;;
;;; returns first element of the list, which is the destination
;;; of the search that was conducted in Connect-to-core
;;;
;;; errors:
;;;		- condition: no content node exists
;;;		- returns: (error no-content-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;                          with connect-to-core path
;;;             - returns: (error error-in-node-with-connect-to-core)
;;;
;;;             - condition: an error was returned by Connect-to-core
;;;             - returns: (error connect-to-core-failed)

(defun find-destination-process (core-content-node)
  (cond ((null core-content-node)
	 '((error no-content-node)))
	((content-node-has-error? core-content-node)
	 '((error error-in-node-with-connect-to-core)))
	(t (let ((connection-path (get-only-val (list core-content-node
						      'kb-subgraph))))
	     (if (or (null connection-path)
		     (equal (first connection-path) 'error))
		 '((error connect-to-core-failed))
		 (first connection-path))))))

	     
;-----------------------------------------------------------------------
;			  Find-Partonomic-Connection
;-----------------------------------------------------------------------

;;; arguments: Object
;;;
;;; searches up the partonomy from Object to find concept with
;;; which user is familiar
;;;
;;; considers slots other than ``part-of'' that are similar,
;;; e.g., contained-in
;;;
;;; search continues until encounter either (1) a known concept 
;;; (uses function is-known-p) or (2) an elementary concept 
;;; (is-known-p uses function is-elementary-p), or (3) no
;;; familiar concept is encountered and cannot climb higher
;;; in partonomy (an error)
;;;
;;; if user-modeling is not on, returns (1) error if Object has
;;; no super-parts, or (2) first super-part encountered
;;;
;;; performs a breadth-first search up the partonomy (needs to
;;; be breadth-first to ensure that most specific concept in
;;; partonomy is found)
;;;
;;; efficiency addition: keeps ``closed'' list so doesn't exam same
;;;                      node twice
;;;
;;; extra benefit of efficiency addition: no infinite loop on if encounter
;;;                                       circularities in partonomy
;;;
;;; returns that concept at which the search halted
;;;
;;; errors:
;;;		- condition: user modeling is off and object has
;;;                          no super-parts
;;;		- returns: (error no-user-modeling-and-no-super-part)
;;;
;;;		- condition: no familiar concept is encountered and
;;;                          cannot climb higher in partonomy
;;;		- returns: (error no-familiar-super-part)

(defun find-partonomic-connection (object)
  (if (not (user-modeling-on?))
      (let ((super-parts (find-super-parts object)))
	(if (null super-parts)
	    '((error no-user-modeling-and-no-super-part))
	    (first super-parts)))
      (find-part-conn-aux (list object) nil)))


(defun find-part-conn-aux (part-list parts-already-considered)
  (if (null part-list)
      nil
      (let ((first-part (first part-list)))
	;(format t "Considering ~a~%" first-part)
	;(format t "Part list ~a~%" part-list)
	;(format t "Parts already considered ~a~%" parts-already-considered)
	(if (is-known-p first-part)
	    first-part
	    (let* ((super-parts (find-super-parts first-part))
		   (actual-super-parts
		    (set-difference super-parts parts-already-considered)))
	      (find-part-conn-aux (append (cdr part-list)
					  actual-super-parts)
				  (cons first-part
					parts-already-considered)))))))


;;; finds all super-parts of given object; if none, returns nil
;;;
;;; list of parts-slots is stored in:
;;;          (Part-slot-list part-slots-used-by-knight)

(defun find-super-parts (object)
  (let ((parts
	 (do* ((remaining-parts-slots (get-local '(part-slot-list
						   part-slots-used-by-knight))
				      (cdr remaining-parts-slots))
	       (current-slot (first remaining-parts-slots) 
			     (first remaining-parts-slots))
	       (current-values (get-local (list object current-slot))
			       (get-local (list object current-slot)))
	       (super-parts (if (not (null current-values))
				current-values)
			    (if (not (null current-values))
				(append super-parts current-values)
				super-parts)))
	      ((null remaining-parts-slots)
	       super-parts)
	   ;(format t "Remaining parts slots: ~a~%" remaining-parts-slots)
	   ;(format t "Current slot: ~a~%" current-slot)
	   ;(format t "Current values: ~a~%" current-values)
	   ;(format t "Super-parts: ~a~%" super-parts)
	   )))
    (remove-duplicates parts)))


;-----------------------------------------------------------------------
;				 Find-Ref-Conc
;-----------------------------------------------------------------------

;;; arguments: Origin
;;;
;;; searches up the taxonomy from Origin to find concept with
;;; which user is familiar
;;; 
;;; considers slots ``generalizations'', ``instance-of'' and ``stage-of''
;;;
;;; search continues until encounter either (1) a known concept 
;;; (uses function Is-known-p) or (2) an elementary concept 
;;; is-known-p uses function is-elementary-p), or (3) no
;;; familiar concept is encountered (this is an error)
;;;
;;; performs a breadth-first search up the taxonomy (needs to
;;; be breadth-first to ensure that most specific concept in
;;; partonomy is found) via the KM function ``ancestry*''
;;;
;;; if user-modeling is not on, returns (1) error if Origin has
;;; no genl's, or (2) first genl encountered
;;;
;;; returns that concept at which the search halted
;;; 
;;; errors:
;;;		- condition: user modeling is off and origin has
;;;                          no genls
;;;		- returns: (error no-user-modeling-and-no-genl)
;;;
;;;		- condition: no familiar concept is encountered and
;;;                          cannot climb higher in taxonomy
;;;		- returns: (error no-familiar-generalizations)

(defun find-ref-conc (origin)
  (if (not (user-modeling-on?))
      (let ((genls (get-local (list origin 'generalizations))))
	(if (null genls)
	    '((error no-user-modeling-and-no-genl))
	    (first genls)))
      (do* ((remaining-ancestors (ancestry* origin)
				 (cdr remaining-ancestors))
	    (current-concept (first remaining-ancestors)
			     (first remaining-ancestors))
	    (current-concept-known? (is-known-p current-concept)
				    (is-known-p current-concept)))
	   ((or current-concept-known?
		(null remaining-ancestors))
	    (if current-concept-known?
		current-concept
		;; search has exhausted remaining actors
		'((error no-familiar-generalizations))))
	;(format t "Considering concept: ~a~%" current-concept)
	)))


;-----------------------------------------------------------------------
;			      Find-Subevent-Order
;-----------------------------------------------------------------------

;;; arguments: Process
;;;
;;; obtains list of Process.subevents
;;;
;;; examines temporal constaints such as occurs-before and
;;; occurs-after to find the temporal order of the subevents
;;;
;;; assumes that knowledge engineer put in as specific info as possible
;;;
;;; if temporal information is missing, orders subevents arbitrarily
;;;
;;; Ordering-relation slots in KB: (slots considered in algorithm are *'d)
;;;        - starts-before             *
;;;        - starts-after              *
;;;        - occurs-after              *
;;;        - occurs-before             *
;;;        - contiguous-with           (too weak)
;;;             - contiguous-before    *
;;;             - contiguous-after     *
;;;        - overlaps-start            *
;;;        - overlaps-end              *
;;;        - coincidental-with         *
;;;        - co-terminal-with          (no clue about which starts first)
;;;        - contains-temporal         *
;;;        - co-originating-with       *
;;;        - occurs-within             *
;;;
;;; this algorithm is *not* intended to be a sound and complete temporal
;;; reasoner; its goal is merely to provide a general guide for ordering
;;; subevents in a discourse, so unsound reasoning is allowed, e.g.,
;;; if we have (i starts-before j), we conclude (i before j); though
;;; we do not know that i ends before j begins, it makes more sense
;;; to discuss i before j; in general, the heuristic is to place event-i
;;; before event-j if event-i begins before event-j begins
;;;
;;; Algorithm
;;; ---------
;;;
;;;   (1) Find all ordering relations between all subevents
;;;
;;;   (2) Map kb temporal relations to discourse temporal relations
;;;
;;;   (3) Condense discourse temporal relations to list of form
;;;
;;;            (event-item-1 event-item-2 ... event-item-n)
;;;
;;;       which indicates order of event beginnings;
;;;
;;;       An event-item is a pair of the form 
;;;
;;;            ((same-as event-i event-j ...) (contains event-k event-l ...))
;;;
;;;       where the same-as component can contain one or more events and
;;;       the contains component may contain be empty except for the
;;;       keyword `contains.''
;;;      
;;;       Note that only one level of containment can be accounted for
;;;       by this scheme.  It is assumed that if there were multiple levels,
;;;       the events wouldn't have all been made subevents of the same
;;;       event in the first place.
;;;
;;;       Special conditions:
;;;         - condition:  elements appear in list twice
;;;           action:     remove second occurrence
;;;
;;;         - condition:  some elements left over
;;;           action:     place (arbitrarily) at end
;;;
;;;         - if neither of special conditions hold, and all elements
;;;           in the ordered-list constructed in (3) are related to
;;;           one another, then a total order has been achieved
;;;
;;;   (4) Flatten structured list, i.e., construct an unnested list
;;;       by reading left-to-right in structured list
;;;
;;; returns (a list of a) the flat list described above
;;;
;;; errors:
;;;		- condition: process has no subevents
;;;		- returns: (error no-subevents)

(defun find-subevent-order (process)
  (let ((subevent-list (get-local (list process 'subevents))))
    (cond ((null subevent-list) '(error no-subevents))
	  ((equal (length subevent-list) 1) (list subevent-list))
	  (t
	   ;; at least 2 subevents
	   (let* ((kb-triples
		   (get-temporal-relation-triples subevent-list))
		  (discourse-triples
		   (map-to-discourse-triples kb-triples))
		  (structured-ordered-elements-results
		   (map-to-ordered-list discourse-triples))
		  (total-order?
		   (first structured-ordered-elements-results))
		  (structured-ordered-elements
		   (second structured-ordered-elements-results))
		  (flattened-ordered-elements
		   (flatten-temporal-structure structured-ordered-elements))
		  (exist-dupe-events? (exist-duplicate-elements?
				       flattened-ordered-elements))
		  (exist-uncovd-events? (exist-uncovered-events?
					 flattened-ordered-elements
					 subevent-list))
		  (final-total-order? (and (equal total-order? 'total-order)
					   (not exist-dupe-events?)
					   (not exist-uncovd-events?))))
	     ;; tests for special conditions
	     ;(format t "Total-order?: ~a~%" total-order?)
	     ;(format t "Discourse-triples:~%")
	     ;(pprint discourse-triples)
	     ;(format t "~%Structured-ordered-elements:~%")
	     ;(pprint structured-ordered-elements-results)
	     ;(format t "~%Flattend-ordered-elements: ~a~%"
	     ;	     flattened-ordered-elements)
	     ;(format t "Dupe-events?: ~a~%" exist-dupe-events?)
	     ;(format t "Uncovd-events?: ~a~%" exist-uncovd-events?)
	     ;(format t "Final-total-order?: ~a~%" final-total-order?)
	     (cond (final-total-order?
                    ;total order					
		    (list flattened-ordered-elements))

		   (exist-dupe-events?
		    ;no total order
		    (list (remove-duplicates flattened-ordered-elements
					     :from-end t)))
		   
		   (exist-uncovd-events?
		    ;no total order
		    (list
		     (append flattened-ordered-elements
			     exist-uncovd-events?)))

		   (t
		    ;no total order
		    (list flattened-ordered-elements))))))))


;;; given a list of events, finds all ordering-relation triples
;;; that relate pairs of events
;;;
;;; for each temporal-relation finds all pairs of events that
;;; are related by that relation
;;;
;;; returns list of form ( ... (event-i temp-relation-p event-j) ... )

(defun get-temporal-relation-triples (event-list)
  (let ((temporal-relation-list
	 (list 'starts-before 'starts-after 'occurs-after 'occurs-before
	       'contigous-before 'contiguous-after
	       'overlaps-start 'overlaps-end 'coincidental-with
	       'contains-temporal 'co-originating-with
	       'occurs-within))
	(triple-list nil))
    (dolist (temporal-relation temporal-relation-list)
      (dolist (event event-list)
	(dolist (value (get-local (list event temporal-relation)))
	  (if (member value event-list)
	      (setf triple-list
		    (push (list event
				temporal-relation
				value)
			  triple-list))))))
    ;(pprint triple-list)
    triple-list))


;;; maps kb temporal relations to discourse temporal relations
;;;
;;;   Mapping
;;;   -------
;;;   KB-Temporal-Relation                  --> Discourse-Temporal-Relation 
;;;
;;;   (event-i starts-before event-j)       --> (event-i before event-j)
;;;   (event-j starts-after event-i)        --> (event-i before event-j)
;;;
;;;   (event-i contiguous-before event-j)   --> (event-i before event-j)
;;;   (event-j contiguous-after event-i)    --> (event-i before event-j)
;;;
;;;   (event-i occurs-before event-j)       --> (event-i before event-j)
;;;   (event-j occurs-after event-i)        --> (event-i before event-j)
;;;
;;;   (event-i overlaps-start event-j)      --> (event-i before event-j)
;;;   (event-j overlaps-end event-i)        --> (event-i before event-j)
;;;
;;;   (event-i contains-temporal event-j)   --> (event-i contains event-j)
;;;   (event-j occurs-within event-i)       --> (event-i contains event-j)
;;;
;;;   (event-i coincidental-with event-j)   --> (event-i same-as event-j)
;;;   (event-i co-originating-with event-j) --> (event-i same-as event-j)

(defun map-to-discourse-triples (kb-triples)
  (mapcar
   #'(lambda (triple) 
       (let ((unit (first triple))
	     (slot (second triple))
	     (value (third triple)))
	 (case slot
	   (starts-before       (list unit  'before   value))
	   (starts-after        (list value 'before   unit))
	   (contiguous-before   (list unit  'before   value))
	   (contiguous-after    (list value 'before   unit))
	   (occurs-before       (list unit  'before   value))
	   (occurs-after        (list value 'before   unit))
	   (overlaps-start      (list unit  'before   value))
	   (overlaps-end        (list value 'before   unit))
	   (contains-temporal   (list unit  'contains value))
	   (occurs-within       (list value 'contains unit))
	   (coincidental-with   (list unit  'same-as  value))
	   (co-originating-with (list unit  'same-as  value)))))
   kb-triples))


;;; condenses discourse temporal relations to list of form
;;;
;;;       (event-item-1 event-item-2 ... event-item-n)
;;;
;;; which indicates order of event beginnings;
;;;
;;; an event-item is a dotted pair of the form 
;;;
;;;       ((same-as event-i event-j ...) . (contains event-k event-l ...))
;;;
;;; where the ``same-as'' component can contain one or more events and the
;;; ``contains'' component may be empty except for the keyword `contains.''
;;;      
;;;       Mapping
;;;       -------
;;;       Discourse-Temporal-Relation --> Ordering
;;;
;;;       (event-i before event-j)  -->
;;;                                  (((same-as event-i)  (contains))
;;;                                   ((same-as event-j)  (contains)))
;;;
;;;       (event-i same-as event-j)  -->
;;;                                  (((same-as event-i event-j) (contains)))
;;;
;;;       (event-i contains event-j) -->
;;;                                  (((same-as event-i) (contains event-j)))
;;;
;;;       Method
;;;       ------
;;;       (a) Eliminate duplicates in discourse temporal relations
;;;       (b) Find all of before-triples, same-as-triples, and contains-triples
;;;       (c) Order before's (considering the same-as information)
;;;       (d) Incorporate the same-as and strip out ``before'' keywords
;;;       (e) Incorporate the contains information

(defun map-to-ordered-list (discourse-triples)
  (let* ((non-redundant-triples (remove-duplicates discourse-triples
						   :test #'equal))
	 (before-triples (find-before-triples non-redundant-triples))
	 (same-as-triples (find-same-as-triples non-redundant-triples))
	 (contains-triples (find-contains-triples non-redundant-triples))
	 (same-as-groups (find-same-as-groups same-as-triples))
	 (ordered-befores-results (impose-before-order before-triples
						       same-as-groups))
	 (total-order? (first ordered-befores-results))
	 (ordered-befores (second ordered-befores-results))
	 (ordered-befores-and-same-as (impose-same-as-order ordered-befores
							    same-as-groups))
	 (ordered-contains (impose-contains-order ordered-befores-and-same-as
						  contains-triples)))
    ;(format t "Before-triples: ~a~%" before-triples)
    ;(format t "Same-as-groups: ~a~%" same-as-groups)
    ;(format t "Ordered-befores:~%")
    ;(pprint ordered-befores)
    ;(format t "~%")
    (list total-order? ordered-contains)))


;;; finds triples in triple-list whose slot is 'before
(defun find-before-triples (triple-list)
  (reduce #'append
	  (mapcar #'(lambda (triple) (if (equal (second triple)
						'before)
					 (list triple)))
		  triple-list)))


;;; finds triples in triple-list whose slot is 'same-as
(defun find-same-as-triples (triple-list)
  (reduce #'append
	  (mapcar #'(lambda (triple) (if (equal (second triple)
						'same-as)
					 (list triple)))
		  triple-list)))


;;; finds triples in triple-list whose slot is 'contains
(defun find-contains-triples (triple-list)
  (reduce #'append
	  (mapcar #'(lambda (triple) (if (equal (second triple)
						'contains)
					 (list triple)))
		  triple-list)))


;;; finds all groups of same-as-elements
;;; returns list of groups
;;; example: original-form: ((a same-as b) (a same-as c) (d same-as e))
;;;          reduced-form:  ((a b) (a c) (d e)
;;;          final-form:    ((a b c) (d e))
(defun find-same-as-groups (same-as-triples)
  (let ((reduced-form-of-triples
	 (mapcar #'(lambda (triple) (list (first triple)
					  (third triple)))
		 same-as-triples)))
    (find-same-as-groups-aux reduced-form-of-triples)))


;;; converts from reduced form of same-as-triples to merged groups
(defun find-same-as-groups-aux (reduced-triples-list)
  (if (null reduced-triples-list)
      nil
      (let ((first-group (first reduced-triples-list))
	    (remaining-groups (rest reduced-triples-list))
	    (remaining-groups-for-iteration (rest reduced-triples-list))
	    (merged? nil))
	(dolist (group remaining-groups-for-iteration)
	  (let ((common-elements (intersection first-group group)))
	    (when (not (null common-elements))
	      (setf first-group (remove-duplicates (append first-group group)))
	      (setf remaining-groups (remove group remaining-groups
					     :test #'equal))
	      (setf merged? t))))
	(if merged?
	    (find-same-as-groups-aux (cons first-group remaining-groups))
	    (cons first-group (find-same-as-groups-aux remaining-groups))))))


;;; imposes order on list of ``before'' triples
;;; considers same-as groups
;;;
;;; examples:
;;;           before-triples: ((a before b)) 
;;;                         --> (a before b)
;;;
;;;           before-triples: ((a before b) (c before d))
;;;                         --> ((a before b) (cd before d))
;;;
;;;           before-triples: ((a before b) (j before c))
;;;           same-as-groups: ((b j))
;;;                         --> ((a before b) (j before c))
;;;
;;; returns pair (<ordering> ordered-list)
;;; where <ordering> is either 'total-order or 'no-total-order

(defun impose-before-order (before-triples same-as-groups)
  (let* ((ordered-triples (sort-triples-and-same-as before-triples
						    same-as-groups))
	 (totally-ordered? (triples-have-total-before-order ordered-triples
							    same-as-groups)))
    (if totally-ordered?
	(list 'total-order ordered-triples)
	(list 'no-total-order ordered-triples))))


;;; sorts before-triples considering same-as-groups
;;;
;;; sort is *not* destructive
;;;
;;; can't just use built in function ``sort'' because not every pair
;;; of triples are directly related to one another by the ``less-than''
;;; ordering
(defun sort-triples-and-same-as (before-triples same-as-groups)
  (if (null before-triples)
      nil
      (let ((least-element (find-least-triple before-triples same-as-groups)))
	(cons least-element
	      (sort-triples-and-same-as (remove least-element
						before-triples)
					same-as-groups)))))


;;; auxilliary function for sort-triples-and-same-as
;;;
;;; note that because there may not necessarily be a total order
;;; possible on the triple-list, there may be several least elements;
;;; one is chosen arbitrarily
;;;
(defun find-least-triple (triple-list same-as-groups)
  (if (equal (length triple-list) 1)
      (first triple-list)
      (let* ((first-triple (first triple-list))
	     (lesser-triple (find-first-earlier-triple first-triple
						       (rest triple-list)
						       same-as-groups)))
	(if (null lesser-triple)
	    first-triple
	    (find-least-triple (rest triple-list) same-as-groups)))))


;;; finds first triple in triple list that is ``less than'' current triple
;;; example: (a before b) is ``less than'' (b before c)
;;;
;;; also considers same-as group info
;;; example: (a before b) is ``less than'' (j before c) if
;;;          (j b) is in the same-as-groups
(defun find-first-earlier-triple (given-triple triple-list same-as-groups)
  (if (null triple-list)
      nil
      (let* ((given-triple-unit (first given-triple))
	     (given-triple-unit-equivs (get-same-as-equivs
					given-triple-unit
					same-as-groups))
	     (current-triple (first triple-list))
	     (current-triple-value (third current-triple))
	     (current-triple-value-equivs (get-same-as-equivs
					   current-triple-value
					   same-as-groups)))
	(if (not (null (intersection given-triple-unit-equivs
				     current-triple-value-equivs)))
	    current-triple
	    (find-first-earlier-triple given-triple
				       (rest triple-list)
				       same-as-groups)))))


;;; determines if element is in one of same-as-groups
;;; if so, returns the group; otherwise returns a list of the element
(defun get-same-as-equivs (element same-as-groups)
  (cond ((null same-as-groups)
	 (list element))
	((member element (first same-as-groups))
	 (first same-as-groups))
	(t (get-same-as-equivs element (rest same-as-groups)))))


;;; determines if triples have total before order
;;; method: checks if every pair of adjacent triples is of form
;;;         (x before y) followed by (y before z) or
;;;         (x before y) followed by (w before z) where
;;;         y and w are in the same same-as group
(defun triples-have-total-before-order (ordered-triples same-as-groups)
  (cond ((null ordered-triples) t)
	((equal (length ordered-triples) 1) t)
	;; have at least 2 triples in list
	(t (let* ((triple1 (first ordered-triples))
		  (value1 (third triple1))
		  (value1-equivs (get-same-as-equivs value1 same-as-groups))
		  (triple2 (second ordered-triples))
		  (unit2 (first triple2))
		  (unit2-equivs (get-same-as-equivs unit2 same-as-groups)))
	     (if (not (null (intersection value1-equivs unit2-equivs)))
		 (triples-have-total-before-order (rest ordered-triples)
						  same-as-groups)
		 nil)))))


;;; incorporates same-as information from same-as triples
;;; into ordered-list of before-triples and strips out ``before'' keywords
;;;
;;; example: converts ((a before b) (j before c) and ((j b)) to
;;;          ((same-as a) (same-as b d e) (same-as c))
(defun impose-same-as-order (ordered-befores same-as-groups)
  (remove-duplicates 
   (reduce #'append
	   (mapcar #'(lambda (before-triple)
		       (let* ((unit (first before-triple))
			      (unit-equivs
                               (cons 'same-as
				     (get-same-as-equivs unit
							 same-as-groups)))
			      (value (third before-triple))
			      (value-equivs
			       (cons 'same-as
				     (get-same-as-equivs value
							 same-as-groups))))
			 (list unit-equivs value-equivs)))
		   ordered-befores))
   :test #'equal
   :from-end t))


;;; incorporates ``contains'' information from ``contains'' triples
;;; into ordered-list with same-as's
;;;
;;; example: ((same-as a) (same-as b d e) (same-as c)) and
;;;          ((c contains g) (d contains f)) to
;;;          (((same-as a) (contains))
;;;           ((same-as b d e) (contains f))
;;;           ((same-as c) (contains g)))

(defun impose-contains-order (ordered-befores-and-same-as contains-triples)
  (mapcar #'(lambda (same-as-element)
	      (let* ((same-as-events (rest same-as-element))
		     (contains-events
		      (find-contains-events same-as-events
					    contains-triples)))
		(if (null contains-events)
		    (list same-as-element
			  (list 'contains))
		    (list same-as-element
			  (cons 'contains
				contains-events)))))
	  ordered-befores-and-same-as))


;;; finds all events in contains-triples that are contained by
;;; some event in same-as-events
(defun find-contains-events (same-as-events contains-triples)
  (reduce #'append
	  (mapcar #'(lambda (event)
		      (let ((contained-events nil))
			(dolist (triple contains-triples)
			  (if (equal event (first triple))
			      (setf contained-events
				    (push (third triple) contained-events))))
			contained-events))
		  same-as-events)))


;;; flattens out ordered list
;;;
;;; converts from structured list to flat list
;;;
;;; example: (((same-as a) (contains))
;;;           ((same-as b d e) (contains f))
;;;           ((same-as c) (contains g))) 
;;;         to
;;;          (a b d e f c g)

(defun flatten-temporal-structure (structured-ordered-elements)
  (reduce #'append
	  (mapcar #'(lambda (element)
		      (let ((same-as-elements (rest (first element)))
			    (contains-elements (rest (second element))))
			(append same-as-elements contains-elements)))
		  structured-ordered-elements)))


;;; returns t if at least one pair of duplicates exists; otherwise nil
(defun exist-duplicate-elements? (flattened-ordered-elements)
  (cond ((null flattened-ordered-elements) nil)
	((member (first flattened-ordered-elements)
		 (rest flattened-ordered-elements))
	 t)
	(t (exist-duplicate-elements? (rest flattened-ordered-elements)))))


;;; determine if some elements are in original-subevent-list that
;;; weren't included in the list flattened-ordered-elements
;;;
;;; if so, returns those elements; otherwise nil

(defun exist-uncovered-events? (flattened-ordered-elements
				original-subevent-list)
  (set-difference original-subevent-list
		  flattened-ordered-elements))


;-----------------------------------------------------------------------
;			    Find-Undiscussed-Actors
;-----------------------------------------------------------------------

;;; arguments: Actor-List
;;;
;;; for each actor in Actor-list, places actor in result
;;; list if actor hasn't been discussed
;;;
;;; uses ``is-known-p'' function
;;;
;;; returns (a list of the) subset of Actor-list where the actors haven't
;;;         yet been discussed
;;;
;;; if user modeling not on, returns entire actor-list
;;;
;;; errors:
;;;		- condition: list of actors is empty
;;;             - returns: (error no-actors)

(defun find-undiscussed-actors (actor-list)
  (cond	((null actor-list)
	 '((error no-actors)))
	((not (user-modeling-on?))
	 (list actor-list))
	(t (list (remove-if #'(lambda (x) (is-known-p x))
			    actor-list)))))


;-----------------------------------------------------------------------
;			     Get-Function-Process
;-----------------------------------------------------------------------

;;; arguments: Object-significance-content-node
;;;
;;; retrieves process which was used in functional description
;;; in this content node
;;; 
;;; currently finds first process on the agent-in slot
;;; of the viewpoint
;;;
;;; later may want to modify to return multiple processes 
;;; (for objects with multiple functions)
;;;
;;; returns the process
;;;
;;; errors:
;;;		- condition: node is empty
;;;		- returns: (error no-significance-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;             - returns: (error error-in-object-significance-node)
;;;
;;;             - condition: no viewpoint exists in content node
;;;             - returns: (error no-viewpoint-in-significance-node)

(defun get-function-process (content-node)
  (cond ((null content-node)
	 '((error no-significance-node)))
	((content-node-has-error? content-node)
	 '((error error-in-object-significance-node)))
	(t (let ((viewpoint
		  (get-only-val (list content-node 'kb-subgraph))))
	     (if (null viewpoint)
		 '((error no-viewpoint-in-significance-node))
		 (get-only-val (list viewpoint 'agent-in)))))))

	
;-----------------------------------------------------------------------
;			   Get-Functional-Processes
;-----------------------------------------------------------------------

;;; arguments: Content Node with Struct-Funct-Viewpoint
;;;
;;; traverses structural-functional viewpoint to obtain list
;;; of processes that are mentioned in the viewpoint
;;;
;;; returns (a list of) list of processes
;;;
;;; errors:
;;;		- condition: node is empty
;;;		- returns: (error no-black-box-functional-iteration-node)
;;;
;;;             - condition: an error has occurred in content
;;;                          determination at content node
;;;             - returns: (error error-in-black-box-functional-iteration-node)
;;;
;;;		- condition: no viewpoint
;;;		- returns: (error no-struct-funct-viewpoint)
;;;
;;;		- condition: struct-funct viewpoint has no top-level view
;;;		- returns: (error struct-funct-viewpoint-malformed)

(defun get-functional-processes (content-node)
  (cond ((null content-node)
	 '((error no-black-box-functional-iteration-node)))
	((content-node-has-error? content-node)
	 '((error error-in-black-box-functional-iteration-node)))
	(t (let ((struct-funct-viewpoint 
		  (get-only-val (list content-node 'kb-subgraph))))
	     (if (null struct-funct-viewpoint)
		 '((error no-struct-funct-viewpoint))
		 (let ((viewpoint-of-top-event
			(get-viewpoint-of-top-event struct-funct-viewpoint)))
		   (if (null viewpoint-of-top-event)
		       '((error struct-funct-viewpoint-malformed))
		       (list (get-local (list viewpoint-of-top-event
					      'subevents))))))))))


(defun get-viewpoint-of-top-event (struct-funct-viewpoint)
  (let ((top-event
	 (get-only-val (list struct-funct-viewpoint 'correspondence-with))))
    (get-only-val (list struct-funct-viewpoint
			'correspondence-with
			top-event
			'has-viewpoint))))


;-----------------------------------------------------------------------
;			Get-Temporal-Ordering-Relations
;-----------------------------------------------------------------------

;;; arguments: None
;;;
;;; looks up ordering relations in KB
;;;
;;; returns (a list of) a list of the ordering relations
;;;
;;; errors: none

(defun get-temporal-ordering-relations ()
  (list
   (get-local '(temporal-ordering specializations))))


;-----------------------------------------------------------------------
;			Get-Temporal-Relation-Values
;-----------------------------------------------------------------------

;;; arguments: Process, Temporal-Relation
;;;
;;; looks up values on Process.Temporal-Relation
;;;
;;; returns (a list of) a list of the ordering relations
;;;
;;; errors: none

(defun get-temporal-relation-values (process temporal-relation)
  (list
   (get-local (list process temporal-relation))))


;-----------------------------------------------------------------------
;				  Make-Triple
;-----------------------------------------------------------------------

;;; arguments: Unit, Slot, Value
;;;
;;; appends arguments to construct a triple
;;;
;;; returns (a list of) the triple
;;;
;;; errors: none

(defun make-triple (unit slot value)
  (list
   (list unit slot value)))

third current-triple))
	     (cuorganization.lisp                                                                                   000775  003117  001440  00000027741 05641657625 015525  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		     The Auxilliary Organization Functions
;;;;		     -------------------------------------


;;;; orders actual nodes by matching up to nodes in specification
;;;;     list and placing in that order
;;;;
;;;; because some actual nodes may have failed a focus function
;;;;     test, first checks to see if actual node has an
;;;;     instantiated focus condition; if so checks to see if
;;;;     it evaluated to True
;;;;
;;;; then installs previous and next-node links
;;;;
;;;; assumes focus-condition-evaluation assigns value 
;;;; that is ``real boolean'', i.e., True or False
;;;;
;;;; if specification-list is null, issues a warning when
;;;; trace-organization? is on, but returns original list of actual
;;;; nodes; this is not technically an error because there are
;;;; cases when an organization specification cannot be given in
;;;; an EDP unit, e.g., ordering the content-nodes that result from
;;;; determining content of the processes that are modulatory facilitators
;;;; of some process
;;;;
;;;; another special case is when iteration is involved:
;;;;
;;;; EDP example:
;;;;              A
;;;;             / \
;;;;  iterative X   Y non-iterative
;;;;            |    
;;;;            Z   
;;;;
;;;; Explanation Plan:
;;;;             a
;;;;           / / \
;;;;         z1  z2 y
;;;;
;;;; all the instances of X/Z need to come before all instances of Y
;;;;
;;;; this latter case is covered by the legal-with-iteration? clause


(in-package 'km)


(defun order-subtopics (actual-nodes specification-list)
  (let ((error? (illegal-ordering-call-p actual-nodes specification-list)))
    (cond (error?
	   (cond ((equal (second (first error?))
			 'null-specification-list)
		  (describe-organization actual-nodes)
		  actual-nodes)
		 ((equal (second (first error?))
			 'actual-node-not-in-specification-list)
		  (let ((iterative-interpretation
			 (legal-with-iteration? actual-nodes
						specification-list)))
		    (cond ((not (null iterative-interpretation))
			   (describe-organization iterative-interpretation)
			   iterative-interpretation)
			  (t 	 (when (trace-organization?)
				   (format t "Organization error: ~
                                              actual-node not in ~
                                              specification-list~%~%"))
				 error?))))
		 (t error?)))
	  (t (let* ((nodes-to-include (remove-if-not #'include-subtopic-p
						     actual-nodes))
		    (ordered-nodes
		     (sort nodes-to-include
			   #'<
			   :key #'(lambda (x)
				    (position (get-only-val
					       (list x 'node-type))
					      specification-list)))))
	       (install-previous-and-next ordered-nodes)
	       (describe-organization ordered-nodes)
	       ordered-nodes)))))


(defun illegal-ordering-call-p (actual-nodes specification-list)
  (cond ((null actual-nodes)
	 (when (trace-organization?)
	   (format t "Organization error: Null actual-node list~%~%"))
	 '((error null-actual-nodes)))

	((not (listp actual-nodes))
	 (when (trace-organization?)
	   (format t "Organization error: Actual-nodes not a list~%~%"))
	 '((error actual-nodes-not-a-list)))

	((null specification-list)
	 (when (trace-organization?)
	   (format t "Organization warning: Null specification-list~%~%"))
	 '((error null-specification-list)))

	((not (listp specification-list))
	 (when (trace-organization?)
	   (format t "Organization error: Specification-list not a list~%~%"))
	 '((error specification-list-not-a-list)))

	((not (all-plan-tree-nodes? actual-nodes))
	 (when (trace-organization?)
	   (format t "Organization error:~%")
	   (format t "Illegal actual-node list: ~a.~%~%"
		   actual-nodes))
	 '((error actual-nodes-not-plan-tree-nodes)))

	((not (all-edp-units? specification-list))
	 (when (trace-organization?)
	   (format t "Organization error:~%")	   
	   (format t "Illegal specification list: ~a.~%~%"
		   specification-list))
	 '((error specification-list-not-edp-units)))

	((not (all-plan-nodes-in-spec-list? actual-nodes
					    specification-list))
	 '((error actual-node-not-in-specification-list)))

	(t nil)))


;;; returns t if each node in actual-nodes is a plan tree node
;;; otherwise returns nil

(defun all-plan-tree-nodes? (actual-nodes)
  (cond ((null actual-nodes) t)
	((not (member 'explanation-plan-node
		      (ancestry* (first actual-nodes))))
	 nil)
	(t (all-plan-tree-nodes? (rest actual-nodes)))))


;;; returns t if each unit in edp-list is an edp-unit
;;; otherwise returns nil

(defun all-edp-units? (edp-list)
  (cond ((null edp-list) t)
	((not (member 'edp-unit
		      (ancestry* (first edp-list))))
	 nil)
	(t (all-edp-units? (rest edp-list)))))


;;; returns t if each node in actual-nodes is of a type that
;;;    appears in specification-list
;;; otherwise returns nil

(defun all-plan-nodes-in-spec-list? (actual-nodes specification-list)
  (if (null actual-nodes)
      t
      (let ((node-type (get-only-val (list (first actual-nodes)
					   'node-type))))
	(if (not (member node-type specification-list))
	    nil
	    (all-plan-nodes-in-spec-list? (rest actual-nodes)
					  specification-list)))))


;;; determines if all actual nodes are either
;;;          (1) the type of some nested iteration specification, or
;;;          (2) included in the standard type
;;; function called only when some actual nodes are not in specification list
;;;
;;; if all actual nodes can be accomodated, returns ordered list
;;; otherwise returns nil

(defun legal-with-iteration? (actual-nodes specification-list)
  (when (trace-organization?)
    (format t "Attempting iterative interpretation of~%~
               organization specification list.~%~%"))
  (let* ((actual-nodes-covered-pairings (find-covered-nodes
					 actual-nodes
					 specification-list))
	 (actual-nodes-not-covered (set-difference
				    actual-nodes
				    (get-covered-nodes
				     actual-nodes-covered-pairings)))
	 (iterative-nodes-covered-pairings (find-iterative-covering
					    actual-nodes-not-covered
					    specification-list)))
    (when (trace-organization?)
      (format t "Actual-nodes-covered pairings:")
      (pprint actual-nodes-covered-pairings t)
      (format t "~%~%")
      (format t "Actual nodes not covered:")
      (pprint actual-nodes-not-covered t)
      (format t "~%~%")
      (format t "Iterative-nodes-covered pairings:")
      (pprint iterative-nodes-covered-pairings t)
      (format t "~%~%"))
    (if (null iterative-nodes-covered-pairings)
	nil
	(let ((ordered-nodes
	       (impose-iterative-ordering actual-nodes
					  actual-nodes-covered-pairings
					  iterative-nodes-covered-pairings
					  specification-list)))
	  (install-previous-and-next ordered-nodes)
	  ordered-nodes))))


;;; finds all actual nodes and their pairing with items in
;;; specification list
;;;
;;; returns association list of form
;;;          (... (actual-node-i . node-type-i) ...)

(defun find-covered-nodes (actual-nodes specification-list)
  (if (null actual-nodes)
      nil
      (let ((node-type (get-only-val (list (first actual-nodes)
					   'node-type))))
	(if (not (member node-type specification-list))
	    (find-covered-nodes (cdr actual-nodes)
				specification-list)
	    (acons (first actual-nodes)
		   node-type
		   (find-covered-nodes (cdr actual-nodes)
				       specification-list))))))


;;; takes actual node pairings generated in find-covered-nodes
;;;
;;; returns list of all covered nodes, i.e., all the keys in the list

(defun get-covered-nodes (actual-nodes-covered-pairings)
  (mapcar #'(lambda (pairing)
	      (first pairing))
	  actual-nodes-covered-pairings))


;;; takes all nodes not covered in ``normal'' manner
;;;
;;; first checks if each actual node is a content node (only
;;; content nodes are involved in iteration, so if node isn't
;;; a content node, it can't be covered with an iterative
;;; interpretation)
;;;
;;; determines if each actual node can be covered by tracing up
;;; nested iterations in EDP to find element in specification list
;;;
;;; if each actual node in actual-nodes-not-covered can be covered
;;; in this manner, returns association list of pairings
;;;          (... (actual-node-i . iterative-node-type-i) ...)
;;;
;;; otherwise returns nil

(defun find-iterative-covering (actual-nodes-not-covered specification-list)
  (if (not (all-actual-nodes-content-nodes? actual-nodes-not-covered))
      nil
      (let ((iterative-covering
	     (find-iterative-covering-aux actual-nodes-not-covered
					  specification-list)))
	(if (not (member 'error iterative-covering))
	    iterative-covering
	    nil))))


;;; returns t if all actual nodes are of type content-specification
;;; otherwise nil

(defun all-actual-nodes-content-nodes? (actual-nodes-not-covered)
  (cond ((null actual-nodes-not-covered) t)
	((member 'content-node
		 (get-local (list (first actual-nodes-not-covered)
				  'generalizations)))
	 (all-actual-nodes-content-nodes? (cdr actual-nodes-not-covered)))
	(t nil)))


(defun find-iterative-covering-aux (actual-nodes-not-covered
				    specification-list)
  (if (null actual-nodes-not-covered)
      nil
      (let ((first-node-covering (get-iterative-covering-for-single-node
				  (first actual-nodes-not-covered))))
	(if (or (null first-node-covering)
		(not (member first-node-covering specification-list)))
	    '(error)
	    (acons (first actual-nodes-not-covered)
		   first-node-covering
		   (find-iterative-covering-aux (rest actual-nodes-not-covered)
						specification-list))))))


;;; climbs up edp-units to get to top of nested iteration
;;;
;;; assumes actual node is a content node
;;;
;;; returns type of actual node if it was generated from an
;;; iterative content specification
;;;
;;; otherwise returns nil

(defun get-iterative-covering-for-single-node (actual-node)
  (do* ((edp-unit (get-only-val (list actual-node 'node-type))
		  parent-of-edp-unit)
	(parent-of-edp-unit (get-only-val (list edp-unit
						'content-specification-of))
			    (get-only-val (list edp-unit
						'content-specification-of))))
	((or (member (get-only-val (list parent-of-edp-unit
					 'generalizations))
		     '(topic elaboration))
	     (null edp-unit))
	 edp-unit)))

		   
;;; assumes all nodes are covered in either
;;;        (1) actual-nodes-covered-pairings, or
;;;        (2) iterative-nodes-covered-pairings
;;;
;;; returns list of ordered nodes based on specification-list
;;; and the pairings

(defun impose-iterative-ordering (actual-nodes
				  actual-nodes-covered-pairings
				  iterative-nodes-covered-pairings
				  specification-list)
  (sort actual-nodes
	#'<
	:key #'(lambda (x)
		 (position
		  (let ((possible-node-type
			 (assoc x actual-nodes-covered-pairings)))
		    (if (null possible-node-type)
			(cdr (assoc x iterative-nodes-covered-pairings))
			(cdr possible-node-type)))
		  specification-list))))


;;; determines if a plan-node should be included
;;; returns T if either (1) node's focus condition evaluated to True
;;;               or    (2) node has no focus condition
;;; returns nil if node's focus condition evaluated to False

(defun include-subtopic-p (plan-node)
  "Predicate for determining whether a plan node should be included"
  (let ((value (get-only-val (list plan-node
				  'focus-condition-evaluation))))
    (or (null value)
	(equal value 'true))))


;;; installs previous and next node links

(defun install-previous-and-next (ordered-node-list)
  "Installs previous and next node links"
  (mapl #'(lambda (x)
	    (when (not (null (rest x)))
	      (let ((current (first x))
		    (next (second x)))
		(connect-to-next current next)		  
		(connect-to-previous next current))))
	ordered-node-list))


(defun connect-to-previous (current-node previous-node)
  "Connects one plan node to `previous' plan node"
  (put-local (list current-node 'previous-node) (list previous-node)))


(defun connect-to-next (current-node next-node)
  "Connects one plan node to `next' plan node"
  (put-local (list current-node 'next-node) (list next-node)))


;;; trace of result of organization

(defun describe-organization (ordered-nodes)
  (when (trace-organization?)
    (format t "Resulting organization:")
    (pprint ordered-nodes t)
    (format t "~%~%")))null iterative-interpretation))plan-node-functions.lisp                                                                            000775  003117  001440  00000031073 05641657626 016676  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		       The Plan-Node Operation Functions
;;;;		       ---------------------------------


;;;; This file contains the functions for creating, removing, and
;;;; locating nodes in Explanation Plan Trees.  It has 4 sections
;;;; of functions:
;;;;
;;;;                 - Node Creation Functions
;;;;                 - Node Creation Test Calls
;;;;                 - Node Removal Functions
;;;;                 - Node Location Functions
;;;;
;-----------------------------------------------------------------------
;			 Plan Node Function Directory
;-----------------------------------------------------------------------
;;;;
;;;; Node Creation Functions
;;;; -----------------------
;;;; (construct-explanation-plan-header verbosity)
;;;; (construct-exposition-node edp-type verbosity primary-concept)
;;;; (construct-topic-node topic-type parent-exposition-node)
;;;; (construct-content-node content-type parent-node kind-of-parent-node)
;;;; (construct-elaboration-node elaboration-type parent-content-node)
;;;;
;;;; Node Creation Test Calls
;;;; ------------------------
;;;; (test-node-creation-fns)
;;;;
;;;; Node Removal Function
;;;; ---------------------
;;;; (clear-out-plan-nodes)
;;;;
;;;; Node Location Functions
;;;; -----------------------
;;;; (current-explanation-plan-header)
;;;; (current-exposition-node)
;;;; (current-topic-node)
;;;; (current-t-content-node)
;;;; (current-e-content-node)
;;;; (current-elaboration-node)
;;;; (find-node &key parent child-slot node-type)
;;;;
;;;;
;-----------------------------------------------------------------------
;			  The Node Creation Functions
;-----------------------------------------------------------------------


;;;; There are 5 functions for creating nodes in an Explanation Plan:
;;;;
;;;;        - construct-explanation-plan-header
;;;;
;;;;        - construct-exposition-node
;;;;
;;;;        - construct-topic-node
;;;;
;;;;        - construct-content-node
;;;;
;;;;        - construct-elaboration-node
;;;;
;;;; There is also a test function, test-node-creation-fns, that
;;;; calls each of these functions to create a node of each type.


(in-package 'km)


(defun construct-explanation-plan-header (verbosity)
  "Constructs new Explanation Plan header"
  (let ((new-header (gentemp "EXPLANATION-PLAN-HEADER-")))
    (when (trace-node-creation?)
      (format t "Creating new explanation plan header: ~a.~%~%"
	      new-header))
    (add-val-local '(explanation-plan-header specializations)
		   new-header
		   :location :start)
    (put-local (list new-header 'generalizations)
	       '(explanation-plan-header))
    (put-local (list new-header 'verbosity-setting)
	       (list verbosity))
    (put-local (list new-header 'number-of-content-nodes)
	       (list 0))
    (put-local (list 'knight-global-state
		     'current-explanation-plan-header)
	       (list new-header))
    new-header))


;;; constructs new exposition node
;;;
;;; assumes the new exposition node will be the subject of the
;;; explanation plan header; this will need to be changed when
;;; edps start calling other edps

(defun construct-exposition-node (edp-type verbosity primary-concept)
  "Constructs new Exposition node"
  (let ((new-exposition-node (gentemp "EXPOSITION-NODE-")))
    (when (trace-node-creation?)
      (format t "~%~%Creating new exposition node: ~a.~%"
	      new-exposition-node)
      (format t "Exposition node type: ~a.~%~%"
	      edp-type))
    (add-val-local '(exposition-node specializations) 
		   new-exposition-node
		   :location :start)
    (put-local (list new-exposition-node 'generalizations)
	       '(exposition-node))
    (put-local (list new-exposition-node 'subject-of-header)
	       (list (current-explanation-plan-header)))
    (put-local (list (current-explanation-plan-header) 'explanation-subject)
	       (list new-exposition-node))
    (put-local (list new-exposition-node 'node-type)
	       (list edp-type))
    (put-local (list new-exposition-node 'primary-concept)
	       (list primary-concept))
    (put-local (list new-exposition-node 'verbosity-setting)
	       (list verbosity))
    (put-local (list new-exposition-node 'topics-considered)
	       (get-local (list edp-type 'topic-list)))
    (put-local (list 'knight-global-state
		     'current-exposition-node)
	       (list new-exposition-node))
    new-exposition-node))


(defun construct-topic-node (topic-type parent-exposition-node)
  "Constructs new Topic node"
  (let ((new-topic-node (make-node-name topic-type)))
    (when (trace-node-creation?)
      (format t "Creating new topic node: ~a.~%"
	      new-topic-node)
      (format t "Topic node type: ~a.~%~%"
	      topic-type))
    (add-val-local '(topic-node specializations)
		   new-topic-node
		   :location :start)
    (put-local (list new-topic-node 'generalizations)
	       '(topic-node))
    (put-local (list new-topic-node 'node-type)
	       (list topic-type))
    (put-local (list new-topic-node 'child-of-node)
	       (list parent-exposition-node))
    (add-val-local (list parent-exposition-node 'topic-nodes)
		   new-topic-node
		   :location :start)
    (put-local (list new-topic-node 'verbosity-setting)
	       (list (get-only-val (list parent-exposition-node
					 'verbosity-setting))))
    (put-local (list new-topic-node 'centrality)
	       (list (let ((centrality
			    (get-only-val (list topic-type
						'centrality))))
		       (if centrality
			   centrality
			   'medium)))) ;centrality defaults to medium
    (put-local (list new-topic-node 'focus-condition)
	       (list 
		;; default is true
		(let ((focus-condition 
		       (get-only-val (list topic-type 'focus-condition))))
		  (if focus-condition
		      focus-condition
		      'true))))
    (put-local (list 'knight-global-state
		     'current-topic-node)
	       (list new-topic-node))
    new-topic-node))


;;; note: kind-of-parent-node must be either Topic or Elaboration
(defun construct-content-node (content-type parent-node kind-of-parent-node)
  "Constructs new Content node"
  (let ((new-content-node (make-node-name content-type)))
    (when (trace-node-creation?)
      (format t "Creating new content node: ~a.~%"
	      new-content-node)
      (format t "Content node type: ~a.~%~%"
	      content-type))
    (add-val-local '(content-node specializations)
		   new-content-node
		   :location :start)
    (put-local (list new-content-node 'generalizations)
	       '(content-node))
    (put-local (list new-content-node 'node-type)
	       (list content-type))
    (put-local (list new-content-node 'child-of-node)
	       (list parent-node))
    (put-local (list new-content-node 'verbosity-setting)
	       (list (get-only-val (list parent-node 'verbosity-setting))))
    (add-val-local (list parent-node 'content-nodes)
		   new-content-node
		   :location :end) ;; J.L. made end for correct order 6-4-94
    (put-local (list new-content-node 'content-specification-template)
	       (get-local (list content-type
				'content-specification-template)))
    (let ((elabs-considered (get-local (list content-type
					     'elaborations))))
      (when elabs-considered
	(put-local (list new-content-node 'elaborations-considered)
		   elabs-considered)))
    (copy-all-values (list content-type 'local-variables)
    		     (list new-content-node 'local-variables))
    (put-local (list (current-explanation-plan-header)
		     'number-of-content-nodes)
	       (list (1+ (get-only-val (list (get-only-val
					      '(knight-global-state
						current-explanation-plan-header))
					     'number-of-content-nodes)))))
    (case kind-of-parent-node
      ((topic) (put-local '(knight-global-state	current-t-content-node)
			  (list new-content-node)))
      ((elaboration) (put-local '(knight-global-state current-e-content-node)
				(list new-content-node))))
    new-content-node))
     

(defun construct-elaboration-node (elaboration-type parent-content-node)
  "Constructs new Elaboration node"
  (let ((new-elaboration-node (make-node-name elaboration-type)))
    (when (trace-node-creation?)
      (format t "Creating new elaboration node: ~a.~%"
	      new-elaboration-node)
      (format t "Elaboration node type: ~a.~%~%"
	      elaboration-type))
    (add-val-local '(elaboration-node specializations)
		   new-elaboration-node
		   :location :start)	;places the new value in
					;the first position
    (put-local (list new-elaboration-node 'generalizations)
	       '(elaboration-node))
    (put-local (list new-elaboration-node 'node-type)
	       (list elaboration-type))
    (put-local (list new-elaboration-node 'child-of-node)
	       (list parent-content-node))
    (add-val-local (list parent-content-node 'elaboration-nodes)
		   new-elaboration-node
		   :location :start)
    (put-local (list new-elaboration-node 'verbosity-setting)
	       (list (get-only-val (list parent-content-node
					 'verbosity-setting))))
    (put-local (list new-elaboration-node 'centrality)
	       (list (let ((centrality
			    (get-only-val (list elaboration-type
						'centrality))))
		       (if centrality
			   centrality
			   'medium)))) ;centrality defaults to medium
    (put-local (list new-elaboration-node 'focus-condition)
	       (list
		;; default is true
		(let ((focus-condition
		       (get-only-val (list elaboration-type
					   'focus-condition))))
		  (if focus-condition
		      focus-condition
		      'true))))
    (put-local '(knight-global-state current-elaboration-node)
	       (list new-elaboration-node))
    new-elaboration-node))


;;; gensym's a name of the given node type
(defun make-node-name (node-type)
  (gentemp (concatenate 'string
			(string node-type)
			"-")))


;---------------------------------------------------------------------
;			   Node Creation Test Calls
;---------------------------------------------------------------------


;(defun test-node-creation-fns ()
;  "Tests out node creation functions"
;  (let* ((my-header (construct-explanation-plan-header 'medium))
;	 (my-expo-node (construct-exposition-node 'process-edp
;						  'medium
;						  'growth))
;	 (my-topic-node (construct-topic-node 'process-significance
;					      my-expo-node))
;	 (my-content-node (construct-content-node 'core-connection
;						  my-topic-node
;						  'topic))
;	 (my-elaboration-node (construct-elaboration-node 'core-elaboration
;							  my-content-node)))))


;-----------------------------------------------------------------------
;			  The Node Removal Functions
;-----------------------------------------------------------------------


;;; Clears out all plan nodes but viewpoints
(defun clear-out-plan-nodes ()
  "Removes all plan tree nodes from KB, including viewpoints"
  (remove-all-children 'explanation-plan-header)
  (remove-all-children 'exposition-node)
  (remove-all-children 'topic-node)
  (remove-all-children 'content-node)
  (remove-all-children 'elaboration-node)
  (remove-all-children 'viewpoint))
		       


;;; Clears out viewpoints (use this one carefully!)
(defun clear-out-view-points ()
  "Severs all viewpoints from Viewpoint frame."
  (put-local '(viewpoint instances)
	     nil)
  (put-local '(vp-shell instances)
	     nil))


;-----------------------------------------------------------------------
;			  The Node Location Functions
;-----------------------------------------------------------------------


;;; finds nodes in current explanation plan tree that are
;;; pointed to by global state variables


(defun current-explanation-plan-header ()
  (get-only-val '(knight-global-state current-explanation-plan-header)))


(defun current-exposition-node ()
  (get-only-val '(knight-global-state current-exposition-node)))


(defun current-topic-node ()
  (get-only-val '(knight-global-state current-topic-node)))


(defun current-t-content-node ()
  (get-only-val '(knight-global-state current-t-content-node)))


(defun current-e-content-node ()
  (get-only-val '(knight-global-state current-e-content-node)))


(defun current-elaboration-node ()
  (get-only-val '(knight-global-state current-elaboration-node)))


;;; selects a node from the Explanation Plan Tree that 
;;;
;;;   (1) has Parent as its parent in the tree, and
;;;
;;;   (2) is connected to Parent via Child-Slot, 
;;;       e.g., ``content-nodes'', and
;;;
;;;   (3) is of type Node-Type, e.g., a content node
;;;       is of type ``Core-Connection'' if it was
;;;       constructed by a content specification named
;;;       Core-Connection
;;;
;;; assumes parent has only one child node of the given node-type

(defun find-node (&key parent child-slot node-type)
  "Finds requested node in Explanation Plan Tree"
  (let ((candidate-nodes (get-local (list parent child-slot))))
    (find node-type candidate-nodes
	  :key #'(lambda (x) (get-only-val (list x 'node-type))))))
	  
    (format t "Topic node type: ~a.~%~%"
	      topic-type))
    (add-val-local '(topic-node specializations)
		   new-topic-node
		   :location :start)
    (put-local (list new-topic-node 'generalizations)
	       '(topic-node))
    (put-local (list new-topic-node 'node-type)
	       (list topic-type))
    (put-local (list new-topic-node 'child-of-node)
	       (list parent-exposition-node))
    (add-val-local (list parent-exposition-node 'topic-noprompts.lisp                                                                                        000775  003117  001440  00000003053 05641657626 014514  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;			      KnEd Prompts Macros
;;;;			      -------------------


;;;; Used for turning off KnEd calls in middle of KM functions



(in-package 'km)


(defmacro with-no-prompts (&rest form)
  `(let ((old-inverse-prompt-val *prompt-for-inverses*)
         (old-prompt-annotation-removal *prompt-annotation-removal*))
     (setf *prompt-for-inverses* nil)
     (setf *prompt-annotation-removal* nil)
     (unwind-protect
          (progn ,@form)
          (setf *prompt-annotation-removal* old-prompt-annotation-removal)
          (setf *prompt-for-inverses* old-inverse-prompt-val))))


;;; turns off interaction with user wrt inverse-maintenance
(defmacro with-inverse-prompt-off (&rest form)
  `(let ((old-inverse-prompt-val *prompt-for-inverses*))
     (setf *prompt-for-inverses* nil)
     (unwind-protect
          (progn ,@form)
          (setf *prompt-for-inverses* old-inverse-prompt-val))))


;;; turns off inverse-maintenance on all calls to put-global and add-val
(defmacro with-no-inverses (&rest form)
  `(let ((old-inverse-val *standard-inverse*))
     (setf *standard-inverse* nil)
     (unwind-protect
          (progn ,@form)
          (setf *standard-inverse* old-inverse-val))))


;;; turns off warnings from REMOVE-VAL
(defmacro with-warnings-off (&rest form)
    `(let ((old-warnings-val *display-remove-warnings*))
           (setf *display-remove-warnings* nil)
           (unwind-protect
                          (progn ,@form)
                       (setf *display-remove-warnings* old-warnings-val))))


------------------------------
;			   Node Creation Test Calls
;---------------------------------------------------------------------


;(defun test-node-creation-fns ()
;  "Tests out node creation functions"
;  (let* ((my-header (construct-explanation-plan-header 'medium))
;	 (my-expo-node (construct-exposition-node 'process-edp
;						  'medium
;						  'growth))
;	 (my-topic-node (construct-topic-node 'process-significance
;					      my-expo-node))
;	 (my-conterealize.lisp                                                                                        000775  006350  001440  00000061316 05655777324 015021  0                                                                                                    ustar 00theorist                        brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;			   The Realization Functions
;;;;			   -------------------------

;;;; This file contains functions that invoke the Natural Language
;;;; Generator.


(in-package 'km)


;;; given: a paragraph-structure: a list of lists of viewpoints,
;;;        i.e., ((VP1 VP2) (VP3) (VP4 VP5))
;;;
;;; assumptions: - each viewpoint in the structure is error-free
;;;
;;;              - each embedded list denotes a paragraph
;;;
;;; returns a list of lists of sentences

(defun realize-explanation (paragraph-structure &key (string nil))
  (let* ((parag-sentence-list
	  (remove-if #'null
		     (mapcar #'realize-paragraph
			     paragraph-structure)))
	 (parag-sentence-list-revised
	  (revise-paragraph-grouping-v2 parag-sentence-list))
	 (parag-sentence-list-revised-no-dupes
	  (remove-duplicate-sentences parag-sentence-list-revised))
	 (parag-sentence-list-revised-no-dupes-with-pronouns
	  (pronominalize-explanation parag-sentence-list-revised-no-dupes)))
	   
    ;(format t "~%parag-sentence-list: ~a~%"
    ;	    parag-sentence-list)
    ;(format t "~%parag-sentence-list-revised: ~a~%"
    ;	     parag-sentence-list-revised)
    ;(format t "~%parag-sentence-list-revised-no-dupes: ~a~%"
    ;        parag-sentence-list-revised-no-dupes)
    ;(format t "~%parag-sentence-list-no-dupes-with-pronouns: ~a~%"
    ;        parag-sentence-list-revised-no-dupes-with-pronouns)

    (put-local (list (current-exposition-node)
		     'explanation)
	       parag-sentence-list-revised-no-dupes-with-pronouns)

    (if (not string) (progn (format t "~%")

    (mapcar #'(lambda (single-paragraph-string-list)
		(make-paragraph-text single-paragraph-string-list))
	    parag-sentence-list-revised-no-dupes-with-pronouns)
    (values))

    (eval `(string-append ,@(mapcar #'add-blanks-to-sent (uncanonize
          parag-sentence-list-revised-no-dupes-with-pronouns)))))))


(defun realize-paragraph (viewpoint-list)
  (let ((strings-and-nils-list (mapcar #'realize-viewpoint
				       viewpoint-list)))
    (if (not (member nil strings-and-nils-list))
	(reduce #'append strings-and-nils-list)
	(cascade-linguistic-pruning viewpoint-list
				    strings-and-nils-list))))


;;; given: a viewpoint
;;;
;;; returns *only* a list of sentences produced from that viewpoint
;;;
;;; if a unification failure occurs for some FD, nil is *not*
;;; returned by that failure
;;;
;;; only if every FD fails should nil be returned
;;;
;;; diagrammatic example:
;;;
;;;    input: viewpoint1
;;;
;;;           viewpoint1 --> FD1,          FD2,       FD3
;;;                           |             |          |
;;;                           |             |          |
;;;                           |             |          |
;;;                           |             |          |
;;;                           v             v          v
;;;                  Sent1, Sent2, Sent3   Fail   Sent4, Sent5
;;;
;;;    output: (Sent1, Sent2, Sent3, Sent4, Sent5)

(defun realize-viewpoint (viewpoint)
  (remove "<fail>"
	  (mapcar #'(lambda (x)
		      (make-sentence (uni-string (first x) :limit 2500
					    :non-interactive t)
				     (second x)))
		  (2fd viewpoint))
	  :test #'string-equal))


(defun make-sentence (string1 string2)
    (cond ((null string2)  string1)
	  ((not (null string1))
	   (concatenate 'string (substitute #\space
					    #\.
					    string1)
			string2 "."))
	  (t  nil)))


;--------------------------------------------------------------------
;			  Cascade-Linguistic-Pruning
;--------------------------------------------------------------------
;;;
;;; this function deals with the problem of the realization component
;;; pruning a viewpoint Vi that would have generated a sentence Si,
;;; and there is a subsequent viewpoint Vj that generates a sentence
;;; Sj, but now that Si is not there, Sj makes no sense out of context.
;;;
;;; Solution:
;;;   each time a viewpoint is pruned, prune all sentences produced
;;;   from viewpoints that are elaborations of the viewpoint whose
;;;   sentence was pruned
;;;
;;; Technique:
;;;   
;;;    given: - viewpoint-list
;;;           - string-and-nil-list (result of realization)
;;;
;;;    if a nil appears in string-and-nil-list then
;;;       find viewpoint V that generated it
;;;       find content-node C associated with V in explanation plan
;;;       if C has elaborations (assumed to be in this paragraph)
;;;          for each elaboration E
;;;              for each content node C-elab of E
;;;                  for each viewpoint of V-elab of C-elab
;;;                     remove sentence produced by V-elab from list
;;;
;;; Note: this function had to be implemented at the last minute
;;;       so it's very inelegant (lots of unneccessary work done by code)
;;;
;;;       the way this should be implemented is to store the strings
;;;       produced by a viewpoint in the explantion plan (since we
;;;       don't do that now, we have to regenerate the mappings
;;;       from viewpoint-list to strings-and-nils-list)
;;;
;;;       currently not general:
;;;            - only implemented for one level of elaboration,
;;;              i.e., top-level content nodes and their elaborations
;;;
(defun cascade-linguistic-pruning (viewpoint-list strings-and-nils-list)
  (let* ((vp-list-to-strings-mapping
	  (make-vp-list-to-strings-mapping viewpoint-list
					   strings-and-nils-list))
	 (new-list-to-strings-mapping
	  (cascade-linguist-pruning-aux vp-list-to-strings-mapping))
	 (new-strings-and-nils-list
	  (return-to-strings-and-nils-list new-list-to-strings-mapping)))
    (reduce #'append
	    new-strings-and-nils-list)))


(defun cascade-linguist-pruning-aux (vp-list-to-strings-mapping)
  (let ((first-failed-viewpoint (get-first-failed-vp
				 vp-list-to-strings-mapping))
	(new-vp-list-to-strings-mapping vp-list-to-strings-mapping))
    (cond (first-failed-viewpoint

	   ;; remove the intial viewpoint
	   (setf new-vp-list-to-strings-mapping
		 (remove-element-from-vp-list-to-strings-mapping
		  first-failed-viewpoint
		  new-vp-list-to-strings-mapping))

	   ;; remove elaborative viewpoints
	   (let* ((content-node-of-failure
		   (get-only-val (list first-failed-viewpoint
				       'kb-subgraph-of)))
		  (elab-nodes-of-failed-content-node
		   (get-local (list content-node-of-failure
				    'elaboration-nodes))))

	     ;(format t "~%Elab nodes of failed content node: ~a~%"
	     ;        elab-nodes-of-failed-content-node)

	     ;; if there are elaborative nodes, remove their viewpoints
	     (when elab-nodes-of-failed-content-node
	       (dolist (elab-node elab-nodes-of-failed-content-node)
		 (dolist (content-node
			   (get-local (list elab-node 'content-nodes)))
		   (let ((elab-viewpoint
			  (get-only-val (list content-node 'kb-subgraph))))

		     ;(format t "~%Elab viewpoint: ~a~%"
		     ;	     elab-viewpoint)

		     ;; elab-viewpoint is a viewpoint that was generated
		     ;; from a content node of an elaboration of the
		     ;; content node that produced first-failed-viewpoint
		     ;;
		     ;; so: remove the (elab-viewpoint sentence-list)
		     ;;     from the vp-list-to-strings-mapping
		 
		     (setf new-vp-list-to-strings-mapping
			   (remove-element-from-vp-list-to-strings-mapping
			    elab-viewpoint
			    new-vp-list-to-strings-mapping)))))))

	   (cascade-linguist-pruning-aux new-vp-list-to-strings-mapping))

	  (t new-vp-list-to-strings-mapping))))


;;; for each V in viewpoint-list, pairs it to the
;;; element in strings-and-nils-list that 
(defun make-vp-list-to-strings-mapping (viewpoint-list
					strings-and-nils-list)
  (pair-up-lists viewpoint-list	strings-and-nils-list))


;;; pairs up elements of lists L1 and L2
;;; assumes: their number of elements is equal
(defun pair-up-lists (L1 L2)
  (if L1
      (cons (list (first L1)
		  (first L2))
	    (pair-up-lists (rest L1) (rest L2)))))


(defun get-first-failed-vp (vp-list-to-strings-mapping)
  (if vp-list-to-strings-mapping
      (let ((first-elem (first vp-list-to-strings-mapping)))
	(if (null (second first-elem))
	    (first first-elem)
	    (get-first-failed-vp (rest vp-list-to-strings-mapping))))))


(defun remove-element-from-vp-list-to-strings-mapping
    (elab-viewpoint vp-list-to-strings-mapping)
  (if vp-list-to-strings-mapping
      (let ((first-elem (first vp-list-to-strings-mapping)))
	(if (equal (first first-elem) elab-viewpoint)
	    (rest vp-list-to-strings-mapping)
	    (cons first-elem
		  (remove-element-from-vp-list-to-strings-mapping
		   elab-viewpoint
		   (rest vp-list-to-strings-mapping)))))))


;;; given:   a list of the form ((a 1) (b 2) (c 3))
;;;
;;; returns: a list of the form (1 2 3)
(defun return-to-strings-and-nils-list (list-to-strings-mapping)
  (if list-to-strings-mapping
      (let ((first-elem (first list-to-strings-mapping)))
	(cons (second first-elem)
	      (return-to-strings-and-nils-list
	       (rest list-to-strings-mapping))))))

	    
;--------------------------------------------------------------------
;			   Revise-Paragraph-Grouping
;--------------------------------------------------------------------
;				   Version 1
;--------------------------------------------------------------------
;;;
;;; this function attempts to improve a paragraph clustering
;;;
;;; given: a list of paragraph cluster of sentences, e.g., 
;;;
;;;        ((s1 s2) (s3) (s4 s5))
;;;
;;; improvements: eliminates paragraphs that have only one sentence
;;;               by merging all 1-sentence paragraphs with
;;;               the paragraphs above them
;;;
;;;               if the first paragraph has only one sentence,
;;;               it is moved down
;;;
;;; deficiency: given ((A 1) (B) (C) (D) (E) (F G))
;;;             the system will dumbly return
;;;                   ((A 1 B C D E) (F G))
;;;             rather than leaving (A 1) alone and merging
;;;             (B), (C), (D), and (E) into a new one
;;;
;;; note: Art didn't like the results of this version, so we
;;;       wrote version 2 below

(defun revise-paragraph-grouping-v1 (paragraph-cluster-list)
  (if (and paragraph-cluster-list
	   (> (length paragraph-cluster-list) 1))
      (let ((cluster-1 (first paragraph-cluster-list))
	    (cluster-2 (second paragraph-cluster-list)))
	(if (equal (length cluster-1) 1)
	    (let ((new-cluster (append cluster-1 cluster-2)))
	      (revise-paragraph-grouping-aux
	       (cons new-cluster
		     (rest (rest paragraph-cluster-list)))))
	    (revise-paragraph-grouping-aux paragraph-cluster-list)))
      paragraph-cluster-list))
	     

(defun revise-paragraph-grouping-aux (paragraph-cluster-list)
  (if (and paragraph-cluster-list
	   (> (length paragraph-cluster-list) 1))
      (let ((cluster-1 (first paragraph-cluster-list))
	    (cluster-2 (second paragraph-cluster-list)))
	(if (equal (length cluster-2) 1)
	    (let ((new-cluster (append cluster-1 cluster-2)))
	      (revise-paragraph-grouping-aux
	       (cons new-cluster
		     (rest (rest paragraph-cluster-list)))))
	    (cons cluster-1
		  (revise-paragraph-grouping-aux
		   (rest paragraph-cluster-list)))))
      paragraph-cluster-list))

	    
;--------------------------------------------------------------------
;			   Revise-Paragraph-Grouping
;--------------------------------------------------------------------
;				   Version 2
;--------------------------------------------------------------------
;;;
;;; this function attempts to improve a paragraph clustering
;;; given: a list of paragraph cluster of sentences, e.g., 
;;;
;;;        ((s1 s2) (s3) (s4 s5))
;;;
;;; improvements: - eliminates a first paragraph that has only
;;;                 one sentence
;;;               - if there are 4 or fewer sentences, merges them
;;;                 all into one paragraph

(defun revise-paragraph-grouping-v2 (paragraph-cluster-list)
  (if paragraph-cluster-list
      (let ((flat-sentence-list (flatten paragraph-cluster-list)))
	(if (<= (length flat-sentence-list) 4)
	    (list flat-sentence-list)
	    (if (and (equal (length (first paragraph-cluster-list))
			    1)
		     (>= (length paragraph-cluster-list)
			 2))
		(let ((new-cluster (append (first paragraph-cluster-list)
					   (second paragraph-cluster-list)))
		      (other-clusters (rest (rest paragraph-cluster-list))))
		  (cons new-cluster
			other-clusters))
		paragraph-cluster-list)))))


;--------------------------------------------------------------------
;			  Remove-Duplicate-Sentences
;--------------------------------------------------------------------
;;;
;;; given: a list of lists of sentences, e.g., 
;;;            ((s1 s2) (s3) (s4 s2))
;;;
;;; returns: a list of lists of sentences in which duplicate sentences
;;;          have been removed but with the original structure
;;;          still intact      
;;;
;;;          always removes all latter appearances and maintains the
;;;          first
;;;
;;; example above returns: 
;;;            ((s1 s2) (s3) (s4))
;;;
(defun remove-duplicate-sentences (paragraph-cluster-list)
  (if (and paragraph-cluster-list
	   (listp paragraph-cluster-list)
	   (listp (first paragraph-cluster-list)))
      (let* ((cluster-1 (first paragraph-cluster-list))
	     (cluster-1-rev
	      (remove-duplicate-sentences-in-cluster cluster-1))
	     (revised-cluster-list-rest (rest paragraph-cluster-list)))
	(dolist (sent cluster-1-rev)
	  (setf revised-cluster-list-rest
		(remove-sent-from-cluster-list sent
					       revised-cluster-list-rest)))
	(cons cluster-1-rev
	      (remove-duplicate-sentences revised-cluster-list-rest))))) 


;;; given: - a sentence
;;;        - a list of cluster
;;; 
;;; for each appearance of sentence in any of the clusters in
;;; cluster-list, removes that sentence
;;;
;;; if removing a sentence causes a cluster to become nil, then
;;; that cluster is removed
;;;
(defun remove-sent-from-cluster-list (sent cluster-list)
  (remove nil
	  (mapcar #'(lambda (cluster)
		      (remove-all-sents-from-cluster sent cluster))
		  cluster-list)))


;;; given: - a sentence
;;;        - a list of sentences
;;;
;;; returns: list of sentences with all instances of sentences
;;;          removed from it
(defun remove-all-sents-from-cluster (sent parag-cluster)
  (remove sent parag-cluster :test #'string-equal))

  
;;; given: a list of sentences
;;;
;;; returns: list of sentences with all but first instance of each
;;;          sentence removed from list
(defun remove-duplicate-sentences-in-cluster (paragraph-cluster)
  (remove-duplicates paragraph-cluster
		     :from-end t
		     :test #'string-equal))


;--------------------------------------------------------------------
;			   Pronominalize Explanation
;--------------------------------------------------------------------
;;; given: a list of sentences
;;;
;;; returns: the list with the following changes:
;;;          for each sentence except the first
;;;              IF the first word is the string associated with
;;;                            primary concept
;;;                                            AND
;;;               (the previous sentence begins with the string OR
;;;                 the previous sentence has already been pronominalized)
;;;                                            AND
;;;               the following character is not a comma
;;;                      (to rule out: ``It, which contains carbon, is ...'')
;;;              THEN
;;;                  the first word is pronominalized by ...
;;;    the pronominalization method:
;;;          for a singular concept: substitute ``It''
;;;          for a plural concept:  substitute ``They''
;;;
(defun pronominalize-explanation (list-of-paragraphs)
  (mapcar #'(lambda (paragraph)
	      (pronominalize-paragraph paragraph))
	  list-of-paragraphs))


(defun pronominalize-paragraph (paragraph)
  (let* ((primary-concept
	  (get-only-val (list (current-exposition-node)
			      'primary-concept)))
	 (pronoun (compute-pronoun primary-concept))
	 (concept-strings (compute-concept-strings primary-concept)))
    (pronominalize-paragraph-aux paragraph concept-strings pronoun)))


;;; given: a concept
;;; returns: a string representing the capitalized pronoun for
;;;          that concept
;;;
;;;          (either "It" or "They")
;;;
(defun compute-pronoun (concept)
  (let ((number (compute-number concept)))
    (if number
	(if (equal number 'singular)
	    "It"
	    "They"))))


;;; if top-level-frame is a concept that is singular, then
;;; returns singular
;;; otherwise returns plural
;;;
(defun compute-number (top-level-frame)
  (if (getobj top-level-frame)
      (if (member2 '(number plural)
		   (first (get-local
			   `(,top-level-frame
			     lexical-info
			     li-primary lex-fd))))
	  'plural
	  'singular)))


;;; given: a concept
;;;
;;; returns: 3 strings representing that concept might appear
;;;          in a sentence 
;;;             (1) "Concept"
;;;             (2) "A concept"
;;;             (3) "The concept"
;;;
(defun compute-concept-strings (concept)
  (let* ((concept-fd (make-np concept))
	 (countable-no-fd (any-to-count-no concept-fd))
         (definite-no-fd (any-to-def-no concept-fd))
         (definite-yes-fd (any-to-def-yes concept-fd)))
    (mapcar #'remove-period
	    (mapcar #'(lambda (fd)
			(uni-string fd
				    :limit 1200
				    :non-interactive t))
		    (list countable-no-fd
			  definite-no-fd
			  definite-yes-fd)))))


;;; given: a string ending in "."
;;;
;;; returns: the string without the "."
;;;
(defun remove-period (string-with-terminal-period)
  (let ((strng-length (length string-with-terminal-period)))
    (subseq string-with-terminal-period 0 (1- strng-length))))


(defun pronominalize-paragraph-aux (paragraph concept-strings pronoun)
  (if (> (length paragraph) 1)
      (let* ((sent-1 (first paragraph))
	     (sent-2 (second paragraph))
	     (pronominalized-sent-2
	      (pronominalize-sent concept-strings pronoun sent-2 sent-1)))
	(cons sent-1
	      (pronominalize-paragraph-aux (cons pronominalized-sent-2
						 (rest (rest paragraph)))
					   concept-strings
					   pronoun)))
      paragraph))


;;; substitutes pronoun for string representing concept if
;;;         the string appears first in the sentence       AND
;;;         the previous sentence begins with the concept,
;;;             which may itself have been pronominalized
;;;         AND the subsequent character is not a comma
;;;         AND the subsequent character is a blank
;;;         AND the sentence begins with the same string as
;;;             the previous sentence (unless the previous sentence
;;;             begins with pronoun)
(defun pronominalize-sent (concept-strings pronoun sent previous-sent)
  (let ((pronominalized-result
	 (pronominalize-sent-aux-1 concept-strings
				   pronoun
				   sent))
	(prev-sent-beginning
	 (previous-sent-begins-with-concept concept-strings
					    pronoun
					    previous-sent)))
    (if (and pronominalized-result
	     prev-sent-beginning
	     (or (equal prev-sent-beginning pronoun)
		 (sent-begins-with-string prev-sent-beginning
					  (length prev-sent-beginning)
					  sent
					  (length sent))))
	pronominalized-result
	sent)))


;;; for each possible-lead concept string, checks if substitution
;;; can be made
;;;
;;; if encounters one that can, returns it
;;; otherwise, checks others
;;;
(defun pronominalize-sent-aux-1 (possible-lead-concept-strings
				 pronoun sent)
  (if possible-lead-concept-strings
      (let* ((first-string (first possible-lead-concept-strings))
	     (result (pronominalize-sent-aux-2 first-string pronoun sent)))
	(if result
	    result
	    (pronominalize-sent-aux-1 (rest possible-lead-concept-strings)
				      pronoun
				      sent)))))


;;; given: - a concept string candidate, e.g., the string representing
;;;                 the possible leading substring
;;;        - the pronoun to replace it with
;;;        - the sentence
;;;
;;; if concept-string-candidate is an initial substring of sent,
;;;         then substitute pronoun in sentence
;;; return: nil                 - if concept-string-candidate was
;;;                               not an initial subseq OR comma test failed
;;;         the revised senence - if concept-string-candidate was
;;;                               an initial subseq
;;;
(defun pronominalize-sent-aux-2 (concept-string-candidate pronoun sent)
  (let ((concept-string-length (length concept-string-candidate))
	(sent-length (length sent)))
    (if (sent-begins-with-string concept-string-candidate
				 concept-string-length
				 sent
				 sent-length)
	(let ((sent-without-leading-concept-string
	       (subseq sent
		       concept-string-length
		       sent-length)))     
	  (if (and
	       (not (begins-with-comma sent-without-leading-concept-string))
	       (begins-with-blank sent-without-leading-concept-string))
	      (concatenate 'string
			   pronoun
			   sent-without-leading-concept-string))))))


;;; returns t iff sent begins with string
;;; otherwise nil    
;;;
(defun sent-begins-with-string (given-string given-string-length
					     sent sent-length)
  (if (> sent-length given-string-length)
      (let ((initial-sent-subseq 
	     (subseq sent 0 given-string-length)))
	(string-equal given-string
		      initial-sent-subseq))))


;;; given: - a list of concept strings
;;;        - a pronoun
;;;        - a sentence
;;;
;;; returns: if prev-sent starts with strng-1, strng-2, or strng-3,
;;;          then returns that string
;;;          otherwise returns nil
;;;
(defun previous-sent-begins-with-concept (concept-strings pronoun prev-sent)
  (let* ((strng-1         (first concept-strings))
	 (strng-2         (second concept-strings))
	 (strng-3         (third concept-strings))
	 (strng-1-length  (length strng-1))
	 (strng-2-length  (length strng-2))	 
	 (strng-3-length  (length strng-3))
	 (pronoun-length  (length pronoun))
	 (sent-length     (length prev-sent)))
    (cond ((sent-begins-with-string pronoun pronoun-length
				    prev-sent sent-length)
	   pronoun)
	  ((sent-begins-with-string strng-1 strng-1-length
				 prev-sent sent-length)
	   strng-1)
	  ((sent-begins-with-string strng-2 strng-2-length
				    prev-sent sent-length)
	   strng-2)
	  ((sent-begins-with-string strng-3 strng-3-length
				    prev-sent sent-length)
	   strng-3)
	  (t nil))))


(defun begins-with-comma (strng)
  (and (stringp strng)
       (> (length strng) 0)
       (equal (elt strng 0)
	      #\,)))


(defun begins-with-blank (strng)
  (and (stringp strng)
       (> (length strng) 0)
       (is-blank-p (elt strng 0))))


;;;; --------------------------------------------------------------------
;;;; formats a list of sentence strings
;;;; --------------------------------------------------------------------

;;; assumes longest word is shorter than value of line-length parameter

(defparameter *line-length* 70)


;;; given: a list of strings, where each string is sentence ending
;;;        in a period
;;;
;;; returns: a formatted string with line breaks
(defun make-paragraph-text (parag-sentence-list)
  (let ((parag-string (make-parag-with-blanks parag-sentence-list)))
    (make-paragraph-text-aux parag-string)
    (format t "~%"))
  (values))


;;; given: a string of sentences with blanks at end of sentences
;;;
;;; returns: a formatted string with line breaks
(defun make-paragraph-text-aux (parag-string)
  (let ((strng-length (length parag-string)))
    (if (not (empty-string-p parag-string strng-length))
	(let* ((end-of-first-line (get-end-of-first-line parag-string))
	       (first-line (subseq parag-string 0 end-of-first-line)))
	  (format t first-line)
	  (format t "~%")
	  (make-paragraph-text-aux
	   (strip-leading-blanks 
	    (subseq parag-string end-of-first-line strng-length)))))))
					 


;;; returns t iff strng is empty
;;;    
;;; a string is empty if it is of 0 length or if each element
;;; is a blank    
(defun empty-string-p (strng strng-length)
  (or (zerop strng-length)
      (and (is-blank-p (elt strng 0))
	   (empty-string-p (subseq strng 1 strng-length)
			   (1- strng-length)))))


;;; given: a string of sentences with blanks at end of sentences
;;;
;;; returns: the position at which the first line should end
(defun get-end-of-first-line (parag-string)
  (if (<= (length parag-string) *line-length*)
      (length parag-string)
      (do ((counter *line-length* (- counter 1)))
	  ((or (is-blank-p (elt parag-string counter))
	       (zerop counter))
	   counter))))


;;; given: a list of sentences
;;; returns: a string of all the sentences with blanks after
;;;          each sentence	 
(defun make-parag-with-blanks (parag-sentence-list)
  (apply #'concatenate
	 'string
	 (mapcar #'add-blanks-to-sent
		 parag-sentence-list)))


;;; addes two spaces to end of sentence
(defun add-blanks-to-sent (sent)
  (concatenate 'string sent "  "))


;;; returns string with leading blanks removed
;;;
(defun strip-leading-blanks (strng)
  (let ((strng-length (length strng)))
    (if (zerop strng-length)
	strng
	(do ((counter 0 (1+ counter)))
	    ((or (not (is-blank-p (elt strng counter)))
		 (equal counter (1- strng-length)))
	     (if (is-blank-p (elt strng counter))
		 ""
		 (subseq strng counter strng-length)))))))


(defun is-blank-p (ch)
  (equal ch '#\Space))


     AND
;;;               (the previous sentence begins with the string OR
;;;                 the previous sentence has already been pronominalized)
;;;                                            AND
;;;               the following character is not a comma
;;;                      (to rule out: ``It, whreports.lisp                                                                                        000775  003117  001440  00000015471 05641657627 014516  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
				       
;;;;			The Report Generation Functions
;;;;			-------------------------------


;;;; Functions for testing if reports should be generated and
;;;; for generating reports


(in-package 'km)


;-----------------------------------------------------------------------
;		       The Top-Level Reporting Functions
;-----------------------------------------------------------------------

;;; makes a report about problematic content nodes and the
;;; length of the final linearized plan

(defun make-report (question-type)
  (print-report-header)
  (report-inputs question-type)
  (report-problems)
  (report-length)
  (report-top-most-plan-node)
  (report-paragraphized-leaves)
  (format t "~%")
  (format t "~%")
  (values))


;;; sets the make-report parameter, which is recorded in Knight-Global-State
;;;
;;; defaults to false
(defun set-make-report? (&optional (rept-value 'false))
  (case rept-value
    ((false true) (put-local '(knight-global-state make-report?)
			     rept-value))
    (t                 (format t "Illegal report setting.~%")
		       (values))))


;;; retrieves make-report setting
;;;
;;; assumes it is non-null

(defun make-report? ()
  (let ((result (get-only-val '(knight-global-state make-report?))))
    (if (equal result 'true)
	t)))


;-----------------------------------------------------------------------
;				 Print Header
;-----------------------------------------------------------------------

(defun print-report-header ()
  (format t "~%~%-------------------------------------------------------------~
             ------------~%")
  (format t "                         Explanation Generation Results~%")
  (format t "----------------------------------------------------------------~
             ---------~%~%"))


;-----------------------------------------------------------------------
;			       Inputs Reporting
;-----------------------------------------------------------------------

(defun report-inputs (question-type)
  (format t "Question type: ~a~%~%"
	  question-type)
  (format t "Concept of Interest: ~a~%~%"
	  (get-only-val (list (current-exposition-node) 'primary-concept)))
  (format t "Amount of Detail: ~a~%~%"
	  (get-verbosity))
  (format t "Discourse History Setting: ~a~%~%"
	  (get-only-val '(knight-global-state user-modeling?))))


;-----------------------------------------------------------------------
;		   Top-Most Explanation Plan Node Reporting
;-----------------------------------------------------------------------

;;; reports the topmost explanation plan node

(defun report-top-most-plan-node ()
  (when (current-exposition-node)
    (format t "Top-most explanation plan node: ~a~%~%"
	    (current-exposition-node)))
  (values))


;-----------------------------------------------------------------------
;				Error Reporting
;-----------------------------------------------------------------------

;;; reports content-nodes of current explanation plan with errors
;;;
;;; a content node has an error if 
;;;         (1) an error has occurred at the content node
;;;         (2) an error has occurred in the viewpoint associated
;;;             with the content node
;;;
;;; note: this is *not* an efficient implementation;
;;;       it traverses all content nodes and reports only
;;;       those that are in the current explanation plan
;;;       rather than traversing the explanation plan itself;
;;;       the implemented algorithm was just a little easier
;;;       to code

(defun report-problems ()
  (format t "Problematic content nodes:~%~%")
  (dolist (problem-content-node (find-erroneous-content-nodes))
    (let ((problem-type (find-problem-type problem-content-node)))
      (format t "      ~a : ~a~%" problem-content-node problem-type)))
  (format t "~%")
  (values))


(defun find-erroneous-content-nodes ()
  (let* ((all-content-nodes
	  (get-local '(content-node specializations)))
	 (current-content-nodes
	  (remove-if-not #'content-node-of-current-explanation-plan-p
			 all-content-nodes)))
    (remove-if-not #'problem-content-node-p
		   current-content-nodes)))


(defun content-node-of-current-explanation-plan-p (content-node)
  (let* ((current-exposition-node
	  (get-only-val '(knight-global-state
			  current-exposition-node)))
	 (search-result
	  (kb-search (list content-node)
		     (list 'child-of-node)
		    :terminate-with-success-criteria
		    #'(lambda (curr-plan-node)
			(equal curr-plan-node
			       current-exposition-node))
		    :collect-path? nil
		    :loop-elimination? t)))
    (not (equal (first search-result)
		'fail))))

			       
(defun problem-content-node-p (content-node)
  (or (content-node-has-error? content-node)
      (viewpoint-contains-error? (get-only-val (list content-node
						     'kb-subgraph)))))


(defun find-problem-type (problem-content-node)
  (let ((error-on-content-node
	 (get-only-val (list problem-content-node 'error-type))))
    (if error-on-content-node
	error-on-content-node
	(let ((viewpoint (get-only-val (list problem-content-node
					     'kb-subgraph))))
	  (if viewpoint
	      (let ((viewpoint-error (get-only-val (list viewpoint
							 'error-type))))
		(if viewpoint-error
		    viewpoint-error
		    'viewpoint-error))
	      'no-viewpoint)))))


;-----------------------------------------------------------------------
;			       Length Reporting
;-----------------------------------------------------------------------

;;; reports the number of filtered, paragraphed viewpoints in the
;;; linearized plan

(defun report-length ()
  (let* ((leaves (get-local (list (current-exposition-node)
				 'linearized-leaves)))
	 (size (length (flatten leaves))))
    (if (equal size 0)
	(format t "There are no viewpoints in the plan.~%~%")
	(format t "Number of viewpoints: ~a~%~%"
		size)))
  (values))


;-----------------------------------------------------------------------
;			Paragraphized Leaves Reporting
;-----------------------------------------------------------------------

(defun report-paragraphized-leaves ()
  (let ((leaves (get-local (list (current-exposition-node)
			   'linearized-leaves))))
    (when leaves
      (format t "Linearized viewpoints (grouped by paragraph):~%")
      (pprint leaves t))))


;-----------------------------------------------------------------------
;			      Verbosity Functions
;-----------------------------------------------------------------------

;;; sets the verbosity level, which is recorded in Knight-Global-State
;;;
;;; defaults to medium
(defun set-verbosity (&optional (verbosity-level 'medium))
  (case verbosity-level
    ((low medium high) (put-local '(knight-global-state verbosity-setting)
				  verbosity-level))
    (t                 (format t "Illegal verbosity setting.~%")
		       (values))))


;;; retrieves verbosity level
;;;
;;; assumes it is non-null

(defun get-verbosity ()
  (get-only-val '(knight-global-state verbosity-setting)))
-------------------
;		       The Top-Level Reporting Functions
;-----------------------------------------------------------------------

;;; makes a report about problematic content nodes and the
;;sweep.lisp                                                                                          000775  003117  001440  00000067435 05641657627 014152  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-
    				       

;;;;			  Sweeping Functions
;;;;			  ------------------


;;;; This file contains functions that are used to sweep the KB.


(in-package 'km)


;;;-------------------------------------------------------------------
;;; finds units with particular numbers of hyphens in their names
;;;-------------------------------------------------------------------

(defun find-units-with-more-than-2-hyphens ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/more-than-two-hyphens"
			     :direction :output
			     :if-does-not-exist :create
			     :if-exists :append)
      (dolist (unit (append (progeny* 'object) (progeny* 'process)))
	(when (not (listp unit))
	  (let* ((string-name (string unit))
		 (hyphen-count (hyphens string-name 0 0)))
	    (if (> hyphen-count 2)
		(format outstream "~a~%" unit)))))))
	  

(defun find-units-with-2-hyphens ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/two-hyphens"
			     :direction :output
			     :if-does-not-exist :create
			     :if-exists :append)
      (dolist (unit (append (progeny* 'object) (progeny* 'process)))
	(when (not (listp unit))
	  (let* ((string-name (string unit))
		 (hyphen-count (hyphens string-name 0 0)))
	    (if (= hyphen-count 2)
		(format outstream "~a~%" unit)))))))


;;;-------------------------------------------------------------------
;;; fix domains of most viewpoint units
;;;-------------------------------------------------------------------

(defun fix-viewslots ()
  (let ((slots (get-local '(viewpoint-slots specializations))))
    (dolist (slot slots)
      (put-local (list slot 'domain)
		 'viewpoint))))


;;;-------------------------------------------------------------------
;;; find units with periods
;;;-------------------------------------------------------------------

(defun find-units-with-periods ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/periods"
			     :direction :output
			     :if-does-not-exist :create
			     :if-exists :append)
      (dolist (unit (append (progeny* 'object) (progeny* 'process)))
	(when (not (listp unit))
	  (if (unit-has-period-in-name? unit)
		(format outstream "~a~%" unit))))))


(defun unit-has-period-in-name? (unit)
  (let ((string-name (string unit)))
    (> (period string-name 0 0) 0)))
  

(defun period (unit pos count)
  (if (/= pos (array-total-size unit))
      (if (eq #\. (char unit pos))
	  (period unit (1+ pos) (1+ count))
	  (period unit (1+ pos) count))
      count))


;;;-------------------------------------------------------------------
;;; removes inappropriate lexical slot values
;;;-------------------------------------------------------------------

(defun remove-lexical-slot ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(remove-all-values (list unit 'lexical-slot)))))

(defun remove-lex-item ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(remove-all-values (list unit 'lex-item)))))


(defun remove-plural-lex-item ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(remove-all-values (list unit 'plural-lex-item)))))


(defun remove-name-singular ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(remove-all-values (list unit 'name-singular)))))


(defun remove-name-plural ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(remove-all-values (list unit 'name-plural)))))


;;;-------------------------------------------------------------------
;;; generates reports about missing Process-Description Template info
;;;
;;; also generates reports about missing modulatory and temporal info
;;;-------------------------------------------------------------------

;;; traverses the progeny of a process that has a PDT associated with
;;; it to determine if all the necessary information is present about
;;; the processes to ensure that the PDT can be applied

;;; Note: this version only checks top-level units


(defvar *pdt-required-report-file*
  "/v/sage/v0/brewery/Lex-Info/pdt-required-report")


(defparameter *pdt-list-required*
;;; format: a list of pairs of the form
;;;            (process var-list)
;;;         where process is the name of the process
;;;                 with which the PDT is associated, and, consequently,
;;;                 the place where a search will begin, and
;;;               var-list is a list of variables (slot-names) which
;;;                 must have at least one value on every descendant
;;;                 of process (or there must be a spec-slot
;;;                 of each variable in var-list on every descendant of
;;;                 process)
  '(;Process                      Variables (Slots)
    ;-------                      -----------------
    (acquisition                  (acquired acquirer))
    (assimilation                 (assimilated))
    (attraction                   (attractant attracted))
    (biosynthesis                 (raw-materials products))
    (chemical-reaction            (reactants products))
    (destruction                  (destroyed))
    (development                  (developing-entity))
    (disintegration               (disintegrated))
    (energy-transduction          (input-energy-form output-energy-form))
    (formation                    (formed))
    (generation                   (generated))
    (growth                       (growing-entities))
    (maturation                   (matures))
    (removal                      (transported source))
    (reproduction                 (ancestors))
    (reproductive-fertilization   (fertilizer fertilizee products))
    (size-decrease-transformation (transformed-entity))
    (size-increase-transformation (transformed-entity))
    (storage                      (stored))
    (transportation               (transported))
    ))


(defun report-missing-required-pdt-info ()
  (with-open-file (outstream
		   *pdt-required-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "            Missing Information for ~
                       Process-Description Templates~%")
      (format outstream "            ------------------------~
                       -----------------------------~%~%")
    (dolist (pdt-pair *pdt-list-required*)
      (let ((pdt-process (first pdt-pair))
	    (var-list (second pdt-pair)))
	(format outstream "~%~%~%Checking processes for ~a PDT~%" pdt-process)
	(format outstream "------------------------------------------------~%")
	(dolist (curr-process (progeny* pdt-process))
	  (when (not (listp curr-process))
	    (check-process-with-pdt curr-process var-list outstream)))))))


(defvar *pdt-optional-report-file*
  "/v/sage/v0/brewery/Lex-Info/pdt-optional-report")


(defparameter *pdt-list-optional*
;;; format: a list of pairs of the form
;;;            (process var-list)
;;;         where process is the name of the process
;;;                 with which the PDT is associated, and, consequently,
;;;                 the place where a search will begin, and
;;;               var-list is a list of variables (slot-names) which
;;;                 might have a value on a descendant of process
;;;                 (or there must be a spec-slot of each variable
;;;                 in var-list on every descendant of process)
  '(;Process             Variables (Slots)
    ;-------             -----------------
    (acquisition         (location))
    (biosynthesis        (location))
    (chemical-reaction   (location))
    (degeneration        (location))
    (destruction         (location))
    (development         (location))
    (energy-transduction (energy-acceptor location))
    (reproductive-fertilization (location))
    (generation          (location))
    (growth              (location))
    (maturation          (location))
    (removal             (destination))
    (reproduction        (offspring location))
    (storage             (location))
    (transportation      (source conduit destination location))
    ))


(defun report-missing-optional-pdt-info ()
  (with-open-file (outstream
		   *Pdt-optional-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "            Missing Optional Information for ~
                       Process-Description Templates~%")
      (format outstream "            ---------------------------------~
                       -----------------------------~%~%")
    (dolist (pdt-pair *pdt-list-optional*)
      (let ((pdt-process (first pdt-pair))
	    (var-list (second pdt-pair)))
	(format outstream "~%~%~%Checking processes for ~a PDT~%" pdt-process)
	(format outstream "------------------------------------------------~%")
	(dolist (curr-process (progeny* pdt-process))
	  (when (not (listp curr-process))
	    (check-process-with-pdt curr-process var-list outstream)))))))


(defvar *modulatory-report-file*
  "/v/sage/v0/brewery/Lex-Info/modulatory-report")


(defparameter *modulatory-list*
;;; format: a list of pairs of the form
;;;            (process var-list)
;;;         where process is the name of the process
;;;                 with which the PDT is associated, and, consequently,
;;;                 the place where a search will begin, and
;;;               var-list is a list of variables (slot-names) which
;;;                 must have at least one value on every descendant
;;;                 of process (or there must be a spec-slot
;;;                 of each variable in var-list on every descendant of
;;;                 process)
  '(;Process             Variables (Slots)
    ;-------             -----------------
    (process             (inhibits enables causes initiates))
    ))


(defun report-missing-modulatory-info ()
  (with-open-file (outstream
		   *modulatory-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "            Missing Modulatory Information~%")
    (format outstream "            ------------------------------~%~%")
    (dolist (pdt-pair *modulatory-list*)
      (let ((pdt-process (first pdt-pair))
	    (var-list (second pdt-pair)))
	(dolist (curr-process (progeny* pdt-process))
	  (when (not (listp curr-process))
	    (check-process-with-pdt curr-process var-list outstream)))))))


(defvar *transportation-pdt-required-report-file*
  "/v/sage/v0/brewery/Lex-Info/transportation-pdt-required-report")


(defun report-missing-required-pdt-info-for-transportation ()
  (with-open-file (outstream
		   *transportation-pdt-required-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "            Missing Information for ~
                       Transportation Process-Description Templates~%")
      (format outstream "            ------------------------~
                       --------------------------------------------~%~%")
      (dolist (curr-process (progeny* 'transportation))
	(when (not (listp curr-process))
	  (when (and (not (slot-or-spec-slot-has-value-on 'source
							  curr-process))
		     (not (slot-or-spec-slot-has-value-on 'destination
							  curr-process)))
	    (format outstream "~a has no value for source or destination.~%~%"
		    curr-process))))))


(defvar *acquistion-pdt-required-report-file*
  "/v/sage/v0/brewery/Lex-Info/acquistion-pdt-required-report")


(defun report-missing-required-pdt-info-for-acquistion ()
  (with-open-file (outstream
		   *acquistion-pdt-required-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "            Missing Information for ~
                       Acquisition Process-Description Templates~%")
      (format outstream "            ------------------------~
                       -----------------------------------------~%~%")
      (dolist (curr-process (progeny* 'acquisition))
	(when (not (listp curr-process))
	  (when (not (slot-or-spec-slot-has-value-on 'acquirer
						     curr-process))
	    (format outstream "~a has no value for acquirer.~%~%"
		    curr-process))))))


(defvar *development-pdt-required-report-file*
  "/v/sage/v0/brewery/Lex-Info/development-pdt-required-report")


(defun report-missing-required-pdt-info-for-development ()
  (with-open-file (outstream
		   *development-pdt-required-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "            Missing Information for ~
                       Development Process-Description Templates~%")
      (format outstream "            ------------------------~
                       -----------------------------------------~%~%")
      (dolist (curr-process (progeny* 'development))
	(when (not (listp curr-process))
	  (let ((developee (get-only-val (list curr-process
					       'developing-entity))))
	    (if (null developee)
		(format outstream "~a has no value for developing-entity.~%~%"
		    curr-process)
		(let ((before-state (get-only-val (list curr-process
							'developing-entity
							developee
							'before-state)))
		      (after-state (get-only-val (list curr-process
							'developing-entity
							developee
							'after-state))))
		  (when (null before-state)
		    (format outstream
			    "~a has no value for before-state annotation.~%~%"
			    curr-process))
		  (when (null after-state)
		    (format outstream
			    "~a has no value for after-state annotation.~%~%"
			    curr-process)))))))))


(defvar *temporal-report-file*
  "/v/sage/v0/brewery/Lex-Info/temporal-report")


(defparameter *temporal-list*
;;; format: a list of pairs of the form
;;;            (process var-list)
;;;         where process is the name of the process
;;;                 with which the PDT is associated, and, consequently,
;;;                 the place where a search will begin, and
;;;               var-list is a list of variables (slot-names) which
;;;                 must have at least one value on every descendant
;;;                 of process (or there must be a spec-slot
;;;                 of each variable in var-list on every descendant of
;;;                 process)
  '(;Process             Variables (Slots)
    ;-------             -----------------
    (process             (occurs-before occurs-after))
    ))


(defun report-missing-temporal-info ()
  (with-open-file (outstream
		   *temporal-report-file*
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "               Missing Temporal Information~%")
    (format outstream "               ----------------------------~%~%")
    (dolist (pdt-pair *temporal-list*)
      (let ((pdt-process (first pdt-pair))
	    (var-list (second pdt-pair)))
	(dolist (curr-process (progeny* pdt-process))
	  (when (not (listp curr-process))
	    (check-process-with-pdt curr-process var-list outstream)))))))


(defun check-process-with-pdt (curr-process var-list outstream)
  (dolist (var var-list)
    (when (not (slot-or-spec-slot-has-value-on var curr-process))
      (format outstream "~a has no value for ~a.~%~%" curr-process var))))


;;; returns t iff there is a value on unit.slot or there
;;; there is a value on unit.spec-slot, where spec-slot is a
;;; spec-slot of slot
;;;
;;; note: this version requires (probably unnessarily) that unit
;;;       have an explicit value on slot (or one of its specs);
;;;       we may change this to permit inherited values in the future
(defun slot-or-spec-slot-has-value-on (slot unit)
  (let ((slots-on-unit (get-explicit-slots unit))
	(all-spec-slots (progeny* slot)))
    (intersection slots-on-unit all-spec-slots)))


;;;-------------------------------------------------------------------
;;; find processes to which no PDT can be applied
;;;-------------------------------------------------------------------

(defun sweep-for-pdts ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/process-without-pdts"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "                  Processes without PDTs~%")
      (format outstream "                  ----------------------~%~%~%~%")
      (let ((processes (progeny* 'process)))
	(dolist (proc processes)
	  (when (equal (find-pdt proc) 'none)
	    (format outstream "~a~%~%" proc))))))


(defun find-pdt (concept)
  (if (null concept)
      'none
      (let* ((initial-unit-list (list concept))
	     (genl-slots (list 'generalizations 'stage-of 'i-genls))
	     (search-result 
	      (kb-search initial-unit-list
			 genl-slots
			 :terminate-with-success-criteria #'has-pdt?
			 :control-strategy 'breadth-first
			 :loop-elimination? t)))
	(if (equal (first search-result) 'fail)
	    'none
	    (second search-result)))))


(defun has-pdt? (concept)
  (get-local (list concept
		   'lexical-info
		   'li-primary
		   'lex-process-description-template)))


;;;-------------------------------------------------------------------
;;; prints out non-implicit unit Processes and Objects and Relations
;;;-------------------------------------------------------------------


;;; prints out all non-implicit units that are processes in the KB
(defun print-out-processes ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/process-list"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (dolist (curr-process (progeny* 'process))
	(when (not (listp curr-process))
	  (format outstream "~a~%" curr-process)))))


;;; prints out all non-implicit units that are object in the KB
(defun print-out-objects ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/object-list"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (dolist (curr-object (progeny* 'object))
	(when (not (listp curr-object))
	  (format outstream "~a~%" curr-object)))))


;;;-------------------------------------------------------------------
;;; prints out results of different kinds of ``relations'' sweeps
;;;-------------------------------------------------------------------


;;; prints out all ``decent'' relations in the KB
;;; omits all relations that are spec-relations of actor and actor-in
;;;
;;; for a given relation prints out relation
;;;
;;; if the relation has an inverse, prints out the inverse on the
;;; following line in parens
(defun print-out-relations ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/relations-inverse-list"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (let ((relations-seen-so-far nil))
	(dolist (curr-relation (progeny* 'new-slot-top))
	  (when (and (not (listp curr-relation))
		     (not (member 'actor-in (ancestry* curr-relation )))
		     (not (member 'actors (ancestry* curr-relation)))
		     (not (member curr-relation relations-seen-so-far)))
	    (let ((curr-relation-inverse (get-local (list curr-relation
							  'inverse))))
	      (cond (curr-relation-inverse
		     (format outstream "~a ~a~%"
			     curr-relation
			     curr-relation-inverse)
		     (push curr-relation relations-seen-so-far)		
		     (push (first curr-relation-inverse)
			   relations-seen-so-far))
		    (t (format outstream "~a (No inverse dude!)~%"
			       curr-relation)
		       (push curr-relation relations-seen-so-far)))))))))


;;; prints out all relations with no value for the english slot
(defun print-out-relations-with-no-english ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/relations-with-no-english"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (let ((relations-seen-so-far nil))
	(dolist (curr-relation (progeny* 'new-slot-top))
	  (when (and (not (listp curr-relation))
		     (not (member 'actor-in (ancestry* curr-relation )))
		     (not (member 'actors (ancestry* curr-relation)))
		     (not (get-local (list curr-relation 'english))))
	    (format outstream "~a~%" curr-relation))))))


;;; prints out relations and the English Art has given them
;;; format: relation (inverse) English
;;;
;;; for a given relation prints out relation
;;;
;;; if the relation has an inverse, prints out the inverse on the
;;; following line in parens
(defun print-out-relations-and-english ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/relations-with-english"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :append)
      (format outstream "                             Relations~%")
      (format outstream "                             ---------~%~%~%~%")
      (format outstream "Format: <Slot> (<Inverse>)~%<english for slot>~%~%~%")
      (dolist (curr-relation (progeny* 'new-slot-top))
	(when (and (not (listp curr-relation))
		   (not (member 'actor-in (ancestry* curr-relation )))
		   (not (member 'actors (ancestry* curr-relation))))
	  (let ((curr-relation-inverse (get-only-val (list curr-relation
							   'inverse)))
		(curr-relation-english (get-only-val (list curr-relation
							   'english))))
	    (cond (curr-relation-inverse
		   (format outstream "~a (~a)~% ~a~%~%"
			   curr-relation
			   curr-relation-inverse
			   curr-relation-english))
		  (t
 		   (format outstream "~a (no inverse)~% ~a~%~%"
			   curr-relation
			   curr-relation-english))))))))


;;;-------------------------------------------------------------------
;;; prints out results of  ``elementary'' sweeps
;;;-------------------------------------------------------------------

(defun elementary-sweep ()
  (with-open-file (outstream
		   "/v/sage/v0/brewery/Lex-Info/elementary-results"
		   :direction :output
		   :if-does-not-exist :create
		   :if-exists :supersede)
      (format outstream "                       Elementary Info~%")
      (format outstream "                       ---------------~%~%~%~%")
      (dolist (concept (progeny* 'process))
	(let ((elementary-ancestor (find-elementary-ancestor concept)))
	  (when (equal elementary-ancestor 'process)
	    (format outstream "~a~%~%" concept))))))

(defun find-elementary-ancestor (concept)
  (let* ((initial-unit-list (list concept))
	 (genl-slots (list 'generalizations 'stage-of 'i-genls))
	 (search-result 
	  (kb-search initial-unit-list
		     genl-slots
		     :terminate-with-success-criteria #'is-elementary-p
		     :control-strategy 'breadth-first
		     :loop-elimination? t)))
    (if (equal (first search-result) 'fail)

	;; no elementary concept found
	'none

	;; terminated with success, so return elementary concept
	(second search-result))))

;;;-------------------------------------------------------------------
;;; modify lex items of processes: definite = no --> countable = no
;;;-------------------------------------------------------------------

;;; fixes bug in all top-level processes
;;;
;;; known exceptions:  - gradient-driven-process
;;;                    - concentration-driven-process
;;;
;;; place to check it: - plant-reproductive-fertilization


(defun sweep-process-for-lex-definite-no ()
  (let ((processes (progeny* 'process)))
    (dolist (proc processes)
      (when (not (listp proc))
	(fix-process-lex proc)))))


(defun fix-process-lex (process)
  (let* ((fd-bit (get-fd-bit process))
	 (new-fd-bit (make-new-process-fd-bit fd-bit)))
    (put-fd-bit process new-fd-bit)))


(defun put-fd-bit (concept fd-bit)
    (put-local (list concept 'lexical-info 'li-primary 'lex-fd)
	       (list fd-bit)))


(defun get-fd-bit (concept)
  (get-local (list concept 'lexical-info 'li-primary 'lex-fd)))


(defun make-new-process-fd-bit (fd-bit)
  (mapcar #'(lambda (x)
	      (if (equal x '(definite
			     no))
		  '(countable no)   x))
	  (car fd-bit)))

;;;-------------------------------------------------------------------
;;; modify various aspects of lex items
;;;-------------------------------------------------------------------

(defun sweep-lex-items ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(remove-nil-fd unit))))


(defun lex-check-for-empty (unit)
  (let ((lex-fd (get-local (list unit 'lexical-info
				 'li-primary 'lex-fd)))
	(lex-noun (get-local (list unit 'lexical-info
				   'li-primary 'lex-noun))))
    (when (and (not  lex-fd) (not lex-noun))
      (format t "~%Problem lex item on ~a: ~a~%"
	      unit
	      (if lex-fd
		  "no lex-noun"
		  "no lex-fd")))))


;(fix-mass-or-count unit)
;(fix-verb-participle unit)
;(fix-verb-particle unit)
;(fix-lex-type-noun-phrase unit)
;(fix-lex-noun unit)


(defun remove-nil-fd (unit)
  (let ((lex-fd (get-local (list unit 'lexical-info 'li-primary 'lex-fd))))
    (when (equal lex-fd '(nil))
      (remove-all-values (list unit 'lexical-info 'li-primary 'lex-fd)))))


(defun fix-mass-or-count (unit)
  (let ((lex-type (get-local (list unit 'lexical-info 'li-primary 'lex-type))))
    (when (not (or (equal lex-type '(noun))
		   (null lex-type)))
      (remove-all-values (list unit
			       'lexical-info
			       'li-primary
			       'mass-or-count?)))))


(defun fix-verb-participle(unit)
  (let ((participle (get-local (list unit
				   'lexical-info
				   'li-primary
				   'lex-verb-participle))))
    (when participle
      (remove-all-values (list unit
			       'lexical-info
			       'li-primary
			       'lex-verb-participle)))))


(defun fix-verb-particle (unit)
  (let ((particle (get-local (list unit
				   'lexical-info
				   'li-primary
				   'lex-verb-particle))))
    (when particle
      (remove-all-values (list unit
			       'lexical-info
			       'li-primary
			       'lex-verb-particle)))))


(defun fix-lex-type-noun-phrase (unit)
  (let ((lex-type (get-local (list unit 'lexical-info 'li-primary 'lex-type))))
    (when (equal lex-type '(noun-phrase))
      (remove-all-values (list unit
			       'lexical-info
			       'li-primary
			       'lex-noun)))))


(defun fix-lex-noun (unit)
  (let ((noun (get-local (list unit
			       'lexical-info
			       'li-primary
			       'lex-noun))))
    (when noun
      (put-local (list unit
		       'lexical-info
		       'li-primary
		       'lex-noun)
		 noun))))
     

(defun sweep-empty-lex-slots ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(fix-goofy-lex-slot unit 'lex-mass-or-count)
	(fix-goofy-lex-slot unit 'process-description-template)	
	(fix-goofy-lex-slot unit 'lex-verb-type)
	(fix-goofy-lex-slot unit 'lex-verb-mode)
	(fix-goofy-lex-slot unit 'lex-fd-params)
	(fix-goofy-lex-slot unit 'lex-verb-subtype)
	(fix-goofy-lex-slot unit 'lex-verb-voice))))


(defun fix-goofy-lex-slot (unit goofy-lex-slot)
  (when (get-local (list unit 'lexical-info 'li-primary goofy-lex-slot))
    (remove-all-values (list unit
			     'lexical-info
			     'li-primary
			     goofy-lex-slot))))


;;;-------------------------------------------------------------------
;;; Add elementary and unspeakable concepts (5-24-94)
;;;-------------------------------------------------------------------

(add-elementary-concepts
   '(ORGANISM-LEVEL-STRUCTURE
     PHOTOSYNTHETIC-TISSUE-LEVEL-STRUCTURE
     PLANT-TISSUE-LEVEL-STRUCTURE
     PLANT-DIVISION
     ORGANISM-DIVISION
     PLANT-CELL-LEVEL-STRUCTURE
     STOMA-CONTAINING-STRUCTURE
     STARCH-STORAGE
     PHLOEM-UNLOADING
     CAPTURE
     PRIMARY-GROWTH
     PLANT-SEXUAL-REPRODUCTION
     PERIPHERAL-ZONE
     ))


(add-unspeakable-concepts
   '(ORGANISM-LEVEL-STRUCTURE
     PHOTOSYNTHETIC-TISSUE-LEVEL-STRUCTURE
     PLANT-TISSUE-LEVEL-STRUCTURE
     PLANT-DIVISION
     ORGANISM-DIVISION
     PLANT-CELL-LEVEL-STRUCTURE
     STOMA-CONTAINING-STRUCTURE
     CAPTURE
     ))

;;;-------------------------------------------------------------------
;;; Remove all viewpoints that aren't current
;;;-------------------------------------------------------------------

(defun remove-non-current-viewpoints ()
    (dolist (unit *kb-objects*)
      (when (not (listp unit))
	(when (is-a-viewpoint-but-not-current? unit)
	  (remove-frame unit)))))


(defun is-a-viewpoint-but-not-current? (unit)
  (and (get-local (list unit 'viewpoint-of))
       (not (equal (get-local (list unit 'instance-of))
		   '(viewpoint)))))


;;;-------------------------------------------------------------------
;;;				  Count Slots
;;;-------------------------------------------------------------------

(defun count-top-level-slots ()
  (length
   (remove-if #'listp
	      (progeny* 'slot))))

all ``decent'' relations in the KB
;;; omits all relations that are spec-relations of actor and actor-in
;;;
;;; for a given relation prints out relation
;;;
;;; if the relation has an inverse, prints out the inverse on the
;;;tracers.lisp                                                                                        000775  003117  001440  00000006310 05641657627 014453  0                                                                                                    ustar 00lester                          brewery                         000000  000000                                                                                                                                                                         ;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		  The Trace Switches and Accessors
;;;;              --------------------------------


;;;; Functions for setting and determining values of tracers
;;;;
;;;; Method:
;;;;     Sets and looks up values on slots of KB frame Knight-Global-State 
;;;;
;;;; Tracer Types:
;;;;               - trace-instantiation?
;;;;               - trace-instantiation-details?
;;;;               - trace-kb-access?
;;;;               - trace-node-creation?
;;;;               - trace-iteration?
;;;;               - trace-organization?
;;;;               - trace-edp-selection?
;;;;               - trace-viewpoint-filtering?
;;;;
;;;; Tracers are defined in initialize-knight function; when add
;;;; a new tracer, update list in initialize-knight
;;;;
;-----------------------------------------------------------------------
;			   Tracer Function Directory
;-----------------------------------------------------------------------
;;;;
;;;;    Tracer Switch Functions
;;;;    -----------------------
;;;;    (switch-on-all-tracers)
;;;;    (switch-on-tracer tracer-type)
;;;;    (switch-off-all-tracers)
;;;;    (switch-off-tracer tracer-type)
;;;;
;;;;    Tracer Access Functions
;;;;    -----------------------
;;;;    (trace-instantiation?)
;;;;    (trace-instantiation-details?)
;;;;    (trace-kb-access?)
;;;;    (trace-node-creation?)
;;;;    (trace-iteration?)
;;;;    (trace-organization?)
;;;;    (trace-edp-selection?)
;;;;
;;;;
;-----------------------------------------------------------------------
;			  The Tracer Switch Functions
;-----------------------------------------------------------------------


(in-package 'km)


(defun switch-on-all-tracers ()
  (dolist (tracer-type (get-local '(knight-global-state
				    tracer-list)))
    (switch-on-tracer tracer-type)))


(defun switch-on-tracer (tracer-type)
  (put-local (list 'knight-global-state tracer-type)
	     'true))


(defun switch-off-all-tracers ()
  (dolist (tracer-type (get-local '(knight-global-state
				    tracer-list)))
    (switch-off-tracer tracer-type)))


(defun switch-off-tracer (trace-type)
  (put-local (list 'knight-global-state trace-type)
	     'false))


;-----------------------------------------------------------------------
;			  The Tracer Access Functions
;-----------------------------------------------------------------------


(defun trace-instantiation? ()
  (equal (get-only-val '(knight-global-state trace-instantiation?))
	 'true))
		       
(defun trace-instantiation-details? ()
  (equal (get-only-val '(knight-global-state trace-instantiation-details?))
	 'true))

(defun trace-kb-access? ()
  (equal (get-only-val '(knight-global-state trace-kb-access?))
	 'true))

(defun trace-node-creation? ()
  (equal (get-only-val '(knight-global-state trace-node-creation?))
	 'true))

(defun trace-iteration? ()
  (equal (get-only-val '(knight-global-state trace-iteration?))
	 'true))

(defun trace-organization? ()
  (equal (get-only-val '(knight-global-state trace-organization?))
	 'true))

(defun trace-edp-selection? ()
  (equal (get-only-val '(knight-global-state trace-edp-selection?))
	 'true))

(defun trace-viewpoint-filtering? ()
  (equal (get-only-val '(knight-global-state trace-viewpoint-filtering?))
	 'true))
)
	 (genl-slots (list 'generalizations 'stage-of 'i-genls))
	 (search-result 
	  (kb-search initial-unit-list
		     genl-slots
		     :terminate-with-success-criteria #'is-elementary-p
		     :control-strategy 'breadth-first
		     :loop-elimination? t)))
    (if (equal (first search-result) 'fail)

	;; no ele                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                