; -*- Mode:Lisp; Syntax:Common-Lisp; Package:KM; Base:10 -*-
(in-package 'km)


;; put replaces annotation on the value located on unit/slot
;; install the inverse annotation (replaced-by) when
;; the optional parameter, inverse-maint is T (default is nil)
(defun put-replaces+ (unit slot value replaces-list &key inverse-maint)
  (put-replaces (extend-address-indefinitely unit slot value)
		replaces-list
		:inverse-maint inverse-maint))

(defun put-replaces (address replaces-list &key inverse-maint)
  (let* ((current-replaced-by (get-replaced-by address))
	 (new-replacements (if replaces-list
			       (list 'replaces replaces-list)
			       nil))
	 (new-replaced-by (if current-replaced-by
			      (list 'replaced-by current-replaced-by)
			      nil))
	 (replacements-record 
	  (if (or new-replaced-by new-replacements)
	      (delete-if #'null (list ':a-novalue 
				      new-replaced-by new-replacements))
	      :novalue))) ;putting :novalue at an address deletes 
                                    ;the replacements record

;   (format *terminal-io* "current-replaced-by: ~a~%" current-replaced-by)
;   (format *terminal-io* "new-replacements: ~a~%" new-replacements)
;   (format *terminal-io* "new-replaced-by: ~a~%" new-replaced-by)
;   (format *terminal-io* "replacements-record: ~a~%" replacements-record)

    ;since this call to put-replaces eliminates the old replaces annotation,
    ;we must eliminate the inverses of this annotation too
    (when inverse-maint
      (dolist (old-replaces-addr (get-replaces address))
	(remove-replaced-by old-replaces-addr address :inverse-maint nil)))

    ;install the inverses for this call to put-replaces
    (when inverse-maint
      (dolist (new-replaces-addr replaces-list)
	(add-replaced-by new-replaces-addr address :inverse-maint nil)))

    ;finally, put the new replaces information in the KB
    (put-local address replacements-record)))




;; put replaced-by annotation on the value located on unit/slot
;; install the inverse annotation (replaces) when
;; the optional parameter, inverse-maint is T (default is nil)
(defun put-replaced-by+ (unit slot value replaced-by-list 
			      &key inverse-maint)
  (put-replaced-by (extend-address-indefinitely unit slot value)
		   replaced-by-list 
		   :inverse-maint inverse-maint))

(defun put-replaced-by (address replaced-by-list &key inverse-maint)
  (let* ((current-replacements (get-replaces address))
	 (new-replaced-by (if replaced-by-list
			      (list 'replaced-by replaced-by-list)
			      nil))
	 (new-replacements (if current-replacements
			       (list 'replaces current-replacements)
			       nil))
	 (replacements-record 
	  (if (or new-replaced-by new-replacements)
	      (delete-if #'null (list ':a-novalue 
				      new-replaced-by new-replacements))
	      :novalue))) ;putting :novalue at an address deletes
                                    ;the replacements record

    ;since this call to put-replaced-by eliminates the old replaced-by 
    ;annotation, we must eliminate the inverses of this annotation too
    (when inverse-maint
      (dolist (old-replaced-by-addr (get-replaced-by address))
	(remove-replaces old-replaced-by-addr address :inverse-maint nil)))

    ;install the inverses for this call to put-replaced-by
    (when inverse-maint
      (dolist (new-replaced-by-addr replaced-by-list)
	(add-replaces new-replaced-by-addr address :inverse-maint nil)))

    ;finally, put the new replaces information in the KB
    (put-local address replacements-record)))


;; remove the replaced-by annotation located on the 
(defun remove-replaced-by+ (unit slot value 
			   address-to-delete
			   &key inverse-maint)
  (remove-replaced-by (extend-address-indefinitely unit slot value)
		      address-to-delete
		      :inverse-maint inverse-maint))

(defun remove-replaced-by (address-of-replaced-by-info 
			   address-to-delete
			   &key inverse-maint)
  (let ((new-val (remove
		  address-to-delete
		  (get-replaced-by address-of-replaced-by-info)
		  :test #'equal)))
    (if new-val
	(put-replaced-by address-of-replaced-by-info
			 new-val
			 :inverse-maint inverse-maint)
	(remove-all-replaced-by address-of-replaced-by-info
				:inverse-maint inverse-maint))))

(defun remove-replaces+ (unit slot value 
			      address-to-delete
			      &key inverse-maint)
  (remove-replaces (extend-address-indefinitely unit slot value)
		   address-to-delete
		   :inverse-maint inverse-maint))

(defun remove-replaces (address-of-replaces-info 
			address-to-delete
			&key inverse-maint)
  (let ((new-val (remove
		  address-to-delete
		  (get-replaces address-of-replaces-info)
		  :test #'equal)))
    (if new-val
	(put-replaces address-of-replaces-info
		      new-val
		      :inverse-maint inverse-maint)
	(remove-all-replaces address-of-replaces-info
			     :inverse-maint inverse-maint))))


(defun remove-all-replaces+ (unit slot value &key inverse-maint)
  (put-replaces+ unit slot value nil :inverse-maint inverse-maint))

(defun remove-all-replaced-by+ (unit slot value &key inverse-maint)
  (put-replaced-by+ unit slot value nil :inverse-maint inverse-maint))

(defun remove-all-replaces (address &key inverse-maint)
  (put-replaces address nil :inverse-maint inverse-maint))

(defun remove-all-replaced-by (address &key inverse-maint)
  (put-replaced-by address nil :inverse-maint inverse-maint))


(defun get-replaces+ (unit slot value)
  (get-replaces (extend-address-indefinitely unit slot value)))

(defun get-replaces (address)
  (let* ((replacement-record 
	  (get-local address :nullify nil))
	 (replacements (if (atom replacement-record)
			   nil
			   (assoc 'replaces (cdr replacement-record)
				  :test #'equal))))
    (if replacements
	(second replacements)
	nil)))

(defun get-replaced-by+ (unit slot value)
  (get-replaced-by (extend-address-indefinitely unit slot value)))

(defun get-replaced-by (address)
  (let* ((replacement-record 
	  (get-local address :nullify nil))
	 (replaced-by (if (atom replacement-record)
			  nil
			  (assoc 'replaced-by (cdr replacement-record)
				 :test #'equal))))
    (if replaced-by
	(second replaced-by)
	nil)))


(defun add-replaces+ (unit slot value new-replacement &key inverse-maint)
  (add-replaces (extend-address-indefinitely unit slot value)
		new-replacement
		:inverse-maint inverse-maint))

(defun add-replaces (address new-replacement &key inverse-maint)
  (let ((current-replacements (get-replaces address)))
    (unless (member new-replacement current-replacements :test #'equal)
      (put-replaces address
		    (append 
		     (list new-replacement) 
		     current-replacements)
		    :inverse-maint nil)
      (when inverse-maint
	(add-replaced-by new-replacement address)))))

(defun add-replaced-by+ (unit slot value new-replaced-by &key inverse-maint)
  (add-replaced-by (extend-address-indefinitely unit slot value)
		   new-replaced-by 
		   :inverse-maint inverse-maint))

(defun add-replaced-by (address new-replaced-by &key inverse-maint)
  (let ((current-replaced-bys (get-replaced-by address)))
    (unless (member new-replaced-by current-replaced-bys :test #'equal)
      (put-replaced-by address
		       (append 
			(list new-replaced-by) 
			current-replaced-bys)
		       :inverse-maint nil)
      (when inverse-maint
	(add-replaces new-replaced-by address)))))



;; get the replaces or replaced-by annotation for the value
;; located a particular addr.
;; slot is either 'replaces or 'replaced-by

(defun get-replaces-annotation (addr value slot)
  (if (equal slot 'replaces)
      (get-replaces addr value)
      (get-replaced-by addr value)))


