;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
				       
;;;;				   Finds PDT
;;;;				   ---------
				       

;;;; Given: a viewpoint
;;;;
;;;; Returns: 
;;;;
;;;;    if viewpoint is a blackbox view then 
;;;;                returns the PDT-type (from reference concept)
;;;;    else
;;;;                the viewpoint's specification type
;;;;
;;;; Code required: Need to load the file "bruce-and-my-search"
;;;;                from the directory:
;;;;
;;;;                /v/sally/v6/lester/Planner/EDP/Implementation
;;;;
;;;; The process-description-template information is stored on
;;;; the lex-process-description-template slot of li-primary's.


(in-package 'km)


(defun find-pdt (viewpoint)
  (if viewpoint
      (let ((spec-type (get-only-val (list viewpoint
					   'specification-type))))
	(if (equal spec-type 'black-box-process-description)
	    (let ((ref-conc (get-only-val (list viewpoint
						'reference-concept))))
	      (if ref-conc
		  (find-pdt-aux ref-conc)))
	    spec-type))))

      
(defun find-pdt-aux (reference-concept)
  (let* ((initial-unit-list (list reference-concept))
	 (genl-slots (list 'generalizations 'stage-of 'i-genls))
	 (search-result 
	  (kb-search initial-unit-list
		     genl-slots
		     :terminate-with-success-criteria #'has-pdt?
		     :control-strategy 'breadth-first
		     :loop-elimination? t)))
    (if (equal (first search-result) 'fail)
	'none
	(let ((final-unit (second search-result)))
	  (get-only-val (list final-unit 'lexical-info 'li-primary
			      'lex-process-description-template))))))


(defun has-pdt? (concept)
  (get-local (list concept
		   'lexical-info
		   'li-primary
		   'lex-process-description-template)))

