;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		    The Focus Function Evaluation Function
;;;;		    --------------------------------------


(in-package 'km)


(defun evaluate-focus-function (topic-or-elab-node centrality verbosity)
  "Evaluates focus function for topic or elaboration"
  (let* ((focus-condition (get-only-val (list topic-or-elab-node
					      'focus-condition-evaluation)))
	 (condition-value (eval focus-condition))
	 ;; converts evaluation result to ``real boolean'', i.e.,
	 ;; to TRUE or FALSE
	 (real-boolean-condition-value (if (equal condition-value t)
					   'true
					   'false)))
    (put-local (list topic-or-elab-node 'focus-condition-evaluation)
	       (list real-boolean-condition-value))
    (if condition-value
	(case verbosity
	  ((low) (if (equal centrality 'high)
		     'true
		     'false))
	  ((medium) (if (or (equal centrality 'medium)
			    (equal centrality 'high))
			'true
			'false))
	  ((high) 'true))
	'false)))
		  
		  
	       
