;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		  The Global Variable Manipulation Functions
;;;;		  ------------------------------------------


;;;; These are the functions that manipulate global variables:
;;;;
;;;; Representation: 
;;;;                  knight-global-state
;;;;                  -------------------
;;;;                  global-variable-bindings: ((x . v1) (y . v2))
;;;;
;;;; Use: when have value that want to use many times but that doesn't
;;;;      appear as a local-variable in the tree
;;;;
;;;; Example: the subevents of the functions of the object in object-edp
;;;;
;;;;	- need to know them to see if functions of substructures are
;;;;          in this list of subevents
;;;;
;;;;	- the functions are computed in object-functions iteration, but are
;;;;          only used for the iterate-over-list, which doesn't happen
;;;;          to be stored in the explanation plan; so need to compute
;;;;          the subevents and refer to them several times
;;;;
;;;; Restriction: nil cannot be the value of a global variable


;;;;--------------------------------------------------------------------
;;;;			      Function Directory
;;;;--------------------------------------------------------------------
;;;;
;;;;     Initialize
;;;;     ----------
;;;;     (initialize-global-variable-bindings)
;;;;
;;;;     Access
;;;;     ------
;;;;     (retrieve-global-var-value var)
;;;;     
;;;;     Update
;;;;     ------
;;;;     (assert-global-var-value var new-value)
;;;;	
;;;;--------------------------------------------------------------------


(in-package 'km)


;;; initializes list of global-variable-bindings
(defun initialize-global-variable-bindings ()
  (put-local '(knight-global-state global-variable-bindings)
	     nil))


;;; retrieves value of global variable if variable exists
;;; if it doesn't exist, returns nil

(defun retrieve-global-var-value (var)
  (let* ((binding-list (get-local '(knight-global-state
				   global-variable-bindings)))
	 (binding (assoc var binding-list)))
    (if binding
	(cdr binding))))


;;; asserts value of global variable
;;; if variable already exists, replaces old value
;;; if variable doesn't exist yet, creates it and asserts the given value

(defun assert-global-var-value (var new-value)
  (let* ((binding-list (get-local '(knight-global-state
				    global-variable-bindings)))
	 (binding (assoc var binding-list)))
    (if binding

	;replace value of existing variable
	(let ((fixed-binding-list 
	       (remove binding binding-list
		       :test #'equal)))
	  (put-local '(knight-global-state
		       global-variable-bindings)
		     (acons var new-value fixed-binding-list)))

	;create new variable with given value
	(let ((new-binding-list
	       (acons var new-value binding-list)))
	  (put-local '(knight-global-state
		       global-variable-bindings)
		     new-binding-list)))))
