;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;			    Global Knight Variables
;;;;			    -----------------------


;;;; Initializes the global variables of the Knight system
;;;;
;;;; All of their values are stored in the KB on the frame:
;;;;
;;;;         Knight-Global-State


(in-package 'km)


;-----------------------------------------------------------------------
;			    Initialization Function
;-----------------------------------------------------------------------

(defun initialize-knight ()
  (put-local '(knight-global-state
  	       current-explanation-plan-header)
  	     'explanation-plan-header)
  (put-local '(explanation-plan-header
  	       number-of-content-nodes)
  	     0)
  (put-local '(knight-global-state
  	       current-exposition-node)
  	     'current-exposition-node)
  (put-local '(knight-global-state
  	       current-topic-node)
  	     'current-topic-node)
  (put-local '(knight-global-state
  	       current-t-content-node)       ;Current content node that is
  	     'current-t-content-node)        ;child of current topic node 
  (put-local '(knight-global-state
	       current-e-content-node)       ;Current content node that is
  	     'current-e-content-node)        ;child of current elaboration
                                             ;node 
  (put-local '(knight-global-state
  	       current-elaboration-node)
  	     'current-elaboration-node)  
  (put-local '(knight-global-state
  	       instantiation-error?)
  	     'false)

  (put-local '(knight-global-state
	       current-user)
	     nil)

  (put-local '(knight-global-state
  	       filter-path-values?)
  	     'true)

  (put-local '(knight-global-state
  	       filter-path-viewpoints?)
  	     'true)

  (put-local '(knight-global-state
  	       create-vp-shells-batch?)
	     'true)

  (set-verbosity 'high)

  (set-make-report? 'true)

  ;; set tracers appropriately
  (put-local '(knight-global-state
	       trace-edp-selection?)
	     'true)
  (put-local '(knight-global-state           ;Turns off detailed trace of 
	       trace-instantiation-details?) ;computation during instantiation
	     'false)                         
  (put-local '(knight-global-state           ;Turns off trace of computation 
	       trace-instantiation?)         ;during instantiation
	     'false) 
  (put-local '(knight-global-state
	       trace-iteration?)
	     'false)
  (put-local '(knight-global-state
	       trace-kb-access?)
	     'true)
  (put-local '(knight-global-state
	       trace-node-creation?)
	     'true)
  (put-local '(knight-global-state
	       trace-organization?)
	     'false)
  (put-local '(knight-global-state
	       trace-viewpoint-filtering?)
	     'true)

  ;; initializes tracer list
  (put-local '(knight-global-state
	       tracer-list)
	     '(trace-instantiation?
	       trace-instantiation-details?
	       trace-kb-access?
	       trace-node-creation?
	       trace-iteration?
	       trace-organization?
	       trace-edp-selection?
	       trace-viewpoint-filtering?))

  ;; nullifies list of global variable bindings
  (initialize-global-variable-bindings)

  ;; switches user model off
  (switch-off-um)

  ;; initializes non-domain-slot-record on Knight-global-state
  ;;
  ;; non-domain-slot-record points to Non-domain-slot-list
  ;;
  ;; Non-domain-slot-list has a slot non-domain-slots
  ;;
  ;; the value of non-domain-slots is a list of slots that is 
  ;; used by the user model to compute what percentage of slots
  ;; on a given unit that is known to the user
  ;;
  ;; non-domain-slots are those that
  ;;     (1) are bookkeeping slots
  ;;     (2) are domain-discourse slots
  ;;     (3) are constraint-slots, e.g., range-of
  ;;     (4) are notation-slots, e.g., english
  ;;     (5) are lexical-slots, e.g., lexical-info
  (put-local '(knight-global-state
	       non-domain-slot-record)
	     'non-domain-slot-list)
  (let ((bookkeeping-slots (remove-if #'listp
				      (progeny* 'bookkeeping-slots)))
	(domain-discourse-slots (remove-if #'listp
					   (progeny* 'domain-discourse-slots)))
	(constraint-slots (remove-if #'listp
				     (progeny* 'constraint-slots)))
	(notation-slots (remove-if #'listp
				   (progeny* 'notation-slots)))
	(lexical-slots (remove-if #'listp
				   (progeny* 'lexical-slot)))
	(other-slots '(i-specs checked)))
    (put-local '(non-domain-slot-list
		 non-domain-slots)
	       (append bookkeeping-slots
		       domain-discourse-slots
		       constraint-slots
		       notation-slots
		       lexical-slots
		       other-slots)))

  ;; initalizes part-slots-record on Knight-global-state
  ;;
  ;; part-slots-record points to part-slot-list
  ;;
  ;; part-slot-list has a slot part-slots-used-by-knight
  ;;
  ;; the value of part-slots-used-by-knight is used by the
  ;; find-partonomic-connection function in the library of
  ;; auxiliary content determination functions
  ;;
  ;; the slots in this list are considered when the system
  ;; ascends the partonomy searching for a familiar object
  ;;
  ;; the slots in this list are ordered by specificity so
  ;; most specific slots are listed (and hence tried) before
  ;; more general ones  
  ;;
  ;; when editing this list, the best place to look is in
  ;; the slot hierarchy in the unit ``partition-of''

  (put-local '(knight-global-state part-slots-record)
	     'part-slot-list)

  (let* ((knight-part-of-slots
	  (list 'basic-unit-of 'subregion-of 'layer-of
		'part-of 'composes 'protective-component-for
		'contained-in))

	 (knight-part-slots
	  (list 'basic-unit 'subregions 'layers 'parts 'composed-of
		'protective-components 'contains))

	 (all-part-of-slots
	  (compute-all-progeny knight-part-of-slots))

	 (all-part-slots
	  (compute-all-progeny knight-part-slots)))

    (put-local '(part-slot-list part-slots-substructures-used-by-knight)
	       knight-part-slots)
    (put-local '(part-slot-list all-part-slots-substructures-used-by-knight)
	       all-part-slots)
    (put-local '(part-slot-list part-slots-used-by-knight)
	       knight-part-of-slots)
    (put-local '(part-slot-list all-part-slots-used-by-knight)
	       all-part-of-slots)

    ;; hacks for suppressing the over-zealous warning messages

  (values)))  ;; so no value is returned

