;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		     The Knowledge Base Access Functions
;;;;		     -----------------------------------


;;; instantiates specification template and evaluates it
;;;
;;; if successful, adds KB Subgraph to content-node
;;;
;;; if fails, i.e., if knowledge is not present in KB or
;;; specification template is invalid, signals an error


(in-package 'km)


(defun access-kb (content-node)
  "Accesses knowledge base to retrieve domain knowledge"
  (let* ((instantiated-specification-template
	  (get-only-val (list content-node
			      'instantiated-specification-template)))
	 (template-has-error?
	  (contains-error instantiated-specification-template)))

    (when (and (trace-kb-access?)	       
	       (not template-has-error?))
      (format t "Accessing KB with call:")
      (pprint instantiated-specification-template)
      (format t "~%~%"))

    (let ((result (if (not (equal template-has-error?
				  'true))
		      (eval instantiated-specification-template))))

      (cond ((or (null instantiated-specification-template)
		 (equal template-has-error? 'true))
	     (signal-kb-access-error content-node
				     'specification-template-uninstantiable))

	    ((and (equal (first instantiated-specification-template)
			 'retrieve-view)
		  (null result))
	     (signal-kb-access-error content-node
				     'view-retriever-error))

	    ((and (equal (first instantiated-specification-template)
			 'retrieve-view)
		  (empty-view-p result))
	     (signal-empty-viewpoint-warning content-node))

	    ((and (listp result)
		  (equal (first result) 'error))
	     (signal-kb-access-error content-node
				     (second result)))

	    ((null result)
	     (signal-kb-access-error content-node
				     'null-kb-access-result))

	    (t (put-local (list content-node 'kb-subgraph)
			  (listify result))
	       (put-local (list result 'kb-subgraph-of)
			  (list content-node)))))))
