;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       

;;;;		     The Knowledge Base Error Functions
;;;;		     ----------------------------------


;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;;
;;; 


(in-package 'km)






;;; determines if the keyword ``error'' occurs anyplace
;;; in the nested expression

(defun contains-error (expression)
  (cond ((null expression)
	 nil)
	((and (atom expression)
	      (equal expression 'error))
	 t)
	((atom expression) nil)
	(t (or (contains-error (first expression))
	       (contains-error (cdr expression))))))


;;; signals an empty viewpoint error

(defun signal-empty-viewpoint-warning (content-node)
  (when (trace-kb-access?)
    (format t "KB Access Warning: Empty viewpoint at ~a.~%~%"
	    content-node))
  (put-local (list content-node 'error-occurred?)
	     'true)
  (put-local (list content-node 'error-type)	     
	     'empty-viewpoint))

    
;;; determines if an error is shown by a content-node

(defun content-node-has-error? (content-node)
  (equal (get-only-val (list content-node 'error-occurred?))
	 'true))


;;; determines if a viewpoint has an error
;;;
;;; returns t iff viewpoint is not a true viewpoint or
;;;               when viewpoint has an error

(defun viewpoint-contains-error? (viewpoint)
  (or (not (viewpoint? viewpoint))
      (equal (get-only-val (list viewpoint 'error-occurred?))
	     'true)))


;;; reports content-nodes of current explanation plan with errors
;;;
;;; a content node has an error if 
;;;         (1) an error has occurred at the content node
;;;         (2) an error has occurred in the viewpoint associated
;;;             with the content node
;;;
;;; note: this is *not* an efficient implementation;
;;;       it traverses all content nodes and reports only
;;;       those that are in the current explanation plan
;;;       rather than traversing the explanation plan itself;
;;;       the implemented algorithm was just a little easier
;;;       to code

(defun report-kb-access-irregularities ()
  (pprint (find-erroneous-content-nodes) t))


(defun find-erroneous-content-nodes ()
  (let* ((all-content-nodes
	  (get-local '(content-node specializations)))
	 (current-content-nodes
	  (remove-if-not #'content-node-of-current-explanation-plan-p
			 all-content-nodes)))
    (remove-if-not #'problem-content-node-p
		   current-content-nodes)))


(defun content-node-of-current-explanation-plan-p (content-node)
  (let* ((current-exposition-node
	  (get-only-val '(knight-global-state
			  current-exposition-node)))
	 (search-result
	  (kb-search (list content-node)
		     (list 'child-of-node)
		    :terminate-with-success-criteria
		    #'(lambda (curr-plan-node)
			(equal curr-plan-node
			       current-exposition-node))
		    :collect-path? nil
		    :loop-elimination? t)))
    (not (equal (first search-result)
		'fail))))

			       
(defun problem-content-node-p (content-node)
  (or (content-node-has-error? content-node)
      (viewpoint-contains-error? (get-only-val (list content-node
						     'kb-subgraph)))))




;-----------------------------------------------------------------------
;			   Signals a KB Access Error
;-----------------------------------------------------------------------

;;; records KB Access error in content-node of Explanation Plan
;;; when trace is turned on, prints error message

(defun signal-kb-access-error (content-node error-type)
  (when (trace-kb-access?)	       
    (format t "An error has occurred at ~a.~%"
	    content-node)
    (format t "Error type: ~a~%~%"
	    error-type))
  (put-local (list content-node 'error-occurred?)
	     'true)
  (put-local (list content-node 'error-type)	     
	     error-type))

