;;; -*- Mode:Lisp; Package:User; Base:10 -*-
				       
;;;;			     The Knight/NLG System
;;;;			     ---------------------

;;;; Starting Kned/KM & Knight & NLG
;;;; -------------------------------
;;;;
;;;;    (1) Start Up Ilisp & Clim  :    M-x lucid-clim
;;;;
;;;;    (2) Load Kned              :    (start), select ``1'' for user 
;;;;                                
;;;;    (3) Load Knight and NLG    :    (load-knight-and-nlg)
;;;;
;;;;    (4) Go to KM package       :    (in-package 'km)
;;;;
;;;;    (5) Start Up KnEd & Load KB:    (kned::begin-kned)
;;;;
;;;;    (6) Initialize Knight           (initialize-knight)

;-----------------------------------------------------------------------
;			Defines Knight and Auxiliary Code
;-----------------------------------------------------------------------

(in-package 'km)

(proclaim '(optimize (compilation-speed 0)))


(defvar *knight-file-list*
  '(

    ;; KM Extension Files
    ;; ------------------
    "bruce-and-my-replaces-annot.lisp"
    "bruce-and-my-km-extensions.lisp"
    "my-km-extensions"
    ;; File below commented out because of all of the overwriting
    ;; definitions.  If this works, then just get rid of next
    ;; line.  These functions appear to all be in
    ;; /v/sage/v0/brewery/km/general-utilities.lisp
    ;;"prompts"

    ;; Search File
    ;; -----------
    "bruce-and-my-search"

    ;; View Retriever File
    ;; -------------------
    "bruce-and-my-retrieve"

    ;; Knight
    ;; ------
    "user-model"
    "tracers"
    "global-variable-manip"
    "plan-node-functions"
    "error-predicates"
    "evaluation"
    "reports"
    "initialization"
    "instantiate-templates"
    "focus-function-eval"
    "kb-filter"
    "kb-access"
    "linearize"
    "realize"
    "organization"
    "content-determination"
    "applier-top-level"
    "explain"
    ))
    

(defun load-knight-files ()
  (dolist (curr-file *knight-file-list*)
    (load curr-file
	  :if-source-only :load-source
	  :if-source-newer :compile)))

;-----------------------------------------------------------------------
;			Defines NLG and Auxiliary Code
;-----------------------------------------------------------------------

(defun start2a ()
    (load "i.l2"))   ;;Loads FUF with its own readtable

;;; the KB must be loaded after this is executed
(defun start2b ()
    (in-package 'km)
    (km::surge)      ;;Loads SURGE
    ;;(load "/v/sage/v0/brewery/kastl/James/load-file.lisp")
    (in-package 'km))  

(defun start2 ()
  (start2a)
  (start2b))

;-----------------------------------------------------------------------
;		    Loads KNIGHT and NLG and Auxiliary Code
;-----------------------------------------------------------------------

(in-package 'user)

(defun load-knight-and-nlg-files ()
  (cd "/v/sally/v6/lester/Planner/EDP/Implementation")
  (km::load-knight-files)
  (cd "~theorist/Fugtest")
  (km::start2))

(load-knight-and-nlg-files)
