;;; -*- Mode:Lisp; Package:User; Base:10 -*-

;;;;			       The Knight System
;;;;			       -----------------

;;;; Starting Kned/KM & Knight
;;;; -------------------------
;;;;
;;;;    (1) Start Up Ilisp & Clim  :    M-x lucid-clim
;;;;
;;;;    (2) Load Kned              :    (start), select ``1'' for user 
;;;;                                
;;;;    (3) Load system            :    (load-knight)
;;;;
;;;;    (4) Go to KM package       :    (in-package 'km)
;;;;
;;;;    (5) Start Up KnEd & Load KB:    (kned::begin-kned)
;;;;
;;;;    (6) Initialize Knight           (initialize-knight)

;;;; Editing Knight
;;;; --------------
;;;;
;;;;   (1) Change to Knight implementation directory :  cdknight
;;;;
;;;;   (2) Invoke emacs                              :  em
;;;;
;;;;   (3) Load Knight files into emacs              :  M-x load-knight-system
;;;;

;;;; Changing Knight System File-List
;;;; --------------------------------
;;;;
;;;; To update which knight files are loaded into emacs:
;;;;
;;;;    Change *knight-files-to-be-loaded* in .emacs

;;;; Viewing EDPs and Explanation Plans with Tree Frames
;;;; ---------------------------------------------------
;;;;
;;;; EDPs can be viewed in a tree frame with selected slots:
;;;;       topic-list
;;;;       content-specifications
;;;;       elaborations
;;;;
;;;; Explanation Plans can be viewed in a tree frame with selected slots:
;;;;       kb-subgraph
;;;;       current-explanation-plan-header
;;;;       explanation-subject
;;;;       topic-nodes
;;;;       content-nodes
;;;;       elaboration-nodes

;-----------------------------------------------------------------------
;		    Conceptual Organization of Knight Code
;-----------------------------------------------------------------------

;;;; Main Files
;;;; ----------
;;;; explain.lisp
;;;;    applier-top-level.lisp
;;;;        instantiate-templates.lisp
;;;;        focus-function-eval.lisp
;;;;        kb-access.lisp
;;;;        kb-filter.lisp
;;;;        organization.lisp
;;;;    linearize.lisp
;;;;    realize.lisp
;;;;
;;;; Content Determination File
;;;; --------------------------
;;;; content-determination.lisp
;;;;
;;;; Support Files
;;;; -------------
;;;; initialization.lisp
;;;; tracers.lisp
;;;; user-model.lisp
;;;; plan-node-functions.lisp
;;;; global-variable-manip.lisp
;;;; error-predicates.lisp
;;;; reports.lisp
;;;; evaluation.lisp

;-----------------------------------------------------------------------
;			Loads Knight and Auxiliary Code
;-----------------------------------------------------------------------

(in-package 'km)

(cd "/v/sage/v0/brewery/knight")


(proclaim '(optimize (compilation-speed 0)))


(defvar *knight-file-list*
  '(

    ;; KM Extension Files
    ;; ------------------
    "bruce-and-my-replaces-annot.lisp"
    "bruce-and-my-km-extensions.lisp"
    "my-km-extensions"
    ;; File below commented out because of all of the overwriting
    ;; definitions.  If this works, then just get rid of next
    ;; line.  These functions appear to all be in
    ;; /v/sage/v0/brewery/km/general-utilities.lisp
    ;;"prompts"

    ;; Search File
    ;; -----------
    "bruce-and-my-search"

    ;; View Retriever File
    ;; -------------------
    "bruce-and-my-retrieve"

    ;; Knight
    ;; ------
    "user-model"
    "tracers"
    "global-variable-manip"
    "plan-node-functions"
    "error-predicates"
    "evaluation"
    "reports"
    "initialization"
    "instantiate-templates"
    "focus-function-eval"
    "kb-filter"
    "kb-access"
    "linearize"
    "realize"
    "organization"
    "content-determination"
    "applier-top-level"
    "explain"
    ))
    

(defun load-knight-files ()
  (dolist (curr-file *knight-file-list*)
    (load curr-file)))
;;	  :if-source-only :load-source
;;	  :if-source-newer :compile)))


(load-knight-files)
