;;; -*- Mode:Lisp; Package:CL-User; Base:10 -*-


;;; Load the Knight system.
;;; Compiles, loads binaries, or loads source, as selected.

(in-package :cl-user)

(defun  MAKE-KNIGHT ()

  "Make system KNIGHT."
  (let ((action (get-action)))
    (when action
      (compile?-load action *knight-directory*
	;; KM Extension Files
	;; ------------------
	"bruce-and-my-replaces-annot"
	"bruce-and-my-km-extensions"
	"my-km-extensions"
	;; File below commented out because of all of the overwriting
	;; definitions.  If this works, then just get rid of next
	;; line.  These functions appear to all be in
	;; /v/sage/v0/brewery/km/general-utilities.lisp
	;;"prompts"
	
	;; Search File
	;; -----------
	"bruce-and-my-search"
	
	;; View Retriever File
	;; -------------------
	"bruce-and-my-retrieve"
	
	;; Knight
	;; ------
	"user-model"
	"tracers"
	"global-variable-manip"
	"plan-node-functions"
	"error-predicates"
	"evaluation"
	"reports"
	"initialization"
	"instantiate-templates"
	"focus-function-eval"
	"kb-filter"
	"kb-access"
	"linearize"
	"realize"
	"organization"
	"content-determination"
	"applier-top-level"
	"explain"
	))))

(MAKE-KNIGHT)

(unless (member :knight *features*)
  (push :knight *features*))
