;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;			       Extensions To KM
;;;			       ----------------


(in-package 'km)

	    
(defun process-p (concept)
  (member 'process (ancestry* concept)))


(defun object-p (concept)
  (member 'object (ancestry* concept)))


(defun slot-p (concept)
  (member 'slot (ancestry* concept)))


;;; returns t iff slot is an actor slot
(defun actor-slot-p (slot)
  (when (member 'actors (ancestry* slot))
    t))


(defun viewpoint-p (concept)
  (member 'viewpoint (ancestry* concept)))


;;;function for (non-recursively) removing all children of given unit 
(defun remove-all-children (parent)
  "Removes all specializations and instances from given unit"
  (dolist (frame (get-local (list parent 'specializations)))
    (remove-frame frame))
  (dolist (frame (get-local (list parent 'instances)))
    (remove-frame frame)))


;;;function for computing all progeny of all slots in a unit 
(defun compute-all-progeny (slot-list)
  (reduce #'append
	  (mapcar #'(lambda (slot)
		      (progeny* slot))
		  slot-list)))



#||  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; retrieves only value in a get-local
(defun get-only-val (addr)
  (first (get-local addr)))


;;; Address Extension Functions
;;; ---------------------------
;;;
;;; These functions do not check whether the extended address is
;;; well-formed (i.e. that the extensions are legal for the address and
;;; that the extended-address exists in the kb).

;;; extend an address with a slot
(defun extend-address (address extension)
  (child address extension))


;;; extend an address with an arbitrary number of slots and values  
(defun extend-address-indefinitely (address val &rest vals)
  (append (listify address) (list val) vals))


;;; Filtered Get-Explicit-Slots
;;; ---------------------------

;;; returns all local slots on concept - except for notation
;;; slots such as bookkeeping slots and the english slot
(defun get-explicit-slots (concept)
  (set-difference (all-explicit-slots-on-embedded-unit concept)
		  (progeny* 'notation-slots)))


||#