;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;			      KnEd Prompts Macros
;;;;			      -------------------


;;;; Used for turning off KnEd calls in middle of KM functions



(in-package 'km)


(defmacro with-no-prompts (&rest form)
  `(let ((old-inverse-prompt-val *prompt-for-inverses*)
         (old-prompt-annotation-removal *prompt-annotation-removal*))
     (setf *prompt-for-inverses* nil)
     (setf *prompt-annotation-removal* nil)
     (unwind-protect
          (progn ,@form)
          (setf *prompt-annotation-removal* old-prompt-annotation-removal)
          (setf *prompt-for-inverses* old-inverse-prompt-val))))


;;; turns off interaction with user wrt inverse-maintenance
(defmacro with-inverse-prompt-off (&rest form)
  `(let ((old-inverse-prompt-val *prompt-for-inverses*))
     (setf *prompt-for-inverses* nil)
     (unwind-protect
          (progn ,@form)
          (setf *prompt-for-inverses* old-inverse-prompt-val))))


;;; turns off inverse-maintenance on all calls to put-global and add-val
(defmacro with-no-inverses (&rest form)
  `(let ((old-inverse-val *standard-inverse*))
     (setf *standard-inverse* nil)
     (unwind-protect
          (progn ,@form)
          (setf *standard-inverse* old-inverse-val))))


;;; turns off warnings from REMOVE-VAL
(defmacro with-warnings-off (&rest form)
    `(let ((old-warnings-val *display-remove-warnings*))
           (setf *display-remove-warnings* nil)
           (unwind-protect
                          (progn ,@form)
                       (setf *display-remove-warnings* old-warnings-val))))


