;;; -*- Mode:Lisp; Package:User; Base:10 -*-


;;;;		  The Trace Switches and Accessors
;;;;              --------------------------------


;;;; Functions for setting and determining values of tracers
;;;;
;;;; Method:
;;;;     Sets and looks up values on slots of KB frame Knight-Global-State 
;;;;
;;;; Tracer Types:
;;;;               - trace-instantiation?
;;;;               - trace-instantiation-details?
;;;;               - trace-kb-access?
;;;;               - trace-node-creation?
;;;;               - trace-iteration?
;;;;               - trace-organization?
;;;;               - trace-edp-selection?
;;;;               - trace-viewpoint-filtering?
;;;;
;;;; Tracers are defined in initialize-knight function; when add
;;;; a new tracer, update list in initialize-knight
;;;;
;-----------------------------------------------------------------------
;			   Tracer Function Directory
;-----------------------------------------------------------------------
;;;;
;;;;    Tracer Switch Functions
;;;;    -----------------------
;;;;    (switch-on-all-tracers)
;;;;    (switch-on-tracer tracer-type)
;;;;    (switch-off-all-tracers)
;;;;    (switch-off-tracer tracer-type)
;;;;
;;;;    Tracer Access Functions
;;;;    -----------------------
;;;;    (trace-instantiation?)
;;;;    (trace-instantiation-details?)
;;;;    (trace-kb-access?)
;;;;    (trace-node-creation?)
;;;;    (trace-iteration?)
;;;;    (trace-organization?)
;;;;    (trace-edp-selection?)
;;;;
;;;;
;-----------------------------------------------------------------------
;			  The Tracer Switch Functions
;-----------------------------------------------------------------------


(in-package 'km)


(defun switch-on-all-tracers ()
  (dolist (tracer-type (get-local '(knight-global-state
				    tracer-list)))
    (switch-on-tracer tracer-type)))


(defun switch-on-tracer (tracer-type)
  (put-local (list 'knight-global-state tracer-type)
	     'true))


(defun switch-off-all-tracers ()
  (dolist (tracer-type (get-local '(knight-global-state
				    tracer-list)))
    (switch-off-tracer tracer-type)))


(defun switch-off-tracer (trace-type)
  (put-local (list 'knight-global-state trace-type)
	     'false))


;-----------------------------------------------------------------------
;			  The Tracer Access Functions
;-----------------------------------------------------------------------


(defun trace-instantiation? ()
  (equal (get-only-val '(knight-global-state trace-instantiation?))
	 'true))
		       
(defun trace-instantiation-details? ()
  (equal (get-only-val '(knight-global-state trace-instantiation-details?))
	 'true))

(defun trace-kb-access? ()
  (equal (get-only-val '(knight-global-state trace-kb-access?))
	 'true))

(defun trace-node-creation? ()
  (equal (get-only-val '(knight-global-state trace-node-creation?))
	 'true))

(defun trace-iteration? ()
  (equal (get-only-val '(knight-global-state trace-iteration?))
	 'true))

(defun trace-organization? ()
  (equal (get-only-val '(knight-global-state trace-organization?))
	 'true))

(defun trace-edp-selection? ()
  (equal (get-only-val '(knight-global-state trace-edp-selection?))
	 'true))

(defun trace-viewpoint-filtering? ()
  (equal (get-only-val '(knight-global-state trace-viewpoint-filtering?))
	 'true))
