
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import mobios.type.IndexObject;

public class MoBIoSInteger extends IndexObject
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 8905949778737809500L;
	
	int myInt;
    
	public MoBIoSInteger() {
	
	}
	
    public MoBIoSInteger(int i)
    {
        this.myInt = i;
    }

    public int size()
    {
        return 1;
    }

    public IndexObject[] expand()
    {
        return new MoBIoSInteger[] {this};
    }

    public int compareTo(IndexObject oThat)
    {
        if (!(oThat instanceof MoBIoSInteger) ) {
            throw new Error("datatypes are not compatible");
        }
        MoBIoSInteger thatInt = (MoBIoSInteger) oThat;
        if (this.myInt == thatInt.myInt) 
            return 0;
        else if (this.myInt > thatInt.myInt)
            return 1;
        else 
            return -1;
    }
    

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.myInt);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        myInt = in.readInt();
    }

    public int minus(MoBIoSInteger two)
    {
        return myInt-two.myInt;
    }
    
    public String toString () {
    		return new Integer(myInt).toString();
    }

}
