
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

import mobios.db.Table;

public class MoBIoSIntegerTable extends Table {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3940017799141759719L;

	public static final MoBIoSIntegerMetric DEFAULT_METRIC = new MoBIoSIntegerMetric();

	public MoBIoSIntegerTable(File fileName, int maxDataSize)
			throws FileNotFoundException {
		super(fileName, maxDataSize, DEFAULT_METRIC);
		BufferedReader reader = new java.io.BufferedReader(
				new java.io.FileReader(fileName));

		loadData(reader, maxDataSize);
	}

	private void loadData(BufferedReader reader, int maxDataSize) {

		String line;
		ArrayList<MoBIoSInteger> myData = new ArrayList<MoBIoSInteger>();
		System.out.println("Loading... ");
		try {
			for (int i = 0; i < maxDataSize; i++) {
				line = reader.readLine(); // read the first line
				if (line != null)
					line = line.trim();
				else
					break;
				myData.add(new MoBIoSInteger(new Integer(line).intValue()));
			}

		} catch (java.io.IOException e) {
			e.printStackTrace();
		}
		myData.trimToSize();
		data =myData; 
	}

}
