header {* Arithmetic Reasoning *}

theory Arithmetic
imports Base
begin


subsection {* Additional Rules for Isabelle *}

theorem "lessp of negone and zero" [simp]:
  "lessp negone zero = t"
  by(simp add: lessp_def)

theorem "lessp of negone and one" [simp]:
  "lessp negone one = t"
  by(simp add: lessp_def)

theorem "lessp of zero and one" [simp]:
  "lessp zero one = t" 
  by(simp add: lessp_def)

theorem "lessp of one and zero" [simp]:
  "lessp one zero = nil" 
  by(simp add: lessp_def)

theorem "lessp of one and negone" [simp]:
  "lessp one negone = nil"
  by(simp add: lessp_def)

theorem "minus zero" [simp]:
  "minus zero = zero"
  by(simp add: minus_def)

theorem "lessp when not integerp (left)" []: -- "Expensive"
  "\<lbrakk> integerp x = nil \<rbrakk> \<Longrightarrow> lessp x y = lessp zero y"
  by(simp add: lessp_def)

theorem "lessp when not integerp (right)" []: -- "Expensive"
  "\<lbrakk> integerp y = nil \<rbrakk> \<Longrightarrow> lessp x y = lessp x zero"
  by(simp add: lessp_def)

theorem "plus when not integerp (left)" []: -- "Expensive"
  "\<lbrakk> integerp x = nil \<rbrakk> \<Longrightarrow> plus x y = plus zero y"
  by(simp add: plus_def)

theorem "plus when not integerp (right)" []: -- "Expensive"
  "\<lbrakk> integerp y = nil \<rbrakk> \<Longrightarrow> plus x y = plus x zero"
  by(simp add: plus_def)

theorem "minus when not integerp" []: -- "Expensive"
  "\<lbrakk> integerp x = nil \<rbrakk> \<Longrightarrow> minus x = zero"
  by(simp add: minus_def)



subsection {* Simple Rules taken from ACL2 *}

theorem "lessp is irreflexive" [simp]:
  "lessp x x = nil"
  by(simp add: lessp_def)

theorem "plus under iff" [simp]:
  "(plus x y ~= nil) = True"
  by(simp add: plus_def)

theorem "plus under iff (two)" [simp]:
  "(plus x y = nil) = False"
  by(simp add: plus_def)

theorem "minus under iff" [simp]:
  "(minus x ~= nil) = True"
  by(simp add: minus_def)

theorem "minus under iff (two)" [simp]:
  "(minus x = nil) = False"
  by(simp add: minus_def)

theorem "integerp of plus" [simp]:
  "integerp (plus x y) = t"
  by(simp add: plus_def)

theorem "integerp of minus" [simp]:
  "integerp (minus x) = t"
  by(simp add: minus_def)

theorem "commutativity of plus" [simp]:
  "plus a b = plus b a"
  by(simp add: plus_def)

theorem "associativity of plus" [simp]:
  "plus (plus x y) z = plus x (plus y z)"
  by(simp add: plus_def)

theorem "commutativity of plus two" [simp]:
  "plus x (plus y z) = plus y (plus x z)"
  by(simp add: plus_def)

theorem "plus of zero (left)" [simp]:
  "plus zero x = ite (integerp x) x zero"
  by(simp add: plus_def)

theorem "plus of zero (right)" [simp]:
  "plus x zero = ite (integerp x) x zero"
  by(simp add: plus_def)

theorem "plus of inverse (left)" [simp]:
  "plus (minus x) x = zero"
  by(simp add: plus_def minus_def)

theorem "plus of inverse (right)" [simp]:
  "plus x (minus x) = zero"
  by(simp add: plus_def minus_def)

theorem "minus of plus" [simp]:
  "minus (plus x y) = plus (minus x) (minus y)"
  by(simp add: plus_def minus_def)

theorem "minus of minus" [simp]:
  "minus (minus x) = ifix x"
  by(simp add: minus_def)

theorem "lessp of zero and minus" [simp]:
  "lessp zero (minus x) = lessp x zero"
  by(simp add: lessp_def minus_def)

theorem "lessp of minus and zero" [simp]:
  "lessp (minus x) zero = lessp zero x"
  by(simp add: lessp_def minus_def)

theorem "(< (+ (- y) x) z)" [simp]:
  "lessp (plus (minus y) x) z = lessp x (plus y z)"
  by(simp add: lessp_def plus_def minus_def)

theorem "(< (+ x (- y)) z)" [simp]:
  "lessp (plus x (minus y)) z = lessp x (plus y z)"
  by(simp add: lessp_def plus_def minus_def)

theorem "(< x (+ (- y) z))" [simp]:
  "lessp x (plus (minus y) z) = lessp (plus y x) z"
  by(simp add: lessp_def plus_def minus_def)

theorem "(< x (+ z (- y)))" [simp]:
  "lessp x (plus z (minus y)) = lessp (plus y x) z"
  by(simp add: lessp_def plus_def minus_def)

theorem "(= (+ (- y) x) z)" [simp]:
  "(plus (minus y) x = z) = (if integerp z = t
                                then (ifix x = plus y z)
                                else False)"
  by(case_tac z, auto simp add: plus_def minus_def)

theorem "(= (+ x (- y)) z)" [simp]:
  "(plus x (minus y) = z) = (if integerp z = t
                                then ifix x = plus y z
                                else False)"
  by(case_tac z, auto simp add: plus_def minus_def)

theorem "(= x (+ (- y) z))" [simp]:
  "(x = plus (minus y) z) = (if integerp x = t
                                then ifix z = plus y x
                                else False)"
  by(case_tac x, auto simp add: plus_def minus_def)

theorem "(= x (+ z (- y)))" [simp]:
  "(x = plus z (minus y)) = (if integerp x = t 
                                then ifix z = plus y x
                                else False)"
  by(case_tac x, auto simp add: plus_def minus_def)

theorem "sum of nonnegative and positive is positive" [simp]:
  "\<lbrakk> lessp a zero = nil ; lessp zero b = t \<rbrakk> \<Longrightarrow> lessp zero (plus a b) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of nonnegative and positive is positive (alt)" [simp]:
  "\<lbrakk> lessp a zero = nil ; lessp zero b = t \<rbrakk> \<Longrightarrow> lessp (plus a b) zero = nil"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of positive and nonnegative is positive" [simp]:
  "\<lbrakk> lessp zero a = t ; lessp b zero = nil \<rbrakk> \<Longrightarrow> lessp zero (plus a b) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of positive and nonnegative is postiive (alt)" [simp]:
  "\<lbrakk> lessp zero a = t ; lessp b zero = nil \<rbrakk> \<Longrightarrow> lessp (plus a b) zero = nil"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of two nonnegatives is nonnegative" [simp]:
  "\<lbrakk> lessp a zero = nil ; lessp b zero = nil \<rbrakk> \<Longrightarrow> lessp (plus a b) zero = nil"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of nonnegative and positive is nonzero" [simp]:
  "\<lbrakk> lessp a zero = nil ; lessp zero b = t \<rbrakk> \<Longrightarrow> (plus a b = zero) = False"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of positive and nonnegative is nonzero" [simp]:
  "\<lbrakk> lessp zero a = t ; lessp b zero = nil \<rbrakk> \<Longrightarrow> (plus a b = zero) = False"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum of two nonnegatives is probably positive" [simp]:
  "\<lbrakk> lessp a zero = nil ; lessp b zero = nil \<rbrakk>
     \<Longrightarrow>
     lessp zero (plus a b) = lessp zero a or lessp zero b"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "(< x (+ x y))" [simp]:
  "lessp x (plus x y) = lessp zero y"
  by(simp add: lessp_def plus_def)

theorem "(< x (+ y x))" [simp]:
  "lessp x (plus y x) = lessp zero y"
  by(simp add: lessp_def plus_def)

theorem "(< (+ x y) x)" [simp]:
  "lessp (plus x y) x = lessp y zero"
  by(simp add: lessp_def plus_def)

theorem "(< (+ y x) x)" [simp]:
  "lessp (plus y x) x = lessp y zero"
  by(simp add: lessp_def plus_def)

theorem "(< x (+ a x y))" [simp]:
  "lessp x (plus a (plus x y)) = lessp zero (plus a y)"
  by(simp add: lessp_def plus_def)

theorem "(< x (+ a b x))" [simp]:
  "lessp x (plus a (plus b x)) = lessp zero (plus a b)"
  by(simp add: lessp_def plus_def)

theorem "(< a (+ x y z a))" [simp]:
  "lessp a (plus x (plus y (plus z a))) = lessp zero (plus x (plus y z))"
  by(simp add: lessp_def plus_def)

theorem "(< a (+ x y a z))" [simp]:
  "lessp a (plus x (plus y (plus a z))) = lessp zero (plus x (plus y z))"
  by(simp add: lessp_def plus_def)

theorem "(< a (+ w x y a z))" [simp]:
  "lessp a (plus w (plus x (plus y (plus a z)))) = 
   lessp zero (plus w (plus x (plus y z)))"
  by(simp add: lessp_def plus_def)

theorem "(< a (+ w x y z a))" [simp]:
  "lessp a (plus w (plus x (plus y (plus z a)))) = 
   lessp zero (plus w (plus x (plus y z)))"
  by(simp add: lessp_def plus_def)

theorem "(< a (+ v w x y a z))" [simp]:
  "lessp a (plus v (plus w (plus x (plus y (plus a z))))) = 
   lessp zero (plus v (plus w (plus x (plus y z))))"
  by(simp add: lessp_def plus_def)

theorem "(< (+ a x) (+ a y))" [simp]:
  "lessp (plus a x) (plus a y) = lessp x y"
  by(simp add: lessp_def plus_def)

theorem "(< (+ x a) (+ y a))" [simp]:
  "lessp (plus x a) (plus y a) = lessp x y"
  by(simp add: lessp_def plus_def)

theorem "(< (+ b c) (+ a b)" [simp]:
  "lessp (plus b c) (plus a b) = (lessp c a)"
  by(simp add: lessp_def plus_def)

theorem "(< (+ x y) (+ a x z))" [simp]:
  "lessp (plus x y) (plus a (plus x z)) = 
   lessp y (plus a z)"
  by(simp add: lessp_def plus_def)

theorem "(< (+ x a y)) (+ z a))" [simp]:
  "lessp (plus x (plus a y)) (plus z a) =
   lessp (plus x y) z"
  by(simp add: lessp_def plus_def)

theorem "(= (+ a x) (+ a y))" [simp]:
  "(plus a x = plus a y) = (ifix x = ifix y)"
  apply(case_tac x, auto simp add: lessp_def plus_def)
  apply(case_tac y, auto)
  apply(case_tac y, auto)
done

theorem "(= (+ x a) (+ y a))" [simp]:
  "(plus x a = plus y a) = (ifix x = ifix y)"
  apply(case_tac x, auto simp add: lessp_def plus_def)
  apply(case_tac y, auto)
  apply(case_tac y, auto)
done

theorem "sum as large when parts as large" [simp]:
  "\<lbrakk> lessp a1 b1 = nil ; lessp a2 b2 = nil \<rbrakk> \<Longrightarrow> lessp (plus a1 a2) (plus b1 b2) = nil"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum as large when parts as large alt" [simp]:
  "\<lbrakk> lessp a1 b1 = nil ; lessp a2 b2 = nil \<rbrakk> \<Longrightarrow> lessp (plus a2 a1) (plus b1 b2) = nil"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum smaller when part is smaller" [simp]:
  "\<lbrakk> lessp b1 a1 = t ; lessp a2 b2 = nil \<rbrakk> \<Longrightarrow> lessp (plus b1 b2) (plus a1 a2) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum smaller when part is smaller (alt)" [simp]:
  "\<lbrakk> lessp b1 a1 = t ; lessp a2 b2 = nil \<rbrakk> \<Longrightarrow> lessp (plus b1 b2) (plus a2 a1) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum smaller when part is smaller two" [simp]:
  "\<lbrakk> lessp a1 b1 = nil ; lessp b2 a2 = t \<rbrakk> \<Longrightarrow> lessp (plus b1 b2) (plus a1 a2) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "sum smaller when part is smaller two (alt)" [simp]:
  "\<lbrakk> lessp a1 b1 = nil ; lessp b2 a2 = t \<rbrakk> \<Longrightarrow> lessp (plus b1 b2) (plus a2 a1) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "smaller than increment when at least" [simp]:
  "\<lbrakk> lessp b a = nil ; lessp zero c = t \<rbrakk> \<Longrightarrow> lessp a (plus c b) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "smaller than increment when at least (alt)" [simp]:
  "\<lbrakk> lessp b a = nil ; lessp zero c = t \<rbrakk> \<Longrightarrow> lessp a (plus b c) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "smaller than increment when at least three" [simp]:
  "\<lbrakk> lessp b a = nil ; lessp zero c = t ; lessp d zero = nil \<rbrakk>
     \<Longrightarrow>
     lessp a (plus c (plus b d)) = t"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "smaller than increment when at three (alt)" [simp]:
  "\<lbrakk> lessp b a = nil ; lessp zero c = t ; lessp d zero = nil \<rbrakk> 
     \<Longrightarrow>
     lessp a (plus c (plus d b)) = t"
  by(auto)

theorem "(< (ifix x) y)" [simp]:
  "lessp (ifix x) y = lessp x y"
  by(auto simp add: "lessp when not integerp (left)")

theorem "(< x (ifix y))" [simp]:
  "lessp x (ifix y) = lessp x y"
  by(auto simp add: "lessp when not integerp (right)")

theorem "(+ (ifix x) y)" [simp]:
  "plus (ifix x) y = plus x y"
  by(auto simp add: "plus when not integerp (left)")

theorem "(+ x (ifix y))" [simp]:
  "plus x (ifix y) = plus x y"
  by(auto simp add: "plus when not integerp (right)")

theorem "(- (ifix x))" [simp]:
  "minus (ifix x) = minus x"
  by(auto simp add: "minus when not integerp")

theorem "naturals are not negone" [simp]:
  "\<lbrakk> lessp n zero = nil \<rbrakk> \<Longrightarrow> (n = negone) = False"
  by(auto)



subsection {* More Rules for Isabelle *}

theorem "plus one of plus negone" [simp]:
  "plus one (plus x negone) = ifix x"
  by(simp add: plus_def)

theorem "lessp of increment when lessp" [simp]:
  "\<lbrakk> lessp a b = nil \<rbrakk> \<Longrightarrow> lessp (plus one a) b = nil"
  by(simp add: lessp_def plus_def split: split_if_asm)

theorem "not equal zero when positive" [simp]:
  "\<lbrakk> lessp zero b = t \<rbrakk> \<Longrightarrow> (zero = b) = False"
  apply(auto)
done

end