
text {* Our simplification procedure will try to ``cheaply'' apply rules as in
  the red, white, blue example.  To do this, we will run Isabelle's simplifier
  from inside a simplification procedure after lowering its depth limit. *}

text {* We will expect our "cheap" theorems to have precisely the following 
  form:  [| ... |] ==> (lhs = rhs), where = is some HOL-level equality.  The
  internal form of (lhs = rhs) is Trueprop $ ( op= $ lhs $ rhs ) *}

ML {*

exception BAD_CONCLUSION of string * term;

fun split_concl (_ $ (_ $ lhs $ rhs)) = (lhs, rhs)
  | split_concl x = 
      raise BAD_CHEAP_THM ("Conclusion must have the form lhs = rhs, but is ", x);

*}

ML {*


(* rewritec function in meta_simplifier.ML seems reasonably good *)

val thm_to_use = thm "is_white when not red or blue";

val eta_thm = Thm.eta_conversion thm_to_use;

val hyps = prems_of thm_to_use;
val concl = concl_of thm_to_use;
val (lhs, rhs)  = split_concl concl;

val thy = the_context ();
val sset = simpset ();
val redex = read "is_white a";
val credex = cterm_of thy redex;

val match = Thm.cterm_match lhs credex;


*}

ML {*

val redex = read "is_white a";






*}


ML {*

val thm_to_use = thm "is_white when not red or blue"

fun cdr_trueprop (trueprop $ x) = x;
fun first_of_opequal (opequal $ fst $ snd) = fst;
fun cdr_isred (isred $ x) = x;
fun cdr_iswhite (iswhite $ x) = x;

val xvar  = cdr_isred (first_of_opequal (cdr_trueprop (concl_of thm_to_use)));


fun my_proc thy sset redex = 
  let
    val credex = cterm_of thy redex;
    val msg = writeln (concat ["my_proc has been called: ", (string_of_cterm credex)]);
    
    val arg1 = cdr_iswhite redex;
    val carg1 = cterm_of thy arg1;
    val msg = writeln (concat ["Arg is: ", (string_of_cterm carg1)]);
 
    val hyps = prems_of thm_to_use;
    val hyps' = substitute_var_list xvar arg1 hyps;
    val hyps'' = map (cterm_of thy) hyps'

    val msg = writeln "THE HYPS ARE: ";
    val msg = map prin hyps';
  
    val results = map (Simplifier.rewrite (simpset ())) hyps'';
    val msg = writeln "THE RESULTS ARE: ";
    val msg = map print_thm results;
    
    val victory = and_list (map good_rewrite results);
  in
    if victory 
       then 
           (writeln "Victory!" ; NONE)
       else
           (writeln "Failure!" ; NONE)
  end;

val my_simproc = Simplifier.simproc
                  (the_context ())
                  "my_simproc"
                  [ "is_white x" ]
                  my_proc;

Addsimprocs [my_simproc];

*}

ML {* simp_depth_limit := 5; *}


theorem "loopy theorem" []:
  "is_red a \<or> is_white a \<or> is_blue a"
  apply(auto)
  apply(auto)
done




ML {*

val thm_to_use = thm "is_white when not red or blue";
val sgn = sign_of_thm thm_to_use;
val hyps = map (cterm_of sgn) (prems_of thm_to_use);

*}

ML {*
val results = map (Simplifier.rewrite (simpset ())) hyps;
val victory = and_list (map good_rewrite results);
val results' = map strip_meta_equal_true results;
val main_thm = implies_elim_list thm_to_use results';
val output = insert_meta_equal_true main_thm;

*}

ML {*
val thm_to_use = thm "is_red when is_white";
val thy = (sign_of_thm thm_to_use);
val sset = (simpset ());
val redex = read "is_red a";
*}

ML {*

fun extract_lhs_term (equal $ lhs $ rhs) = lhs;



val thm_to_use = thm "is_red when is_white";







(*     val inst = read_instantiate [("x", (string_of_cterm clhs))] thm_to_use; *)


val thm_to_use = thm "is_red when is_white";

(* We expect the conclusion to be of the form lhs = rhs, which internally is
   actually (lhs = rhs) == True. *)

fun extract_lhs2 (equal $ lhs $ rhs) = lhs;
fun extract_lhs1 (trueprop $ arg) = extract_lhs2 arg;
fun extract_lhs x = extract_lhs1 (concl_of x);

concl_of thm_to_use;



extract_lhs thm_to_use;





(* BOZO add error checking for good theorems *)

ML {*

val thm_to_use = thm "is_red when is_white";

(* We expect the conclusion to be of the form lhs = rhs, which internally is
   actually (lhs = rhs) == True. *)

fun extract_lhs2 (equal $ lhs $ rhs) = lhs;
fun extract_lhs1 (trueprop $ arg) = extract_lhs2 arg;
fun extract_lhs x = extract_lhs1 (concl_of x);

concl_of thm_to_use;

extract_lhs thm_to_use;
*}

ML {*

val pat = read "f(x)";
val conc = read "f(1)";

Pattern.match sgn (pat, conc);

*}


ML {*




*}







done





*}


ML {*

val cheaply_def = thm "cheaply_def";

fun get_1ary_argument (_ $ arg) = arg;

fun cheaply_proc thy sset redex = 
  let
    val arg = cterm_of thy (get_1ary_argument redex);
    val msg = writeln (concat ["cheaply resolve: ", string_of_cterm arg])
    val true_term = cterm_of thy (Const("True", Type("bool", [])));
    val false_term = cterm_of thy (Const("False", Type("bool", [])));
  in
    if (arg = true_term) 
      then (writeln "Sniping at cheaply True" ; 
            SOME (read_instantiate [("x", "True")] cheaply_def)
           )
    else if (arg = false_term) 
      then (writeln "Sniping at cheaply False" ; 
            SOME (read_instantiate [("x", "False")] cheaply_def)
           )
    else NONE
  end;

val cheaply_simproc = Simplifier.simproc
                       (the_context ())
                       "cheaply_simproc"    (* name of the procedure *)
                       [ "cheaply x" ]      (* terms to trigger on *)
                       cheaply_proc;

Addsimprocs [cheaply_simproc];

*}

ML {* simp_depth_limit := 2; *}

declare cheaply_def [simp del]


theorem "is_red x \<or> is_white x \<or> is_blue x"
  apply(auto)
done



       let 
         val credex = cterm_of thy redex;
         val msg = writeln (concat ["The credex is: ", string_of_cterm credex]);  

         val clhs = cterm_of thy lhs;
         val msg = writeln (concat ["The clhs is: ", string_of_cterm clhs]);

         val object_type = Type("Base.object", []);
         val integerp_term = Const("Base.integerp", object_type --> object_type);
         val goal = integerp_term $ lhs;
         val msg = writeln "The goal is: ";
         val msg = prin goal;

         val cgoal = cterm_of thy goal;
         val msg = writeln (concat ["The cgoal is: ", string_of_cterm cgoal]);


         val orig_limit = !simp_depth_limit;

         val rewrite = (simp_depth_limit := 1;
                        Simplifier.rewrite sset cgoal);

         val reset_limit = (simp_depth_limit := orig_limit);

         val msg = writeln "";















subsection {* Background *}




subsection {* Cheapening Rules *}





text {* In ACL2, we can set a "backchain limit" on these rules so that 
  the simp\_depth\_limit is artificially lowered when executing them.  In
  Isabelle, I'm not aware of any such facility.  But, I think I can probably
  fake it with a simproc. *}





ML {*
val object_type = Type("object", []);
val integerp_term = Const("integerp", object_type --> object_type);
val zero_term = Const("zero", object_type);
val integerp_of_zero = integerp_term $ zero_term;
*}


ML {*

Int.toString (!simp_depth_limit);

*}


ML {*
simp_depth_limit := 100
*}

ML_setup {*

fun extract_lhs (_ $ lhs $ _) = SOME lhs
  | extract_lhs _ = NONE;

fun cheap_proc thy sset redex =
  let 
     val msg = writeln "cheap_proc invoked.";
     val lhs_opt = extract_lhs redex;
     val msg = writeln (concat ["simp_depth_limit: ", Int.toString(!simp_depth_limit)]);

  in
  case lhs_opt of 
     SOME lhs =>
       let 
         val credex = cterm_of thy redex;
         val msg = writeln (concat ["The credex is: ", string_of_cterm credex]);  

         val clhs = cterm_of thy lhs;
         val msg = writeln (concat ["The clhs is: ", string_of_cterm clhs]);

         val object_type = Type("Base.object", []);
         val integerp_term = Const("Base.integerp", object_type --> object_type);
         val goal = integerp_term $ lhs;
         val msg = writeln "The goal is: ";
         val msg = prin goal;

         val cgoal = cterm_of thy goal;
         val msg = writeln (concat ["The cgoal is: ", string_of_cterm cgoal]);


         val orig_limit = !simp_depth_limit;

         val rewrite = (simp_depth_limit := 1;
                        Simplifier.rewrite sset cgoal);

         val reset_limit = (simp_depth_limit := orig_limit);

         val msg = writeln "";
       in
         NONE
       end
   | NONE => NONE
  end;


val cheap_simproc = Simplifier.simproc (the_context ())
                     "cheap_simproc" [ "lessp x y" ] cheap_proc;

Addsimprocs [cheap_simproc];

*}



ML {*

rep_ss;


*}

end 




(* I thought for awhile about writing a function, cheaply, as follows

   consts cheaply :: "bool \<Rightarrow> bool"

   defs cheaply_def:
     "cheaply x == x"

   And then just adding this to theorems, e.g., writing 

   theorem "is_red when is_white" [simp]:
     "\<lbrakk> cheaply (is_white x) \<rbrakk> \<Longrightarrow> is_red x = False"
     by(case_tac x, auto)

   The tactic would then try to resolve the argument to cheaply with a 
   smaller limit, and give up otherwise.  But this doesn't seem to work.
   The problem is, the simplifier still dives past the as you 
   would probably normally want it to), so you don't really have that 
   level of control.  I'm not aware of any sort of "hide" feature that
   could be used to combat this. *) 
