(* 

 Concluding Thoughts about Isabelle

 More ACL2-like than I expected it to be
  - Do proofs with induct and auto
  - Setting up rewrite rules, and enabling/disable rules

 Apparently little support for evaluation
  - I don't know how to just execute a function and get an answer
  - You can sort of use "test theorems" as a hack

 Types seem nice
  - They aren't very strange like in Coq
  - They lead to concise definitions and good rules
  - Some corner cases and hypotheses just don't arise, e.g., x + 0 = x
  - They don't seem to really get in the way (though I haven't done much)

 Higher-order stuff seems nice
  - No messy macros to functional instantiate theories

 Dealing with quantifiers seems hard
  - Sometimes they seem to get in the way when you are trying to just
    "insert" facts into theorems
  - But maybe with more experience or with a better understanding of Isar
    this would be easier

 Mixfix syntax isn't a terrible thing
  - Looks nice in LaTeX
  - Seems sufficient and pretty natural for "and" and "or", etc.
  - Gripe: Mandatory(?) no-currying in "recdef" definitions is irritating
    and forces f(x, y) instead of (f x y)

 The ProofGeneral interface is quite good overall
  - X-symbol is pretty
  - Having an actual emacs editor is nice (Obviously I am on the path to 
    destruction and have no chance to survive)
  - Keeps your file synced up with the Isabelle process
  - I also have several complaints:
     - Let me edit comments/whitespace "above the line"
     - Respect my window layout (left and right panes)
     - Don't eat comments past the "next" event, treat them as events
     - Don't get confused when malformed text comes after a valid 
       event (this one is really irritating)
     - Handle nested comments, please!
 
 The LaTeX integration is a really great idea
   - On the whole it is well-implemented
   - You have a lot of control over the resulting document (to reorder
     sections, etc) and it seems like a viable way to go
   - Somewhat restrictive in that you have to define things before you
     can anti-quote them, but type-checked anti-quotation seems nice
   - Can be very hard to debug LaTeX errors like text {* foo_bar *}
     instead of text {* foo\_bar *}
   - "Hiding" things can be a little obscure and I wish I had more
     control over what is displayed

 The simplifier is somewhat disappointing
  - Easy to get it into loops
     - Apparently has no "worse than" detection
  - Very difficult to debug
     - The tracing facility can crash x-emacs and is too verbose
     - Something like cw-gstack would be really useful
  - Simprocs are powerful but hard to write and underdocumented
     - Apparently syntaxp can be implemented as a simproc
     - Probably backchain limits, too

 The feedback is also somewhat disappointing
  
   Here is an Isar error that I got when trying to prove 
     A \<or> B \<Longrightarrow> B \<or> A.

   *** Local statement will fail to solve any pending goal
   *** Failed attempt to solve goal by exported rule:
   ***   (A \<or> B) \<Longrightarrow> B \<or> A  [!]
   *** At command "show".

   It would be nice if it told me what the pending goal was,
   since I thought this was what I was trying to show.  I still
   don't know what's wrong with my proof.

 You don't get much output as to what tactics are doing.  Tracing
 the simplifier is about the only useful output and it's not in a 
 very easy-to-read format.

*)


     


