theory Isar 
imports Main
begin

text {* Isar is a way to write proofs in a "more natural" style than apply.
  The proofs are allegedly readable to both humans and machines.  It seems 
  to mainly useful for "hard to automate" proofs which involve quantifiers
  and such. *}

text {* The "by" keyword is actually an Isar feature.  So, we can see that
  Isar is nice for the most trivial proofs. *}

theorem "Suc 0 = 1"
  apply(auto)
done

theorem "Suc 0 = 1"
  by(simp)


text {* Lets look at some examples of apply-style proofs and their Isar 
  equivalents. *}

theorem "A \<longrightarrow> A"
  by(auto)

theorem "A \<longrightarrow> A"
  apply(rule impI)    -- {* Converts \<longrightarrow> into \<Longrightarrow> *}
  apply(assumption)   -- {* Proves \<lbrakk> \<dots> ; A ; \<dots> \<rbrakk> \<Longrightarrow> A *}
done

theorem "A \<longrightarrow> A"
proof 
  assume hyp1 : "A"
  show "A" by (rule hyp1)
qed

theorem "A \<longrightarrow> A"
proof
  assume "A"    -- {* We don't have to name assumptions *}
  show "A" .    -- {* "." is shorthand for applying "assumption". *}
qed



theorem "A \<longrightarrow> A \<and> A"
  by(auto)

theorem "A \<longrightarrow> A \<and> A"
  apply(rule impI)  -- {* Converts \<longrightarrow> into \<Longrightarrow> *}
  apply(rule conjI) -- {* Converts \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A \<and> B into \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A and
                                                         \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> B *}
  apply(assumption) -- {* Proves \<lbrakk> \<dots> ; A ; \<dots> \<rbrakk> \<Longrightarrow> A *}
  apply(assumption)
done

theorem "A \<longrightarrow> A \<and> A"
proof
  assume "A"
  show "A \<and> A" by(rule conjI) -- {* by(rule \<dots>) applies the rule then tries to 
                                    apply "assumption" as much as possible. *}
qed

theorem "A \<longrightarrow> A \<and> A"
proof
  assume "A"
  show "A \<and> A" ..  -- {* ".." tries to apply the built-in introduction and 
                         elimination rules from natural deduction, and then  
                         tries to use "assumption" as much as possible. *}
qed



theorem "A \<and> B \<longrightarrow> B \<and> A"
  by(auto)

theorem "A \<and> B \<longrightarrow> B \<and> A"
  apply(rule impI)   -- {* Converts \<longrightarrow> into \<Longrightarrow> *}
  apply(rule conjI)  -- {* Converts \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A \<and> B into \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A and
                                                          \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> B *} 
  apply(erule conjE) -- {* Converts \<lbrakk> A \<and> B \<rbrakk> \<Longrightarrow> \<dots> into \<lbrakk> A ; B \<rbrakk> \<Longrightarrow> \<dots> *}
  apply(assumption)
  apply(erule conjE)
  apply(assumption)
done

theorem "A \<and> B \<longrightarrow> B \<and> A"
  apply(rule impI)
  apply(erule conjE)
  apply(rule conjI)
  apply(assumption)
  apply(assumption)
done

theorem "A \<and> B \<longrightarrow> B \<and> A" -- {* This doesn't seem much better *}
proof
  assume "A \<and> B"
  then show "B \<and> A"
  proof                  -- {* A nested proof *}
    assume "A" "B"       -- {* Assume can do the conjE for us *}
    show ?thesis ..      -- {* ?thesis abbreviates the current goal *}
  qed
qed

theorem "A \<and> B \<longrightarrow> B \<and> A"   -- {* This version is pretty readable. *}
proof
  assume ab: "A \<and> B"    
  from ab have a: "A" ..
  from ab have b: "B" ..
  from b a show "B \<and> A" ..
qed



theorem "A \<or> B \<longrightarrow> B \<or> A"
  by(auto)

theorem "A \<or> B \<longrightarrow> B \<or> A"
  apply(rule impI)
  apply(erule disjE)     -- {* Convert \<lbrakk> A \<or> B \<rbrakk> \<Longrightarrow> \<dots> into \<lbrakk> A \<rbrakk> \<Longrightarrow> \<dots> and
                                                             \<lbrakk> B \<rbrakk> \<Longrightarrow> \<dots> *}
  apply(rule disjI2)     -- {* Convert \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A \<or> B into \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> B *}
  apply(assumption)
  apply(rule disjI1)     -- {* Convert \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A \<or> B into \<lbrakk> \<dots> \<rbrakk> \<Longrightarrow> A *}
  apply(assumption)
done


theorem "A \<or> B \<longrightarrow> B \<or> A"
proof
  assume "A \<or> B"
  moreover { assume a : "A" have "B \<or> A" .. }
  moreover { assume b : "B" have "B \<or> A" .. }
  ultimately show "B \<or> A" by blast
qed


text {* I'm not exactly sure why Isar is a good idea, but they seem to like it.
  Maybe it's better for dealing with quantifiers, etc., where auto is not very
  good. *}

end