header {* Map Utility Functions *}

theory MapUtilities
imports ListUtilities
begin

consts
  mapp     :: "object \<Rightarrow> object"
  cons_fix :: "object \<Rightarrow> object"
  lookup   :: "object \<Rightarrow> object \<Rightarrow> object"
  update   :: "object \<Rightarrow> object \<Rightarrow> object \<Rightarrow> object"
  dom      :: "object \<Rightarrow> object"
  ran      :: "object \<Rightarrow> object"
  submapp1 :: "object \<Rightarrow> object \<Rightarrow> object \<Rightarrow> object"
  submapp  :: "object \<Rightarrow> object \<Rightarrow> object"


text {* We now introduce our map utilities.  Note that the names @{term domain}
  and @{term range} are already taken by Isabelle, so we use @{term dom} and
  @{term ran} instead. *}


subsection {* @{term mapp} *}

primrec 
  "mapp (Symbol x) = t"
  "mapp (Integer x) = t"
  "mapp (Cons a x) = consp a and mapp x"

theorem "mapp correspondence" []:
  "mapp x = (ite (consp x) 
                 (consp (car x) and mapp (cdr x))
              t)"
  by(induct x rule: len.induct, auto)

theorem "mapp when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> mapp x = t"
  by(case_tac x, auto)

theorem "mapp of list_fix" [simp]:
  "mapp (list_fix x) = mapp x"
  by(induct x rule: len.induct, auto)
 
theorem "booleanp of mapp" [simp]:
  "booleanp (mapp x) = t"
  by(induct x rule: len.induct, auto)

theorem "mapp of app" [simp]:
  "mapp (app x y) = mapp x and mapp y"
  by(induct x rule: len.induct, auto)



subsection {* @{term cons_fix} *}

defs cons_fix_def []:
  "cons_fix x \<equiv> (ite (consp x) x (Cons nil nil))"

theorem "cons_fix when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> cons_fix x = Cons nil nil"
  by(simp add: cons_fix_def)

theorem "cons_fix when consp" [simp]:
  "\<lbrakk> consp x = t \<rbrakk> \<Longrightarrow> cons_fix x = x"
  by(simp add: cons_fix_def)

theorem "cons_fix of cons" [simp]:
  "cons_fix (Cons a x) = (Cons a x)"
  by(auto)

theorem "consp of cons_fix" [simp]:
  "consp (cons_fix x) = t"
  by(case_tac x, auto)

theorem "car of cons_fix" [simp]:
  "car (cons_fix x) = car x"
  by(case_tac x, auto)

theorem "cdr of cons_fix" [simp]:
  "cdr (cons_fix x) = cdr x"
  by(case_tac x, auto)

theorem "cons_fix equals nil" [simp]:
  "(cons_fix x = nil) = False"
  by(case_tac x, auto)



subsection {* @{term lookup} *}

primrec
  "lookup a (Symbol x) = nil"
  "lookup a (Integer x) = nil"
  "lookup a (Cons b x) = (ite (equal a (car b))
                              (cons_fix b) 
                           (lookup a x))"

theorem "lookup correspondence" []:
  "lookup a x = (ite (consp x)
                     (ite (equal a (car (car x)))
                          (ite (consp (car x))
                               (car x)
                             (Cons (car (car x))
                                   (cdr (car x))))
                       (lookup a (cdr x)))
                   nil)"
  by(induct x rule: len.induct, auto)

theorem "lookup when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> lookup a x = nil"
  by(case_tac x, auto)

theorem "consp of lookup" [simp]:
  "consp (lookup a x) = (ite (lookup a x) t nil)"
  by(induct x rule: len.induct, auto)

theorem "lookup of list_fix" [simp]:
  "lookup a (list_fix x) = lookup a x"
  by(induct x rule: len.induct, auto)

theorem "lookup of app" [simp]:
  "lookup a (app x y) = (ite (lookup a x) (lookup a x) (lookup a y))"
  by(induct x rule: len.induct, auto)

theorem "car of lookup when found" [simp]:
  "\<lbrakk> lookup a x \<noteq> nil \<rbrakk> \<Longrightarrow> car (lookup a x) = a"
  by(induct x rule: len.induct, auto)




subsection {* @{term update} *}

defs update_def []:
  "update key val map \<equiv> Cons (Cons key val) (list_fix map)"

theorem "mapp of update when mapp" [simp]:
  "\<lbrakk> mapp map = t \<rbrakk> \<Longrightarrow> mapp (update key val map) = t"
  by(simp add: update_def)

theorem "lookup of update" [simp]:
  "lookup a (update b val map) = (ite (equal a b)
                                      (Cons a val)
                                    (lookup a map))"
  by(simp add: update_def)

theorem "consp of update" [simp]:
  "consp (update key val map) = t"
  by(simp add: update_def)

theorem "update of list_fix" [simp]:
  "update key val (list_fix map) = update key val map"
  by(simp add: update_def)



subsection {* @{term dom} *}

primrec 
  "dom (Symbol x) = nil"
  "dom (Integer x) = nil"
  "dom (Cons a x) = Cons (car a) (dom x)"

theorem "dom correspondence" []:
  "dom x = (ite (consp x)
                (Cons (car (car x))
                      (dom (cdr x)))
             nil)"
  by(induct x rule: len.induct, auto)

theorem "dom when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> dom x = nil"
  by(case_tac x, auto)

theorem "dom of list_fix" [simp]:
  "dom (list_fix x) = dom x"
  by(induct x rule: len.induct, auto)

theorem "consp of dom" [simp]:
  "consp (dom x) = consp x"
  by(case_tac x, auto)

theorem "true_listp of dom" [simp]:
  "true_listp (dom x) = t"
  by(induct x rule: len.induct, auto)

theorem "dom of app" [simp]:
  "dom (app x y) = app (dom x) (dom y)"
  by(induct x rule: len.induct, auto)

theorem "dom of update" [simp]:
  "dom (update a x map) = Cons a (dom map)"
  by(simp add: update_def)

(* BOZO somehow we hit a loop here 
  theorem "memberp of dom when memberp" [simp]:
    "\<lbrakk> memberp a x = t \<rbrakk> \<Longrightarrow> memberp (car a) (dom x) = t"
    apply(induct x rule: len.induct)
    apply(auto)
    apply(split split_if_asm)
    apply(split split_if_asm)
    apply(split split_if_asm)
    apply(simp)
    apply(simp)
  done *)

(* Fix above to get this back
theorem "memberp of dom when memberp of subsetp dom" []: -- Loops
  "\<lbrakk> memberp a (dom x) = t ; subsetp x y = t \<rbrakk> 
     \<Longrightarrow>
     memberp a (dom y) = t"
  apply(induct x rule: len.induct)
  apply(auto split: split_if_asm)
done *)

(* BOZO fixme
theorem "subsetp of doms when subsetp" [simp]:
  "\<lbrakk> subsetp x y = t \<rbrakk>
     \<Longrightarrow> 
     subsetp (dom x) (dom y) = t"
  apply(insert "subsetp by membership" [of "dom x" "dom y"])
  apply(auto split: split_if_asm)
  apply(simp add: "memberp of dom when memberp of subsetp dom")  -- {* Ugly, loopy, slow *}
done *)

(* BOZO proveme
theorem "uniquep when uniquep of dom" []:       -- Loops
  "\<lbrakk> uniquep (dom x) = t \<rbrakk> \<Longrightarrow> uniquep x = t"
  apply(induct x rule: len.induct, auto split: split_if_asm)
  apply(erule_tac Q="memberp (first a) (dom x) = nil" in contrapos_pp)
  apply(auto)
  apply(case_tac "memberp a x = t")
  apply(auto)
done *)

theorem "memberp of domain" [simp]:
  "memberp a (dom x) = (ite (lookup a x) t nil)"
  by(induct x rule: len.induct, auto)

theorem "dom of rev" [simp]:
  "dom (rev x) = rev (dom x)"
  by(induct x rule: len.induct, auto)



subsection {* @{term range} *}

primrec
  "ran (Symbol x) = nil"
  "ran (Integer x) = nil"
  "ran (Cons a x) = (Cons (cdr a) (ran x))"

theorem "ran correspondence" []:
  "ran x = (ite (consp x)
                (Cons (cdr (car x))
                      (ran (cdr x)))
             nil)"
  by(induct x rule: len.induct, auto)

theorem "ran when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> ran x = nil"
  by(case_tac x, auto)

theorem "ran of list_fix" [simp]:
  "ran (list_fix x) = ran x"
  by(induct x rule: ran.induct, auto)

theorem "true_listp of ran" [simp]:
  "true_listp (ran x) = t"
  by(induct x rule: ran.induct, auto)

theorem "len of ran" [simp]:
  "len (ran x) = len x"
  by(induct x rule: ran.induct, auto)

(* BOZO seems like we forgot a lot of theorems about ran, and similarly we forgot to 
   prove len of dom, etc.  (In the ACL2 model).  We could add theorems like these. *)

theorem "ran of app" [simp]:
  "ran (app x y) = app (ran x) (ran y)"
  by(induct x rule: ran.induct, auto)





subsection {* @{term submapp} *}

primrec 
  "submapp1 (Symbol d) x y = t"
  "submapp1 (Integer d) x y = t"
  "submapp1 (Cons a d) x y = equal (lookup a x) (lookup a y)
                               and submapp1 d x y"

theorem "submapp1 correspondence" []:
  "submapp1 d x y = (ite (consp d)
                         (equal (lookup (car d) x) (lookup (car d) y)
                            and submapp1 (cdr d) x y)
                      t)"
  by(induct d rule: len.induct, auto)
             
theorem "submapp1 when not consp" [simp]:
  "\<lbrakk> consp d = nil \<rbrakk> \<Longrightarrow> submapp1 d x y = t"
  by(case_tac d, auto)

theorem "booleanp of submapp1" [simp]:
  "booleanp (submapp1 d x y) = t"
  by(induct d rule: len.induct, auto)

theorem "submapp1 of list_fix (domain)" [simp]:
  "submapp1 (list_fix d) x y = submapp1 d x y"
  by(induct d rule: len.induct, auto)

theorem "submapp1 of list_fix (left)" [simp]:
  "submapp1 d (list_fix x) y = submapp1 d x y"
  by(induct d rule: len.induct, auto)

theorem "submapp1 of list_fix (right)" [simp]:
  "submapp1 d x (list_fix y) = submapp1 d x y"
  by(induct d rule: len.induct, auto)

theorem "submapp1 of app" [simp]:
  "submapp1 (app d1 d2) x y = submapp1 d1 x y and submapp1 d2 x y"
  by(induct d1 rule: len.induct, auto)

theorem "submapp1 is reflexive" [simp]:
  "submapp1 d x x = t"
  by(induct d rule: len.induct, auto)

theorem "equal lookups when memberp of submapp1 domain" []:
  "\<lbrakk> submapp1 d x y = t ; memberp a d = t \<rbrakk> \<Longrightarrow> lookup a x = lookup a y"
  by(induct d rule: len.induct, auto split: split_if_asm)

theorem "submapp1 by membership" []:
  "submapp1 d x y = (if (\<forall> a . memberp a d = t --> lookup a x = lookup a y)
                        then t else nil)"
  by(induct d rule: len.induct, auto)

theorem "submapp1 when submapp1 of dom superset" [simp]:
  "\<lbrakk> subsetp d1 d2 = t ; submapp1 d2 x y = t \<rbrakk> \<Longrightarrow> submapp1 d1 x y = t"
  apply(insert "submapp1 by membership" [of d1 x y])
  apply(insert "submapp1 by membership" [of d2 x y])
  apply(auto split: split_if_asm)
  apply(auto simp add: "memberp when memberp of subsetp")
done

theorem "submapp1 of cons onto map" [simp]:
  "\<lbrakk> memberp a d = nil \<rbrakk> \<Longrightarrow> submapp1 d x (Cons (Cons a v) x) = t"
  apply(insert "submapp1 by membership" [of d x "Cons (Cons a v) x"])
  apply(auto split: split_if_asm)
done



defs submapp_def:
  "submapp x y \<equiv> submapp1 (dom x) x y"

theorem "booleanp of submapp" [simp]:
  "booleanp (submapp x y) = t"
  by(simp add: submapp_def)

theorem "submapp of list_fix (left)" [simp]:
  "submapp (list_fix x) y = submapp x y"
  by(simp add: submapp_def)

theorem "submapp of list_fix (right)" [simp]:
  "submapp x (list_fix y) = submapp x y"
  by(simp add: submapp_def)

theorem "equal of lookups when submapp" []:  -- {* Loopy? *}
  "\<lbrakk> submapp x y = t ; lookup a x \<noteq> nil \<rbrakk> 
     \<Longrightarrow> 
     lookup a x = lookup a y"
  apply(insert "equal lookups when memberp of submapp1 domain"
               [of "dom x" x y a])
  apply(simp)                      -- {* Ugly; prevents loop somehow *}
  apply(simp add: submapp_def)
done

theorem "lookup when lookup in submapp" []: -- {* Loopy? *}
  "\<lbrakk> submapp x y = t ; lookup a x \<noteq> nil \<rbrakk> 
     \<Longrightarrow> 
     lookup a y \<noteq> nil"
  apply(insert "equal of lookups when submapp" [of x y a])
  apply(simp)
done

theorem "submapp by membership" []:
  "submapp x y = (if (\<forall> a . memberp a (dom x) = t --> lookup a x = lookup a y)
                     then t else nil)"
  apply(insert "submapp1 by membership" [of "dom x" x y])
  apply(simp add: submapp_def)
done

theorem "subsetp of doms when submap" [simp]:
  "\<lbrakk> submapp x y = t \<rbrakk> \<Longrightarrow> subsetp (dom x) (dom y) = t"
  apply(insert "subsetp by membership" [of "dom x" "dom y"])
  apply(insert "submapp by membership" [of x y])
  apply(simp split: split_if_asm)
done

theorem "submapp is reflexive" [simp]:
  "submapp x x = t"
  apply(simp add: submapp_def)
done

theorem "submapp is transitive" []:
  "\<lbrakk> submapp x y = t ; submapp y z = t \<rbrakk> \<Longrightarrow> submapp x z = t"
  apply(insert "submapp by membership" [of x z])
  apply(insert "equal of lookups when submapp" [of x y])
  apply(insert "equal of lookups when submapp" [of y z])
  apply(auto split: split_if_asm)
done

theorem "submapp of cons onto map" [simp]:
  "\<lbrakk> lookup a x = nil \<rbrakk> \<Longrightarrow> submapp x (Cons (Cons a v) x) = t"
  by(simp add: submapp_def)

(* BOZO

  theorem "equal of lookups when unique doms and subsetp" []:
  "\<lbrakk> uniquep (dom x) = t ; 
      uniquep (dom y) = t ;
      subsetp(x, y) = t ; 
      memberp(a, dom x) = t \<rbrakk>
      \<Longrightarrow>
      lookup(a, x) = lookup(a, y)"
  done

  (encapsulate
   ()
   (local theorem lemma
          (implies (and (memberp a x)
                        (uniquep (dom x))                
                        (equal (car a) (car (car x))))
                   (equal (car x) 
                          a))
          :hints(("Goal" 
                  :in-theory (disable memberp-of-dom-when-memberp)
                  :use ((:instance memberp-of-dom-when-memberp
                                   (a a) 
                                   (x (cdr x)))))))

   (local theorem lemma2
          (implies (and (uniquep (dom x))
                        (memberp a x))
                   (equal (lookup (car a) x)
                          (cons-fix a)))
          :hints(("Goal" 
                  :in-theory (enable lookup)
                  :induct (lookup (car a) x))))

   (local theorem equal-of-lookups-when-unique-doms-and-subsetp
          (implies (and (uniquep (dom x))
                        (uniquep (dom y))
                        (subsetp x y) 
                        (memberp a (dom x)))
                   (equal (equal (lookup a x)
                                 (lookup a y))
                          t))
          :hints(("Goal" :induct (cdr-induction x))))

   theorem submapp-when-unique-doms-and-subsetp
     (implies (and (uniquep (dom x))
                   (uniquep (dom y))
                   (subsetp x y))
              (equal (submapp x y)
                     t))
     :hints(("Goal" :use ((:instance submapp-badguy-membership-property
                                     (x x) 
                                     (y y)))))) *)








end






(* ACL2 BOZOs

   submapp of cons onto map:
    Why aren't we using update?
    Why are we checking consp of lookup instead of lookup equal nil? 
    Why all these enables instead of a lemma about submapp1? 

*)
