header {* Numeric List Utilities *}

theory NumericListUtilities 
imports ListUtilities
begin

consts tuplep :: "object \<times> object \<Rightarrow> object"
       repeat :: "object \<times> object \<Rightarrow> object"


subsection {* Tuplep *}

recdef tuplep
  "measure (\<lambda>(n,x).hol_nfix n)"
  "tuplep(n, x) = (case hol_bfix (zp n) of 
                     True \<Rightarrow> equal x nil
                   | False \<Rightarrow> (consp x
                                 and 
                               tuplep(plus negone n, cdr x)))"

theorem "tuplep correspondence" []:
  "tuplep(n, x) = (ite (zp n) 
                       (equal x nil)
                    (consp x 
                     and tuplep((plus negone n), (cdr x))))"
  by(induct n x rule: tuplep.induct, auto)

theorem "tuplep when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> tuplep(n, x) = zp n and not x"
  by(auto)

theorem "tuplep when zp" [simp]:
  "\<lbrakk> zp n = t \<rbrakk> \<Longrightarrow> tuplep(n, x) = not x"
  by(auto)

declare tuplep.simps [simp del]

theorem "booleanp of tuplep" [simp]:
  "booleanp (tuplep(n, x)) = t"
  apply(induct n x rule: tuplep.induct)
  apply(case_tac "zp n = t")
  apply(auto simp add: tuplep.simps)
done

(* 
theorem "true_listp when tuplep" [simp]:
  "\<lbrakk> tuplep(n, x) = t \<rbrakk> \<Longrightarrow> true_listp x = t"
  apply(induct n x rule: tuplep.induct)
  apply(case_tac "zp n = t")
  apply(auto split: split_if_asm)
  apply(case_tac x, auto)           -- {* Slightly ugly *}
done
*)

theorem "tuplep of cons" [simp]:
  "tuplep(n, Cons a x) = integerp n 
                           and lessp zero n 
                           and tuplep(plus negone n, x)"
  apply(case_tac "zp n = t")
  apply(auto)
  apply(simp add: tuplep.simps)
done

theorem "plus one negone" [simp]:
  "plus one negone = zero"
  by(simp add: plus_def)




theorem "len when tuplep" [simp]:
  "\<lbrakk> tuplep(n, x) = t \<rbrakk> \<Longrightarrow> len x = nfix n"
  apply(induct n x rule: tuplep.induct)
  apply(case_tac x)
  apply(auto split: split_if_asm)
  apply(Asm_full_simp_tac)
  apply(simp split: split_if_asm)
  defer
  apply(simp split: split_if_asm)
  apply(simp split: split_if_asm)

  apply(insert "odd trichotomy of lessp" [of n zero])
  apply(auto split: split_if_asm split_if)
  apply(

  apply(case_tac "zp n = t")
  apply(auto split: split_if_asm)
  apply(simp)
  apply(simp add: tuplep.simps)

  apply(simp add: tuplep.simps)
  apply(auto split: split_if_asm)
  apply(auto split: split_if_asm)
  apply(auto split: split_if_asm simp add: tuplep.simps)


  apply(auto split: split_if_asm)

  apply(
         del: )
  apply(auto simp only: )
  apply(simp_all split: split_if_asm)
  apply(auto)
  apply(simp split: split_if_asm)
  defer
  apply(simp split: split_if_asm)
  defer
  apply(simp split: split_if_asm)

 
  apply(auto)


  apply(split split_if_asm)

  apply(case_tac "zp n = t")
  apply(auto simp only: )
  apply(simp split: split_if_asm)
  apply(erule_tac Q="lessp n zero = nil" in contrapos_pp)
  apply(simp)

done




theorem "tuplep of cons" [simp]:
  "tuplep(n, Cons a x) = integerp n 
                           and lessp zero n 
                           and tuplep(plus negone n, x)"
  by(case_tac "zp n = t", auto)

(* BOZO need better arithmetic reasoning or this is crazy.

  theorem "tuplep when true_listp" [simp]:
    "\<lbrakk> true_listp x = t \<rbrakk> \<Longrightarrow> tuplep(n,x) = equal (len x) (nfix n)"
    apply(induct n x rule: tuplep.induct)
  done *)





subsection {* Repeat *}

recdef repeat
  "measure (\<lambda>(a, n).hol_nfix n)"
  "repeat(a, n) = (case hol_bfix (zp n) of 
                     True \<Rightarrow> nil
                   | False \<Rightarrow> Cons a (repeat(a, plus negone n)))"

theorem "repeat correspondence" []:
  "repeat(a, n) = (ite (zp n) 
                       nil
                    (Cons a (repeat(a, plus negone n))))"
  by(induct a n rule: repeat.induct, auto)

theorem "repeat when zp" [simp]:
  "\<lbrakk> zp n = t \<rbrakk> \<Longrightarrow> repeat(a, n) = nil"
  by(auto)

theorem "repeat when not zp" [simp]:
  "\<lbrakk> zp n = nil \<rbrakk> \<Longrightarrow> repeat(a, n) = Cons a (repeat(a, plus negone n))"
  by(auto)

declare repeat.simps [simp del]

theorem "consp of repeat" [simp]:
  "consp (repeat(a, n)) = not (zp n)"
  apply(induct a n rule: repeat.induct)
  apply(auto)
done

theorem "repeat under iff" [simp]:
  "(repeat(x, n) ~= nil) = (if zp n = nil then True else False)"
  by(auto)

theorem "repeat under iff (two)" [simp]:
  "(repeat(x, n) = nil) = (if zp n = t then True else False)"
  by(auto)

theorem "len of repeat" [simp]:
  "len (repeat(a, n)) = nfix n"
  apply(induct a n rule: repeat.induct)
  apply(case_tac "zp n = t")
  apply(auto split: split_if_asm)
  apply(auto simp add: plus_def lessp_def split: split_if_asm)    -- {* BOZO Arithmetic *}
  apply(case_tac n)    -- {* BOZO Ugly *}
  apply(auto)
done

theorem "true_listp of repeat" [simp]:
  "true_listp (repeat(a, n)) = t"
  apply(induct a n rule: repeat.induct)
  apply(case_tac "zp n = t", auto)
done

theorem "list_fix of repeat" [simp]:
  "list_fix (repeat(a, n)) = repeat(a, n)"
  by(auto)  

theorem "memberp of repeat" [simp]:
  "memberp(a, (repeat(b, n))) = lessp zero (nfix n) and equal a b"
  apply(induct a n rule: repeat.induct)
  apply(case_tac "zp n = t", auto split: split_if_asm)
  apply(auto simp add: plus_def lessp_def split: split_if_asm)    -- {* BOZO Arithmetic *}
done

theorem "app of repeat" [simp]:
  "app(repeat(a, n1), repeat(a, n2)) = repeat(a, plus (nfix n1) (nfix n2))"
  apply(induct a n1 rule: repeat.induct)
  -- {* BOZO this is really terrible. *}
  apply(auto simp del: "repeat when zp" "repeat when not zp"
             split: split_if_asm)
  apply(simp_all)
  apply(simp_all add: plus_def lessp_def
                 split: split_if_asm)
done

theorem "car of repeat" [simp]:
  "car (repeat(a, n)) = (ite (zp n) nil a)"
  by(auto)

theorem "cdr of repeat" [simp]:
  "cdr (repeat(a, n)) = (ite (zp n) nil (repeat(a, plus negone n)))"
  by(auto)





subsection {* Nth *}

consts nth :: "object \<times> object \<Rightarrow> object"

recdef nth
  "measure (\<lambda>(n, x). hol_rank x)"
  "nth(n, x) = (case hol_bfix (consp x) of 
                     True \<Rightarrow> (ite (zp n) 
                                  (car x)
                               (nth(plus negone n, cdr x)))
                   | False \<Rightarrow> nil)"

theorem "nth correspondence" []:
  "nth(n, x) = (ite (consp x)
                    (ite (zp n)
                         (car x)
                      (nth(plus negone n, cdr x)))
                 nil)"
  by(induct n x rule: nth.induct, auto)

theorem "nth when not consp" [simp]:
  "\<lbrakk> consp x = nil \<rbrakk> \<Longrightarrow> nth(n, x) = nil"
  by(auto)

theorem "nth of cons" [simp]:
  "nth(n, Cons a x) = (ite (zp n) a (nth(plus negone n, x)))"
  by(auto)

declare nth.simps [simp del]

theorem "nth when zp" [simp]:
  "\<lbrakk> zp n = t \<rbrakk> \<Longrightarrow> nth(n, x) = car x"
  by(case_tac x, auto)

theorem "nth of list_fix" [simp]:
  "nth(n, list_fix x) = nth(n, x)"
  apply(induct n x rule: nth.induct)
  apply(case_tac x, auto)
done

(* BOZO prove us       

  (defthm nth-when-index-too-large
    (implies (and (integerp n)
                  (not (< n (len x))))
             (equal (nth n x)
                    nil))
    :hints(("Goal" :in-theory (enable nth))))
          
  (defthm nth-of-increment
    (implies (and (integerp n)
                  (not (< n 0)))
             (equal (nth (+ 1 n) x)
                    (nth n (cdr x))))
    :hints(("Goal" :in-theory (enable nth))))

  (defthm nth-of-app
    (implies (and (integerp n)
                  (not (< n 0)))
             (equal (nth n (app x y))
                    (if (< n (len x))
                        (nth n x)
                      (nth (+ n (- (len x))) y))))
    :hints(("Goal" 
            :in-theory (enable nth)
            :induct (nth n x))))

  (defthm nth-of-rev
    (implies (and (integerp n)
                  (not (< n 0)))
             (equal (nth n (rev x))
                    (if (< n (len x))
                        (nth (+ -1 (+ (len x) (- n))) x)
                      nil)))
    :hints(("Goal" 
            :in-theory (enable nth)
            :induct (cdr-induction x))))

  (defthm memberp-of-nth
    (implies (and (integerp n)
                  (not (< n 0))
                  (< n (len vars)))
             (equal (memberp (nth n vars) vars)
                    t))
    :hints(("Goal" :in-theory (enable nth))))

  (encapsulate
   ()

   (local (defun my-induction (m n vars)
	    (declare (xargs :measure (rank vars)
			     :verify-guards nil))
	    (if (consp vars)
		(if (or (zp m)
			(zp n))
		    nil
		  (my-induction (+ -1 m) (+ -1 n) (cdr vars)))
	      nil)))

   (local (defthm lemma
	    (implies (and (memberp (nth m vars) vars)
			  (not (memberp (nth m vars) (cdr vars)))
			  (integerp m)
			  (not (< m 0)))
		     (equal (nth m vars) 
			    (car vars)))))

   (local (defthm lemma2
	    (implies (and (not (memberp (nth m vars) (cdr vars)))
			  (consp vars)
			  (integerp m)
			  (not (< m 0)))
		     (equal (< m (len vars))
			    (equal m 0)))
	    :hints(("Goal" :in-theory (enable nth)))))

   (defthm equal-of-nths-when-uniquep
     (implies (and (uniquep vars)
		   (integerp n)
		   (integerp m)
		   (not (< n 0))
		   (not (< m 0))
		   (< n (len vars))
		   (< m (len vars)))
	      (equal (equal (nth n vars) (nth m vars))
		     (equal m n)))
     :hints(("Goal" 
	     :in-theory (enable nth)
	     :induct (my-induction n m vars)))))

   *)


subsection {* First\_Index *}

(* BOZO 

  (defund first-index (a x)
    ;; We return the smallest index of x which contains element a, or len(x) if 
    ;; no such index exists.
    (declare (xargs :guard t))
    (if (consp x)
	(if (equal (car x) a)
	    0
	  (+ 1 (first-index a (cdr x))))
      0))

  (in-theory (disable (:type-prescription first-index)))

  (defthm first-index-nonnegative
    (equal (< (first-index a x) 0)
	   nil)
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm integerp-of-first-index
    (equal (integerp (first-index a x))
	   t)
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm memberp-binds-first-index-range
    (implies (memberp a x)
	     (equal (< (first-index a x) (len x))
		    t))
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm first-index-of-app
    (equal (first-index a (app x y))
	   (if (memberp a x)
	       (first-index a x)
	     (+ (len x) (first-index a y))))
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm first-index-of-rev-when-unique
    (implies (and (uniquep x)
		  (memberp a x))
	     (equal (first-index a (rev x))
		    (+ -1 (+ (len x) (- (first-index a x))))))
    :hints(("Goal" :in-theory (e/d (first-index)
                                   (decrement-len-when-consp)))))

  (defthm first-index-of-car
    (equal (first-index (car x) x)
	   0)
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm nth-of-first-index-when-memberp
    (implies (memberp a x)
	     (equal (nth (first-index a x) x) 
		    a))
    :hints(("Goal" :in-theory (enable first-index
				      nth ;; yuck?
				      ))))

  (defthm first-index-less-than-len
    (equal (< (first-index a x) (len x))
	   (equal (memberp a x)
		  t))
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm nth-of-first-index-of-nth
    (implies (and (integerp n)
		  (not (< n 0))
		  (< n (len x)))
	     (equal (nth (first-index (nth n x) x) x)
		    (nth n x)))
    :hints(("Goal" :in-theory (enable first-index))))

  (defthm first-index-of-nth-when-unique
    (implies (and (uniquep x)
		  (integerp n)
		  (not (< n 0))
		  (< n (len x)))
	     (equal (first-index (nth n x) x)
		    n))
    :hints(("Goal" 
	    :use ((:instance equal-of-nths-when-uniquep
			     (n (first-index (nth n x) x))
			     (m n)
			     (vars x))))))

  (defthm nth-of-first-index-of-domain-and-range
    (equal (nth (first-index a (domain x)) (range x))
	   (cdr (lookup a x)))
    :hints(("Goal" 
	    :in-theory (enable nth first-index)
	    :induct (cdr-induction x))))

  (defthm equal-of-first-index-and-len-free
    (implies (equal (len xs) n)
	     (equal (equal (first-index a xs) n)
		    (not (memberp a xs))))
    :hints(("Goal" :in-theory (enable first-index))))

*)


subsection {* Prefixp\_Badguy *}

(* BOZO

  (defund prefixp-badguy (x y)
    ;; We search for the index of the first location where x and y differ, i.e.,
    ;; the first element which violates prefixp.
    (declare (xargs :guard (<= (len x) (len y))))
    (if (consp x)
	(if (equal (car x) (car y))
	    ((lambda (index)
	       (if index
		   (+ 1 index)
		 nil))
	     (prefixp-badguy (cdr x) (cdr y)))
	  0)
      nil))

  (in-theory (disable (:type-prescription prefixp-badguy)))

  (defthm integerp-of-prefixp-badguy
    (equal (integerp (prefixp-badguy x y))
	   (if (prefixp-badguy x y)
	       t
	     nil))
    :hints(("Goal" :in-theory (enable prefixp-badguy))))

  (encapsulate
   () 
   (local (defthm |(< (prefixp-badguy x y) 0)|
	    (implies (integerp (prefixp-badguy x y))
		     (equal (< (prefixp-badguy x y) 0)
			    nil))
	    :hints(("Goal" :in-theory (enable prefixp-badguy)))))

   (local (defthm |(< 0 (prefixp-badguy x y))|
	    (implies (integerp (prefixp-badguy x y))
		     (equal (< 0 (prefixp-badguy x y))
			    (equal (car x) (car y))))
	    :hints(("Goal" :in-theory (enable prefixp-badguy)))))

   (local (defthm |(< (prefixp-badguy x y) (len x))|
	    (implies (integerp (prefixp-badguy x y))
		     (equal (< (prefixp-badguy x y) (len x))
			    t))
	    :hints(("Goal" :in-theory (enable prefixp-badguy)))))

   (local (defthm nth-of-prefixp-badguy
	    (implies (integerp (prefixp-badguy x y))
		     (not (equal (nth (prefixp-badguy x y) x)
				 (nth (prefixp-badguy x y) y))))
	    :hints(("Goal" :in-theory (enable prefixp-badguy)))))

   (defthmd prefixp-badguy-index-property
     (implies (integerp (prefixp-badguy x y))           
	      (and (equal (< (prefixp-badguy x y) 0)
			  nil)
		   (equal (< (prefixp-badguy x y) (len x))
			  t)
		   (not (equal (nth (prefixp-badguy x y) x)
			       (nth (prefixp-badguy x y) y)))))))

  (defthm forcing-prefixp-when-not-prefixp-badguy
    (implies (and (force (not (< (len y) (len x))))
		  (not (prefixp-badguy x y)))
	     (equal (prefixp x y)
		    t))
    :hints(("Goal" :in-theory (enable prefixp-badguy))))

  *)






end