#!/bin/sh


# Prints out some number of spaces.
indent_to()
{
  local amount=$1
  local i=0
  while [ "$i" -lt "$amount" ]
  do
     echo -n " "
     ((i += 1))
  done
}


# We look for lines with Applying, Succeeded, and Failed.
LINES=`egrep "(Applying instance|SUCCEEDED|FAILED)" $1`

breakline() 
{
   # breaks a "[3]Applying..." line into 
   #   stack=3 and 
   #   type=Applying | SUCCEEDED | FAILED
   #   rule="HOL.simp_thms_6", etc.
   local line=$1
   stack=`echo $line | sed "s/\[//" | sed "s/\].*//"`
   content=`echo $line | sed "s/.*\]//"`
   type=`echo $content | sed "s/ .*//"`
   if [ "$type" == "Applying" ]
   then
      rule=`echo $content | sed "s/.*rule //"`
      rule=`echo $rule | sed "s/:$//"`
   else
      rule=""
   fi
}


# We now load these lines into arrays of their contents.
IFS="
"
I=0
for line in $LINES
do
  breakline $line
  Stacks[$I]=$stack
  Types[$I]=$type
  Rules[$I]=$rule
  (( I += 1 ))
done
COUNT=$I


# We now iterate through the arrays.
I=0
while [ "$I" -lt "$COUNT" ]
do

  # Skip lines until we find an Applying line.
  if [ "${Types[$I]}" != "Applying" ]
  then 
     ((I += 1)) 
     continue
  fi

  depth=${Stacks[$I]}

  # Find the first Success or Failure line for this stack depth.
  J=$((I + 1))
  while [ "$J" -lt "$COUNT" ]
  do
    if [ "${Stacks[$J]}" == "$depth" ]
    then
       break
    fi
    (( J += 1 ))
  done

  indent_to ${Stacks[$I]}

  # Now we have the Applying line and its result (if the result exists).
  if [ "$J" == "$COUNT" ]
  then
      echo ${Rules[$I]}
  elif [ "${Types[$J]}" == "SUCCEEDED" ]
  then
      echo -e "\033[32m${Rules[$I]}\033[0m"
  else 
      echo -e "\033[31m${Rules[$I]}\033[0m"
  fi
    
  (( I += 1 ))

done


