(in-package "ACL2")

(include-book "unicode/rev" :dir :system)
(include-book "unicode/app" :dir :system)
(include-book "tools/mv-nth" :dir :system)
(include-book "tools/bstar" :dir :system)
(include-book "stobj" :ttags :all)

(encapsulate
 ()
 (local (defthm acl2-count-cdr-strong
          (implies (consp x)
                   (< (acl2-count (cdr x))
                      (acl2-count x)))
          :rule-classes ((:rewrite) (:linear))))

 (defthm bg-acc-count-strong
   (implies (bg-acc bg)
            (< (acl2-count (cdr (bg-acc bg)))
               (acl2-count (bg-acc bg))))
   :rule-classes ((:rewrite) (:linear))
   :hints(("Goal" :use ((:instance true-listp-of-bg-acc))))))

  
(defund bg-vals (bg acc)
  (declare (xargs :guard t
                  :stobjs bg
                  :measure (acl2-count (bg-acc bg))))
  (if (bg-endp bg)
      (mv acc bg)
    (mv-let (val1 bg)
            (bg-pop bg)
            (bg-vals bg (cons val1 acc)))))

(encapsulate
 ()
 (local (defthm lemma
          (implies (and (consp x)
                        (true-listp acc))
                   (equal (app (rev (cdr x)) (cons (car x) acc))
                          (app (rev x) acc)))
          :hints(("Goal" :expand (append (rev x) acc)))))

 (defthm bg-vals-1
   (implies (true-listp acc)
            (equal (mv-nth 0 (bg-vals bg acc))
                   (revappend (bg-acc bg) acc)))
   :hints(("Goal" :in-theory (enable bg-vals)))))



(defund fib (x)
  (declare (xargs :guard t))
  (if (or (not (natp x))
          (<= x 0))
      1
    (if (= x 1)
        1
      (+ (fib (- x 1))
         (fib (- x 2))))))

(defund fib-list (x)
  (declare (xargs :guard t))
  (if (consp x)
      (cons (fib (car x))
            (fib-list (cdr x)))
    nil))

(defthm true-listp-of-fib-list
  (true-listp (fib-list x))
  :rule-classes :type-prescription)



(defund bg-fib-list-aux (x bg)
  (declare (xargs :guard t :stobjs bg))
  (if (atom x)
      bg
    (let ((bg (bg-push (fib (car x)) bg)))
      (bg-fib-list-aux (cdr x) bg))))

(defund bg-fib-list (x)
  (declare (xargs :guard t))
  (with-local-stobj bg
                    (mv-let (result bg)
                            (b* ((bg (bg-clear bg))
                                 (bg (bg-fib-list-aux x bg))
                                 ;; Put them in spawn-order
                                 (bg (bg-rev bg)))
                                (bg-vals bg nil))
                            (reverse result))))

(defund fib-list-acc (x acc)
  (if (atom x)
      acc
    (let ((acc (cons (fib (car x)) acc)))
      (fib-list-acc (cdr x) acc))))

(defthm bg-fib-list-aux-removal
  (equal (bg-acc (bg-fib-list-aux x bg))
         (fib-list-acc x (bg-acc bg)))
  :hints(("Goal" :in-theory (enable fib-list-acc bg-fib-list-aux))))

(defthm fib-list-acc-removal
  (implies (true-listp acc)
           (equal (fib-list-acc x acc)
                  (revappend (fib-list x) acc)))
  :hints(("Goal" :in-theory (enable fib-list-acc fib-list))))


(defthm app-of-nil
  (equal (app x nil)
         (list-fix x))
  :hints(("Goal" :induct (len x))))

(defthm bg-fib-list-correct
  (equal (bg-fib-list x)
         (fib-list x))
  :hints(("Goal" :in-theory (e/d (bg-fib-list)
                                 (create-bg)))))



#||

(bg-fib-list '(1 2 3 4 5))
(fib-list '(1 2 3 4 5))

;; 10.23 seconds, 10.22 seconds in user mode
(time$ (fib-list (make-list 16 :initial-element 35)))

;; 2.182 seconds, 10.5 seconds in user mode
(time$ (bg-fib-list (make-list 16 :initial-element 35)))

;; speedup factor = 4.68 (8 cores)


;; 12.18 seconds, 12.18 user mode seconds
(time$ (fib-list (make-list 8 :initial-element 37)))

;; 2.56 seconds, 12.74 user mode seconds
(time$ (bg-fib-list (make-list 8 :initial-element 37)))

;; speedup factor = 4.97 (8 cores)


||#

