(in-package "ACL2")

;; int open(const char *path, int oflags);

(defun syscall-open (pathname flags x86-32)
  (when (not (and (live-stobjp x86-32)
                  (x86-32-oracle-hidden-p x86-32)))
    (return-from syscall-open
                 (syscall-open-logic pathname flags x86-32)))
  (setq ptr  (ccl::make-cstring pathname))
  (setq ret  (ccl::external-call "syscall"
                                 :signed-int 2
                                 :address ptr
                                 :signed-int flags
                                 :signed-int))
  (mv (cons ret nil)
      x86-32))

;; int close(int fildes);

(defun syscall-close (filedes x86-32)
  (when (not (and (live-stobjp x86-32)
                  (x86-32-oracle-hidden-p x86-32)))
    (return-from syscall-close
                 (syscall-close-logic filedes x86-32)))
  (setq ret  (ccl::external-call "syscall"
                                 :signed-int 3
                                 :signed-int filedes
                                 :signed-int))
  (mv (cons ret nil)
      x86-32))

;; size_t read(int fildes, void *buf, size_t nbytes);

(defun syscall-read (filedes nbytes x86-32)
  (when (not (and (live-stobjp x86-32)
                  (x86-32-oracle-hidden-p x86-32)))
    (return-from syscall-read
                 (syscall-read-logic filedes nbytes x86-32)))
  (multiple-value-bind (lstr lptr)
                       (ccl::make-heap-ivector nbytes '(unsigned-byte 8))
                       (setq str lstr)
                       (setq ptr lptr))
  (setq ret  (ccl::external-call "syscall"
                                 :signed-int 0
                                 :signed-int filedes
                                 :address ptr
                                 :unsigned-int nbytes
                                 :signed-int))
  (setq retStr (ccl::%str-from-ptr ptr nbytes))
  (ccl::dispose-heap-ivector ptr)
  (mv (cons ret
            (cons retStr nil))
      x86-32))

;; size_t write(int fildes, const void *buf, size_t nbytes);

(defun syscall-write (filedes buffer nbytes x86-32)
  (when (not (and (live-stobjp x86-32)
                  (x86-32-oracle-hidden-p x86-32)))
    (return-from syscall-write
                 (syscall-write-logic filedes buffer nbytes x86-32)))
  (setq ptr  (ccl::make-cstring buffer))
  (setq ret  (ccl::external-call "syscall"
                                 :signed-int 1
                                 :signed-int filedes
                                 :address ptr
                                 :unsigned-int nbytes
                                 :signed-int))
  (ccl::dispose-heap-ivector ptr)
  (mv (cons ret nil)
      x86-32))
